/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network;

import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.recipe.RecipeInfo;
import com.denfop.api.vein.Vein;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.Fluids;
import com.denfop.invslot.InvSlot;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EncodedType;
import com.denfop.network.packet.INetworkObject;
import com.denfop.tiles.base.DataOre;
import com.denfop.utils.ModUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.math.Vector3d;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class EncoderHandler {
    private static final Map<Class<?>, EncodedType> classToTypeCache = Collections.synchronizedMap(new IdentityHashMap());

    public static void encode(CustomPacketBuffer os, Object o) throws IOException {
        try {
            EncoderHandler.encode(os, o, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static int idFromType(EncodedType type) {
        return type.ordinal();
    }

    private static EncodedType typeFromObject(Object o) {
        return o == null ? EncodedType.Null : EncoderHandler.typeFromClass(o.getClass());
    }

    private static Class<?> box(Class<?> clazz) {
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz == Character.TYPE ? Character.class : clazz;
    }

    private static EncodedType typeFromClass(Class<?> cls) {
        EncodedType[] var3;
        EncodedType ret;
        if (cls == null) {
            return EncodedType.Null;
        }
        if (cls.isArray()) {
            return EncodedType.Array;
        }
        if (cls.isPrimitive()) {
            cls = EncoderHandler.box(cls);
        }
        if ((ret = EncodedType.classToTypeMap.get(cls)) != null) {
            return ret;
        }
        ret = classToTypeCache.get(cls);
        if (ret != null) {
            return ret;
        }
        for (EncodedType type : var3 = EncodedType.types) {
            if (type.cls == null || !type.cls.isAssignableFrom(cls)) continue;
            classToTypeCache.put(cls, type);
            return type;
        }
        throw new IllegalStateException("unmatched " + cls);
    }

    public static void encode(CustomPacketBuffer os, Object o, boolean withType) throws IOException {
        EncodedType type = EncoderHandler.typeFromObject(o);
        if (withType) {
            os.writeByte(EncoderHandler.idFromType(type));
        }
        switch (type) {
            case Array: {
                Object value;
                int i;
                Class<?> componentClass = o.getClass().getComponentType();
                int len = Array.getLength(o);
                if (componentClass == Object.class && len > 0) {
                    boolean isEnum = false;
                    Class<Object> target = null;
                    block40: for (i = 0; i < len; ++i) {
                        value = Array.get(o, i);
                        if (target == null) {
                            if (value instanceof Enum) {
                                target = ((Enum)value).getDeclaringClass();
                                isEnum = true;
                                continue;
                            }
                            if (value == null) continue;
                            target = value.getClass();
                            assert (target != Object.class);
                            continue;
                        }
                        if (value != null) {
                            Class<?> valueClass = value.getClass();
                            if (valueClass != target && !target.isAssignableFrom(valueClass)) {
                                if (isEnum || value instanceof Enum) {
                                    throw new IllegalArgumentException("Array of mixed enum entries");
                                }
                                do {
                                    if ((target = target.getSuperclass()) != Object.class) continue;
                                    ++i;
                                    while (i < len) {
                                        if (Array.get(o, i) instanceof Enum) {
                                            throw new IllegalArgumentException("Array of mixed enum entries");
                                        }
                                        ++i;
                                    }
                                    break block40;
                                } while (!target.isAssignableFrom(valueClass));
                                continue;
                            }
                            assert (isEnum == value instanceof Enum);
                            continue;
                        }
                        if (!isEnum) continue;
                        throw new IllegalArgumentException("Enum array with null entry");
                    }
                    componentClass = target;
                }
                EncodedType componentType = EncoderHandler.typeFromClass(componentClass);
                os.writeByte(EncoderHandler.idFromType(componentType));
                os.writeBoolean(componentClass.isPrimitive());
                if (componentType == EncodedType.Enum) {
                    os.writeString(componentClass.getName());
                }
                os.m_130130_(len);
                boolean anyTypeMismatch = false;
                for (i = 0; i < len; ++i) {
                    value = Array.get(o, i);
                    if (value != null && EncoderHandler.typeFromClass(value.getClass()) == componentType) continue;
                    anyTypeMismatch = true;
                    break;
                }
                os.writeBoolean(anyTypeMismatch);
                for (i = 0; i < len; ++i) {
                    EncoderHandler.encode(os, Array.get(o, i), anyTypeMismatch);
                }
                break;
            }
            case Block: {
                EncoderHandler.encode(os, Registry.f_122824_.m_7981_((Object)((Block)o)), false);
                break;
            }
            case BlockPos: {
                BlockPos pos = (BlockPos)o;
                os.writeInt(pos.m_123341_());
                os.writeInt(pos.m_123342_());
                os.writeInt(pos.m_123343_());
                break;
            }
            case Boolean: {
                os.writeBoolean((Boolean)o);
                break;
            }
            case Byte: {
                os.writeByte(((Byte)o).byteValue());
                break;
            }
            case network_object: {
                os.writeBytes((ByteBuf)((INetworkObject)o).writePacket());
                break;
            }
            case Character: {
                os.writeChar(((Character)o).charValue());
                break;
            }
            case ChunkPos: {
                ChunkPos chunkpos = (ChunkPos)o;
                os.writeInt(chunkpos.f_45578_);
                os.writeInt(chunkpos.f_45579_);
                break;
            }
            case DataOre: {
                os.writeBytes((ByteBuf)((DataOre)o).getCustomPacket());
                break;
            }
            case Collection: {
                EncoderHandler.encode(os, ((Collection)o).toArray(), false);
                break;
            }
            case Component: {
                os.writeBytes((ByteBuf)((AbstractComponent)o).updateComponent());
                break;
            }
            case Double: {
                os.writeDouble((Double)o);
                break;
            }
            case Enchantment: {
                EncoderHandler.encode(os, Registry.f_122825_.m_7981_((Object)((Enchantment)o)), false);
                break;
            }
            case Enum: {
                os.m_130130_(((Enum)o).ordinal());
                break;
            }
            case Float: {
                os.writeFloat(((Float)o).floatValue());
                break;
            }
            case Fluid: {
                EncoderHandler.encode(os, Registry.f_122822_.m_7981_((Object)((Fluid)o)), false);
                break;
            }
            case FluidStack: {
                FluidStack fs = (FluidStack)o;
                if (!fs.isEmpty()) {
                    EncoderHandler.encode(os, fs.getFluid(), false);
                } else {
                    EncoderHandler.encode(os, Fluids.EMPTY, false);
                }
                os.writeInt(fs.getAmount());
                EncoderHandler.encode(os, fs.getTag(), true);
                break;
            }
            case FluidTank: {
                FluidTank tank = (FluidTank)o;
                EncoderHandler.encode(os, tank.getFluid(), true);
                os.writeInt(tank.getCapacity());
                break;
            }
            case GameProfile: {
                GameProfile gp = (GameProfile)o;
                EncoderHandler.encode(os, gp.getId(), true);
                os.writeString(gp.getName());
                break;
            }
            case Integer: {
                os.writeInt((Integer)o);
                break;
            }
            case InvSlot: {
                InvSlot slot = (InvSlot)o;
                ItemStack[] contents = new ItemStack[slot.size()];
                for (int i = 0; i < slot.size(); ++i) {
                    contents[i] = slot.get(i);
                }
                EncoderHandler.encode(os, contents, false);
                break;
            }
            case Item: {
                EncoderHandler.encode(os, Registry.f_122827_.m_7981_((Object)((Item)o)), false);
                break;
            }
            case ItemStack: {
                ItemStack stack = (ItemStack)o;
                if (ModUtils.isEmpty(stack)) {
                    os.writeByte(0);
                    break;
                }
                os.writeByte(ModUtils.getSize(stack));
                EncoderHandler.encode(os, stack.m_41720_(), false);
                EncoderHandler.encode(os, stack.m_41783_(), true);
                break;
            }
            case Long: {
                os.writeLong((Long)o);
                break;
            }
            case NBTTagCompound: {
                NbtIo.m_128941_((CompoundTag)((CompoundTag)o), (DataOutput)new ByteBufOutputStream((ByteBuf)os));
                break;
            }
            case Null: {
                if (withType) break;
                throw new IllegalArgumentException("o has to be non-null without types");
            }
            case Object: {
                throw new IllegalArgumentException("unhandled class: " + o.getClass());
            }
            case Potion: {
                EncoderHandler.encode(os, Registry.f_122828_.m_7981_((Object)((Potion)o)), false);
                break;
            }
            case ResourceLocation: {
                ResourceLocation loc = (ResourceLocation)o;
                os.writeString(loc.m_135827_());
                os.writeString(loc.m_135815_());
                break;
            }
            case Short: {
                os.writeShort(((Short)o).shortValue());
                break;
            }
            case String: {
                os.writeString((String)o);
                break;
            }
            case TileEntity: {
                BlockEntity te = (BlockEntity)o;
                EncoderHandler.encode(os, te.m_58904_(), false);
                EncoderHandler.encode(os, te.m_58899_(), false);
                break;
            }
            case UUID: {
                UUID uuid = (UUID)o;
                os.writeLong(uuid.getMostSignificantBits());
                os.writeLong(uuid.getLeastSignificantBits());
                break;
            }
            case Vec3: {
                Vector3d v = (Vector3d)o;
                os.writeDouble(v.f_86214_);
                os.writeDouble(v.f_86215_);
                os.writeDouble(v.f_86216_);
                break;
            }
            case World: {
                os.m_236858_(((Level)o).m_46472_());
                break;
            }
            case Vein: {
                Vein vein = (Vein)o;
                os.writeBytes((ByteBuf)vein.writePacket());
                break;
            }
            case RecipeInfo: {
                RecipeInfo recipeInfo = (RecipeInfo)o;
                os.writeBytes((ByteBuf)recipeInfo.getPacket());
                break;
            }
            case Radiation: {
                Radiation radiation = (Radiation)o;
                os.writeBytes((ByteBuf)radiation.writePacket());
                break;
            }
            default: {
                throw new IllegalArgumentException("unhandled type: " + type);
            }
        }
    }
}

