/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.componets.AbstractComponent;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.tiles.base.TileEntityBlock;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PacketAbstractComponent
implements IPacket {
    public PacketAbstractComponent() {
    }

    public PacketAbstractComponent(TileEntityBlock te, String componentName, ServerPlayer player, CustomPacketBuffer data) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(64);
        try {
            buffer.writeByte(this.getId());
            EncoderHandler.encode(buffer, te.m_58899_(), false);
            buffer.writeString(componentName);
            buffer.writeBytes((ByteBuf)data);
        }
        catch (IOException var7) {
            throw new RuntimeException(var7);
        }
        buffer.flip();
        IUCore.network.getServer().sendPacket(buffer, player);
    }

    @Override
    public byte getId() {
        return 2;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readPacket(CustomPacketBuffer is, Player entityPlayer) {
        TileEntityBlock tile;
        Object component;
        BlockPos pos1;
        try {
            pos1 = DecoderHandler.decode(is, BlockPos.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String componentName = is.readString();
        byte[] data = new byte[is.writerIndex() - is.readerIndex()];
        is.readBytes(data);
        BlockEntity teRaw = entityPlayer.m_9236_().m_7702_(pos1);
        if (teRaw instanceof TileEntityBlock && (component = (tile = (TileEntityBlock)teRaw).getComp(componentName)) != null) {
            try {
                ((AbstractComponent)component).onNetworkUpdate(new CustomPacketBuffer(data));
            }
            catch (IOException var6) {
                throw new RuntimeException(var6);
            }
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

