/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.api.space.fakebody.FakeAsteroid;
import com.denfop.api.space.fakebody.FakePlanet;
import com.denfop.api.space.fakebody.FakeSatellite;
import com.denfop.api.space.fakebody.IFakeAsteroid;
import com.denfop.api.space.fakebody.IFakeBody;
import com.denfop.api.space.fakebody.IFakePlanet;
import com.denfop.api.space.fakebody.IFakeSatellite;
import com.denfop.api.space.research.api.IResearchTable;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.mechanism.TileEntityResearchTableSpace;
import java.io.IOException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PacketUpdateFakeBody
implements IPacket {
    public PacketUpdateFakeBody() {
    }

    public PacketUpdateFakeBody(IResearchTable tileEntityResearchTableSpace, IFakeBody fakeBody) {
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer();
        packetBuffer.writeByte(this.getId());
        try {
            EncoderHandler.encode(packetBuffer, ((TileEntityBlock)((Object)tileEntityResearchTableSpace)).getWorld());
            EncoderHandler.encode(packetBuffer, ((TileEntityBlock)((Object)tileEntityResearchTableSpace)).getPos());
            if (fakeBody instanceof IFakePlanet) {
                packetBuffer.writeByte(0);
            }
            if (fakeBody instanceof IFakeSatellite) {
                packetBuffer.writeByte(1);
            }
            if (fakeBody instanceof IFakeAsteroid) {
                packetBuffer.writeByte(2);
            }
            if (fakeBody == null) {
                packetBuffer.writeByte(3);
            }
            if (fakeBody != null) {
                EncoderHandler.encode(packetBuffer, fakeBody.writeNBTTagCompound(new CompoundTag()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        IUCore.network.getServer().sendPacket(packetBuffer);
    }

    @Override
    public byte getId() {
        return 41;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        try {
            BlockEntity tile;
            Level world = (Level)DecoderHandler.decode(customPacketBuffer);
            BlockPos pos = (BlockPos)DecoderHandler.decode(customPacketBuffer);
            byte id = customPacketBuffer.readByte();
            assert (world != null);
            if (entityPlayer.m_9236_().m_46472_() == world.m_46472_() && (tile = world.m_7702_(pos)) instanceof TileEntityResearchTableSpace) {
                IFakeBody fakePlanet;
                CompoundTag nbt;
                if (id == 0) {
                    nbt = (CompoundTag)DecoderHandler.decode(customPacketBuffer);
                    fakePlanet = new FakePlanet(nbt);
                    ((TileEntityResearchTableSpace)tile).fakeBody = fakePlanet;
                }
                if (id == 1) {
                    nbt = (CompoundTag)DecoderHandler.decode(customPacketBuffer);
                    fakePlanet = new FakeSatellite(nbt);
                    ((TileEntityResearchTableSpace)tile).fakeBody = fakePlanet;
                }
                if (id == 2) {
                    nbt = (CompoundTag)DecoderHandler.decode(customPacketBuffer);
                    fakePlanet = new FakeAsteroid(nbt);
                    ((TileEntityResearchTableSpace)tile).fakeBody = fakePlanet;
                }
                if (id == 3) {
                    ((TileEntityResearchTableSpace)tile).fakeBody = null;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

