/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe;

import com.denfop.recipe.IInputItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InputOreDict
implements IInputItemStack {
    public int amount;
    public final Integer meta;
    private final TagKey<Item> tag;
    private final List<ItemStack> ores;

    public InputOreDict(String input) {
        this(input.toLowerCase(), 1);
    }

    public InputOreDict(String input, int amount) {
        this(input.toLowerCase(), amount, 0);
    }

    public InputOreDict(String input, int amount, Integer meta) {
        ResourceLocation input1 = new ResourceLocation(input.toLowerCase());
        this.amount = amount;
        this.meta = meta;
        this.tag = ItemTags.create((ResourceLocation)input1);
        this.ores = new ArrayList<ItemStack>();
        Iterable holder = Registry.f_122827_.m_206058_(this.tag);
        holder.forEach(itemHolder -> this.ores.add(new ItemStack(itemHolder)));
        for (ItemStack stack : this.ores) {
            stack.m_41764_(this.getAmount());
        }
    }

    public InputOreDict(TagKey<Item> tag, int amount) {
        this.amount = amount;
        this.meta = 0;
        this.tag = tag;
        this.ores = new ArrayList<ItemStack>();
        Registry.f_122827_.m_206058_(this.tag).forEach(itemHolder -> this.ores.add(new ItemStack(itemHolder)));
        for (ItemStack stack : this.ores) {
            stack.m_41764_(this.getAmount());
        }
    }

    @Override
    public void growAmount(int col) {
        this.amount += col;
        for (ItemStack stack : this.getOres()) {
            stack.m_41764_(this.getAmount());
        }
    }

    public InputOreDict(int amount, TagKey<Item> tag) {
        this.amount = amount;
        this.meta = 0;
        this.tag = tag;
        this.ores = new ArrayList<ItemStack>();
        Registry.f_122827_.m_206058_(this.tag).forEach(itemHolder -> this.ores.add(new ItemStack(itemHolder)));
        for (ItemStack stack : this.ores) {
            stack.m_41764_(this.getAmount());
        }
    }

    public InputOreDict(FriendlyByteBuf buffer) {
        this(buffer.readInt(), (TagKey<Item>)new TagKey(Registry.f_122904_, buffer.m_130281_()));
    }

    public static ItemStack setSize(ItemStack stack, int col) {
        stack = stack.m_41777_();
        stack.m_41764_(col);
        return stack;
    }

    @Override
    public boolean matches(ItemStack subject) {
        List<ItemStack> inputs = this.getOres();
        boolean useOreStackMeta = this.meta == null;
        Item subjectItem = subject.m_41720_();
        int subjectMeta = 0;
        return inputs.stream().anyMatch(oreStack -> {
            Item oreItem = oreStack.m_41720_();
            int metaRequired = useOreStackMeta ? 0 : this.meta;
            return subjectItem == oreItem && (subjectMeta == metaRequired || metaRequired == Short.MAX_VALUE);
        });
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeInt(1);
        buffer.writeInt(this.amount);
        buffer.m_130085_(this.tag.f_203868_());
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public List<ItemStack> getInputs() {
        List<ItemStack> ores = this.getOres();
        boolean allSuitableEntries = ores.stream().allMatch(stack -> stack.m_41613_() == this.getAmount());
        if (allSuitableEntries) {
            return ores;
        }
        return ores.stream().filter(stack -> stack.m_41720_() != ItemStack.f_41583_.m_41720_()).map(stack -> stack.m_41613_() == this.getAmount() ? stack : InputOreDict.setSize(stack, this.getAmount())).toList();
    }

    @Override
    public boolean haTag() {
        return true;
    }

    @Override
    public TagKey<Item> getTag() {
        return this.tag;
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            InputOreDict other = (InputOreDict)obj;
            if (this.tag.equals(other.tag) && other.amount == this.amount) {
                return Objects.equals(this.meta, other.meta);
            }
        }
        return false;
    }

    private List<ItemStack> getOres() {
        return this.ores;
    }
}

