/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.base;

import com.denfop.tiles.base.IIsMolecular;
import com.denfop.tiles.base.TileEntityBlock;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;

public class RenderCoreProcess<T extends TileEntityBlock>
implements BlockEntityRenderer<T> {
    private static final Map<List<Serializable>, Integer> textureSizeCache = new HashMap<List<Serializable>, Integer>();
    private static final ResourceLocation plazmaTextloc = new ResourceLocation("industrialupgrade", "textures/models/plazma.png");
    private static final ResourceLocation particlesTextloc = new ResourceLocation("industrialupgrade", "textures/models/particles.png");
    public static int size1 = -1;
    public static int size2 = -1;
    private final BlockEntityRendererProvider.Context contex;
    private final Random random = new Random();
    public int ticker;
    float rotation;
    float prevRotation;

    public RenderCoreProcess(BlockEntityRendererProvider.Context p_173636_) {
        this.contex = p_173636_;
    }

    public static int getTextureSize(String s, int dv) {
        Integer textureSize = textureSizeCache.get(Arrays.asList(s, dv));
        if (textureSize != null) {
            return textureSize;
        }
        try {
            InputStream inputstream = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation("industrialupgrade", s)).get()).m_215507_();
            BufferedImage bi = ImageIO.read(inputstream);
            int size = bi.getWidth() / dv;
            textureSizeCache.put(Arrays.asList(s, dv), size);
            return size;
        }
        catch (Exception var5) {
            var5.printStackTrace();
            return 16;
        }
    }

    public void render(T te, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int combinedOverlay) {
        if (((TileEntityBlock)((Object)te)).getActive()) {
            this.renderCore(te, poseStack, bufferSource, packedLight, combinedOverlay);
            this.renderItem((IIsMolecular)te, poseStack, bufferSource, packedLight, combinedOverlay);
        }
    }

    public void renderItem(IIsMolecular te, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        ItemStack itemStack = te.getItemStack();
        if (itemStack.m_41619_()) {
            return;
        }
        BakedModel bakedModel = te.getBakedModel();
        if (bakedModel != null) {
            boolean isGui3d = bakedModel.m_7539_();
            poseStack.m_85836_();
            int count = this.transformModelCount(te, poseStack, buffer, Minecraft.m_91087_().getPartialTick());
            for (int i = 0; i < count; ++i) {
                poseStack.m_85836_();
                if (isGui3d) {
                    if (i > 0) {
                        float xOffset = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        yOffset = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        float zOffset = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        poseStack.m_85837_((double)xOffset, (double)yOffset, (double)zOffset);
                    }
                } else if (i > 0) {
                    float xOffset = (this.random.nextFloat() * 2.0f - 1.0f) * 0.075f;
                    yOffset = (this.random.nextFloat() * 2.0f - 1.0f) * 0.075f;
                    poseStack.m_85837_((double)xOffset, (double)yOffset, 0.0);
                }
                BakedModel transformedModel = te.getTransformedModel();
                this.contex.m_234447_().m_115143_(itemStack, ItemTransforms.TransformType.FIXED, false, poseStack, buffer, light, overlay, transformedModel);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
    }

    private int transformModelCount(IIsMolecular itemIn, PoseStack poseStack, MultiBufferSource bufferSource, float partialTicks) {
        ItemStack itemStack = itemIn.getItemStack();
        Item item = itemStack.m_41720_();
        if (item == Items.f_41852_) {
            return 0;
        }
        int modelCount = 1;
        float offsetY = 1.0f;
        poseStack.m_85837_(0.5, (double)(0.25f * offsetY) + 0.25, 0.5);
        poseStack.m_85841_(0.4f, 0.4f, 0.4f);
        this.prevRotation = this.rotation = (this.prevRotation + (this.rotation - this.prevRotation) * partialTicks) % 360.0f;
        this.rotation += 0.15f;
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(this.rotation));
        return modelCount;
    }

    private void renderCore(T te, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int combinedOverlay) {
        ++this.ticker;
        if (this.ticker % 2 != 0) {
            return;
        }
        if (this.ticker > 161) {
            this.ticker = 1;
        }
        if (size1 == -1) {
            size1 = RenderCoreProcess.getTextureSize("textures/models/plazma.png", 64);
        }
        if (size1 == -2) {
            size2 = RenderCoreProcess.getTextureSize("textures/models/particles.png", 32);
        }
        Camera camera = this.contex.m_234446_().f_114358_;
        Quaternion rotation = camera.m_90591_();
        float scaleCore = 0.35f;
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        float posX = 0.5f;
        float posY = 0.5f;
        float posZ = 0.5f;
        Color color = new Color(0xC0FFFF);
        poseStack.m_85836_();
        poseStack.m_85841_(scaleCore, scaleCore, scaleCore);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.m_69482_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)plazmaTextloc);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        int i = this.ticker % 16;
        float size4 = size1 * 4;
        float float_sizeMinus0_01 = (float)size1 - 0.01f;
        float x0 = ((float)(i % 4 * size1) + 0.0f) / size4;
        float x1 = ((float)(i % 4 * size1) + float_sizeMinus0_01) / size4;
        float x2 = ((float)i / 4.0f * (float)size1 + 0.0f) / size4;
        float x3 = ((float)i / 4.0f * (float)size1 + float_sizeMinus0_01) / size4;
        Vec3 lookVec = new Vec3(camera.m_90596_());
        Vec3 upVec = new Vec3(camera.m_90597_());
        Vec3 rightVec = new Vec3(camera.m_167686_());
        float f1 = (float)rightVec.f_82479_;
        float f2 = (float)rightVec.f_82480_;
        float f3 = (float)rightVec.f_82481_;
        float f4 = (float)upVec.f_82479_;
        float f5 = (float)upVec.f_82481_;
        buffer.m_85982_(matrix, (float)((double)posX + rightVec.f_82479_ * (double)(-scaleCore) + upVec.f_82479_ * (double)(-scaleCore)), (float)((double)posY + rightVec.f_82480_ * (double)(-scaleCore) + upVec.f_82480_ * (double)(-scaleCore)), (float)((double)posZ + rightVec.f_82481_ * (double)(-scaleCore) + upVec.f_82481_ * (double)(-scaleCore))).m_7421_(x1, x3).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
        buffer.m_85982_(matrix, (float)((double)posX + rightVec.f_82479_ * (double)(-scaleCore) + upVec.f_82479_ * (double)scaleCore), (float)((double)posY + rightVec.f_82480_ * (double)(-scaleCore) + upVec.f_82480_ * (double)scaleCore), (float)((double)posZ + rightVec.f_82481_ * (double)(-scaleCore) + upVec.f_82481_ * (double)scaleCore)).m_7421_(x1, x2).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
        buffer.m_85982_(matrix, (float)((double)posX + rightVec.f_82479_ * (double)scaleCore + upVec.f_82479_ * (double)scaleCore), (float)((double)posY + rightVec.f_82480_ * (double)scaleCore + upVec.f_82480_ * (double)scaleCore), (float)((double)posZ + rightVec.f_82481_ * (double)scaleCore + upVec.f_82481_ * (double)scaleCore)).m_7421_(x0, x2).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
        buffer.m_85982_(matrix, (float)((double)posX + rightVec.f_82479_ * (double)scaleCore + upVec.f_82479_ * (double)(-scaleCore)), (float)((double)posY + rightVec.f_82480_ * (double)scaleCore + upVec.f_82480_ * (double)(-scaleCore)), (float)((double)posZ + rightVec.f_82481_ * (double)scaleCore + upVec.f_82481_ * (double)(-scaleCore))).m_7421_(x0, x3).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.m_69465_();
        RenderSystem.m_69461_();
        poseStack.m_85849_();
        poseStack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        int qq = this.ticker % 16;
        i = 24 + qq;
        float size8 = size2 * 8;
        float_sizeMinus0_01 = (float)size2 - 0.01f;
        x0 = ((float)(i % 8 * size2) + 0.0f) / size8;
        x1 = ((float)(i % 8 * size2) + float_sizeMinus0_01) / size8;
        x2 = ((float)i / 8.0f * (float)size2 + 0.0f) / size8;
        x3 = ((float)i / 8.0f * (float)size2 + float_sizeMinus0_01) / size8;
        float var11 = Mth.m_14031_((float)((float)this.ticker / 10.0f)) * 0.1f;
        scaleCore = 0.4f + var11;
        buffer = tesselator.m_85915_();
        RenderSystem.m_69482_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)plazmaTextloc);
        if (((IIsMolecular)te).getMode() != 0) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("industrialupgrade", "textures/models/particles" + ((IIsMolecular)te).getMode() + ".png"));
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)particlesTextloc);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        buffer.m_85982_(matrix, (float)((double)posX + rightVec.f_82479_ * (double)(-scaleCore) + upVec.f_82479_ * (double)(-scaleCore)), (float)((double)posY + rightVec.f_82480_ * (double)(-scaleCore) + upVec.f_82480_ * (double)(-scaleCore)), (float)((double)posZ + rightVec.f_82481_ * (double)(-scaleCore) + upVec.f_82481_ * (double)(-scaleCore))).m_7421_(x1, x3).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
        buffer.m_85982_(matrix, (float)((double)posX + rightVec.f_82479_ * (double)(-scaleCore) + upVec.f_82479_ * (double)scaleCore), (float)((double)posY + rightVec.f_82480_ * (double)(-scaleCore) + upVec.f_82480_ * (double)scaleCore), (float)((double)posZ + rightVec.f_82481_ * (double)(-scaleCore) + upVec.f_82481_ * (double)scaleCore)).m_7421_(x1, x2).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
        buffer.m_85982_(matrix, (float)((double)posX + rightVec.f_82479_ * (double)scaleCore + upVec.f_82479_ * (double)scaleCore), (float)((double)posY + rightVec.f_82480_ * (double)scaleCore + upVec.f_82480_ * (double)scaleCore), (float)((double)posZ + rightVec.f_82481_ * (double)scaleCore + upVec.f_82481_ * (double)scaleCore)).m_7421_(x0, x2).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
        buffer.m_85982_(matrix, (float)((double)posX + rightVec.f_82479_ * (double)scaleCore + upVec.f_82479_ * (double)(-scaleCore)), (float)((double)posY + rightVec.f_82480_ * (double)scaleCore + upVec.f_82480_ * (double)(-scaleCore)), (float)((double)posZ + rightVec.f_82481_ * (double)scaleCore + upVec.f_82481_ * (double)(-scaleCore))).m_7421_(x0, x3).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.m_69465_();
        RenderSystem.m_69461_();
        poseStack.m_85849_();
    }
}

