/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.windgenerator;

import com.denfop.render.windgenerator.RotorModel;
import com.denfop.tiles.mechanism.wind.TileWindGenerator;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class KineticGeneratorRenderer
implements BlockEntityRenderer<TileWindGenerator> {
    private static final Map<Integer, RotorModel> rotorModels = new HashMap<Integer, RotorModel>();

    public KineticGeneratorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileWindGenerator tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        TileWindGenerator windGen = tile;
        Level world = tile.m_58904_();
        BlockPos pos = tile.m_58899_();
        int diameter = windGen.getRotorDiameter();
        if (diameter == 0) {
            return;
        }
        float angle = windGen.getAngle();
        ResourceLocation rotorTexture = windGen.getRotorRenderTexture();
        RotorModel model = rotorModels.computeIfAbsent(diameter, RotorModel::new);
        Direction facing = windGen.getFacing();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.5, 0.0);
        switch (facing) {
            case NORTH: {
                poseStack.m_85837_(0.5, 0.0, 0.0);
                break;
            }
            case EAST: {
                poseStack.m_85837_(1.0, 0.0, 0.5);
                break;
            }
            case SOUTH: {
                poseStack.m_85837_(0.5, 0.0, 1.0);
                break;
            }
            case WEST: {
                poseStack.m_85837_(0.0, 0.0, 0.5);
            }
        }
        switch (facing) {
            case NORTH: {
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                break;
            }
            case EAST: {
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-180.0f));
                break;
            }
            case SOUTH: {
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-270.0f));
                break;
            }
            case UP: {
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-90.0f));
            }
        }
        if (windGen.getSpace()) {
            angle = windGen.getAngle();
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(angle));
        }
        poseStack.m_85837_((double)-0.2f, 0.0, 0.0);
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)rotorTexture));
        model.m_7695_(poseStack, buffer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(TileWindGenerator tile) {
        return true;
    }
}

