/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerWorldCollector;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiWolrdCollector;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.invslot.InvSlotWorldCollector;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.EnumTypeCollector;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileBaseWorldCollector
extends TileElectricMachine
implements IUpdateTick,
IUpgradableBlock,
IHasRecipe {
    public final EnumTypeCollector enumTypeCollector;
    public final InvSlotRecipes inputSlot;
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlotWorldCollector MatterSlot;
    public final double max_matter_energy;
    private final double defaultEnergyConsume;
    private final int defaultOperationLength;
    public double matter_energy;
    public double need_matter;
    public double guiProgress;
    protected MachineRecipe machineRecipe;
    private double energyConsume;
    private int operationLength;
    private int operationsPerTick;
    private boolean canWork = false;
    private int progress;

    public TileBaseWorldCollector(EnumTypeCollector enumTypeCollector1, IMultiTileBlock block, BlockPos pos, BlockState state) {
        super(0.0, 1, 1, block, pos, state);
        this.enumTypeCollector = enumTypeCollector1;
        this.MatterSlot = new InvSlotWorldCollector(this);
        this.inputSlot = new InvSlotRecipes((TileEntityInventory)this, enumTypeCollector1.name().toLowerCase() + "collector", (IUpdateTick)this);
        this.machineRecipe = null;
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.energyConsume = 40.0;
        this.defaultEnergyConsume = 40.0;
        this.operationLength = 800;
        this.defaultOperationLength = 800;
        this.operationsPerTick = 1;
        this.matter_energy = 0.0;
        this.max_matter_energy = 10000.0;
        Recipes.recipes.addInitRecipes(this);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.need_info") + new ItemStack((ItemLike)IUItem.matter.getStack(this.enumTypeCollector.getMeta()), 1).m_41611_().getString());
        super.addInformation(stack, tooltip);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
            this.need_matter = (Double)DecoderHandler.decode(customPacketBuffer);
            this.matter_energy = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
            EncoderHandler.encode(packet, this.need_matter);
            EncoderHandler.encode(packet, this.matter_energy);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    protected void addRecipe(ItemStack input, double need, ItemStack output) {
        IInputHandler input_recipe = Recipes.inputFactory;
        CompoundTag nbt = ModUtils.nbt();
        nbt.m_128347_("need", need);
        Recipes.recipes.addRecipe(this.enumTypeCollector.name().toLowerCase() + "collector", new BaseMachineRecipe(new Input(input_recipe.getInput(input)), new RecipeOutput(nbt, output)));
    }

    protected void addRecipe(String input, ItemStack output, double need) {
        IInputHandler input_recipe = Recipes.inputFactory;
        CompoundTag nbt = ModUtils.nbt();
        nbt.m_128347_("need", this.getMatterFromEnergy(need));
        Recipes.recipes.addRecipe(this.enumTypeCollector.name().toLowerCase() + "collector", new BaseMachineRecipe(new Input(input_recipe.getInput(input)), new RecipeOutput(nbt, output)));
    }

    public MachineRecipe getOutput() {
        this.machineRecipe = this.inputSlot.process();
        return this.machineRecipe;
    }

    protected double getMatterFromEnergy(double energy) {
        return energy / 250000.0;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.f_58857_.f_46443_) {
            this.inputSlot.load();
            this.setOverclockRates();
            this.getOutput();
            if (this.machineRecipe != null) {
                this.getrequiredmatter(this.machineRecipe.getRecipe().getOutput());
            } else {
                this.getrequiredmatter(null);
            }
            this.MatterSlot.getmatter();
        }
    }

    public void operate(MachineRecipe output) {
        for (int i = 0; i < this.operationsPerTick; ++i) {
            this.operateOnce(output.getRecipe().output.items);
            if (this.matter_energy < this.need_matter) break;
            if (this.inputSlot.get(0).m_41619_() || this.inputSlot.get(0).m_41613_() < this.machineRecipe.getRecipe().input.getInputs().get(0).getInputs().get(0).m_41613_() || !this.outputSlot.canAdd(output.getRecipe().output.items)) {
                this.getOutput();
                break;
            }
            if (!(this.matter_energy < this.need_matter && this.inputSlot.get(0).m_41619_() || this.inputSlot.get(0).m_41613_() < 1) && this.outputSlot.canAdd(output.getRecipe().output.items)) continue;
            this.getOutput();
            break;
        }
    }

    public void operateOnce(List<ItemStack> processResult) {
        this.matter_energy -= this.need_matter;
        this.inputSlot.consume();
        this.outputSlot.add(processResult);
        this.getrequiredmatter(this.machineRecipe.getRecipe().getOutput());
    }

    public void setOverclockRates() {
        this.operationsPerTick = this.upgradeSlot.getOperationsPerTick(this.defaultOperationLength);
        this.operationLength = this.upgradeSlot.getOperationLength(this.defaultOperationLength);
        this.energyConsume = this.upgradeSlot.getEnergyDemand(this.defaultEnergyConsume);
    }

    public boolean useEnergy(double amount, boolean consume) {
        if (this.energy.canUseEnergy(amount)) {
            if (consume) {
                this.energy.useEnergy(amount);
            }
            return true;
        }
        return false;
    }

    public double getGuiProgress() {
        return this.guiProgress;
    }

    public double getMatter_energy() {
        return this.matter_energy;
    }

    public double getMax_matter_energy() {
        return this.max_matter_energy;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.matter_energy = nbttagcompound.m_128459_("matter_energy");
        this.progress = nbttagcompound.m_128451_("progress");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        CompoundTag nbt = super.writeToNBT(nbttagcompound);
        nbt.m_128347_("matter_energy", this.matter_energy);
        nbt.m_128405_("progress", this.progress);
        return nbt;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        MachineRecipe output = this.machineRecipe;
        if (this.f_58857_.m_46467_() % 20L == 0L && output != null && this.matter_energy + 200.0 < this.max_matter_energy) {
            this.MatterSlot.getmatter();
        }
        if (output != null && this.outputSlot.canAdd(this.machineRecipe.getRecipe().output.items) && !this.inputSlot.isEmpty() && this.canWork && this.need_matter <= this.matter_energy) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            ++this.progress;
            double p = (double)this.progress * 1.0 / (double)this.operationLength;
            if (p <= 1.0) {
                this.guiProgress = p;
            }
            if (p > 1.0) {
                this.guiProgress = 1.0;
            }
            if (this.progress >= this.operationLength) {
                this.operate(output);
                this.progress = 0;
            }
        } else {
            if (this.progress != 0) {
                this.progress = 0;
            }
            this.guiProgress = 0.0;
            if (this.getActive()) {
                this.setActive(false);
            }
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setOverclockRates();
        }
    }

    public ContainerWorldCollector getGuiContainer(Player entityPlayer) {
        return new ContainerWorldCollector(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiWolrdCollector((ContainerWorldCollector)menu);
    }

    @Override
    public void onUpdate() {
        if (this.machineRecipe == null) {
            this.getrequiredmatter(null);
        } else {
            this.getrequiredmatter(this.machineRecipe.getRecipe().getOutput());
        }
        this.MatterSlot.getmatter();
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.machineRecipe;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.machineRecipe = output;
    }

    public void getrequiredmatter(RecipeOutput output) {
        if (output == null) {
            this.need_matter = 0.0;
            this.canWork = false;
            return;
        }
        this.canWork = true;
        this.need_matter = output.metadata.m_128459_("need");
    }

    @Override
    public void init() {
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

