/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.reactors.CreativeReactor;
import com.denfop.api.reactors.EnumReactors;
import com.denfop.api.reactors.EnumTypeComponent;
import com.denfop.api.reactors.EnumTypeSecurity;
import com.denfop.api.reactors.IReactorItem;
import com.denfop.api.reactors.ITypeRector;
import com.denfop.api.reactors.LogicCreativeFluidReactor;
import com.denfop.api.reactors.LogicCreativeGasReactor;
import com.denfop.api.reactors.LogicCreativeGraphiteReactor;
import com.denfop.api.reactors.LogicCreativeHeatReactor;
import com.denfop.api.reactors.LogicCreativeReactor;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerSimulationReactors;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiSimulationReactors;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotSimulatorReactor;
import com.denfop.items.ItemCraftingElements;
import com.denfop.items.reactors.ItemComponentVent;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntitySimulatorReactor
extends TileEntityInventory
implements IUpdatableTileEvent {
    public final InvSlotSimulatorReactor invSlot = new InvSlotSimulatorReactor(this, InvSlot.TypeItemSlot.INPUT, 80){

        @Override
        public boolean accepts(ItemStack stack, int index) {
            if (TileEntitySimulatorReactor.this.reactors == null) {
                return false;
            }
            switch (TileEntitySimulatorReactor.this.reactors.getType()) {
                case FLUID: 
                case HIGH_SOLID: {
                    if (stack.m_41720_() instanceof IReactorItem) {
                        IReactorItem iReactorItem = (IReactorItem)stack.m_41720_();
                        return TileEntitySimulatorReactor.this.levelReactor >= iReactorItem.getLevel();
                    }
                    return false;
                }
                case GAS_COOLING_FAST: {
                    if (stack.m_41720_() instanceof IReactorItem) {
                        IReactorItem iReactorItem = (IReactorItem)stack.m_41720_();
                        return TileEntitySimulatorReactor.this.levelReactor >= iReactorItem.getLevel() && (iReactorItem.getType() != EnumTypeComponent.HEAT_SINK || stack.m_41720_() instanceof ItemComponentVent);
                    }
                    return false;
                }
                case GRAPHITE_FLUID: {
                    if (stack.m_41720_() instanceof IReactorItem) {
                        IReactorItem iReactorItem = (IReactorItem)stack.m_41720_();
                        return TileEntitySimulatorReactor.this.levelReactor >= iReactorItem.getLevel() && iReactorItem.getType() != EnumTypeComponent.HEAT_EXCHANGER;
                    }
                    return false;
                }
            }
            return false;
        }

        @Override
        public ItemStack set(int index, ItemStack content) {
            super.set(index, content);
            TileEntitySimulatorReactor.this.needUpdate = true;
            switch (TileEntitySimulatorReactor.this.reactors.getType()) {
                case FLUID: {
                    TileEntitySimulatorReactor.this.logicReactor = new LogicCreativeFluidReactor(TileEntitySimulatorReactor.this.reactor);
                    break;
                }
                case GAS_COOLING_FAST: {
                    TileEntitySimulatorReactor.this.logicReactor = new LogicCreativeGasReactor(TileEntitySimulatorReactor.this.reactor);
                    break;
                }
                case GRAPHITE_FLUID: {
                    TileEntitySimulatorReactor.this.logicReactor = new LogicCreativeGraphiteReactor(TileEntitySimulatorReactor.this.reactor);
                    break;
                }
                case HIGH_SOLID: {
                    TileEntitySimulatorReactor.this.logicReactor = new LogicCreativeHeatReactor(TileEntitySimulatorReactor.this.reactor);
                }
            }
            return content;
        }
    };
    public final InvSlot scheduleSlot;
    public int f_58855_ = -1;
    public int levelReactor = -1;
    public EnumReactors reactors;
    public CreativeReactor reactor = new CreativeReactor(this.reactors, this.invSlot);
    public boolean work;
    public boolean explode;
    public LogicCreativeReactor logicReactor;
    public double output;
    public double rad;
    public double heat;
    public EnumTypeSecurity security;
    private boolean needUpdate = false;

    public TileEntitySimulatorReactor(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.simulation_reactors, pos, state);
        this.scheduleSlot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.m_41720_() instanceof ItemCraftingElements && ((ISubEnum)((ItemCraftingElements)stack.m_41720_()).getElement()).getId() == 143;
            }

            @Override
            public int getStackSizeLimit() {
                return 1;
            }
        };
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
        this.explode = customPacketBuffer.readBoolean();
        this.rad = customPacketBuffer.readDouble();
        this.output = customPacketBuffer.readDouble();
        this.heat = customPacketBuffer.readDouble();
        this.security = EnumTypeSecurity.values()[customPacketBuffer.readInt()];
        this.f_58855_ = customPacketBuffer.readInt();
        this.levelReactor = customPacketBuffer.readInt();
        try {
            this.reactor.timer.readBuffer(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        this.f_58855_ = customPacketBuffer.readInt();
        this.levelReactor = customPacketBuffer.readInt();
        if (this.levelReactor != -1 && this.f_58855_ != -1) {
            this.reactors = EnumReactors.values()[(this.f_58855_ - 1) * 4 + (this.levelReactor - 1)];
            this.reactor.level = this.levelReactor;
            this.invSlot.clear();
            this.reactor.reset(this.reactors);
            this.size_inventory = 0;
            for (InvSlot invSlot : this.invSlots) {
                this.size_inventory += invSlot.size();
            }
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        customPacketBuffer.writeInt(this.f_58855_);
        customPacketBuffer.writeInt(this.levelReactor);
        return customPacketBuffer;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.simulation_reactors;
    }

    public ContainerSimulationReactors getGuiContainer(Player var1) {
        return new ContainerSimulationReactors(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiSimulationReactors((ContainerSimulationReactors)menu);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.m_128405_("type", this.f_58855_);
        nbtTagCompound.m_128405_("level", this.levelReactor);
        nbtTagCompound.m_128379_("work", this.work);
        nbtTagCompound.m_128379_("explode", this.explode);
        if (this.reactors != null) {
            nbtTagCompound.m_128405_("reactors", this.reactors.ordinal());
        }
        return nbtTagCompound;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.f_58855_ = nbtTagCompound.m_128451_("type");
        this.levelReactor = nbtTagCompound.m_128451_("level");
        this.reactors = EnumReactors.values()[nbtTagCompound.m_128451_("reactors")];
        this.work = nbtTagCompound.m_128471_("work");
        this.explode = nbtTagCompound.m_128471_("explode");
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeBoolean(this.explode);
        customPacketBuffer.writeDouble(this.rad);
        customPacketBuffer.writeDouble(this.output);
        customPacketBuffer.writeDouble(this.heat);
        customPacketBuffer.writeInt(this.security.ordinal());
        customPacketBuffer.writeInt(this.f_58855_);
        customPacketBuffer.writeInt(this.levelReactor);
        this.reactor.timer.writeBuffer(customPacketBuffer);
        return customPacketBuffer;
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.needUpdate && this.f_58857_.m_46467_() % 20L == 0L && this.reactors != null && !this.scheduleSlot.isEmpty()) {
            this.needUpdate = false;
            ItemStack stack = this.scheduleSlot.get(0);
            CompoundTag nbt = ModUtils.nbt(stack);
            List<ItemStack> infoStack = this.logicReactor.getInfoStack();
            ListTag stacks = new ListTag();
            for (ItemStack stack1 : infoStack) {
                CompoundTag contentTag = new CompoundTag();
                stack1.m_41739_(contentTag);
                stacks.add((Object)contentTag);
            }
            nbt.m_128405_("type", this.f_58855_);
            nbt.m_128405_("level", this.levelReactor);
            nbt.m_128359_("name", this.reactors.getNameReactor().toLowerCase());
            nbt.m_128405_("generation", (int)((double)this.logicReactor.getGeneration() * (this.reactors.getType() == ITypeRector.GAS_COOLING_FAST ? 1.175 : 1.0)));
            nbt.m_128405_("rad", this.logicReactor.getRadGeneration());
            nbt.m_128365_("Items", (Tag)stacks);
            for (int y = 0; y < this.reactors.getHeight(); ++y) {
                for (int x = 0; x < this.reactors.getWidth(); ++x) {
                    CompoundTag tag = new CompoundTag();
                    ItemStack stack1 = this.reactor.getItemAt(x, y);
                    if (stack1.m_41619_()) {
                        tag.m_128379_("empty", true);
                        nbt.m_128365_(String.valueOf(y * this.reactors.getWidth() + x), (Tag)tag);
                        continue;
                    }
                    tag.m_128379_("empty", false);
                    for (int i = 0; i < infoStack.size(); ++i) {
                        if (!infoStack.get(i).m_150930_(stack1.m_41720_())) continue;
                        tag.m_128405_("index", i);
                        break;
                    }
                    nbt.m_128365_(String.valueOf(y * this.reactors.getWidth() + x), (Tag)tag);
                }
            }
        }
        if (this.work && !this.explode && this.reactors != null) {
            this.logicReactor.onTick();
            this.reactor.tick(this.logicReactor.getMaxHeat());
            this.explode = this.reactor.explode;
            this.output = this.reactor.getOutput();
            this.rad = this.reactor.getRad();
            this.heat = this.reactor.getHeat();
            this.security = this.reactor.getSecurity();
        } else {
            this.output = 0.0;
            this.rad = 0.0;
            this.heat = 0.0;
            if (this.security != EnumTypeSecurity.NONE) {
                this.reactor.setTime(EnumTypeSecurity.STABLE);
            }
            this.security = EnumTypeSecurity.NONE;
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.f_58857_.f_46443_ && this.f_58855_ != -1 && this.levelReactor != -1) {
            this.reactors = EnumReactors.values()[(this.f_58855_ - 1) * 4 + (this.levelReactor - 1)];
            this.invSlot.clear();
            this.reactor.reset(this.reactors);
            this.reactor.level = this.levelReactor;
            this.work = false;
            this.explode = false;
            this.reactor.setTime(EnumTypeSecurity.STABLE);
            switch (this.reactors.getType()) {
                case FLUID: {
                    this.logicReactor = new LogicCreativeFluidReactor(this.reactor);
                    break;
                }
                case GAS_COOLING_FAST: {
                    this.logicReactor = new LogicCreativeGasReactor(this.reactor);
                    break;
                }
                case GRAPHITE_FLUID: {
                    this.logicReactor = new LogicCreativeGraphiteReactor(this.reactor);
                    break;
                }
                case HIGH_SOLID: {
                    this.logicReactor = new LogicCreativeHeatReactor(this.reactor);
                }
            }
        }
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (var2 < 0.0) {
            this.levelReactor = (int)(var2 *= -1.0);
        } else if (var2 >= 1.0) {
            this.f_58855_ = (int)var2;
        } else if (var2 < 1.0) {
            this.work = !this.work;
            this.explode = false;
            this.reactor.explode = false;
            this.reactor.setTime(EnumTypeSecurity.STABLE);
            return;
        }
        if (this.levelReactor != -1 && this.f_58855_ != -1) {
            this.reactors = EnumReactors.values()[(this.f_58855_ - 1) * 4 + (this.levelReactor - 1)];
            this.invSlot.clear();
            this.reactor.reset(this.reactors);
            this.size_inventory = 0;
            for (InvSlot invSlot : this.invSlots) {
                this.size_inventory += invSlot.size();
            }
            this.work = false;
            this.explode = false;
            var1.m_6915_();
            this.reactor.setTime(EnumTypeSecurity.STABLE);
            this.reactor.level = this.levelReactor;
            switch (this.reactors.getType()) {
                case FLUID: {
                    this.logicReactor = new LogicCreativeFluidReactor(this.reactor);
                    break;
                }
                case GAS_COOLING_FAST: {
                    this.logicReactor = new LogicCreativeGasReactor(this.reactor);
                    break;
                }
                case GRAPHITE_FLUID: {
                    this.logicReactor = new LogicCreativeGraphiteReactor(this.reactor);
                    break;
                }
                case HIGH_SOLID: {
                    this.logicReactor = new LogicCreativeHeatReactor(this.reactor);
                }
            }
        }
    }
}

