/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.reactors.IGraphiteReactor;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerWirelessControllerGraphiteReactors;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiWirelessControllerGraphiteReactors;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemReactorData;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.tiles.reactors.graphite.IGraphiteController;
import com.denfop.tiles.reactors.graphite.graphite_controller.TileEntityGraphiteController;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ModUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityWirelessGraphiteController
extends TileEntityInventory
implements IUpdatableTileEvent {
    public final InvSlot invslot;
    public List<ItemStack> itemStacks = new LinkedList<ItemStack>();
    public List<TileEntityGraphiteController> graphiteControllers = new LinkedList<TileEntityGraphiteController>();
    public TileMultiBlockBase tileMultiBlockBase = null;

    public TileEntityWirelessGraphiteController(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.wireless_controller_graphite_reactors, pos, state);
        this.invslot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                TileEntityWirelessGraphiteController.this.updateList();
                return content;
            }

            @Override
            public boolean accepts(ItemStack stack, int index) {
                if (!(stack.m_41720_() instanceof ItemReactorData)) {
                    return false;
                }
                CompoundTag nbt = ModUtils.nbt(stack);
                return !nbt.m_128461_("name").isEmpty();
            }
        };
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    public ContainerWirelessControllerGraphiteReactors getGuiContainer(Player var1) {
        return new ContainerWirelessControllerGraphiteReactors(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiWirelessControllerGraphiteReactors((ContainerWirelessControllerGraphiteReactors)menu);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.wireless_controller_graphite_reactors;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            // empty if block
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packetBuffer = super.writeContainerPacket();
        this.updateList();
        packetBuffer.m_130055_(this.invslot.get(0));
        return packetBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.invslot.set(0, customPacketBuffer.m_130267_());
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.updateList();
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
        if (!this.getWorld().f_46443_) {
            this.updateList();
        }
    }

    public void updateList() {
        this.itemStacks.clear();
        this.graphiteControllers.clear();
        this.itemStacks.clear();
        this.tileMultiBlockBase = null;
        CompoundTag nbt = ModUtils.nbt(this.invslot.get(0));
        BlockPos pos = new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
        BlockEntity tileEntity = this.getWorld().m_7702_(pos);
        if (tileEntity instanceof TileMultiBlockBase && tileEntity instanceof IGraphiteReactor) {
            this.tileMultiBlockBase = (TileMultiBlockBase)tileEntity;
            if (this.tileMultiBlockBase.isFull()) {
                List<BlockPos> pos1 = this.tileMultiBlockBase.getMultiBlockStucture().getPosFromClass(this.tileMultiBlockBase.getFacing(), this.tileMultiBlockBase.m_58899_(), IGraphiteController.class);
                for (BlockPos pos2 : pos1) {
                    BlockEntity tileEntity1 = this.getWorld().m_7702_(pos2);
                    if (tileEntity1 == null) continue;
                    this.graphiteControllers.add((TileEntityGraphiteController)tileEntity1);
                    this.itemStacks.add(((TileEntityGraphiteController)tileEntity1).getPickBlock(null, null));
                }
            }
        } else {
            this.itemStacks.add(ItemStack.f_41583_);
        }
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (!this.invslot.get(0).m_41619_() && this.tileMultiBlockBase != null) {
            TileEntityGraphiteController controller;
            if ((double)this.graphiteControllers.size() < var2) {
                this.graphiteControllers.clear();
                if (this.tileMultiBlockBase.isFull()) {
                    List<BlockPos> pos1 = this.tileMultiBlockBase.getMultiBlockStucture().getPosFromClass(this.tileMultiBlockBase.getFacing(), this.tileMultiBlockBase.m_58899_(), IGraphiteController.class);
                    for (BlockPos pos2 : pos1) {
                        BlockEntity tileEntity1 = this.getWorld().m_7702_(pos2);
                        if (tileEntity1 == null) continue;
                        this.graphiteControllers.add((TileEntityGraphiteController)tileEntity1);
                    }
                }
            }
            if ((controller = this.graphiteControllers.get((int)var2)) != null && controller.getMain() != null && controller.getMain().isFull() && !controller.m_58901_()) {
                controller.onActivated(var1, var1.m_7655_(), Direction.NORTH, new Vec3(0.0, 0.0, 0.0));
            }
        }
    }
}

