/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.gui.IType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.vein.IVein;
import com.denfop.api.vein.Type;
import com.denfop.api.vein.VeinSystem;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockQuarryVein;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerQuarryVein;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiQuarryVein;
import com.denfop.items.ItemVeinSensor;
import com.denfop.items.upgradekit.ItemUpgradeMachinesKit;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.render.oilquarry.DataBlock;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileQuarryVein
extends TileElectricMachine
implements IUpdatableTileEvent,
IType {
    @OnlyIn(value=Dist.CLIENT)
    public DataBlock dataBlock;
    public int levelMech = 1;
    public int time = 0;
    public int progress = 0;
    public IVein vein;
    public boolean start = true;
    public int col;
    private int count = 0;
    private boolean work;

    public TileQuarryVein(BlockPos pos, BlockState state) {
        super(400.0, 14, 1, BlockQuarryVein.quarry_vein, pos, state);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockQuarryVein.quarry_vein;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.oilquarry.getBlock();
    }

    @Override
    public ItemStack getPickBlock(Player player, HitResult target) {
        ItemStack stack = super.getPickBlock(player, target);
        CompoundTag nbt = ModUtils.nbt(stack);
        nbt.m_128359_("state", "active_" + this.levelMech);
        nbt.m_128405_("level", this.levelMech);
        return stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if ((this.vein == null || !this.vein.get()) && this.getWorld().m_46467_() % 6L == 0L && this.work) {
            BlockPos pos1 = this.pos.m_7495_();
            BlockState state = this.f_58857_.m_8055_(pos1);
            if (state.m_60767_() == Material.f_76296_) {
                state = Blocks.f_50069_.m_49966_();
            }
            this.f_58857_.m_46796_(2001, this.pos, Block.m_49956_((BlockState)state));
        }
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!player.m_21120_(hand).m_41619_()) {
            if (player.m_21120_(hand).m_41720_() instanceof ItemUpgradeMachinesKit) {
                if (this.levelMech < 4 && this.levelMech == IUItem.machinekit.getMeta(player.m_21120_(hand)) + 1) {
                    ++this.levelMech;
                    player.m_21120_(hand).m_41764_(player.m_21120_(hand).m_41613_() - 1);
                    this.updateTileEntityField();
                    this.setActive("active_" + this.levelMech);
                    return true;
                }
                if (this.levelMech < 4 && IUItem.machinekit.getMeta(player.m_21120_(hand)) == 3) {
                    this.levelMech = 4;
                    this.setActive("active_" + this.levelMech);
                    player.m_21120_(hand).m_41764_(player.m_21120_(hand).m_41613_() - 1);
                    this.updateTileEntityField();
                    return true;
                }
            } else if (player.m_21120_(hand).m_41720_() instanceof ItemVeinSensor && this.vein != VeinSystem.system.getEMPTY() && this.vein.get() && this.vein.getType() != Type.EMPTY) {
                CompoundTag nbt = ModUtils.nbt(player.m_21120_(hand));
                if (this.vein.getType() == Type.VEIN) {
                    String s = this.getType(this.vein.getMeta(), this.vein.isOldMineral());
                    nbt.m_128359_("type", s);
                } else if (this.vein.getType() == Type.OIL) {
                    String s = "oil";
                    nbt.m_128359_("type", s);
                } else {
                    String s = "gas";
                    nbt.m_128359_("type", s);
                }
                nbt.m_128405_("x", this.pos.m_123341_());
                nbt.m_128405_("z", this.pos.m_123343_());
                return true;
            }
        }
        return super.onActivated(player, hand, side, vec3);
    }

    private String getType(int meta, boolean oldMineral) {
        if (oldMineral) {
            String[] s = new String[]{"magnetite", "calaverite", "galena", "nickelite", "pyrite", "quartzite", "uranite", "azurite", "rhodonite", "alfildit", "euxenite", "smithsonite", "ilmenite", "todorokite", "ferroaugite", "sheelite"};
            return s[meta % s.length];
        }
        String[] s = new String[]{"arsenopyrite", "braggite", "wolframite", "germanite", "coltan", "crocoite", "xenotime", "iridosmine", "theoprastite", "tetrahedrite", "fergusonite", "celestine", "zircon", "crystal"};
        return s[meta % s.length];
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        CompoundTag nbt = ModUtils.nbt(stack);
        int n = this.levelMech = nbt.m_128451_("level") != 0 ? nbt.m_128451_("level") : 1;
        if (this.levelMech != 1) {
            this.setActive("active_" + this.levelMech);
        }
        if (this.getWorld().m_46472_() != Level.f_46428_) {
            this.vein = VeinSystem.system.getEMPTY();
        } else {
            if (this.f_58857_.f_46443_) {
                return;
            }
            ChunkAccess chunk = this.getWorld().m_46865_(this.pos);
            ChunkPos chunkpos = chunk.m_7697_();
            if (!VeinSystem.system.getChunkPos().contains(chunkpos)) {
                VeinSystem.system.addVein((LevelChunk)chunk);
            }
            this.vein = VeinSystem.system.getVein(chunkpos);
            if (this.vein.get()) {
                this.progress = 1200;
            }
            new PacketUpdateFieldTile(this, "vein", this.vein);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.levelMech);
            EncoderHandler.encode(packet, this.vein);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.levelMech = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.vein = (IVein)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.progress = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.levelMech = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.vein = (IVein)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, this.levelMech);
            EncoderHandler.encode(packet, this.vein);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.getWorld().m_46472_() != Level.f_46428_) {
            this.vein = VeinSystem.system.getEMPTY();
        } else {
            LevelChunk chunk = (LevelChunk)this.getWorld().m_46865_(this.pos);
            ChunkPos chunkpos = chunk.m_7697_();
            if (!VeinSystem.system.getChunkPos().contains(chunkpos)) {
                VeinSystem.system.addVein(chunk);
            }
            this.vein = VeinSystem.system.getVein(chunkpos);
            if (this.vein.get()) {
                this.progress = 1200;
            }
            if (this.progress >= 1200) {
                this.vein.setFind(true);
            }
        }
        this.updateTileEntityField();
    }

    private void updateTileEntityField() {
        new PacketUpdateFieldTile(this, "level", this.levelMech);
        new PacketUpdateFieldTile(this, "vein", this.vein);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + "5" + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("count")) {
            try {
                this.count = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("progress")) {
            try {
                this.progress = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("work")) {
            try {
                this.work = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("vein")) {
            try {
                this.vein = (IVein)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("level")) {
            try {
                this.levelMech = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.vein == null) {
            return;
        }
        if (this.vein.getCol() != this.count) {
            this.count = this.vein.getCol();
            if (this.getWorld().m_46467_() % 4L == 0L) {
                new PacketUpdateFieldTile(this, "count", this.count);
            }
        }
        if (this.vein.get()) {
            if (this.getWorld().m_46467_() % 20L == 0L && this.col != this.vein.getCol()) {
                new PacketUpdateFieldTile(this, "vein", this.vein);
                this.col = this.vein.getCol();
            }
            return;
        }
        if (this.progress < 1200 && this.energy.getEnergy() >= 5.0 && !this.vein.get()) {
            if (!this.work) {
                this.work = true;
                new PacketUpdateFieldTile(this, "work", this.work);
            }
            if (this.progress == 0) {
                this.initiate(2);
                this.time = 0;
                this.initiate(0);
            }
            if (this.time > 340) {
                this.initiate(2);
                this.time = 0;
            }
            if (this.time == 0) {
                this.initiate(0);
            }
            ++this.time;
            this.progress += (int)Math.pow(2.0, this.levelMech - 1);
            this.energy.useEnergy(5.0);
            if (this.progress >= 1200) {
                this.initiate(2);
                this.progress = 1200;
                this.vein.setFind(true);
                this.updateTileEntityField();
            }
        } else {
            if (this.work) {
                this.work = false;
                new PacketUpdateFieldTile(this, "work", this.work);
            }
            if (this.time > 0) {
                this.initiate(2);
                this.time = 0;
            }
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.m_128451_("progress");
        this.levelMech = nbttagcompound.m_128451_("level");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128405_("progress", this.progress);
        nbttagcompound.m_128405_("level", this.levelMech);
        return nbttagcompound;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<?>> getGui(Player entityPlayer, ContainerBase<?> isAdmin) {
        return new GuiQuarryVein((ContainerQuarryVein)isAdmin);
    }

    public ContainerQuarryVein getGuiContainer(Player entityPlayer) {
        return new ContainerQuarryVein(entityPlayer, this);
    }

    @Override
    public EnumTypeStyle getStyle() {
        switch (this.levelMech) {
            case 2: {
                return EnumTypeStyle.ADVANCED;
            }
            case 3: {
                return EnumTypeStyle.IMPROVED;
            }
            case 4: {
                return EnumTypeStyle.PERFECT;
            }
        }
        return EnumTypeStyle.DEFAULT;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.quarry.getSoundEvent();
    }
}

