/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.gui.IType;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IPatternStorage;
import com.denfop.api.recipe.RecipeInfo;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerScanner;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiScanner;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotScannable;
import com.denfop.items.ItemCrystalMemory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TileScanner
extends TileElectricMachine
implements IType,
IUpdatableTileEvent {
    public final int maxprogress;
    public final InvSlotScannable inputSlot;
    public final InvSlot diskSlot;
    public int progress = 0;
    public double patternUu;
    public double patternEu;
    public ItemStack pattern;
    public BaseMachineRecipe recipe;
    public State state;
    Map<BlockPos, IPatternStorage> iPatternStorageMap = new HashMap<BlockPos, IPatternStorage>();
    List<IPatternStorage> iPatternStorageList = new ArrayList<IPatternStorage>();
    private ItemStack currentStack = ModUtils.emptyStack;

    public TileScanner(int maxprogress, IMultiTileBlock block, BlockPos pos, BlockState state) {
        super(512000.0, 14, 0, block, pos, state);
        this.pattern = ModUtils.emptyStack;
        this.maxprogress = maxprogress;
        this.state = State.IDLE;
        this.inputSlot = new InvSlotScannable(this, 1);
        this.diskSlot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT_OUTPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.m_41720_() == IUItem.crystalMemory.getItem();
            }
        };
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        IPatternStorage storage;
        super.onNeighborChange(neighbor, neighborPos);
        BlockEntity tile = this.getWorld().m_7702_(neighborPos);
        if (tile instanceof IPatternStorage) {
            if (!this.iPatternStorageList.contains((IPatternStorage)tile)) {
                this.iPatternStorageList.add((IPatternStorage)tile);
                this.iPatternStorageMap.put(neighborPos, (IPatternStorage)tile);
            }
        } else if (tile == null && (storage = this.iPatternStorageMap.get(neighborPos)) != null) {
            this.iPatternStorageList.remove(storage);
            this.iPatternStorageMap.remove(neighborPos, storage);
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.state = State.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.progress = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.patternEu = (Double)DecoderHandler.decode(customPacketBuffer);
            this.patternUu = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, (Object)this.state);
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, this.patternEu);
            EncoderHandler.encode(packet, this.patternUu);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.state != State.COMPLETED) {
            if (this.progress < this.maxprogress) {
                if (!this.inputSlot.isEmpty() && (ModUtils.isEmpty(this.currentStack) || ModUtils.checkItemEquality(this.currentStack, this.inputSlot.get(0)))) {
                    if (this.getPatternStorage() == null && this.diskSlot.isEmpty()) {
                        this.state = State.NO_STORAGE;
                        this.reset();
                    } else if (this.energy.getEnergy() >= 256.0) {
                        if (ModUtils.isEmpty(this.currentStack)) {
                            this.currentStack = ModUtils.setSize(this.inputSlot.get(0), 1);
                        }
                        if (this.recipe == null) {
                            this.state = State.FAILED;
                        } else if (this.isPatternRecorded(this.pattern)) {
                            this.state = State.ALREADY_RECORDED;
                            this.reset();
                        } else {
                            this.state = State.SCANNING;
                            this.energy.useEnergy(256.0);
                            ++this.progress;
                            if (this.progress >= this.maxprogress) {
                                this.refreshInfo();
                                this.pattern = this.currentStack.m_41777_();
                                this.state = State.COMPLETED;
                                this.inputSlot.get(0).m_41774_(1);
                            }
                        }
                    } else {
                        this.state = State.NO_ENERGY;
                    }
                } else {
                    this.state = State.IDLE;
                    this.reset();
                }
            } else if (ModUtils.isEmpty(this.pattern)) {
                this.state = State.IDLE;
                this.progress = 0;
            }
        }
    }

    public void reset() {
        this.progress = 0;
        this.currentStack = ModUtils.emptyStack;
    }

    private boolean isPatternRecorded(ItemStack stack) {
        RecipeInfo stored;
        ItemStack crystalMemory;
        if (!this.diskSlot.isEmpty() && this.diskSlot.get(0).m_41720_() instanceof ItemCrystalMemory && ModUtils.checkItemEquality(((ItemCrystalMemory)(crystalMemory = this.diskSlot.get(0)).m_41720_()).readItemStack(crystalMemory), stack)) {
            return true;
        }
        IPatternStorage storage = this.getPatternStorage();
        if (storage == null) {
            return false;
        }
        Iterator<RecipeInfo> var3 = storage.getPatterns().iterator();
        do {
            if (var3.hasNext()) continue;
            return false;
        } while (!ModUtils.checkItemEquality((stored = var3.next()).getStack(), stack));
        return true;
    }

    private void record() {
        if (!ModUtils.isEmpty(this.pattern) && this.patternUu != Double.POSITIVE_INFINITY && !this.savetoDisk(this.pattern)) {
            IPatternStorage storage = this.getPatternStorage();
            if (storage == null) {
                this.state = State.TRANSFER_ERROR;
                return;
            }
            if (!storage.addPattern(new RecipeInfo(this.pattern, this.patternUu))) {
                this.state = State.TRANSFER_ERROR;
                return;
            }
        }
        this.reset();
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.m_128451_("progress");
        CompoundTag contentTag = nbttagcompound.m_128469_("currentStack");
        this.currentStack = ItemStack.m_41712_((CompoundTag)contentTag);
        contentTag = nbttagcompound.m_128469_("pattern");
        this.pattern = ItemStack.m_41712_((CompoundTag)contentTag);
        int stateIdx = nbttagcompound.m_128451_("state");
        this.state = stateIdx < State.values().length ? State.values()[stateIdx] : State.IDLE;
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag contentTag;
        super.writeToNBT(nbt);
        nbt.m_128405_("progress", this.progress);
        if (!ModUtils.isEmpty(this.currentStack)) {
            contentTag = new CompoundTag();
            this.currentStack.m_41739_(contentTag);
            nbt.m_128365_("currentStack", (Tag)contentTag);
        }
        if (!ModUtils.isEmpty(this.pattern)) {
            contentTag = new CompoundTag();
            this.pattern.m_41739_(contentTag);
            nbt.m_128365_("pattern", (Tag)contentTag);
        }
        nbt.m_128405_("state", this.state.ordinal());
        return nbt;
    }

    public ContainerScanner getGuiContainer(Player player) {
        return new ContainerScanner(player, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player player, ContainerBase<? extends IAdvInventory> isAdmin) {
        return new GuiScanner((ContainerScanner)isAdmin);
    }

    public IPatternStorage getPatternStorage() {
        if (this.iPatternStorageList.isEmpty()) {
            return null;
        }
        return this.iPatternStorageList.get(0);
    }

    public boolean savetoDisk(ItemStack stack) {
        if (!this.diskSlot.isEmpty() && stack != null) {
            if (this.diskSlot.get(0).m_41720_() instanceof ItemCrystalMemory) {
                ItemStack crystalMemory = this.diskSlot.get(0);
                ((ItemCrystalMemory)crystalMemory.m_41720_()).writecontentsTag(crystalMemory, stack);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void updateTileServer(Player player, double event) {
        if (!this.iPatternStorageList.isEmpty() || !this.diskSlot.isEmpty()) {
            switch ((int)event) {
                case 0: {
                    this.reset();
                    break;
                }
                case 1: {
                    if (this.state != State.COMPLETED) break;
                    this.record();
                    this.state = State.IDLE;
                }
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.inputSlot.isEmpty()) {
            this.recipe = this.pattern.m_41619_() ? null : Recipes.recipes.getRecipeOutput("replicator", false, this.pattern);
        } else {
            this.recipe = Recipes.recipes.getRecipeOutput("replicator", false, this.inputSlot.get(0));
            this.pattern = this.inputSlot.get(0);
        }
        for (Direction facing : Direction.values()) {
            IPatternStorage storage;
            BlockPos neighborPos = this.pos.m_121955_(facing.m_122436_());
            BlockEntity tile = this.getWorld().m_7702_(neighborPos);
            if (tile instanceof IPatternStorage) {
                if (this.iPatternStorageList.contains((IPatternStorage)tile)) continue;
                this.iPatternStorageList.add((IPatternStorage)tile);
                this.iPatternStorageMap.put(neighborPos, (IPatternStorage)tile);
                continue;
            }
            if (tile != null || (storage = this.iPatternStorageMap.get(neighborPos)) == null) continue;
            this.iPatternStorageList.remove(storage);
            this.iPatternStorageMap.remove(neighborPos, storage);
        }
        this.refreshInfo();
    }

    private void refreshInfo() {
        if (!ModUtils.isEmpty(this.pattern)) {
            this.patternUu = this.recipe.getOutput().metadata.m_128459_("matter");
            this.patternEu = this.patternUu * 1.0E9;
        }
    }

    public int getPercentageDone() {
        return 100 * this.progress / this.maxprogress;
    }

    public int getSubPercentageDoneScaled(int width) {
        return width * (100 * this.progress % this.maxprogress) / this.maxprogress;
    }

    public boolean isDone() {
        return this.progress >= 3300;
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        IDLE,
        SCANNING,
        COMPLETED,
        FAILED,
        NO_STORAGE,
        NO_ENERGY,
        TRANSFER_ERROR,
        ALREADY_RECORDED;

    }
}

