/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.ITransformer;
import com.denfop.api.energy.Mode;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.componets.Energy;
import com.denfop.componets.Redstone;
import com.denfop.componets.RedstoneHandler;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerTransformer;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiTransformer;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TileTransformer
extends TileEntityInventory
implements IUpdatableTileEvent,
ITransformer {
    private static final Mode defaultMode = Mode.redstone;
    protected final Energy energy;
    private final int defaultTier;
    private final Redstone redstone;
    private boolean hasRedstone = false;
    private double inputFlow = 0.0;
    private double outputFlow = 0.0;
    private Mode configuredMode = defaultMode;
    private Mode transformMode = null;

    public TileTransformer(int tier, IMultiTileBlock tileBlock, BlockPos pos, BlockState state) {
        super(tileBlock, pos, state);
        this.defaultTier = tier;
        this.energy = this.addComponent(new Energy((TileEntityInventory)this, EnergyNetGlobal.instance.getPowerFromTier(tier) * 4.0, Collections.emptyList(), Collections.emptyList(), tier, tier, true).setMultiSource(true));
        this.redstone = this.addComponent(new Redstone(this));
        this.redstone.subscribe(new RedstoneHandler(){

            @Override
            public void action(int input) {
                TileTransformer.this.hasRedstone = input != 0;
            }
        });
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.configuredMode = Mode.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.inputFlow = (Double)DecoderHandler.decode(customPacketBuffer);
            this.outputFlow = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, (Object)this.configuredMode);
            EncoderHandler.encode(packet, this.inputFlow);
            EncoderHandler.encode(packet, this.outputFlow);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        int mode = nbt.m_128451_("mode");
        this.configuredMode = mode >= 0 && mode < Mode.values().length ? Mode.values()[mode] : defaultMode;
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.m_128405_("mode", this.configuredMode.ordinal());
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.updateRedstone(true);
        }
    }

    @Override
    public Mode getMode() {
        return this.configuredMode;
    }

    @Override
    public void updateTileServer(Player player, double event) {
        if (event >= 0.0 && event < (double)Mode.values().length) {
            this.configuredMode = Mode.values()[(int)event];
            this.updateRedstone(false);
        } else if (event == 3.0) {
            this.outputFlow = EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSinkTier());
            this.inputFlow = EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSinkTier());
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.updateRedstone(false);
    }

    private void updateRedstone(boolean force) {
        assert (!this.getWorld().f_46443_);
        Mode newMode = switch (this.configuredMode) {
            case Mode.redstone -> this.hasRedstone ? Mode.stepup : Mode.stepdown;
            case Mode.stepdown, Mode.stepup -> this.configuredMode;
            default -> throw new RuntimeException("invalid mode: " + this.configuredMode);
        };
        this.energy.setEnabled(true);
        if (force || this.transformMode != newMode) {
            this.transformMode = newMode;
            this.setActive(this.isStepUp());
            if (this.isStepUp()) {
                this.energy.setSourceTier(this.defaultTier + 1);
                this.energy.setSinkTier(this.defaultTier);
                this.energy.setPacketOutput(1);
                this.energy.setDirections(Arrays.asList(Direction.values()).stream().filter(facing -> facing != this.getFacing()).collect(Collectors.toList()), Collections.singletonList(this.getFacing()));
            } else {
                this.energy.setSourceTier(this.defaultTier);
                this.energy.setSinkTier(this.defaultTier + 1);
                this.energy.setPacketOutput(4);
                this.energy.setDirections(Collections.singletonList(this.getFacing()), Arrays.stream(Direction.values()).filter(facing -> facing != this.getFacing()).collect(Collectors.toList()));
            }
            this.outputFlow = EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSourceTier());
            this.inputFlow = EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSinkTier());
        }
    }

    @Override
    public void setFacing(Direction facing) {
        super.setFacing(facing);
        if (!this.getWorld().f_46443_) {
            this.updateRedstone(true);
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.item.tooltip.High") + " " + (int)EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSinkTier()) + " " + Localization.translate("iu.generic.text.EUt") + " " + Localization.translate("iu.item.tooltip.Low") + " " + (int)EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSourceTier()) + " " + Localization.translate("iu.generic.text.EUt"));
    }

    public ContainerTransformer getGuiContainer(Player player) {
        return new ContainerTransformer(player, this, 202);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<?>> getGui(Player player, ContainerBase<?> isAdmin) {
        return new GuiTransformer((ContainerTransformer)isAdmin);
    }

    @Override
    public double getinputflow() {
        return !this.isStepUp() ? this.inputFlow : this.outputFlow;
    }

    @Override
    public double getoutputflow() {
        return this.isStepUp() ? this.inputFlow : this.outputFlow;
    }

    @Override
    public boolean isStepUp() {
        return this.transformMode == Mode.stepup;
    }
}

