/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.crop;

import com.denfop.IUItem;
import com.denfop.api.agriculture.CropInit;
import com.denfop.api.agriculture.CropNetwork;
import com.denfop.api.agriculture.EnumSoil;
import com.denfop.api.agriculture.ICrop;
import com.denfop.api.agriculture.ICropItem;
import com.denfop.api.agriculture.genetics.EnumGenetic;
import com.denfop.api.agriculture.genetics.GeneticTraits;
import com.denfop.api.agriculture.genetics.GeneticsManager;
import com.denfop.api.agriculture.genetics.Genome;
import com.denfop.api.bee.BeeNetwork;
import com.denfop.api.pollution.ChunkLevel;
import com.denfop.api.pollution.LevelPollution;
import com.denfop.api.pollution.PollutionManager;
import com.denfop.api.radiationsystem.EnumLevelRadiation;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockCrop;
import com.denfop.events.client.GlobalRenderManager;
import com.denfop.network.DecoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.render.oilquarry.DataBlock;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.bee.TileEntityApiary;
import com.denfop.tiles.crop.ICropTile;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.PlantType;

public class TileEntityCrop
extends TileEntityBlock
implements ICropTile {
    @OnlyIn(value=Dist.CLIENT)
    public DataBlock upDataBlock;
    public Block downBlock = null;
    private ICrop crop = null;
    private long BeeId = 0L;
    private Genome genome = null;
    public boolean hasDouble = false;
    private ItemStack cropItem = ItemStack.f_41583_;
    private Radiation radLevel;
    private ChunkPos chunkPos;
    private ChunkAccess chunk;
    private Biome biome;
    private int tickPest = 0;
    private BlockState downState;
    Map<BlockPos, TileEntityCrop> cropMap = new HashMap<BlockPos, TileEntityCrop>();
    private ChunkLevel chunkLevel;
    private int pestUse;
    private AABB axisAlignedBB;
    private List<ChunkPos> chunkPositions = new ArrayList<ChunkPos>();
    private Map<ChunkPos, List<TileEntityApiary>> chunkPosListMap = new HashMap<ChunkPos, List<TileEntityApiary>>();
    @OnlyIn(value=Dist.CLIENT)
    private Function render;
    private boolean humus;
    private boolean canGrow;
    boolean added = false;

    public TileEntityCrop(BlockPos pos, BlockState state) {
        super(BlockCrop.crop, pos, state);
    }

    public ItemStack getCropItem() {
        return this.cropItem;
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.hasDouble = nbt.m_128471_("hasDouble");
        this.pestUse = nbt.m_128445_("pestUse");
        this.tickPest = nbt.m_128448_("tickPest");
        if (nbt.m_128441_("crop_id")) {
            int id = nbt.m_128451_("crop_id");
            this.crop = CropNetwork.instance.getCrop(id).copy();
            this.crop.setTick(nbt.m_128451_("tick"));
            this.crop.setGeneration(nbt.m_128451_("generation"));
            this.cropItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("stack_crop"));
            this.genome = new Genome(this.cropItem);
            this.genome.loadCrop(this.crop);
        }
    }

    public int getPestUse() {
        return this.pestUse;
    }

    public void addPestUse() {
        ++this.pestUse;
    }

    public Block getDownBlock() {
        return this.downBlock;
    }

    public BlockState getDownState() {
        return this.downState;
    }

    public Biome getBiome() {
        return this.biome;
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.m_128379_("hasDouble", this.hasDouble);
        nbt.m_128344_("pestUse", (byte)this.pestUse);
        nbt.m_128376_("tickPest", (short)this.tickPest);
        if (this.crop != null) {
            nbt.m_128405_("tick", this.crop.getTick());
            nbt.m_128405_("generation", this.crop.getGeneration());
            nbt.m_128405_("crop_id", this.crop.getId());
            nbt.m_128365_("stack_crop", (Tag)this.cropItem.serializeNBT());
        }
        return nbt;
    }

    public void event() {
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_46796_(1505, this.pos, 0);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("hasDouble")) {
            try {
                this.hasDouble = (Boolean)DecoderHandler.decode(is);
                this.rerender();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("tick")) {
            try {
                int stage = this.crop.getStage();
                this.crop.setTick((Integer)DecoderHandler.decode(is));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("cropItem")) {
            try {
                this.cropItem = (ItemStack)DecoderHandler.decode(is);
                if (!this.cropItem.m_41619_()) {
                    this.crop = ((ICropItem)this.cropItem.m_41720_()).getCrop(this.cropItem.m_41773_(), this.cropItem).copy();
                    this.genome = new Genome(this.cropItem);
                    this.genome.loadCrop(this.crop);
                } else {
                    this.crop = null;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("texture")) {
            // empty if block
        }
        if (name.equals("crop")) {
            try {
                if (this.crop != null) {
                    this.crop.readPacket((CustomPacketBuffer)((Object)DecoderHandler.decode(is)));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("cropItem1")) {
            this.cropItem = ItemStack.f_41583_;
            this.crop = null;
        }
    }

    public int getTickPest() {
        return this.tickPest;
    }

    public void setTickPest() {
        this.tickPest = 7000;
    }

    @Override
    public boolean canPlace(TileEntityBlock te, BlockPos pos, Level world) {
        EnumSoil[] soil = EnumSoil.values();
        this.downState = world.m_8055_(pos.m_7495_());
        this.downBlock = this.downState.m_60734_();
        for (EnumSoil soil1 : soil) {
            if (!(soil1.getState() == this.downState && !soil1.isIgnore() || soil1.getBlock() == this.downBlock && soil1.isIgnore()) && this.downBlock != IUItem.humus.getBlock(0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public PlantType getPlantType() {
        return PlantType.CROP;
    }

    public Genome getGenome() {
        return this.genome;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (!this.getWorld().f_46443_ && this.added) {
            CropNetwork.instance.removeCropFromWorld(this);
            this.added = false;
        }
        if (this.getWorld().f_46443_) {
            GlobalRenderManager.removeRender(this.getWorld(), this.pos);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.chunkPos = new ChunkPos(this.pos);
            Radiation radiation1 = RadiationSystem.rad_system.getMap().get(this.chunkPos);
            if (radiation1 == null) {
                radiation1 = new Radiation(this.chunkPos);
                RadiationSystem.rad_system.addRadiation(radiation1);
            }
            this.radLevel = radiation1;
            ChunkLevel chunkLevel = PollutionManager.pollutionManager.getChunkLevelSoil(this.chunkPos);
            if (chunkLevel == null) {
                chunkLevel = new ChunkLevel(this.chunkPos, LevelPollution.VERY_LOW, 0.0);
                PollutionManager.pollutionManager.addChunkLevelSoil(chunkLevel);
            }
            this.chunkLevel = chunkLevel;
            this.chunk = this.getWorld().m_46865_(this.pos);
            this.biome = (Biome)this.getWorld().m_204166_(this.pos).get();
            this.cropMap.clear();
            for (Direction facing1 : ModUtils.horizontalFacings) {
                BlockPos pos1 = this.pos.m_121955_(facing1.m_122436_());
                BlockEntity tile = this.getWorld().m_7702_(pos1);
                if (!(tile instanceof TileEntityCrop)) continue;
                this.cropMap.put(pos1, (TileEntityCrop)tile);
            }
            if (!this.added) {
                this.added = true;
                CropNetwork.instance.addNewCropToWorld(this);
            }
            this.axisAlignedBB = new AABB((double)(this.pos.m_123341_() - 4), (double)(this.pos.m_123342_() - 2), (double)(this.pos.m_123343_() - 4), (double)(this.pos.m_123341_() + 4), (double)(this.pos.m_123342_() + 2), (double)(this.pos.m_123343_() + 4));
            int minX = (int)Math.floor(this.axisAlignedBB.f_82288_) >> 4;
            int maxX = (int)Math.floor(this.axisAlignedBB.f_82291_) >> 4;
            int minZ = (int)Math.floor(this.axisAlignedBB.f_82290_) >> 4;
            int maxZ = (int)Math.floor(this.axisAlignedBB.f_82293_) >> 4;
            this.chunkPositions.clear();
            this.chunkPosListMap.clear();
            for (int chunkX = minX; chunkX <= maxX; ++chunkX) {
                for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                    this.chunkPositions.add(new ChunkPos(chunkX, chunkZ));
                }
            }
            for (ChunkPos chunkPos : this.chunkPositions) {
                this.chunkPosListMap.put(chunkPos, BeeNetwork.instance.getApiaryFromChunk(this.f_58857_, chunkPos));
            }
        }
        if (this.downState == null) {
            this.downState = this.f_58857_.m_8055_(this.pos.m_7495_());
            this.downBlock = this.downState.m_60734_();
        }
        this.humus = this.downBlock == IUItem.humus.getBlock(0);
        this.f_58857_.m_7731_(this.pos.m_7495_(), this.downState, 3);
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        customPacketBuffer.writeBoolean(this.hasDouble);
        customPacketBuffer.writeBoolean(this.crop != null);
        if (this.crop != null) {
            customPacketBuffer.writeItemStack(this.cropItem, false);
            customPacketBuffer.writeInt(this.crop.getId());
            customPacketBuffer.writeBytes((ByteBuf)this.crop.writePacket());
        }
        return customPacketBuffer;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        this.hasDouble = customPacketBuffer.readBoolean();
        boolean hasCrop = customPacketBuffer.readBoolean();
        if (hasCrop) {
            this.cropItem = customPacketBuffer.m_130267_();
            int id = customPacketBuffer.readInt();
            this.crop = CropNetwork.instance.getCrop(id).copy();
            this.crop.readPacket(customPacketBuffer);
        }
    }

    public boolean contains(BlockPos vec) {
        if ((double)vec.m_123341_() > this.axisAlignedBB.f_82288_ && (double)vec.m_123341_() < this.axisAlignedBB.f_82291_) {
            if ((double)vec.m_123342_() > this.axisAlignedBB.f_82289_ && (double)vec.m_123342_() < this.axisAlignedBB.f_82292_) {
                return (double)vec.m_123343_() > this.axisAlignedBB.f_82290_ && (double)vec.m_123343_() < this.axisAlignedBB.f_82293_;
            }
            return false;
        }
        return false;
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (this.pos.m_7495_().equals((Object)neighborPos)) {
            if (this.crop != null && !this.cropItem.m_41619_() && this.crop.getId() != 3) {
                ModUtils.dropAsEntity(this.f_58857_, this.pos, this.cropItem, 1);
                this.cropItem = ItemStack.f_41583_;
                this.crop = null;
                this.setActive("");
            }
            this.f_58857_.m_7731_(this.pos, Blocks.f_50016_.m_49966_(), this.f_58857_.f_46443_ ? 11 : 3);
            ModUtils.dropAsEntity(this.f_58857_, this.pos, new ItemStack(IUItem.crop.getItem()), this.hasDouble ? 2 : 1);
        }
        for (Direction facing1 : ModUtils.horizontalFacings) {
            if (!this.pos.m_121955_(facing1.m_122436_()).equals((Object)neighborPos)) continue;
            if (this.cropMap.containsKey(neighborPos)) {
                this.cropMap.remove(neighborPos);
                continue;
            }
            BlockEntity tile = this.getWorld().m_7702_(neighborPos);
            if (!(tile instanceof TileEntityCrop)) continue;
            this.cropMap.put(neighborPos, (TileEntityCrop)tile);
        }
    }

    public List<ItemStack> harvest(boolean dropInWorld) {
        this.crop.setGeneration(this.crop.getGeneration() + 1);
        this.crop.setTick(0);
        this.setActive(this.crop.getName().toLowerCase() + "_" + this.crop.getStage());
        if (dropInWorld) {
            for (ItemStack stack1 : this.crop.getDrops()) {
                ModUtils.dropAsEntity(this.f_58857_, this.pos, stack1, this.crop.getYield());
            }
            if (WorldBaseGen.random.nextInt(100) < 25) {
                ModUtils.dropAsEntity(this.f_58857_, this.pos, this.cropItem, WorldBaseGen.random.nextInt(this.crop.getSizeSeed() + 1));
            }
        }
        if (this.crop.getId() != 3) {
            this.canAdaptationCrop();
        }
        return this.crop.getDrops();
    }

    public AABB getAxisAlignedBB() {
        return this.axisAlignedBB;
    }

    public List<ChunkPos> getChunkPositions() {
        return this.chunkPositions;
    }

    public Map<ChunkPos, List<TileEntityApiary>> getChunkPosListMap() {
        return this.chunkPosListMap;
    }

    private void canAdaptationCrop() {
        if (WorldBaseGen.random.nextInt(100) != 0) {
            return;
        }
        Genome genome = this.genome;
        int geneticAdaptive = genome.hasGenome(EnumGenetic.GENOME_ADAPTIVE) ? genome.getLevelGenome(EnumGenetic.GENOME_ADAPTIVE, Integer.class) : 5;
        int geneticResistance = genome.hasGenome(EnumGenetic.GENOME_RESISTANCE) ? genome.getLevelGenome(EnumGenetic.GENOME_RESISTANCE, Integer.class) : 5;
        block21: for (EnumGenetic enumGenetic : EnumGenetic.values()) {
            GeneticTraits geneticTraits;
            boolean canUpgrade;
            List<GeneticTraits> genetic = GeneticsManager.enumGeneticListMap.get((Object)enumGenetic);
            if (WorldBaseGen.random.nextInt(100) > geneticAdaptive || WorldBaseGen.random.nextInt(100) <= geneticResistance) continue;
            boolean hasGenome = genome.hasGenome(enumGenetic);
            if (!hasGenome && WorldBaseGen.random.nextInt(100) == 0) {
                GeneticTraits geneticTraits2 = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                genome.addGenome(geneticTraits2, this.cropItem);
                continue;
            }
            boolean needRemove = WorldBaseGen.random.nextInt(geneticResistance) > WorldBaseGen.random.nextInt(geneticAdaptive);
            boolean bl = canUpgrade = WorldBaseGen.random.nextInt(geneticAdaptive) > WorldBaseGen.random.nextInt(geneticResistance);
            if ((needRemove || !canUpgrade) && hasGenome) {
                geneticTraits = genome.removeGenome(enumGenetic, this.cropItem);
                GeneticsManager.instance.deleteGenomeCrop(this.crop, geneticTraits);
                continue;
            }
            if (!canUpgrade) continue;
            switch (enumGenetic) {
                case SUN: {
                    if (hasGenome) break block21;
                    genome.addGenome(genetic.get(0), this.cropItem);
                    this.crop.setSun(true);
                    break block21;
                }
                case BIOME: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        List<ResourceKey<Biome>> biomeList = Genome.geneticBiomes.get((Object)geneticTraits);
                        if (this.crop.canGrowInBiome(biomeList.get(0))) break block21;
                        biomeList.forEach(this.crop::addBiome);
                        genome.addGenome(geneticTraits, this.cropItem);
                        break block21;
                    }
                    geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                    GeneticTraits geneticTraits1 = genome.removeGenome(enumGenetic, this.cropItem);
                    GeneticsManager.instance.deleteGenomeCrop(this.crop, geneticTraits1);
                    List<ResourceKey<Biome>> biomeList = Genome.geneticBiomes.get((Object)geneticTraits);
                    biomeList.forEach(this.crop::addBiome);
                    genome.addGenome(geneticTraits, this.cropItem);
                    break block21;
                }
                case AIR: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setAirRequirements(geneticTraits.getValue(LevelPollution.class));
                        break block21;
                    }
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        GeneticTraits traits = genome.getGenome(enumGenetic);
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setAirRequirements(traits.getPrev().getValue(LevelPollution.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setAirRequirements(LevelPollution.LOW);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setAirRequirements(traits1.getValue(LevelPollution.class));
                    break block21;
                }
                case SOIL: {
                    boolean needDecrease;
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        LevelPollution levelPollution = geneticTraits.getValue(LevelPollution.class);
                        if (levelPollution.ordinal() < this.chunkLevel.getLevelPollution().ordinal()) break block21;
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setAirRequirements(levelPollution);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    LevelPollution levelPollution = traits.getValue(LevelPollution.class);
                    boolean bl2 = needDecrease = WorldBaseGen.random.nextBoolean() && this.chunkLevel.getLevelPollution().ordinal() < levelPollution.ordinal();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setSoilRequirements(traits.getPrev().getValue(LevelPollution.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setSoilRequirements(LevelPollution.LOW);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setSoilRequirements(traits1.getValue(LevelPollution.class));
                    break block21;
                }
                case WATER: {
                    if (!hasGenome) {
                        genome.addGenome(genetic.get(0), this.cropItem);
                        this.crop.setWaterRequirement(0);
                        break block21;
                    }
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (!needDecrease) break block21;
                    genome.removeGenome(genetic.get(0), this.cropItem);
                    this.crop.setWaterRequirement(this.crop.getDefaultWaterRequirement());
                    break block21;
                }
                case PEST: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setPestResistance(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setPestResistance(this.crop.getPestResistance() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setPestResistance(this.crop.getPestResistance() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setPestResistance(this.crop.getPestResistance() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                case WEED: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.addChanceWeed(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.addChanceWeed(-level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.addChanceWeed(-level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.addChanceWeed(-level + traits1.getValue(Integer.class));
                    break block21;
                }
                case LIGHT: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setLight(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setLight(traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setLight(this.crop.getDefaultLightLevel());
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setLight(traits1.getValue(Integer.class));
                    break block21;
                }
                case RADIATION: {
                    boolean needDecrease;
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        EnumLevelRadiation levelPollution = geneticTraits.getValue(EnumLevelRadiation.class);
                        if (levelPollution.ordinal() < this.radLevel.getLevel().ordinal()) break block21;
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setRadiationRequirements(levelPollution);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    EnumLevelRadiation levelPollution = traits.getValue(EnumLevelRadiation.class);
                    boolean bl3 = needDecrease = WorldBaseGen.random.nextBoolean() && this.radLevel.getLevel().ordinal() < levelPollution.ordinal();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setRadiationRequirements(traits.getPrev().getValue(EnumLevelRadiation.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setRadiationRequirements(EnumLevelRadiation.LOW);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setRadiationRequirements(traits1.getValue(EnumLevelRadiation.class));
                    break block21;
                }
                case SEED: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.addSizeSeed(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.addSizeSeed(-level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.addSizeSeed(-level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.addSizeSeed(-level + traits1.getValue(Integer.class));
                    break block21;
                }
                case YIELD: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setYield(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setYield(this.crop.getYield() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setYield(this.crop.getYield() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setYield(this.crop.getYield() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                case BEE: {
                    if (hasGenome) break block21;
                    genome.addGenome(genetic.get(0), this.cropItem);
                    this.crop.setBeeCombine(true);
                    break block21;
                }
                case NIGHT_GROW: {
                    if (hasGenome) break block21;
                    genome.addGenome(genetic.get(0), this.cropItem);
                    this.crop.setNight(true);
                    break block21;
                }
                case SOIL_BLOCK: {
                    if (hasGenome) break block21;
                    genome.addGenome(genetic.get(0), this.cropItem);
                    this.crop.setIgnoreSoil(true);
                    break block21;
                }
                case CHANCE: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setChance(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setChance(this.crop.getChance() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setChance(this.crop.getChance() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setChance(this.crop.getChance() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                case GROW_SPEED: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        double level = geneticTraits.getValue(Double.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setGrowthSpeed(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    double level = traits.getValue(Double.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setGrowthSpeed(traits.getPrev().getValue(Double.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setGrowthSpeed(1.0);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setGrowthSpeed(traits1.getValue(Double.class));
                    break block21;
                }
                case WEATHER: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setWeatherResistance(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setWeatherResistance(traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setWeatherResistance(this.crop.getDefaultWeatherResistance());
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setWeatherResistance(traits1.getValue(Integer.class));
                    break block21;
                }
                case GENOME_ADAPTIVE: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setGenomeAdaptive(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setGenomeAdaptive(this.crop.getGenomeAdaptive() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setGenomeAdaptive(this.crop.getGenomeAdaptive() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setGenomeAdaptive(this.crop.getGenomeAdaptive() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                case GENOME_RESISTANCE: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setGenomeResistance(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setGenomeResistance(this.crop.getGenomeResistance() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setGenomeResistance(this.crop.getGenomeResistance() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setGenomeResistance(this.crop.getGenomeResistance() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                default: {
                    continue block21;
                }
            }
        }
    }

    public void setBeeId(long beeId) {
        this.BeeId = beeId;
    }

    public long getBeeId() {
        return this.BeeId;
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>(super.getSelfDrops(fortune, wrench));
        if (this.hasDouble) {
            list.add(this.getPickBlock(null, null));
        }
        if (this.crop != null && this.crop.getId() != 3) {
            list.add(this.cropItem);
        }
        return list;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.crop != null) {
            this.BeeId = 0L;
            boolean work = false;
            if (this.getWorld().m_46467_() % 20L == 0L) {
                if (this.chunk == null) {
                    this.chunkPos = new ChunkPos(this.pos);
                    Radiation radiation1 = RadiationSystem.rad_system.getMap().get(this.chunkPos);
                    if (radiation1 == null) {
                        radiation1 = new Radiation(this.chunkPos);
                        RadiationSystem.rad_system.addRadiation(radiation1);
                    }
                    this.radLevel = radiation1;
                    ChunkLevel chunkLevel = PollutionManager.pollutionManager.getChunkLevelSoil(this.chunkPos);
                    if (chunkLevel == null) {
                        chunkLevel = new ChunkLevel(this.chunkPos, LevelPollution.VERY_LOW, 0.0);
                        PollutionManager.pollutionManager.addChunkLevelSoil(chunkLevel);
                    }
                    this.chunkLevel = chunkLevel;
                    this.chunk = this.getWorld().m_46865_(this.pos);
                    this.biome = (Biome)this.getWorld().m_204166_(this.pos).get();
                }
                if (this.getWorld().m_46467_() % 60L == 0L) {
                    this.canGrow = CropNetwork.instance.canGrow(this.f_58857_, this.pos, this.chunkPos, this.crop, this.radLevel, this.chunk, this.biome, this.chunkLevel);
                }
                if (this.canGrow && (this.getWorld().m_46467_() % 400L != 0L || this.canGrow())) {
                    if (this.crop.getTick() < this.crop.getMaxTick() && this.getWorld().m_46467_() % 400L == 0L && this.crop.getId() != 3) {
                        int chanceWeed = 100 - this.crop.getChanceWeed() - 5 * (this.crop.getSizeSeed() - 1);
                        work = true;
                        if (chanceWeed > 0 && this.getWorld().m_46467_() % 400L == 0L && this.tickPest == 0 && WorldBaseGen.random.nextInt(100) < chanceWeed && WorldBaseGen.random.nextInt(100) == 0) {
                            this.crop = CropInit.weed_seed.copy();
                            this.pestUse = 0;
                            this.cropItem = CropInit.weed_seed.getStack();
                            this.genome = new Genome(this.cropItem);
                            this.setActive(this.crop.getName().toLowerCase() + "_" + this.crop.getStage());
                        }
                    }
                    if (this.radLevel.getLevel().ordinal() > EnumLevelRadiation.HIGH.ordinal() && this.crop.getId() != 3) {
                        this.canAdaptationCrop();
                    }
                    this.tickPest = this.tickPest >= 20 ? (this.tickPest -= 20) : 0;
                    if (this.crop.getTick() < this.crop.getMaxTick()) {
                        boolean needUpdate;
                        int stage = this.crop.getStage();
                        this.crop.addTick((int)(20.0 * this.crop.getGrowthSpeed() * (this.humus ? 1.25 : 1.0)));
                        boolean bl = needUpdate = stage != this.crop.getStage();
                        if (needUpdate) {
                            this.setActive(this.crop.getName().toLowerCase() + "_" + this.crop.getStage());
                        }
                    }
                }
            }
        }
        if (this.getWorld().m_46467_() % 200L == 0L && this.pestUse > 0) {
            --this.pestUse;
        }
        if (this.getWorld().m_46467_() % 400L == 0L && this.tickPest == 0 && this.crop == null && !this.hasDouble && WorldBaseGen.random.nextInt(200) == 0) {
            this.crop = CropInit.weed_seed.copy();
            this.pestUse = 0;
            this.cropItem = CropInit.weed_seed.getStack();
            this.genome = new Genome(this.cropItem);
            this.setActive(this.crop.getName().toLowerCase() + "_" + this.crop.getStage());
        }
        if (this.hasDouble && this.getWorld().m_46467_() % 40L == 0L && !this.cropMap.isEmpty() && WorldBaseGen.random.nextInt(50) == 0) {
            int k;
            int i;
            List<TileEntityCrop> crops = this.cropMap.values().stream().filter(cropTile -> cropTile.crop != null && cropTile.crop.getTick() == cropTile.crop.getMaxTick()).toList();
            if (crops.size() < 2) {
                if (this.getWorld().m_46467_() % 400L == 0L && this.tickPest == 0 && this.crop == null && WorldBaseGen.random.nextInt(200) == 0) {
                    this.hasDouble = false;
                    this.crop = CropInit.weed_seed.copy();
                    this.pestUse = 0;
                    this.cropItem = CropInit.weed_seed.getStack();
                    this.setActive(this.crop.getName().toLowerCase() + "_" + this.crop.getStage());
                }
                return;
            }
            boolean can = false;
            Map<ICrop, TileEntityCrop> cropMap1 = crops.stream().collect(Collectors.toMap(cropTile -> cropTile.crop, cropTile -> cropTile, (existing, replacement) -> existing));
            ArrayList<List<ICrop>> combinations = new ArrayList<List<ICrop>>();
            for (i = 0; i < crops.size() - 1; ++i) {
                for (int j = i + 1; j < crops.size(); ++j) {
                    combinations.add(Arrays.asList(crops.get((int)i).crop, crops.get((int)j).crop));
                }
            }
            for (i = 0; i < crops.size() - 2; ++i) {
                for (int j = i + 1; j < crops.size() - 1; ++j) {
                    for (k = j + 1; k < crops.size(); ++k) {
                        combinations.add(Arrays.asList(crops.get((int)i).crop, crops.get((int)j).crop, crops.get((int)k).crop));
                    }
                }
            }
            for (i = 0; i < crops.size() - 3; ++i) {
                for (int j = i + 1; j < crops.size() - 2; ++j) {
                    for (k = j + 1; k < crops.size() - 1; ++k) {
                        for (int l = k + 1; l < crops.size(); ++l) {
                            combinations.add(Arrays.asList(crops.get((int)i).crop, crops.get((int)j).crop, crops.get((int)k).crop, crops.get((int)l).crop));
                        }
                    }
                }
            }
            for (List list : combinations) {
                ICrop newCrop;
                boolean isEquals = true;
                for (ICrop crop1 : list) {
                    isEquals = ((ICrop)list.get(0)).getId() == crop1.getId();
                }
                int chance = 0;
                for (ICrop crop1 : list) {
                    int additionChance = 0;
                    if (crop1.isBeeCombine()) {
                        TileEntityCrop crop2 = cropMap1.get(crop1);
                        block12: for (List<TileEntityApiary> apiaries : crop2.getChunkPosListMap().values()) {
                            for (TileEntityApiary apiary : apiaries) {
                                if (!this.contains(apiary.getPos()) || apiary.getQueen() == null || !((double)apiary.ill * 1.0 / (double)apiary.bees < 0.2)) continue;
                                additionChance += apiary.getQueen().getChance();
                                break block12;
                            }
                        }
                    }
                    chance = Math.max(chance, crop1.getChance() + additionChance);
                }
                if (WorldBaseGen.random.nextInt(100) > chance && WorldBaseGen.random.nextInt(100) != 0 || (isEquals ? !CropNetwork.instance.canPlantCrop((newCrop = CropNetwork.instance.getCrop(((ICrop)list.get(0)).getId()).copy()).getStackForDrop(), this.f_58857_, this.pos, this.downState, this.biome) : (newCrop = CropNetwork.instance.canCropCombine(list)) == null || !CropNetwork.instance.canPlantCrop(newCrop.getStackForDrop(), this.f_58857_, this.pos, this.downState, this.biome))) continue;
                int size = list.size();
                Genome combinedGenome = new Genome(newCrop.getStackForDrop().m_41777_());
                for (int i2 = 0; i2 < size; ++i2) {
                    if (i2 - 1 == 0 && i2 + 1 == size) continue;
                    int nextIndex = (i2 + 1) % size;
                    Genome currentGenome = cropMap1.get(list.get(i2)).getGenome();
                    Genome nextGenome = cropMap1.get(list.get(nextIndex)).getGenome();
                    int adaptive = currentGenome.hasGenome(EnumGenetic.GENOME_ADAPTIVE) ? currentGenome.getLevelGenome(EnumGenetic.GENOME_ADAPTIVE, Integer.class) : 5;
                    int resistance = nextGenome.hasGenome(EnumGenetic.GENOME_RESISTANCE) ? nextGenome.getLevelGenome(EnumGenetic.GENOME_RESISTANCE, Integer.class) : 5;
                    this.addGenome(new ArrayList<GeneticTraits>(currentGenome.getGeneticTraitsMap().values()), combinedGenome, adaptive, resistance);
                }
                this.hasDouble = false;
                this.cropItem = combinedGenome.getStack();
                newCrop.setStack(this.cropItem);
                this.crop = newCrop;
                this.genome = combinedGenome;
                this.genome.loadCrop(this.crop);
                this.setActive(this.crop.getName().toLowerCase() + "_" + this.crop.getStage());
                can = true;
                break;
            }
            if (!can && this.getWorld().m_46467_() % 400L == 0L && this.tickPest == 0 && this.crop == null && WorldBaseGen.random.nextInt(200) == 0) {
                this.hasDouble = false;
                this.crop = CropInit.weed_seed.copy();
                this.pestUse = 0;
                this.cropItem = CropInit.weed_seed.getStack();
                this.setActive(this.crop.getName().toLowerCase() + "_" + this.crop.getStage());
            }
        }
    }

    public void addGenome(List<GeneticTraits> genericTraits, Genome genome2, int geneticAdaptive, int geneticResistance) {
        for (GeneticTraits geneticTraits : genericTraits) {
            if (WorldBaseGen.random.nextInt(100) > geneticAdaptive || WorldBaseGen.random.nextInt(100) <= geneticResistance || genome2.hasGenome(geneticTraits.getGenetic())) continue;
            genome2.addGenome(geneticTraits, this.cropItem);
        }
    }

    private boolean canGrow() {
        if (!this.cropMap.isEmpty()) {
            List<TileEntityCrop> crops = ((Stream)this.cropMap.values().stream().parallel()).filter(tileEntityCrop -> tileEntityCrop.crop != null && tileEntityCrop.crop.getId() != 3).toList();
            for (TileEntityCrop crop1 : crops) {
                if (!this.crop.compatibilityWithCrop(crop1.getCrop())) continue;
                this.conflictCrop(crop1.getCrop(), crop1.getGenome());
            }
        }
        return true;
    }

    private void conflictCrop(ICrop crop, Genome genome) {
        if (!WorldBaseGen.random.nextBoolean()) {
            return;
        }
        int party = WorldBaseGen.random.nextInt(2);
        int adaptive1 = this.getGenomeLevel(genome, EnumGenetic.GENOME_ADAPTIVE);
        int adaptive2 = this.getGenomeLevel(this.genome, EnumGenetic.GENOME_ADAPTIVE);
        int resistance1 = this.getGenomeLevel(genome, EnumGenetic.GENOME_RESISTANCE);
        int resistance2 = this.getGenomeLevel(this.genome, EnumGenetic.GENOME_RESISTANCE);
        ArrayList<GeneticTraits> traitsList = party == 0 ? new ArrayList<GeneticTraits>(genome.getGeneticTraitsMap().values()) : new ArrayList<GeneticTraits>(this.genome.getGeneticTraitsMap().values());
        Genome sourceGenome = party == 0 ? genome : this.genome;
        Genome targetGenome = party == 0 ? this.genome : genome;
        ICrop sourceCrop = party == 0 ? crop : this.crop;
        ICrop targetCrop = party == 0 ? this.crop : crop;
        int sourceResistance = party == 0 ? resistance1 : resistance2;
        int targetResistance = party == 0 ? resistance2 : resistance1;
        int sourceAdaptive = party == 0 ? adaptive2 : adaptive1;
        int targetAdaptive = party == 0 ? adaptive1 : adaptive2;
        int max = 0;
        for (GeneticTraits trait : traitsList) {
            if (max == 2) break;
            if (WorldBaseGen.random.nextInt(sourceResistance) >= WorldBaseGen.random.nextInt(sourceAdaptive) || !sourceGenome.hasGenome(trait.getGenetic()) || targetGenome.hasGenome(trait.getGenetic())) continue;
            sourceGenome.removeGenome(trait.getGenetic(), sourceGenome.getStack());
            GeneticsManager.instance.deleteGenomeCrop(sourceCrop, trait);
            ++max;
            if (WorldBaseGen.random.nextInt(targetResistance) >= WorldBaseGen.random.nextInt(targetAdaptive)) continue;
            targetGenome.addGenome(trait, targetGenome.getStack());
            GeneticsManager.instance.addGenomeCrop(targetCrop, trait);
        }
    }

    private int getGenomeLevel(Genome genome, EnumGenetic genetic) {
        return genome.hasGenome(genetic) ? genome.getLevelGenome(genetic, Integer.class) : 5;
    }

    @Override
    public void updateEntityClient() {
        super.updateEntityClient();
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        return this.getWorld().f_46443_ || this.rightClick(player, hand);
    }

    @Override
    public boolean onSneakingActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.cropItem.m_41619_() && this.crop != null && !this.getWorld().f_46443_ && this.crop.getId() != 3) {
            if (this.crop != null && this.crop.getTick() == this.crop.getMaxTick() && this.crop.getId() != 3) {
                this.harvest(true);
            }
            ModUtils.dropAsEntity(this.f_58857_, this.pos, this.cropItem, 1);
            this.cropItem = ItemStack.f_41583_;
            this.crop = null;
            this.genome = null;
            this.setActive("");
        }
        return super.onSneakingActivated(player, hand, side, vec3);
    }

    private boolean rightClick(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_() && this.hasDouble && this.crop == null) {
            this.handleDoubleCropRemoval(player);
            return true;
        }
        if (stack.m_150930_(this.getPickBlock(player, null).m_41720_()) && !this.hasDouble && this.crop == null) {
            stack.m_41774_(1);
            this.hasDouble = true;
            this.setActive(true);
            return true;
        }
        if (stack.m_41720_() instanceof HoeItem && !this.hasDouble && this.crop != null && this.crop.getId() == 3) {
            this.resetCrop();
            return true;
        }
        if (stack.m_41720_() == IUItem.fertilizer.getItem() && !this.hasDouble && this.crop != null && this.crop.getTick() < this.crop.getMaxTick() && this.crop.getId() != 3) {
            this.fertilizeCrop(stack);
            return true;
        }
        if (stack.m_41720_() instanceof ICropItem && !this.hasDouble && this.crop == null && CropNetwork.instance.canPlantCrop(stack, this.f_58857_, this.pos, this.downState, this.biome)) {
            this.plantNewCrop(stack);
            return true;
        }
        if (this.crop != null && this.crop.getTick() == this.crop.getMaxTick() && this.crop.getId() != 3) {
            this.harvest(true);
            return true;
        }
        return false;
    }

    private void handleDoubleCropRemoval(Player player) {
        ItemStack stack1 = this.getPickBlock(player, null);
        this.hasDouble = false;
        this.setActive("");
        ModUtils.dropAsEntity(this.f_58857_, this.pos, stack1);
    }

    public void resetCrop() {
        this.crop = null;
        this.cropItem = ItemStack.f_41583_;
        this.genome = null;
        this.setActive("");
    }

    public void fertilizeCrop(ItemStack stack) {
        stack.m_41774_(1);
        this.crop.addTick((int)((double)this.crop.getMaxTick() * 0.2));
        ++this.pestUse;
        this.event();
        if (this.pestUse > 40) {
            this.handlePestResistance();
        } else {
            this.setActive(this.crop.getName().toLowerCase() + "_" + this.crop.getStage());
        }
    }

    private void handlePestResistance() {
        boolean pestResistance;
        int resistance = this.crop.getPestResistance();
        boolean bl = pestResistance = WorldBaseGen.random.nextInt(100) < 100 - resistance;
        if (!pestResistance) {
            this.crop = CropInit.weed_seed.copy();
            this.pestUse = 0;
            this.cropItem = CropInit.weed_seed.getStack();
            this.genome = new Genome(this.cropItem);
            this.setActive(this.crop.getName().toLowerCase() + "_0");
        } else {
            this.setActive(this.crop.getName().toLowerCase() + "_" + this.crop.getStage());
        }
    }

    public void plantNewCrop(ItemStack stack) {
        this.cropItem = stack.m_41777_();
        this.cropItem.m_41764_(1);
        stack.m_41774_(1);
        this.genome = new Genome(this.cropItem);
        this.crop = CropNetwork.instance.getCropFromStack(this.cropItem).copy();
        this.genome.loadCrop(this.crop);
        this.setActive(this.crop.getName().toLowerCase() + "_0");
    }

    @Override
    public SoundType getBlockSound(Entity entity) {
        return SoundType.f_56758_;
    }

    @Override
    public AABB getPhysicsBoundingBox() {
        return new AABB((double)0.2f, -0.0625, (double)0.2f, (double)0.8f, (double)0.85f, (double)0.8f);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockCrop.crop;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.crop.getBlock();
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        ArrayList<AABB> ret = new ArrayList<AABB>();
        if (forCollision) {
            ret.add(new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        } else {
            ret.add(new AABB((double)0.2f, -0.0625, (double)0.2f, (double)0.8f, (double)0.85f, (double)0.8f));
        }
        return ret;
    }

    public boolean isHasDouble() {
        return this.hasDouble;
    }

    @Override
    public ICrop getCrop() {
        return this.crop;
    }

    @Override
    public boolean wrenchCanRemove(Player player) {
        return false;
    }
}

