/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.gaswell;

import com.denfop.IUItem;
import com.denfop.api.gasvein.GasVein;
import com.denfop.api.gasvein.GasVeinSystem;
import com.denfop.api.gasvein.TypeGas;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockGasWell;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerGasWellController;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiGasWellController;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.tiles.gaswell.IController;
import com.denfop.tiles.gaswell.ISocket;
import com.denfop.tiles.gaswell.ITank;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityGasWellController
extends TileMultiBlockBase
implements IController,
IUpdatableTileEvent {
    public boolean work;
    public ITank tank;
    public ISocket socket;
    public GasVein vein;

    public TileEntityGasWellController(BlockPos pos, BlockState state) {
        super(InitMultiBlockSystem.GasWellMultiBlock, BlockGasWell.gas_well_controller, pos, state);
    }

    public ContainerGasWellController getGuiContainer(Player var1) {
        return new ContainerGasWellController(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiGasWellController((ContainerGasWellController)menu);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.getWorld().m_46472_() != Level.f_46428_) {
            this.vein = GasVeinSystem.system.getEMPTY();
        } else {
            LevelChunk chunk = this.getWorld().m_46745_(this.pos);
            ChunkPos chunkpos = chunk.m_7697_();
            if (!GasVeinSystem.system.getChunkPos().contains(chunkpos)) {
                GasVeinSystem.system.addVein((ChunkAccess)chunk);
            }
            this.vein = GasVeinSystem.system.getVein(chunkpos);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.full && this.work && this.vein != null && this.vein.isFind() && this.getEnergy().canUseEnergy(2.0)) {
            int amount = this.vein.getCol();
            amount = Math.min(Math.min(1, amount), this.tank.getTank().getCapacity() - this.tank.getTank().getFluidAmount());
            Fluid fluid = null;
            if (this.vein.getType() == TypeGas.IODINE) {
                fluid = (Fluid)FluidName.fluidiodine.getInstance().get();
            }
            if (this.vein.getType() == TypeGas.BROMIDE) {
                fluid = (Fluid)FluidName.fluidbromine.getInstance().get();
            }
            if (this.vein.getType() == TypeGas.CHLORINE) {
                fluid = (Fluid)FluidName.fluidchlorum.getInstance().get();
            }
            if (this.vein.getType() == TypeGas.FLORINE) {
                fluid = (Fluid)FluidName.fluidfluor.getInstance().get();
            }
            if (fluid == null) {
                return;
            }
            this.getEnergy().useEnergy(2.0);
            this.vein.removeCol(amount);
            this.tank.getTank().fill(new FluidStack(fluid, amount), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.gas_well.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockGasWell.gas_well_controller;
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        this.work = !this.work;
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBytes((ByteBuf)this.socket.getEnergy().updateComponent());
        customPacketBuffer.writeBytes((ByteBuf)this.tank.getTank().writePacket());
        customPacketBuffer.writeBoolean(this.vein != null);
        customPacketBuffer.writeBytes((ByteBuf)this.vein.writePacket());
        customPacketBuffer.writeBoolean(this.work);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.socket.getEnergy().onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.tank.getTank().readPacket(customPacketBuffer);
        boolean hasVein = customPacketBuffer.readBoolean();
        if (hasVein) {
            this.vein = new GasVein(customPacketBuffer);
        }
        this.work = customPacketBuffer.readBoolean();
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.socket = null;
            this.tank = null;
        }
    }

    @Override
    public Energy getEnergy() {
        return this.socket.getEnergy();
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), ISocket.class);
        this.socket = (ISocket)this.getWorld().m_7702_(pos1.get(0));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), ITank.class);
        this.tank = (ITank)this.getWorld().m_7702_(pos1.get(0));
    }

    @Override
    public void usingBeforeGUI() {
    }
}

