/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerChickenFarm;
import com.denfop.gui.GuiChickenFarm;
import com.denfop.gui.GuiCore;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileEntityInventory;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityChickenFarm
extends TileEntityInventory
implements IUpgradableBlock {
    private static final int RADIUS = 4;
    private static final int MAX_CHICKENS = 12;
    public final InvSlot slotSeeds;
    public final InvSlotOutput output;
    public final Energy energy;
    public final InvSlotUpgrade upgradeSlot;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    private final ComponentUpgradeSlots componentUpgrade;
    AABB searchArea;
    List<LevelChunk> chunks;

    public TileEntityChickenFarm(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.chicken_farm, pos, state);
        this.searchArea = new AABB(this.pos.m_7918_(-4, -4, -4), this.pos.m_7918_(4, 4, 4));
        this.chunks = new ArrayList<LevelChunk>();
        this.slotSeeds = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.m_41720_() == Items.f_42404_;
            }
        };
        this.output = new InvSlotOutput(this, 9);
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 1024.0, 4));
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
    }

    public ContainerChickenFarm getGuiContainer(Player var1) {
        return new ContainerChickenFarm(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiChickenFarm((ContainerChickenFarm)menu);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.chicken_farm;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.chicken_farm.info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().m_46467_() % 20L == 0L && this.energy.canUseEnergy(50.0)) {
            this.energy.useEnergy(50.0);
            List chickens = this.f_58857_.m_45976_(Chicken.class, this.searchArea);
            this.collectEggs(this.searchArea);
            if (chickens.size() < 12) {
                this.breedChickens(chickens);
            }
            if (chickens.size() > 12) {
                this.killExcessChickens(chickens);
            }
        }
    }

    private void killExcessChickens(List<Chicken> chickens) {
        for (int i = chickens.size() - 1; i >= 12; --i) {
            Chicken chicken = chickens.get(i);
            chicken.m_146870_();
            this.output.add(new ItemStack((ItemLike)Items.f_42581_, 1));
            if (!this.f_58857_.f_46441_.m_188499_()) continue;
            this.output.add(new ItemStack((ItemLike)Items.f_42402_, this.f_58857_.f_46441_.m_188503_(2) + 1));
        }
    }

    private void breedChickens(List<Chicken> chickens) {
        block0: for (int i = 0; i < chickens.size(); ++i) {
            for (int j = i + 1; j < chickens.size(); ++j) {
                Chicken chicken1 = chickens.get(i);
                Chicken chicken2 = chickens.get(j);
                if (this.slotSeeds.isEmpty() || this.slotSeeds.get(0).m_41613_() < 2 || chicken1.m_146764_() != 0 || chicken2.m_146764_() != 0 || chicken1.m_27593_() || chicken2.m_27593_()) continue;
                chicken1.m_27595_(null);
                chicken2.m_27595_(null);
                this.slotSeeds.get(0).m_41774_(2);
                continue block0;
            }
        }
    }

    private void collectEggs(AABB area) {
        List items = this.f_58857_.m_6443_(ItemEntity.class, area, e -> !e.m_5833_());
        for (ItemEntity item : items) {
            ItemStack stack = item.m_32055_();
            if (stack.m_41720_() != Items.f_42521_) continue;
            item.m_146870_();
            this.output.add(stack);
        }
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }
}

