/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.bee.BeeNetwork;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerCollectorProductBee;
import com.denfop.gui.GuiCollectorProductBee;
import com.denfop.gui.GuiCore;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.bee.TileEntityApiary;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityCollectorProductBee
extends TileEntityInventory
implements IUpgradableBlock {
    private static final int RADIUS = 8;
    public final Energy energy;
    public final InvSlotFluidByList fluidSlot;
    public final InvSlotFluidByList fluidSlot1;
    public final Fluids.InternalFluidTank tank;
    public final Fluids.InternalFluidTank tank1;
    public final InvSlotOutput outputSlot;
    public final InvSlotOutput outputSlot1;
    public final InvSlotUpgrade upgradeSlot;
    public final ComponentUpgradeSlots componentUpgrade;
    private final Fluids fluids;
    AABB searchArea;
    List<List<TileEntityApiary>> list;
    List<LevelChunk> chunks;

    public TileEntityCollectorProductBee(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.collector_product_bee, pos, state);
        this.searchArea = new AABB(this.pos.m_7918_(-8, -8, -8), this.pos.m_7918_(8, 8, 8));
        this.list = new ArrayList<List<TileEntityApiary>>();
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 10000.0, 1));
        this.fluids = this.addComponent(new Fluids(this));
        this.tank = this.fluids.addTankExtract("tank", 10000, Fluids.fluidPredicate((Fluid)FluidName.fluidhoney.getInstance().get()));
        this.tank1 = this.fluids.addTankExtract("tank1", 10000, Fluids.fluidPredicate((Fluid)FluidName.fluidroyaljelly.getInstance().get()));
        this.fluidSlot = new InvSlotFluidByList((TileEntityInventory)this, 1, (Fluid)FluidName.fluidhoney.getInstance().get());
        this.fluidSlot.setTypeFluidSlot(InvSlotFluid.TypeFluidSlot.OUTPUT);
        this.fluidSlot1 = new InvSlotFluidByList((TileEntityInventory)this, 1, (Fluid)FluidName.fluidroyaljelly.getInstance().get());
        this.fluidSlot1.setTypeFluidSlot(InvSlotFluid.TypeFluidSlot.OUTPUT);
        this.outputSlot = new InvSlotOutput(this, 2);
        this.outputSlot1 = new InvSlotOutput(this, 16);
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput, UpgradableProperty.FluidExtract);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.collector_product_bee;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.collector_product_bee.info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            AABB aabb = this.searchArea;
            int j2 = Mth.m_14107_((double)((aabb.f_82288_ - 2.0) / 16.0));
            int k2 = Mth.m_14165_((double)((aabb.f_82291_ + 2.0) / 16.0));
            int l2 = Mth.m_14107_((double)((aabb.f_82290_ - 2.0) / 16.0));
            int i3 = Mth.m_14165_((double)((aabb.f_82293_ + 2.0) / 16.0));
            this.chunks = new ArrayList<LevelChunk>();
            for (int j3 = j2; j3 < k2; ++j3) {
                for (int k3 = l2; k3 < i3; ++k3) {
                    LevelChunk chunk = this.f_58857_.m_6325_(j3, k3);
                    if (this.chunks.contains(chunk)) continue;
                    this.chunks.add(chunk);
                }
            }
            for (LevelChunk chunk : this.chunks) {
                this.list.add(BeeNetwork.instance.getApiaryFromChunk(this.f_58857_, chunk.m_7697_()));
            }
        }
    }

    public ContainerCollectorProductBee getGuiContainer(Player var1) {
        return new ContainerCollectorProductBee(this, var1);
    }

    private void updateBee() {
        this.list.clear();
        for (LevelChunk chunk : this.chunks) {
            this.list.add(BeeNetwork.instance.getApiaryFromChunk(this.f_58857_, chunk.m_7697_()));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiCollectorProductBee((ContainerCollectorProductBee)menu);
    }

    public boolean contains(BlockPos vec) {
        if ((double)vec.m_123341_() > this.searchArea.f_82288_ && (double)vec.m_123341_() < this.searchArea.f_82291_) {
            if ((double)vec.m_123342_() > this.searchArea.f_82289_ && (double)vec.m_123342_() < this.searchArea.f_82292_) {
                return (double)vec.m_123343_() > this.searchArea.f_82290_ && (double)vec.m_123343_() < this.searchArea.f_82293_;
            }
            return false;
        }
        return false;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().m_46467_() % 100L == 0L) {
            this.updateBee();
        }
        if (this.getWorld().m_46467_() % 20L == 0L && this.energy.canUseEnergy(20.0)) {
            block0: for (List<TileEntityApiary> bees : this.list) {
                for (TileEntityApiary bee : bees) {
                    if (!(this.energy.getEnergy() >= 20.0)) break block0;
                    if (!this.contains(bee.getPos())) continue;
                    if (bee.food > 750.0 && bee.getTickDrainFood() == 20 && this.tank.getFluidAmount() + 1000 <= this.tank.getCapacity() && this.energy.getEnergy() >= 20.0) {
                        bee.food -= 750.0;
                        this.tank.fill(new FluidStack((Fluid)FluidName.fluidhoney.getInstance().get(), 1000), IFluidHandler.FluidAction.EXECUTE);
                        this.energy.useEnergy(20.0);
                        bee.setTickDrainFood((byte)0);
                    }
                    if (bee.royalJelly > 50.0 && bee.getTickDrainJelly() == 20 && this.tank1.getFluidAmount() + 1000 <= this.tank1.getCapacity() && this.energy.getEnergy() >= 20.0) {
                        bee.royalJelly -= 50.0;
                        this.tank1.fill(new FluidStack((Fluid)FluidName.fluidroyaljelly.getInstance().get(), 1000), IFluidHandler.FluidAction.EXECUTE);
                        this.energy.useEnergy(20.0);
                        bee.setTickDrainJelly((byte)0);
                    }
                    if (bee.invSlotProduct.isEmpty() || !(this.energy.getEnergy() >= 20.0)) continue;
                    for (ItemStack stack : bee.invSlotProduct) {
                        if (!this.outputSlot1.add(stack)) continue;
                        stack.m_41774_(stack.m_41613_());
                    }
                    this.energy.useEnergy(20.0);
                }
            }
        }
        MutableObject output1 = new MutableObject();
        if (this.tank.getFluidAmount() - 1000 >= 0 && this.fluidSlot.transferFromTank((IFluidTank)this.tank, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.outputSlot.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot.transferFromTank((IFluidTank)this.tank, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.outputSlot.add((ItemStack)output1.getValue());
            }
        }
        if (this.tank1.getFluidAmount() - 1000 >= 0 && this.fluidSlot1.transferFromTank((IFluidTank)this.tank1, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.outputSlot.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot1.transferFromTank((IFluidTank)this.tank1, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.outputSlot.add((ItemStack)output1.getValue());
            }
        }
        if (this.getWorld().m_46467_() % 20L == 0L) {
            this.upgradeSlot.tickNoMark();
        }
    }
}

