/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.fakebody.FakeAsteroid;
import com.denfop.api.space.fakebody.FakePlanet;
import com.denfop.api.space.fakebody.FakeSatellite;
import com.denfop.api.space.fakebody.IFakeAsteroid;
import com.denfop.api.space.fakebody.IFakeBody;
import com.denfop.api.space.fakebody.IFakePlanet;
import com.denfop.api.space.fakebody.IFakeSatellite;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.events.client.GlobalRenderManager;
import com.denfop.events.client.SolarSystemRenderer;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.world.WorldBaseGen;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;

public class TileEntityHologramSpace
extends TileEntityBlock {
    public List<IFakeBody> fakeBodyList = new ArrayList<IFakeBody>();
    @OnlyIn(value=Dist.CLIENT)
    SolarSystemRenderer solarSystemRenderer;
    private UUID uuid = new UUID(WorldBaseGen.random.nextLong(), WorldBaseGen.random.nextLong());

    public TileEntityHologramSpace(BlockPos p_155229_, BlockState p_155230_) {
        super(BlockBaseMachine3.hologram_space, p_155229_, p_155230_);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.getWorld().f_46443_) {
            this.solarSystemRenderer = new SolarSystemRenderer();
            GlobalRenderManager.addRender(this.f_58857_, this.pos, this.createFunction(this));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Function<RenderLevelStageEvent, Void> createFunction(TileEntityHologramSpace te) {
        Function<RenderLevelStageEvent, Void> function = o -> {
            this.solarSystemRenderer.render(te, (RenderLevelStageEvent)o);
            return null;
        };
        return function;
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        if (placer instanceof Player) {
            this.uuid = placer.m_20148_();
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.getWorld().f_46443_) {
            GlobalRenderManager.removeRender(this.f_58857_, this.pos);
        }
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        this.fakeBodyList = SpaceNet.instance.getFakeSpaceSystem().getBodyMap().get(this.uuid);
        if (this.fakeBodyList != null) {
            CustomPacketBuffer packetBuffer = new CustomPacketBuffer();
            packetBuffer.writeInt(this.fakeBodyList.size());
            for (IFakeBody fakeBody : this.fakeBodyList) {
                if (fakeBody instanceof IFakePlanet) {
                    packetBuffer.writeByte(0);
                }
                if (fakeBody instanceof IFakeSatellite) {
                    packetBuffer.writeByte(1);
                }
                if (fakeBody instanceof IFakeAsteroid) {
                    packetBuffer.writeByte(2);
                }
                if (fakeBody == null) continue;
                try {
                    EncoderHandler.encode(packetBuffer, fakeBody.writeNBTTagCompound(new CompoundTag()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return packetBuffer;
        }
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer();
        packetBuffer.writeInt(0);
        return packetBuffer;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.uuid = nbtTagCompound.m_128342_("player");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.m_128362_("player", this.uuid);
        return nbtTagCompound;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer is) {
        super.readUpdatePacket(is);
        int size = is.readInt();
        this.fakeBodyList.clear();
        for (int i = 0; i < size; ++i) {
            byte id = is.readByte();
            try {
                IFakeBody fakePlanet;
                CompoundTag nbt;
                if (id == 0) {
                    nbt = (CompoundTag)DecoderHandler.decode(is);
                    fakePlanet = new FakePlanet(nbt);
                    this.fakeBodyList.add(fakePlanet);
                }
                if (id == 1) {
                    nbt = (CompoundTag)DecoderHandler.decode(is);
                    fakePlanet = new FakeSatellite(nbt);
                    this.fakeBodyList.add(fakePlanet);
                }
                if (id != 2) continue;
                nbt = (CompoundTag)DecoderHandler.decode(is);
                fakePlanet = new FakeAsteroid(nbt);
                this.fakeBodyList.add(fakePlanet);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("fakebody")) {
            int size = is.readInt();
            this.fakeBodyList.clear();
            for (int i = 0; i < size; ++i) {
                byte id = is.readByte();
                try {
                    IFakeBody fakePlanet;
                    CompoundTag nbt;
                    if (id == 0) {
                        nbt = (CompoundTag)DecoderHandler.decode(is);
                        fakePlanet = new FakePlanet(nbt);
                        this.fakeBodyList.add(fakePlanet);
                    }
                    if (id == 1) {
                        nbt = (CompoundTag)DecoderHandler.decode(is);
                        fakePlanet = new FakeSatellite(nbt);
                        this.fakeBodyList.add(fakePlanet);
                    }
                    if (id != 2) continue;
                    nbt = (CompoundTag)DecoderHandler.decode(is);
                    fakePlanet = new FakeAsteroid(nbt);
                    this.fakeBodyList.add(fakePlanet);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.hologram_space;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }
}

