/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.gui.IType;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgrade;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.componets.HeatComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.TypeUpgrade;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerImpAlloySmelter;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiImpAlloySmelter;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotDischarge;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityImpAlloySmelter
extends TileElectricMachine
implements IHasRecipe,
IType,
IUpdateTick,
IUpgradableBlock {
    public final HeatComponent heat;
    public final InvSlot input_slot;
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, 4);
    public final ComponentProcess componentProcess;
    public final InvSlotRecipes inputSlotA = new InvSlotRecipes((TileEntityInventory)this, "impalloysmelter", (IUpdateTick)this);
    public final ComponentProgress componentProgress;
    private final ComponentUpgrade componentUpgrades;
    private final ComponentUpgradeSlots componentUpgrade;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    public MachineRecipe output;
    protected boolean sound = true;

    public TileEntityImpAlloySmelter(BlockPos pos, BlockState state) {
        super(300.0, 1, 1, BlockBaseMachine3.imp_alloy_smelter, pos, state);
        this.dischargeSlot = new InvSlotDischarge(this, InvSlot.TypeItemSlot.INPUT, 1, false);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.componentProgress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, 300));
        this.componentProcess = this.addComponent(new ComponentProcess(this, 300, 1.0));
        this.componentProcess.setHasAudio(true);
        this.componentProcess.setSlotOutput(this.outputSlot);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
        this.componentUpgrades = this.addComponent(new ComponentUpgrade(this, TypeUpgrade.INSTANT, TypeUpgrade.STACK));
        this.heat = this.addComponent(HeatComponent.asBasicSink(this, 8000.0));
        Recipes.recipes.addInitRecipes(this);
        this.input_slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (this.get(0).m_41619_()) {
                    ((TileEntityImpAlloySmelter)this.base).inputSlotA.changeAccepts(ItemStack.f_41583_);
                } else {
                    ((TileEntityImpAlloySmelter)this.base).inputSlotA.changeAccepts(this.get(0));
                }
                return content;
            }

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.m_41720_() == IUItem.recipe_schedule.getItem();
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.RECIPE_SCHEDULE;
            }
        };
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.05));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.125));
    }

    public static void addAlloysmelter(Object container, Object fill, Object fill1, Object fill2, ItemStack output, int temperature) {
        IInputHandler input = Recipes.inputFactory;
        CompoundTag nbt = ModUtils.nbt();
        nbt.m_128376_("temperature", (short)temperature);
        Recipes.recipes.addRecipe("impalloysmelter", new BaseMachineRecipe(new Input(input.getInput(container), input.getInput(fill), input.getInput(fill1), input.getInput(fill2)), new RecipeOutput(nbt, output)));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.heatmachine.info"));
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getOperationsPerTick());
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.sound = nbttagcompound.m_128471_("sound");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128379_("sound", this.sound);
        return nbttagcompound;
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.inputSlotA.load();
            this.getOutput();
            if (this.input_slot.isEmpty()) {
                this.inputSlotA.changeAccepts(ItemStack.f_41583_);
            } else {
                this.inputSlotA.changeAccepts(this.input_slot.get(0));
            }
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.imp_alloy_smelter;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void init() {
        TileEntityImpAlloySmelter.addAlloysmelter(new ItemStack((ItemLike)IUItem.iudust.getStack(21), 4), new ItemStack((ItemLike)IUItem.plastic_plate.getItem()), new ItemStack((ItemLike)IUItem.alloysingot.getStack(20)), new ItemStack((ItemLike)IUItem.alloysingot.getStack(10)), new ItemStack((ItemLike)IUItem.crafting_elements.getStack(479), 1), 6000);
        TileEntityImpAlloySmelter.addAlloysmelter("forge:ingots/Iron", "forge:ingots/Chromium", "forge:ingots/Nickel", "forge:ingots/Manganese", new ItemStack((ItemLike)IUItem.alloysingot.getStack(13), 1), 7000);
        TileEntityImpAlloySmelter.addAlloysmelter("forge:ingots/Iron", "forge:ingots/Chromium", "forge:ingots/Nickel", "forge:ingots/Molybdenum", new ItemStack((ItemLike)IUItem.alloysingot.getStack(14), 1), 7500);
        TileEntityImpAlloySmelter.addAlloysmelter("forge:ingots/Cobalt", "forge:ingots/Chromium", "forge:ingots/Iron", "forge:ingots/Tungsten", new ItemStack((ItemLike)IUItem.alloysingot.getStack(16), 1), 6500);
        TileEntityImpAlloySmelter.addAlloysmelter("forge:ingots/Tin", "forge:ingots/Lead", "forge:ingots/Bismuth", "forge:ingots/Cadmium", new ItemStack((ItemLike)IUItem.alloysingot.getStack(18), 1), 5000);
        TileEntityImpAlloySmelter.addAlloysmelter(new ItemStack((ItemLike)Items.f_42416_, 2), new ItemStack((ItemLike)Items.f_42413_, 3), "forge:ingots/Nickel", "forge:ingots/Manganese", IUItem.advIronIngot, 5000);
        TileEntityImpAlloySmelter.addAlloysmelter("forge:ingots/Iron", new ItemStack((ItemLike)IUItem.iudust.getStack(21), 2), "forge:ingots/Nickel", "forge:ingots/Molybdenum", new ItemStack((ItemLike)IUItem.alloysingot.getStack(21), 1), 8000);
    }

    public ContainerImpAlloySmelter getGuiContainer(Player entityPlayer) {
        return new ContainerImpAlloySmelter(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiImpAlloySmelter((ContainerImpAlloySmelter)menu);
    }

    @Override
    public EnumTypeStyle getStyle() {
        return EnumTypeStyle.IMPROVED;
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        this.sound = !this.sound;
        new PacketUpdateFieldTile(this, "sound", this.sound);
        if (!this.sound && this.getTypeAudio() == EnumTypeAudio.ON) {
            this.setType(EnumTypeAudio.OFF);
            this.initiate(2);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("sound")) {
            try {
                this.sound = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.alloysmelter.getSoundEvent();
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getTypeAudio() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (!this.getEnable()) {
            return;
        }
        if (this.getSound() == null) {
            return;
        }
        if (soundEvent == 0) {
            this.getWorld().m_5594_(null, this.pos, this.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (soundEvent == 1) {
            new PacketStopSound(this.getWorld(), this.pos);
            this.getWorld().m_5594_(null, this.pos, EnumSound.InterruptOne.getSoundEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            new PacketStopSound(this.getWorld(), this.pos);
        }
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }
}

