/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerIndustrialOrePurifier;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiIndustrialOrePurifier;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityIndustrialOrePurifier
extends TileElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent,
IHasRecipe {
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlotRecipes inputSlotA;
    public final ComponentBaseEnergy se;
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public final double defaultEnergyStorage;
    public MachineRecipe output;
    public double energyConsume;
    public int operationLength;
    public int operationsPerTick;
    public double guiProgress;
    public double consumeSE = 0.0;
    protected short progress;

    public TileEntityIndustrialOrePurifier(BlockPos pos, BlockState state) {
        super(200.0, 1, 1, BlockBaseMachine3.industrial_ore_purifier, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.addComponent(new SoilPollutionComponent(this, 0.25));
        this.addComponent(new AirPollutionComponent(this, 0.25));
        this.progress = 0;
        this.energyConsume = 1.0;
        this.defaultEnergyConsume = 1.0;
        this.operationLength = 200;
        this.defaultOperationLength = 200;
        this.defaultTier = 1;
        this.defaultEnergyStorage = 100.0;
        this.inputSlotA = new InvSlotRecipes((TileEntityInventory)this, "ore_purifier", (IUpdateTick)this);
        this.se = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.SOLARIUM, this, 1500.0));
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
    }

    public static void addRecipe(ItemStack container, ItemStack container1, double se) {
        IInputHandler input = Recipes.inputFactory;
        CompoundTag nbt = ModUtils.nbt();
        nbt.m_128347_("se", se);
        Recipes.recipes.addRecipe("ore_purifier", new BaseMachineRecipe(new Input(input.getInput(container)), new RecipeOutput(nbt, container1)));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + "200" + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + "1");
        }
        super.addInformation(stack, tooltip);
    }

    public ContainerIndustrialOrePurifier getGuiContainer(Player var1) {
        return new ContainerIndustrialOrePurifier(var1, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiIndustrialOrePurifier((ContainerIndustrialOrePurifier)menu);
    }

    @Override
    public void init() {
        TileEntityIndustrialOrePurifier.addRecipe(new ItemStack((ItemLike)IUItem.nuclear_res.getStack(21)), new ItemStack((ItemLike)IUItem.crushed.getStack(24)), 1.0);
        TileEntityIndustrialOrePurifier.addRecipe(new ItemStack((ItemLike)IUItem.nuclear_res.getStack(19)), new ItemStack((ItemLike)IUItem.toriy.getItem()), 0.0);
        TileEntityIndustrialOrePurifier.addRecipe(new ItemStack((ItemLike)IUItem.nuclear_res.getStack(17)), new ItemStack((ItemLike)IUItem.radiationresources.getStack(0)), 10.0);
        TileEntityIndustrialOrePurifier.addRecipe(new ItemStack((ItemLike)IUItem.nuclear_res.getStack(18)), new ItemStack((ItemLike)IUItem.radiationresources.getStack(1)), 15.0);
        TileEntityIndustrialOrePurifier.addRecipe(new ItemStack((ItemLike)IUItem.nuclear_res.getStack(20)), new ItemStack((ItemLike)IUItem.radiationresources.getStack(2)), 20.0);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.industrial_ore_purifier;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.f_58857_.f_46443_) {
            this.inputSlotA.load();
            this.getOutput();
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.m_128448_("progress");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128376_("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.output != null && !this.inputSlotA.isEmpty() && this.inputSlotA.continue_process(this.output) && this.outputSlot.canAdd(this.output.getRecipe().getOutput().items) && this.energy.canUseEnergy(this.energyConsume) && this.se.canUseEnergy(this.getConsume())) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            this.se.useEnergy(this.consumeSE);
            if (this.progress == 0) {
                this.initiate(0);
            }
            this.progress = (short)(this.progress + 1);
            this.energy.useEnergy(this.energyConsume);
            double k = this.progress;
            this.guiProgress = k / (double)this.operationLength;
            if (this.progress >= this.operationLength) {
                this.guiProgress = 0.0;
                this.operate();
                this.progress = 0;
                this.initiate(2);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                this.initiate(0);
            }
            if (this.output == null) {
                this.progress = 0;
                this.guiProgress = 0.0;
            }
            if (this.getActive()) {
                this.setActive(false);
            }
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setOverclockRates();
        }
    }

    private double getConsume() {
        this.consumeSE = this.output.getRecipe().getOutput().metadata.m_128459_("se") * (this.energyConsume / this.defaultEnergyConsume);
        return this.consumeSE;
    }

    public void setOverclockRates() {
        this.operationsPerTick = this.upgradeSlot.getOperationsPerTick(this.defaultOperationLength);
        this.operationLength = this.upgradeSlot.getOperationLength(this.defaultOperationLength);
        this.energyConsume = this.upgradeSlot.getEnergyDemand(this.defaultEnergyConsume);
        int tier = this.upgradeSlot.getTier(this.defaultTier);
        this.energy.setSinkTier(tier);
        this.energy.setCapacity(this.upgradeSlot.getEnergyStorage(this.defaultEnergyStorage));
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
    }

    public void operate() {
        for (int i = 0; i < 1; ++i) {
            this.operateOnce();
            this.getOutput();
            if (this.output == null) break;
        }
    }

    public void operateOnce() {
        this.inputSlotA.consume();
        this.outputSlot.addWithoutIgnoring(this.output.getRecipe().getOutput().items, false);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemInput, UpgradableProperty.FluidExtract);
    }

    public double getProgress() {
        return this.guiProgress;
    }
}

