/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.agriculture.ICropItem;
import com.denfop.api.agriculture.genetics.GeneticTraits;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.bee.genetics.Genome;
import com.denfop.api.bee.genetics.IGenomeItem;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerInoculator;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiInoculator;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.items.bee.ItemJarBees;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityInoculator
extends TileElectricMachine
implements IHasRecipe,
IAudioFixer,
IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent {
    public final InvSlotRecipes inputSlotA;
    public final InvSlotUpgrade upgradeSlot;
    public ComponentUpgradeSlots componentUpgrade;
    public ComponentProgress componentProgress;
    public ComponentProcess componentProcess;
    public MachineRecipe output;

    public TileEntityInoculator(BlockPos pos, BlockState state) {
        super(300.0, 1, 1, BlockBaseMachine3.inoculator, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.inputSlotA = new InvSlotRecipes(this, "inoculator", this){

            @Override
            public boolean accepts(ItemStack itemStack, int index) {
                return itemStack.m_41720_() instanceof ICropItem || itemStack.m_41720_() instanceof IGenomeItem || itemStack.m_41720_() instanceof com.denfop.api.agriculture.genetics.IGenomeItem || itemStack.m_41720_() == IUItem.jarBees.getStack(0);
            }
        };
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot){

            @Override
            public void onLoaded() {
                super.onLoaded();
                this.componentProcess = ((TileEntityInoculator)this.getParent()).componentProcess;
            }
        });
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.25));
        this.componentProgress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, 300));
        this.componentProcess = this.addComponent(new ComponentProcess(this, 300, 1.0){

            @Override
            public void operateWithMax(MachineRecipe output, int size) {
                this.operateWithMax(output);
            }

            @Override
            public boolean checkRecipe() {
                ItemStack genome;
                if (TileEntityInoculator.this.output == null) {
                    return false;
                }
                ItemStack stack1 = this.isCrop(this.invSlotRecipes.get(0)) || this.isBee(this.invSlotRecipes.get(0)) ? this.invSlotRecipes.get(0) : this.invSlotRecipes.get(1);
                ItemStack itemStack = genome = this.isCrop(this.invSlotRecipes.get(0)) || this.isBee(this.invSlotRecipes.get(0)) ? this.invSlotRecipes.get(1) : this.invSlotRecipes.get(0);
                if (this.isCrop(stack1)) {
                    com.denfop.api.agriculture.genetics.Genome genome1 = new com.denfop.api.agriculture.genetics.Genome(stack1);
                    com.denfop.api.agriculture.genetics.IGenomeItem genomeItem = (com.denfop.api.agriculture.genetics.IGenomeItem)genome.m_41720_();
                    GeneticTraits genomeTraits = genomeItem.getGenomeTraits(genome);
                    return !genome1.hasGenome(genomeTraits.getGenetic());
                }
                if (this.isBee(stack1)) {
                    Genome genome1 = new Genome(stack1);
                    IGenomeItem genomeItem = (IGenomeItem)genome.m_41720_();
                    com.denfop.api.bee.genetics.GeneticTraits genomeTraits = genomeItem.getGenomeTraits(genome);
                    return !genome1.hasGenome(genomeTraits.getGenetic());
                }
                return false;
            }

            public boolean isCrop(ItemStack stack) {
                return stack.m_41720_() instanceof ICropItem;
            }

            public boolean isBee(ItemStack stack) {
                return stack.m_41720_() instanceof ItemJarBees;
            }

            @Override
            public void operateWithMax(MachineRecipe output) {
                ItemStack genome;
                ItemStack stack1 = this.isCrop(this.invSlotRecipes.get(0)) || this.isBee(this.invSlotRecipes.get(0)) ? this.invSlotRecipes.get(0) : this.invSlotRecipes.get(1);
                ItemStack itemStack = genome = this.isCrop(this.invSlotRecipes.get(0)) || this.isBee(this.invSlotRecipes.get(0)) ? this.invSlotRecipes.get(1) : this.invSlotRecipes.get(0);
                if (this.isCrop(stack1)) {
                    com.denfop.api.agriculture.genetics.IGenomeItem genomeItem = (com.denfop.api.agriculture.genetics.IGenomeItem)genome.m_41720_();
                    com.denfop.api.agriculture.genetics.Genome genome1 = new com.denfop.api.agriculture.genetics.Genome(stack1);
                    GeneticTraits genomeTraits = genomeItem.getGenomeTraits(genome);
                    genome1.addGenome(genomeTraits, stack1);
                    ItemStack outputStack = genome1.getStack().m_41777_();
                    this.invSlotRecipes.consume();
                    this.outputSlot.add(outputStack);
                } else if (this.isBee(stack1)) {
                    IGenomeItem genomeItem = (IGenomeItem)genome.m_41720_();
                    Genome genome1 = new Genome(stack1);
                    com.denfop.api.bee.genetics.GeneticTraits genomeTraits = genomeItem.getGenomeTraits(genome);
                    genome1.addGenome(genomeTraits);
                    ItemStack outputStack = genome1.getStack().m_41777_();
                    this.invSlotRecipes.consume();
                    this.outputSlot.add(outputStack);
                }
            }
        });
        this.componentProcess.setHasAudio(true);
        this.componentProcess.setSlotOutput(this.outputSlot);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
    }

    public static void addRecipe(ItemStack container, ItemStack output) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("inoculator", new BaseMachineRecipe(new Input(input.getInput(container), input.getInput(output)), new RecipeOutput(null, container)));
    }

    @Override
    public void init() {
        ItemStack input;
        int i;
        for (i = 0; i < 82; ++i) {
            if (i == 3) continue;
            input = new ItemStack((ItemLike)IUItem.crops.getStack(0));
            CompoundTag nbt = ModUtils.nbt(input);
            nbt.m_128405_("crop_id", i);
            GeneticTraits[] geneticTraitsArray = GeneticTraits.values();
            int n = geneticTraitsArray.length;
            for (int j = 0; j < n; ++j) {
                GeneticTraits traits = geneticTraitsArray[j];
                TileEntityInoculator.addRecipe(input, new ItemStack((ItemLike)IUItem.genome_crop.getStack(traits.ordinal()), 1));
            }
        }
        for (i = 1; i < 6; ++i) {
            input = IUItem.jarBees.getStack(0).getStackFromId(i);
            for (com.denfop.api.bee.genetics.GeneticTraits traits : com.denfop.api.bee.genetics.GeneticTraits.values()) {
                TileEntityInoculator.addRecipe(input, new ItemStack((ItemLike)IUItem.genome_bee.getStack(traits.ordinal()), 1));
            }
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.inoculator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiInoculator((ContainerInoculator)menu);
    }

    public ContainerInoculator getGuiContainer(Player var1) {
        return new ContainerInoculator(var1, this);
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }
}

