/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.agriculture.CropNetwork;
import com.denfop.api.agriculture.ICropItem;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerPlantGardener;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiPlantGardener;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.crop.TileEntityCrop;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityPlantGardener
extends TileEntityInventory
implements IUpgradableBlock {
    private static final int RADIUS = 8;
    public final Energy energy;
    public final InvSlot output;
    public final InvSlotUpgrade upgradeSlot;
    private final ComponentUpgradeSlots componentUpgrade;
    AABB searchArea;
    List<List<TileEntityCrop>> list;
    List<LevelChunk> chunks;

    public TileEntityPlantGardener(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.plant_gardener, pos, state);
        this.searchArea = new AABB(this.pos.m_7918_(-8, -8, -8), this.pos.m_7918_(8, 8, 8));
        this.list = new ArrayList<List<TileEntityCrop>>();
        this.output = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 9){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.m_41720_() instanceof ICropItem;
            }
        };
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 1024.0, 4));
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.2));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemInput);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.plant_gardener;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.plant_gardener.info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            AABB aabb = this.searchArea;
            int j2 = Mth.m_14107_((double)((aabb.f_82288_ - 2.0) / 16.0));
            int k2 = Mth.m_14165_((double)((aabb.f_82291_ + 2.0) / 16.0));
            int l2 = Mth.m_14107_((double)((aabb.f_82290_ - 2.0) / 16.0));
            int i3 = Mth.m_14165_((double)((aabb.f_82293_ + 2.0) / 16.0));
            this.chunks = new ArrayList<LevelChunk>();
            for (int j3 = j2; j3 < k2; ++j3) {
                for (int k3 = l2; k3 < i3; ++k3) {
                    LevelChunk chunk = this.f_58857_.m_6325_(j3, k3);
                    if (this.chunks.contains(chunk)) continue;
                    this.chunks.add(chunk);
                }
            }
            for (LevelChunk chunk : this.chunks) {
                this.list.add(CropNetwork.instance.getCropsFromChunk(this.f_58857_, chunk.m_7697_()));
            }
        }
    }

    public ContainerPlantGardener getGuiContainer(Player var1) {
        return new ContainerPlantGardener(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiPlantGardener((ContainerPlantGardener)menu);
    }

    public boolean contains(BlockPos vec) {
        if ((double)vec.m_123341_() > this.searchArea.f_82288_ && (double)vec.m_123341_() < this.searchArea.f_82291_) {
            if ((double)vec.m_123342_() > this.searchArea.f_82289_ && (double)vec.m_123342_() < this.searchArea.f_82292_) {
                return (double)vec.m_123343_() > this.searchArea.f_82290_ && (double)vec.m_123343_() < this.searchArea.f_82293_;
            }
            return false;
        }
        return false;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().m_46467_() % 100L == 0L) {
            this.updateCrop();
        }
        if (this.getWorld().m_46467_() % 20L == 0L && this.energy.canUseEnergy(10.0)) {
            block0: for (List<TileEntityCrop> crops : this.list) {
                for (TileEntityCrop crop : crops) {
                    if (!(this.energy.getEnergy() > 10.0)) break block0;
                    if (!this.contains(crop.getPos())) continue;
                    for (ItemStack stack : this.output) {
                        if (stack.m_41619_() || crop.getCrop() != null || crop.isHasDouble() || !CropNetwork.instance.canPlantCrop(stack, this.f_58857_, this.pos, crop.getDownState(), crop.getBiome())) continue;
                        crop.plantNewCrop(stack);
                        this.energy.useEnergy(10.0);
                    }
                }
            }
        }
    }

    private void updateCrop() {
        this.list.clear();
        for (LevelChunk chunk : this.chunks) {
            this.list.add(CropNetwork.instance.getCropsFromChunk(this.f_58857_, chunk.m_7697_()));
        }
    }
}

