/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockPrimalPump;
import com.denfop.componets.ComponentProgress;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileElectricLiquidTankInventory;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TileEntityPrimalPump
extends TileElectricLiquidTankInventory {
    public ComponentProgress componentProgress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, 25));
    private int prevAmount;

    public TileEntityPrimalPump(BlockPos pos, BlockState state) {
        super(0.0, 1, 4, BlockPrimalPump.primal_pump, pos, state);
        this.fluidTank.setTypeItemSlot(InvSlot.TypeItemSlot.OUTPUT);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockPrimalPump.primal_pump;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.primal_pump.getBlock();
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank1 != null) {
                this.fluidTank.readFromNBT(fluidTank1.writeToNBT(new CompoundTag()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("fluidtank")) {
            try {
                FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(is);
                if (fluidTank1 != null) {
                    this.fluidTank.readFromNBT(fluidTank1.writeToNBT(new CompoundTag()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean onSneakingActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && this.fluidTank.getFluidAmount() + 1000 <= this.fluidTank.getCapacity()) {
            if (this.componentProgress.getProgress() < this.componentProgress.getMaxValue()) {
                this.componentProgress.addProgress(0, (short)4);
            } else if (this.canoperate()) {
                this.componentProgress.setProgress((short)0);
            }
            this.setActive(true);
        } else {
            this.setActive(false);
        }
        return super.onSneakingActivated(player, hand, side, vec3);
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && FluidHandlerFix.getFluidHandler(player.m_21120_(hand)) != null) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(ForgeCapabilities.FLUID_HANDLER, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        for (int i = 1; i < 6; ++i) {
            tooltip.add(Localization.translate("primitive_pump.info" + i));
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, (Object)this.fluidTank);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.prevAmount != this.fluidTank.getFluidAmount()) {
            this.prevAmount = this.fluidTank.getFluidAmount();
            new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank);
        }
    }

    public boolean canoperate() {
        return this.operate(true);
    }

    public boolean operate(boolean sim) {
        if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity()) {
            return false;
        }
        boolean canOperate = false;
        for (int i = this.pos.m_123341_() - 1; i <= this.pos.m_123341_() + 1; ++i) {
            for (int j = this.pos.m_123343_() - 1; j <= this.pos.m_123343_() + 1; ++j) {
                for (int k = this.pos.m_123342_() - 1; k <= this.pos.m_123342_() - 1; ++k) {
                    if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity()) {
                        return false;
                    }
                    FluidStack liquid = this.pump(new BlockPos(i, k, j), false);
                    if (liquid == null || liquid.isEmpty() || this.getFluidTank().fill(liquid, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
                    this.getFluidTank().fill(liquid, IFluidHandler.FluidAction.EXECUTE);
                    canOperate = true;
                }
            }
        }
        return canOperate;
    }

    public FluidStack pump(BlockPos pos, boolean sim) {
        BlockState block;
        FluidStack ret = null;
        int freespace = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        if (freespace >= 1000 && (block = this.getWorld().m_8055_(pos)).m_60767_().m_76332_()) {
            if (block.m_60734_() instanceof IFluidBlock) {
                IFluidBlock liquid = (IFluidBlock)block.m_60734_();
                if ((this.fluidTank.getFluid().isEmpty() || this.fluidTank.getFluid().getFluid() == liquid.getFluid()) && liquid.canDrain(this.getWorld(), pos)) {
                    if (!sim) {
                        ret = liquid.drain(this.getWorld(), pos, IFluidHandler.FluidAction.EXECUTE);
                        this.getWorld().m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                    } else {
                        ret = new FluidStack(liquid.getFluid(), 1000);
                    }
                }
            } else {
                if (!block.m_60734_().m_5888_(block).m_76170_()) {
                    return FluidStack.EMPTY;
                }
                ret = new FluidStack(block.m_60734_().m_5888_(block).m_76152_(), 1000);
                if ((this.fluidTank.getFluid().isEmpty() || this.fluidTank.getFluid().getFluid() == ret.getFluid()) && !sim) {
                    this.getWorld().m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
        return ret;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energy.canUseEnergy(amount)) {
            this.energy.useEnergy(amount);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.PumpOp.getSoundEvent();
    }
}

