/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockSolderingMechanism;
import com.denfop.componets.ComponentProgress;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerSolderingMechanism;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiSolderingMechanism;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.world.WorldBaseGen;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityPrimalSolderingMechanism
extends TileElectricMachine
implements IUpdateTick,
IHasRecipe,
IUpdatableTileEvent {
    private static final int RED = 0;
    private static final int GRAY = 1;
    private static final int GREEN = 2;
    private static final int YELLOW = 3;
    private static final int SIZE = 156;
    private static Random random = new Random();
    public final ComponentProgress componentProgress;
    private final int MIN_DISTANCE = 5;
    private final int MAX_ATTEMPTS = 100;
    public InvSlot solderingIronSlot;
    public InvSlotRecipes inputSlotA;
    public MachineRecipe output = null;
    public boolean start;
    public int[] data;
    int failed = 0;
    private int RED_PERCENT = 35;
    private int GREEN_PERCENT = 80;
    private int YELLOW_PERCENT = 100 - this.RED_PERCENT - this.GREEN_PERCENT;

    public TileEntityPrimalSolderingMechanism(BlockPos pos, BlockState state) {
        super(0.0, 0, 1, BlockSolderingMechanism.primal_soldering_mechanism, pos, state);
        this.solderingIronSlot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.m_41720_() == IUItem.solderingIron.getItem();
            }
        };
        this.componentProgress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, 300));
        this.inputSlotA = new InvSlotRecipes((TileEntityInventory)this, "microchip", (IUpdateTick)this);
        Recipes.recipes.addInitRecipes(this);
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    private int[] generateColorStrip() {
        int[] data = new int[156];
        this.fillGrayZones(data);
        this.createGrayGaps(data);
        this.createIslandsWithSpacing(data, 0, this.RED_PERCENT);
        this.createIslandsWithSpacing(data, 2, this.GREEN_PERCENT);
        return data;
    }

    private void fillGrayZones(int[] data) {
        for (int i = 0; i < 156; ++i) {
            data[i] = 1;
        }
    }

    private void createGrayGaps(int[] data) {
        int length;
        for (int index = 0; index < 156; index += length + 5) {
            length = random.nextInt(11) + 10;
            if (index + length > 156) {
                length = 156 - index;
            }
            for (int i = index; i < index + length; ++i) {
                data[i] = 1;
            }
        }
    }

    private void createIslandsWithSpacing(int[] data, int color, int percent) {
        int totalColorCount = 156 * percent / 100;
        int numIslands = random.nextInt(3) + 3;
        while (totalColorCount > 0 && numIslands > 0) {
            int attempts;
            int islandLength = random.nextInt(21) + 10;
            if (islandLength > totalColorCount) {
                islandLength = totalColorCount;
            }
            boolean placed = false;
            for (attempts = 0; !placed && attempts < 100; ++attempts) {
                int startIndex = random.nextInt(156 - islandLength);
                if (!this.isValidPlacement(data, startIndex, islandLength, color)) continue;
                for (int i = startIndex; i < startIndex + islandLength; ++i) {
                    data[i] = color;
                }
                totalColorCount -= islandLength;
                placed = true;
                --numIslands;
            }
            if (attempts < 100) continue;
            break;
        }
    }

    private boolean isValidPlacement(int[] data, int startIndex, int length, int color) {
        for (int i = startIndex; i < startIndex + length; ++i) {
            if (data[i] == 1) continue;
            return false;
        }
        if (startIndex > 0 && data[startIndex - 1] == color) {
            return false;
        }
        return startIndex + length >= 156 || data[startIndex + length] != color;
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (this.start && var2 == 0.0) {
            this.componentProgress.addProgress(0, (short)8);
            if (this.componentProgress.getProgress(0) >= 300) {
                this.componentProgress.setProgress((short)300);
            }
            this.solderingIronSlot.set(0, this.solderingIronSlot.get(0).m_41720_().getCraftingRemainingItem(this.solderingIronSlot.get(0)));
        } else if (this.start && var2 == 1.0) {
            this.componentProgress.addProgress(0, (short)-5);
            if (this.componentProgress.getProgress(0) < 0) {
                this.componentProgress.setProgress((short)0);
            }
            this.solderingIronSlot.set(0, this.solderingIronSlot.get(0).m_41720_().getCraftingRemainingItem(this.solderingIronSlot.get(0)));
            ++this.failed;
        } else if (this.start && var2 == 2.0) {
            this.componentProgress.addProgress(0, (short)-2);
            if (this.componentProgress.getProgress(0) < 0) {
                this.componentProgress.setProgress((short)0);
            }
            this.solderingIronSlot.set(0, this.solderingIronSlot.get(0).m_41720_().getCraftingRemainingItem(this.solderingIronSlot.get(0)));
        }
        if (this.failed >= 12) {
            this.failed = 0;
            if (WorldBaseGen.random.nextDouble() < 0.25) {
                this.inputSlotA.consume();
            }
            this.componentProgress.setProgress(0, (short)0);
            this.start = false;
            this.getOutput();
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.inputSlotA.load();
        this.getOutput();
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiChargeLevel = (Double)DecoderHandler.decode(customPacketBuffer);
            this.start = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.data = (int[])DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiChargeLevel);
            EncoderHandler.encode(packet, this.start);
            EncoderHandler.encode(packet, this.data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.primal_repair5"));
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.start) {
            if (this.output != null) {
                if (!this.solderingIronSlot.isEmpty() && this.inputSlotA.continue_process(this.output) && this.outputSlot.canAdd(this.output.getRecipe().getOutput().items)) {
                    this.start = true;
                    this.data = this.generateColorStrip();
                } else {
                    this.start = false;
                }
            }
        } else if (this.output == null || this.solderingIronSlot.isEmpty()) {
            this.start = false;
        }
        if (this.start && this.componentProgress.getBar() >= 1.0) {
            this.inputSlotA.consume();
            this.componentProgress.setProgress(0, (short)0);
            this.data = this.generateColorStrip();
            this.failed = 0;
            this.outputSlot.add(this.output.getRecipe().getOutput().items);
            this.getOutput();
        }
    }

    public ContainerSolderingMechanism getGuiContainer(Player entityPlayer) {
        return new ContainerSolderingMechanism(entityPlayer, this);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockSolderingMechanism.primal_soldering_mechanism;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.solderingMechanism.getBlock();
    }

    @Override
    public void init() {
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player entityPlayer, ContainerBase<? extends IAdvInventory> isAdmin) {
        return new GuiSolderingMechanism((ContainerSolderingMechanism)isAdmin);
    }

    public String getStartSoundFile() {
        return "Machines/genmirc.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }
}

