/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerRadioactiveOreHandler;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiRadioactiveOreHandler;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityRadioactiveOreHandler
extends TileElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent,
IHasRecipe {
    public final InvSlotUpgrade upgradeSlot;
    public final ComponentUpgradeSlots componentUpgrade;
    public final ComponentProgress componentProgress;
    public final ComponentProcess componentProcess;
    public final InvSlotRecipes inputSlotA;
    public final ComponentBaseEnergy componentRadiation;
    public final InvSlotOutput outputSlot1;
    public MachineRecipe output;

    public TileEntityRadioactiveOreHandler(BlockPos pos, BlockState state) {
        super(200.0, 1, 1, BlockBaseMachine3.radioactive_handler_ore, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.outputSlot1 = new InvSlotOutput(this, 1);
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot){

            @Override
            public void onLoaded() {
                super.onLoaded();
                this.componentProcess = ((TileEntityRadioactiveOreHandler)this.getParent()).componentProcess;
                this.energy = this.getParent().getComp(Energy.class);
                this.setOverclockRates(this.invSlot);
            }
        });
        this.addComponent(new SoilPollutionComponent(this, 0.25));
        this.addComponent(new AirPollutionComponent(this, 0.25));
        this.componentProgress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, 100));
        this.inputSlotA = new InvSlotRecipes((TileEntityInventory)this, "radioactive_handler", (IUpdateTick)this);
        this.componentProcess = this.addComponent(new ComponentProcess(this, 200, 1.0){

            @Override
            public boolean checkRecipe() {
                return TileEntityRadioactiveOreHandler.this.componentRadiation.getEnergy() + 1.0 < TileEntityRadioactiveOreHandler.this.componentRadiation.getCapacity();
            }

            @Override
            protected int getRadiationSize(int size) {
                return (int)Math.min((double)size, TileEntityRadioactiveOreHandler.this.componentRadiation.getCapacity() - TileEntityRadioactiveOreHandler.this.componentRadiation.getEnergy());
            }

            @Override
            public boolean canAddItemStack() {
                return this.outputSlot.canAdd(this.updateTick.getRecipeOutput().getRecipe().getOutput().items.get(0));
            }

            @Override
            public void operateWithMax(MachineRecipe output) {
                if (output.getRecipe() == null) {
                    return;
                }
                int size = 64;
                List<Integer> list = this.updateTick.getRecipeOutput().getList();
                if (this.invSlotRecipes.getRecipe().workbench()) {
                    size = 1;
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        size = Math.min(size, this.invSlotRecipes.get(i).m_41613_() / list.get(i));
                    }
                }
                int maxSize = size;
                int count = this.outputSlot.get(0).m_41619_() ? output.getRecipe().output.items.get(0).m_41741_() : this.outputSlot.get(0).m_41741_() - this.outputSlot.get(0).m_41613_();
                ItemStack outputStack = this.updateTick.getRecipeOutput().getRecipe().output.items.get(0);
                size = Math.min(size, count /= Math.max(outputStack.m_41613_(), 1));
                size = Math.min(size, this.updateTick.getRecipeOutput().getRecipe().output.items.get(0).m_41720_().m_41459_());
                if (this.updateTick.getRecipeOutput().getRecipe().input.getFluid() != null) {
                    int size1 = this.invSlotRecipes.getTank().getFluidAmount() / this.updateTick.getRecipeOutput().getRecipe().input.getFluid().getAmount();
                    size = Math.min(size, size1);
                }
                size = Math.min(size, this.operationsPerTick);
                size = Math.min(this.getSESize(size), this.getRadiationSize(size));
                this.invSlotRecipes.consume(size, output);
                this.outputSlot.add(output.getRecipe().getOutput().items.get(0), size);
                for (int i = 0; i < size; ++i) {
                    if (WorldBaseGen.random.nextInt(100) >= output.getRecipe().output.metadata.m_128451_("random")) continue;
                    TileEntityRadioactiveOreHandler.this.outputSlot1.add(output.getRecipe().getOutput().items.get(1));
                }
                this.consumeSE(size);
                this.consumeRadiation(size);
                if (maxSize == size) {
                    this.updateTick.setRecipeOutput(null);
                }
            }

            @Override
            protected void consumeRadiation(int size) {
                TileEntityRadioactiveOreHandler.this.componentRadiation.addEnergy(size);
            }

            @Override
            public boolean checkRadiation(boolean consume) {
                return true;
            }
        });
        this.componentRadiation = this.addComponent(ComponentBaseEnergy.asBasicSource(EnergyType.RADIATION, this, 2000.0));
        this.componentProcess.setHasAudio(false);
        this.componentProcess.setSlotOutput(this.outputSlot);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
    }

    public static void addRecipe(ItemStack container, ItemStack output, int random, ItemStack itemStack) {
        IInputHandler input = Recipes.inputFactory;
        CompoundTag nbt = ModUtils.nbt();
        nbt.m_128405_("random", random);
        Recipes.recipes.addRecipe("radioactive_handler", new BaseMachineRecipe(new Input(input.getInput(container)), new RecipeOutput(nbt, output, itemStack)));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getOperationsPerTick());
        }
        super.addInformation(stack, tooltip);
    }

    public ContainerRadioactiveOreHandler getGuiContainer(Player var1) {
        return new ContainerRadioactiveOreHandler(var1, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiRadioactiveOreHandler((ContainerRadioactiveOreHandler)menu);
    }

    @Override
    public void init() {
        TileEntityRadioactiveOreHandler.addRecipe(new ItemStack((ItemLike)IUItem.classic_ore.getItem(3), 1), new ItemStack((ItemLike)IUItem.nuclear_res.getStack(21), 2), 5, new ItemStack((ItemLike)IUItem.nuclear_res.getStack(16), 1));
        TileEntityRadioactiveOreHandler.addRecipe(new ItemStack((ItemLike)IUItem.toriyore.getItem(), 1), new ItemStack((ItemLike)IUItem.nuclear_res.getStack(19), 1), 10, new ItemStack((ItemLike)IUItem.nuclear_res.getStack(14), 4));
        TileEntityRadioactiveOreHandler.addRecipe(new ItemStack((ItemLike)IUItem.radiationore.getItem(1), 1), new ItemStack((ItemLike)IUItem.nuclear_res.getStack(18), 1), 10, new ItemStack((ItemLike)IUItem.nuclear_res.getStack(13), 4));
        TileEntityRadioactiveOreHandler.addRecipe(new ItemStack((ItemLike)IUItem.radiationore.getItem(), 1), new ItemStack((ItemLike)IUItem.nuclear_res.getStack(17), 1), 10, new ItemStack((ItemLike)IUItem.nuclear_res.getStack(15), 4));
        TileEntityRadioactiveOreHandler.addRecipe(new ItemStack((ItemLike)IUItem.radiationore.getItem(2), 1), new ItemStack((ItemLike)IUItem.nuclear_res.getStack(20), 1), 20, new ItemStack((ItemLike)IUItem.nuclear_res.getStack(16), 4));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.radioactive_handler_ore;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.f_58857_.f_46443_) {
            this.inputSlotA.load();
            this.getOutput();
        }
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }
}

