/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerWirelessControllerReactors;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiWirelessControllerReactors;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemReactorData;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ModUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityWirelessControllerReactors
extends TileEntityInventory
implements IUpdatableTileEvent {
    public final InvSlot invslot;
    public List<ItemStack> itemStacks = new LinkedList<ItemStack>();
    public List<TileMultiBlockBase> tileMultiBlockBaseList = new LinkedList<TileMultiBlockBase>();

    public TileEntityWirelessControllerReactors(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.wireless_controller_reactors, pos, state);
        this.invslot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 12){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                TileEntityWirelessControllerReactors.this.updateList();
                return content;
            }

            @Override
            public boolean accepts(ItemStack stack, int index) {
                if (!(stack.m_41720_() instanceof ItemReactorData)) {
                    return false;
                }
                CompoundTag nbt = ModUtils.nbt(stack);
                return !nbt.m_128461_("name").isEmpty();
            }
        };
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    public ContainerWirelessControllerReactors getGuiContainer(Player var1) {
        return new ContainerWirelessControllerReactors(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiWirelessControllerReactors((ContainerWirelessControllerReactors)menu);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.wireless_controller_reactors;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            // empty if block
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.tileMultiBlockBaseList.clear();
        this.itemStacks.clear();
        for (int i = 0; i < 12; ++i) {
            CompoundTag nbt = ModUtils.nbt(this.invslot.get(i));
            BlockPos pos = new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
            BlockEntity tileEntity = this.getWorld().m_7702_(pos);
            if (tileEntity instanceof TileMultiBlockBase && tileEntity instanceof IAdvReactor) {
                this.tileMultiBlockBaseList.add((TileMultiBlockBase)tileEntity);
                this.itemStacks.add(((TileMultiBlockBase)tileEntity).getPickBlock(null, null));
                continue;
            }
            this.tileMultiBlockBaseList.add(null);
            this.itemStacks.add(ItemStack.f_41583_);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.updateList();
        }
    }

    public void updateList() {
        this.itemStacks.clear();
        this.tileMultiBlockBaseList.clear();
        for (int i = 0; i < 12; ++i) {
            CompoundTag nbt = ModUtils.nbt(this.invslot.get(i));
            BlockPos pos = new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
            BlockEntity tileEntity = this.getWorld().m_7702_(pos);
            if (tileEntity instanceof TileMultiBlockBase && tileEntity instanceof IAdvReactor) {
                this.tileMultiBlockBaseList.add((TileMultiBlockBase)tileEntity);
                this.itemStacks.add(((TileMultiBlockBase)tileEntity).getPickBlock(null, null));
                continue;
            }
            this.tileMultiBlockBaseList.add(null);
            this.itemStacks.add(ItemStack.f_41583_);
        }
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        TileMultiBlockBase tileMultiBlockBase;
        if (!this.itemStacks.get((int)var2).m_41619_() && (tileMultiBlockBase = this.tileMultiBlockBaseList.get((int)var2)) != null && tileMultiBlockBase.isFull() && !tileMultiBlockBase.m_58901_()) {
            tileMultiBlockBase.onActivated(var1, var1.m_7655_(), Direction.NORTH, new Vec3(0.0, 0.0, 0.0));
        }
    }
}

