/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.dual;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine1;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerDoubleElectricMachine;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiSynthesis;
import com.denfop.invslot.InvSlot;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.EnumDoubleElectricMachine;
import com.denfop.tiles.base.TileDoubleElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileSynthesis
extends TileDoubleElectricMachine
implements IHasRecipe {
    public final ComponentBaseEnergy rad_energy;
    public final InvSlot input_slot;

    public TileSynthesis(BlockPos pos, BlockState state) {
        super(1, 300, 1, EnumDoubleElectricMachine.SYNTHESIS, false, BlockBaseMachine1.synthesis, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot){

            @Override
            public void onLoaded() {
                super.onLoaded();
                this.componentProcess = ((TileSynthesis)this.getParent()).componentProcess;
            }
        });
        this.componentProgress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, 300));
        this.componentProcess = this.addComponent(new ComponentProcess(this, 300, 1.0){

            @Override
            public void operateWithMax(MachineRecipe output) {
                this.consumeRadiation(1);
                this.operate(output);
            }

            @Override
            public void operateWithMax(MachineRecipe output, int size) {
                if (output.getRecipe() == null) {
                    return;
                }
                size = Math.min(this.getSESize(size), this.getRadiationSize(size));
                this.consumeRadiation(size);
                for (int i = 0; i < size; ++i) {
                    this.operate(output);
                }
            }

            @Override
            protected int getRadiationSize(int size) {
                int amount = this.updateTick.getRecipeOutput().getRecipe().output.metadata.m_128451_("rad_amount");
                return (int)Math.min((double)size, TileSynthesis.this.rad_energy.getEnergy() / (double)amount);
            }

            @Override
            public void operateOnce(List<ItemStack> processResult) {
                this.invSlotRecipes.consume();
                CompoundTag nbt = this.updateTick.getRecipeOutput().getRecipe().output.metadata;
                int procent = nbt.m_128451_("percent");
                RandomSource rand = this.getParent().getWorld().f_46441_;
                if (rand.m_188503_(100) + 1 > 100 - procent) {
                    this.outputSlot.add(this.updateTick.getRecipeOutput().getRecipe().output.items.get(0));
                }
            }
        });
        this.rad_energy = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.RADIATION, this, 10000.0));
        this.componentProcess.setHasAudio(true);
        this.componentProcess.setSlotOutput(this.outputSlot);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
        this.input_slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (this.get(0).m_41619_()) {
                    ((TileSynthesis)this.base).inputSlotA.changeAccepts(ItemStack.f_41583_);
                } else {
                    ((TileSynthesis)this.base).inputSlotA.changeAccepts(this.get(0));
                }
                return content;
            }

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.m_41720_() == IUItem.recipe_schedule.getItem();
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.RECIPE_SCHEDULE;
            }
        };
    }

    public static void addsynthesis(ItemStack container, ItemStack fill, int number, ItemStack output, int rad) {
        CompoundTag nbt = ModUtils.nbt();
        nbt.m_128405_("percent", number);
        nbt.m_128405_("rad_amount", rad);
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("synthesis", new BaseMachineRecipe(new Input(input.getInput(container), input.getInput(fill)), new RecipeOutput(nbt, output)));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            if (this.input_slot.isEmpty()) {
                this.inputSlotA.changeAccepts(ItemStack.f_41583_);
            } else {
                this.inputSlotA.changeAccepts(this.input_slot.get(0));
            }
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine1.synthesis;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine.getBlock(this.getTeBlock().getId());
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.synthesys.getSoundEvent();
    }

    @Override
    public void init() {
        TileSynthesis.addsynthesis(new ItemStack((ItemLike)IUItem.radiationresources.getItemFromMeta(2), 1), ModUtils.getCellFromFluid((Fluid)FluidName.fluidHelium.getInstance().get()), 32, new ItemStack((ItemLike)IUItem.radiationresources.getItemFromMeta(3), 1), 200);
        TileSynthesis.addsynthesis(new ItemStack((ItemLike)IUItem.radiationresources.getItemFromMeta(3), 1), ModUtils.getCellFromFluid((Fluid)FluidName.fluidHelium.getInstance().get()), 27, new ItemStack((ItemLike)IUItem.radiationresources.getItemFromMeta(6), 1), 400);
        TileSynthesis.addsynthesis(new ItemStack((ItemLike)IUItem.radiationresources.getItemFromMeta(6), 1), ModUtils.getCellFromFluid((Fluid)FluidName.fluidHelium.getInstance().get()), 22, new ItemStack((ItemLike)IUItem.radiationresources.getItemFromMeta(7), 1), 500);
        TileSynthesis.addsynthesis(new ItemStack((ItemLike)IUItem.radiationresources.getItemFromMeta(7), 1), ModUtils.getCellFromFluid((Fluid)FluidName.fluidHelium.getInstance().get()), 19, new ItemStack((ItemLike)IUItem.radiationresources.getItemFromMeta(11), 1), 750);
        TileSynthesis.addsynthesis(IUItem.uraniumBlock, new ItemStack((ItemLike)IUItem.toriy.getItem()), 22, new ItemStack((ItemLike)IUItem.radiationresources.getItemFromMeta(8), 1), 150);
        TileSynthesis.addsynthesis(new ItemStack((ItemLike)IUItem.radiationresources.getItemFromMeta(1), 1), new ItemStack((ItemLike)IUItem.toriy.getItem()), 20, new ItemStack((ItemLike)IUItem.Plutonium), 100);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player entityPlayer, ContainerBase<? extends IAdvInventory> isAdmin) {
        return new GuiSynthesis((ContainerDoubleElectricMachine)isAdmin);
    }
}

