/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.energy;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.EnergyNetLocal;
import com.denfop.api.energy.IEnergyConductor;
import com.denfop.api.energy.IEnergyController;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.energy.event.EventLoadController;
import com.denfop.api.energy.event.EventUnloadController;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.blockitem.ItemBlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerSubstitute;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiEnergySubstitute;
import com.denfop.invslot.CableItem;
import com.denfop.invslot.InvSlotSubstitute;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.FakePlayerSpawner;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.transport.tiles.TileEntityCable;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TileEnergySubstitute
extends TileEntityInventory
implements IUpdatableTileEvent,
IEnergyController {
    public final InvSlotSubstitute slot;
    public Set<IEnergyConductor> conductorList = new HashSet<IEnergyConductor>();
    public boolean work = false;
    public int size;
    public int max_value = 0;
    List<CableItem> cableItemList = new ArrayList<CableItem>();
    CableItem main_cableItem = null;
    FakePlayerSpawner fakePlayer;
    Map<Direction, IEnergyTile> energyConductorMap = new HashMap<Direction, IEnergyTile>();
    List<InfoTile<IEnergyTile>> validReceivers = new LinkedList<InfoTile<IEnergyTile>>();
    int hashCodeSource;
    private ChunkPos chunkPos;
    private long id;

    public TileEnergySubstitute(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.substitute, pos, state);
        this.slot = new InvSlotSubstitute(this);
        this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 0.0, 14));
    }

    @Override
    public void RemoveTile(IEnergyTile tile, Direction facing1) {
        if (!this.getWorld().f_46443_) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<IEnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IEnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public List<InfoTile<IEnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void AddTile(IEnergyTile tile, Direction facing1) {
        if (!this.getWorld().f_46443_) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<IEnergyTile>(tile, facing1.m_122424_()));
        }
    }

    @Override
    public Map<Direction, IEnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.substitute;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public BlockEntity getTileEntity() {
        return this;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.controller_cables.info"));
        tooltip.add(Localization.translate("iu.controller_cables.info1"));
    }

    public List<CableItem> getCableItemList() {
        return this.cableItemList;
    }

    public void setCableItemList(List<CableItem> cableItemList) {
        this.cableItemList = cableItemList;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EventLoadController(this));
            this.fakePlayer = new FakePlayerSpawner(this.getWorld());
            this.slot.onChanged();
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.size = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onUnloaded() {
        if (!this.getWorld().f_46443_) {
            MinecraftForge.EVENT_BUS.post((Event)new EventUnloadController(this));
        }
        super.onUnloaded();
    }

    public ContainerSubstitute getGuiContainer(Player entityPlayer) {
        return new ContainerSubstitute(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiEnergySubstitute((ContainerSubstitute)menu);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128379_("work", this.work);
        return super.writeToNBT(nbt);
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.work = nbtTagCompound.m_128471_("work");
    }

    public void discover() {
        this.conductorList.clear();
        this.size = 0;
        ArrayList<IEnergyConductor> reachedTileEntities = new ArrayList<IEnergyConductor>();
        ArrayList<IEnergyTile> tileEntitiesToCheck = new ArrayList<IEnergyTile>();
        tileEntitiesToCheck.add(this.getComp(Energy.class).delegate);
        EnergyNetLocal energyNetLocal = EnergyNetGlobal.getForWorld(this.getWorld());
        while (!tileEntitiesToCheck.isEmpty()) {
            IEnergyTile currentTileEntity = (IEnergyTile)tileEntitiesToCheck.remove(0);
            List<InfoTile<IEnergyTile>> validReceivers = energyNetLocal.getValidReceiversSubstitute(currentTileEntity);
            for (InfoTile<IEnergyTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == this || !(validReceiver.tileEntity instanceof IEnergyConductor) || reachedTileEntities.contains((IEnergyConductor)validReceiver.tileEntity)) continue;
                reachedTileEntities.add((IEnergyConductor)validReceiver.tileEntity);
                tileEntitiesToCheck.add((IEnergyTile)validReceiver.tileEntity);
            }
        }
        this.conductorList.addAll(reachedTileEntities);
        this.size = this.conductorList.size();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work) {
            if (this.main_cableItem != null) {
                ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
                for (IEnergyConductor conductor : this.conductorList) {
                    if (!(conductor.getConductorBreakdownEnergy() - 1.0 < this.main_cableItem.getProvider())) continue;
                    for (ItemStack stack : this.slot) {
                        if (!stack.m_150930_(this.main_cableItem.getStack().m_41720_()) || !ModUtils.nbt(this.main_cableItem.getStack()).equals((Object)ModUtils.nbt(stack))) continue;
                        TileEntityBlock tile = (TileEntityBlock)EnergyNetGlobal.instance.getBlockPosFromEnergyTile(conductor);
                        List<ItemStack> drops = tile.getBlock().getDrops(this.f_58857_, tile.getPos(), tile.m_58900_(), null);
                        if (!drops.isEmpty()) {
                            itemStackList.add(drops.get(0));
                        }
                        tile.onUnloaded();
                        conductor.removeConductor();
                        BlockPos pos = tile.getPos();
                        ItemBlockTileEntity itemBlockTileEntity = (ItemBlockTileEntity)this.main_cableItem.getStack().m_41720_();
                        if (!itemBlockTileEntity.placeTeBlock(this.main_cableItem.getStack(), this.fakePlayer, this.getWorld(), pos)) continue;
                        stack.m_41774_(1);
                        this.main_cableItem.shrink(1);
                        TileEntityCable cable = (TileEntityCable)this.getWorld().m_7702_(pos);
                        break;
                    }
                    if (this.main_cableItem.getCount() != 0) continue;
                    this.slot.onChanged();
                    if (this.main_cableItem != null) continue;
                    break;
                }
                for (ItemStack stack : itemStackList) {
                    this.slot.add(stack);
                }
            }
            this.size = 0;
            this.work = false;
            this.discover();
            this.main_cableItem = null;
            this.slot.onChanged();
        }
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (i == 0.0) {
            this.discover();
            this.main_cableItem = null;
            this.slot.onChanged();
        } else if (i == 1.0) {
            this.work = true;
        }
    }

    @Override
    public boolean getWork() {
        return this.work;
    }

    @Override
    public void work() {
        if (this.getWork()) {
            this.discover();
        }
    }

    @Override
    public void unload() {
        this.conductorList.clear();
        this.size = 0;
    }

    public void setMaxValue(int max_value, double provider, CableItem cableItem) {
        if (provider > (double)max_value) {
            this.max_value = (int)provider;
            this.main_cableItem = cableItem;
        }
    }
}

