/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.generator.energy.coal;

import com.denfop.Localization;
import com.denfop.api.gui.IType;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerGenerator;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiGenerator;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.mechanism.generator.energy.TileEntityBaseGenerator;
import com.denfop.utils.DamageHandler;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityAdvGenerator
extends TileEntityBaseGenerator
implements IType {
    public final InvSlot fuelSlot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

        @Override
        public boolean accepts(ItemStack stack, int index) {
            return ModUtils.getFuelValue(stack, false) > 0;
        }
    };
    private final double coef;
    public int itemFuelTime = 0;

    public TileEntityAdvGenerator(double coef, int maxstorage, int tier, IMultiTileBlock multiTileBlock, BlockPos pos, BlockState state) {
        super(coef * (double)Math.round(10.0f), tier, maxstorage, multiTileBlock, pos, state);
        this.coef = coef;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.getActive()) {
            ModUtils.showFlames(this.getWorld(), this.m_58899_(), this.getFacing());
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.fuel = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.fuel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.info_upgrade_energy") + this.coef);
        }
        super.addInformation(stack, tooltip);
    }

    public int gaugeFuelScaled(int i) {
        if (this.fuel <= 0) {
            return 0;
        }
        if (this.itemFuelTime <= 0) {
            this.itemFuelTime = this.fuel;
        }
        return Math.min(this.fuel * i / this.itemFuelTime, i);
    }

    public int consumeFuel() {
        ItemStack fuel = this.consume(1);
        return fuel == null ? 0 : ModUtils.getFuelValue(fuel, false);
    }

    @Override
    public boolean gainFuel() {
        int fuelValue = this.consumeFuel() / 4;
        if (fuelValue == 0) {
            return false;
        }
        this.fuel += fuelValue;
        this.itemFuelTime = fuelValue;
        return true;
    }

    public ItemStack consume(int amount) {
        ItemStack ret = ItemStack.f_41583_;
        ItemStack stack = this.fuelSlot.get(0);
        if (!(stack.m_41619_() || ModUtils.getSize(stack) != 1 && stack.m_41720_().hasCraftingRemainingItem(stack))) {
            int currentAmount = Math.min(amount, ModUtils.getSize(stack));
            amount -= currentAmount;
            if (ModUtils.getSize(stack) == currentAmount) {
                if (stack.m_41720_().hasCraftingRemainingItem(stack)) {
                    ItemStack container = stack.m_41720_().getCraftingRemainingItem(stack);
                    if (container.m_41619_() && container.m_41763_() && DamageHandler.getDamage(container) > DamageHandler.getMaxDamage(container)) {
                        container = ItemStack.f_41583_;
                    }
                    this.fuelSlot.set(0, container);
                } else {
                    this.fuelSlot.set(0, ItemStack.f_41583_);
                }
            } else {
                this.fuelSlot.set(0, ModUtils.decSize(stack, currentAmount));
            }
            ret = ModUtils.setSize(stack, currentAmount);
        }
        return ret;
    }

    public int gaugeStorageScaled(int i) {
        return (int)(this.energy.getEnergy() * (double)i / this.energy.getCapacity());
    }

    public double getEnergy() {
        return this.energy.getEnergy();
    }

    public ContainerGenerator getGuiContainer(Player entityPlayer) {
        return new ContainerGenerator(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player entityPlayer, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiGenerator((ContainerGenerator)menu);
    }

    @Override
    public boolean isConverting() {
        return this.fuel > 0;
    }

    public String getOperationSoundFile() {
        return "Generators/GeneratorLoop.ogg";
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.itemFuelTime = nbt.m_128451_("itemFuelTime");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.m_128405_("itemFuelTime", this.itemFuelTime);
        return nbt;
    }

    @Override
    public EnumTypeStyle getStyle() {
        return EnumTypeStyle.DEFAULT;
    }
}

