/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.generator.energy.fluid;

import com.denfop.IUItem;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine2;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerDieselGenerator;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiDieselGenerator;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotCharge;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.base.TileEntityLiquidTankInventory;
import java.io.IOException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileDieselGenerator
extends TileEntityLiquidTankInventory
implements IAudioFixer,
IUpdatableTileEvent {
    public final InvSlotCharge chargeSlot = new InvSlotCharge(this, 1);
    public final InvSlotFluid fluidSlot;
    public final InvSlotOutput outputSlot;
    public final String name;
    public final Energy energy;
    public final int production = 200;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    public double coef = 1.0;
    public boolean addedToEnergyNet = false;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();
    private boolean sound = true;

    public TileDieselGenerator(BlockPos pos, BlockState state) {
        super(12, BlockBaseMachine2.gen_disel, pos, state);
        this.name = null;
        this.fluidSlot = new InvSlotFluidByList((TileEntityInventory)this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.INPUT, (Fluid)FluidName.fluiddizel.getInstance().get(), (Fluid)FluidName.fluida_diesel.getInstance().get(), (Fluid)FluidName.fluidaa_diesel.getInstance().get(), (Fluid)FluidName.fluidaaa_diesel.getInstance().get(), (Fluid)FluidName.fluidaaaa_diesel.getInstance().get());
        this.outputSlot = new InvSlotOutput(this, 1);
        this.energy = this.addComponent(Energy.asBasicSource(this, 1.0E7, 4).addManagedSlot(this.chargeSlot));
        ((Fluids.InternalFluidTank)this.getFluidTank()).setAcceptedFluids(Fluids.fluidPredicate((Fluid)FluidName.fluiddizel.getInstance().get(), (Fluid)FluidName.fluida_diesel.getInstance().get(), (Fluid)FluidName.fluidaa_diesel.getInstance().get(), (Fluid)FluidName.fluidaaa_diesel.getInstance().get(), (Fluid)FluidName.fluidaaaa_diesel.getInstance().get()));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.45));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.75));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.sound = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.sound);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return this.typeAudio;
    }

    @Override
    public void setType(EnumTypeAudio type) {
        this.typeAudio = type;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine2.gen_disel;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1.getBlock(this.getTeBlock().getId());
    }

    @Override
    public boolean getEnable() {
        return this.sound;
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getTypeAudio() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (!this.getEnable()) {
            return;
        }
        if (this.getSound() == null) {
            return;
        }
        if (soundEvent == 0) {
            this.getWorld().m_5594_(null, this.pos, this.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (soundEvent == 1) {
            new PacketStopSound(this.getWorld(), this.pos);
            this.getWorld().m_5594_(null, this.pos, EnumSound.InterruptOne.getSoundEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            new PacketStopSound(this.getWorld(), this.pos);
        }
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.diesel_generator.getSoundEvent();
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.sound = nbttagcompound.m_128471_("sound");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128379_("sound", this.sound);
        return nbttagcompound;
    }

    @Override
    public void updateEntityServer() {
        MutableObject output;
        super.updateEntityServer();
        if (!this.fluidTank.getFluid().isEmpty()) {
            Fluid fluid = this.fluidTank.getFluid().getFluid();
            if (fluid == FluidName.fluiddizel.getInstance().get()) {
                this.coef = 1.0;
            } else if (fluid == FluidName.fluida_diesel.getInstance().get()) {
                this.coef = 2.0;
            } else if (fluid == FluidName.fluidaa_diesel.getInstance().get()) {
                this.coef = 4.0;
            } else if (fluid == FluidName.fluidaaa_diesel.getInstance().get()) {
                this.coef = 8.0;
            } else if (fluid == FluidName.fluidaaaa_diesel.getInstance().get()) {
                this.coef = 16.0;
            }
        }
        if (this.needsFluid() && this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)(output = new MutableObject()), true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
            if (output.getValue() != null) {
                this.outputSlot.add((ItemStack)output.getValue());
            }
        }
        boolean newActive = this.gainEnergy();
        if (this.getActive() != newActive) {
            this.setActive(newActive);
        }
        if (this.getActive() && this.getWorld().m_46467_() % 60L == 0L) {
            this.initiate(2);
        }
    }

    public float getWrenchDropRate() {
        return 0.9f;
    }

    public boolean gainEnergy() {
        if (this.isConverting()) {
            this.energy.addEnergy((double)this.production * this.coef);
            this.getFluidTank().drain(2, IFluidHandler.FluidAction.EXECUTE);
            this.initiate(0);
            return true;
        }
        this.initiate(2);
        return false;
    }

    public boolean isConverting() {
        return this.getTankAmount() > 1 && this.energy.getEnergy() + (double)this.production * this.coef <= this.energy.getCapacity();
    }

    public ContainerDieselGenerator getGuiContainer(Player entityPlayer) {
        return new ContainerDieselGenerator(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player entityPlayer, ContainerBase<? extends IAdvInventory> isAdmin) {
        return new GuiDieselGenerator((ContainerDieselGenerator)isAdmin);
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        this.sound = !this.sound;
        new PacketUpdateFieldTile(this, "sound", this.sound);
        if (!this.sound && this.getTypeAudio() == EnumTypeAudio.ON) {
            this.setType(EnumTypeAudio.OFF);
            this.initiate(2);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("sound")) {
            try {
                this.sound = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }
}

