/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.steam;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.FluidHandlerRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.Fluids;
import com.denfop.componets.PressureComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerSteamSolidFluidMixer;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiSteamSolidFluidMixer;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntitySteamSolidFluidMixer
extends TileElectricMachine
implements IUpdateTick,
IUpdatableTileEvent,
IHasRecipe {
    public final InvSlotRecipes inputSlotA;
    public final Fluids.InternalFluidTank fluidTank1;
    public final Fluids.InternalFluidTank fluidTank2;
    public final Fluids.InternalFluidTank fluidTank3;
    public final PressureComponent pressure;
    public final ComponentSteamEnergy steam;
    public final FluidHandlerRecipe fluid_handler;
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public final double defaultEnergyStorage;
    private final Fluids fluids;
    private final Fluids.InternalFluidTank fluidTank;
    public MachineRecipe output;
    public double energyConsume;
    public int operationLength;
    public int operationsPerTick;
    public double guiProgress;
    protected short progress;

    public TileEntitySteamSolidFluidMixer(BlockPos pos, BlockState state) {
        super(0.0, 1, 1, BlockBaseMachine3.steam_solid_fluid_mixer, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.progress = 0;
        this.energyConsume = 1.0;
        this.defaultEnergyConsume = 1.0;
        this.operationLength = 200;
        this.defaultOperationLength = 200;
        this.defaultTier = 1;
        this.defaultEnergyStorage = 100.0;
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidTank1 = this.fluids.addTankInsert("fluidTank1", 12000);
        this.fluidTank2 = this.fluids.addTank("fluidTank2", 12000, InvSlot.TypeItemSlot.OUTPUT);
        this.fluidTank3 = this.fluids.addTank("fluidTank3", 12000, InvSlot.TypeItemSlot.OUTPUT);
        this.inputSlotA = new InvSlotRecipes(this, "solid_fluid_mixer", this, this.fluidTank1);
        this.fluid_handler = new FluidHandlerRecipe("solid_fluid_mixer", this.fluids);
        this.pressure = this.addComponent(PressureComponent.asBasicSink(this, 2.0));
        this.fluidTank = this.fluids.addTank("fluidTank6", 4000, InvSlot.TypeItemSlot.NONE, Fluids.fluidPredicate((Fluid)FluidName.fluidsteam.getInstance().get()));
        this.steam = this.addComponent(ComponentSteamEnergy.asBasicSink(this, 4000.0));
        this.steam.setFluidTank(this.fluidTank);
        this.fluidTank1.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getFluids(0)));
        this.fluidTank2.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getOutputFluids(0)));
        this.fluidTank3.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getOutputFluids(1)));
    }

    public static void addRecipe(ItemStack container, FluidStack fluidStack, FluidStack outputfluidStack, FluidStack outputfluidStack1) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("solid_fluid_mixer", new BaseMachineRecipe(new Input(fluidStack, input.getInput(container)), new RecipeOutput(null, container)));
        Recipes.recipes.getRecipeFluid().addRecipe("solid_fluid_mixer", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(fluidStack), Arrays.asList(outputfluidStack, outputfluidStack1)));
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.steam.getSoundEvent();
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && FluidHandlerFix.hasFluidHandler(player.m_21120_(hand))) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(ForgeCapabilities.FLUID_HANDLER, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            // empty if block
        }
        super.addInformation(stack, tooltip);
    }

    public ContainerSteamSolidFluidMixer getGuiContainer(Player var1) {
        return new ContainerSteamSolidFluidMixer(var1, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiSteamSolidFluidMixer((ContainerSteamSolidFluidMixer)menu);
    }

    @Override
    public void init() {
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.steam_solid_fluid_mixer;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.f_58857_.f_46443_) {
            this.inputSlotA.load();
            this.fluid_handler.load(this.inputSlotA.get(0));
            this.getOutput();
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.m_128448_("progress");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128376_("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
        this.fluid_handler.setOutput(null);
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        this.fluid_handler.setOutput(null);
        return this.output;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.fluid_handler.output() == null && this.output != null && this.fluidTank1.getFluidAmount() > 0) {
            this.fluid_handler.getOutput(this.inputSlotA.get(0));
        } else if (this.fluid_handler.output() != null && this.output == null) {
            this.fluid_handler.setOutput(null);
        }
        if (this.output != null && !this.inputSlotA.isEmpty() && this.inputSlotA.continue_process(this.output) && this.fluid_handler.output() != null && this.fluid_handler.canOperate() && this.fluid_handler.canFillFluid() && this.steam.canUseEnergy(this.energyConsume) && this.pressure.getEnergy() == 2.0) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.progress == 0) {
                this.initiate(0);
            }
            this.progress = (short)(this.progress + 1);
            this.steam.useEnergy(this.energyConsume);
            double k = this.progress;
            this.guiProgress = k / (double)this.operationLength;
            if (this.progress >= this.operationLength) {
                this.guiProgress = 0.0;
                this.operate();
                this.progress = 0;
                this.initiate(2);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                this.initiate(0);
            }
            if (this.output == null) {
                this.progress = 0;
                this.guiProgress = 0.0;
            }
            if (this.getActive()) {
                this.setActive(false);
            }
        }
    }

    public void operate() {
        for (int i = 0; i < 1; ++i) {
            this.operateOnce();
            this.getOutput();
            if (this.output == null) break;
        }
    }

    public void operateOnce() {
        this.inputSlotA.consume();
        this.fluid_handler.fillFluid();
    }

    public double getProgress() {
        return this.guiProgress;
    }
}

