/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.steamturbine;

import com.denfop.IUItem;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.steam.ISteamBlade;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockSteamTurbine;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerSteamTurbineRod;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiSteamTurbineRod;
import com.denfop.invslot.InvSlot;
import com.denfop.items.reactors.ItemDamage;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.mechanism.steamturbine.IRod;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntitySteamTurbineRod
extends TileEntityMultiBlockElement
implements IRod {
    private final InvSlot slot;
    List<ISteamBlade> list = new ArrayList<ISteamBlade>();

    public TileEntitySteamTurbineRod(BlockPos pos, BlockState state) {
        super(BlockSteamTurbine.steam_turbine_rod, pos, state);
        this.slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 4){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.m_41720_() instanceof ISteamBlade && ((ISteamBlade)stack.m_41720_()).getLevel() <= TileEntitySteamTurbineRod.this.getMain().getBlockLevel();
            }

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                this.update();
                return content;
            }

            @Override
            public void update() {
                super.update();
                TileEntitySteamTurbineRod.this.list.clear();
                for (int i = 0; i < this.size(); ++i) {
                    ItemStack stack = this.get(i);
                    if (stack.m_41619_()) continue;
                    ItemDamage damage = (ItemDamage)stack.m_41720_();
                    if (damage.getMaxCustomDamage(stack) - damage.getCustomDamage(stack) == 0) {
                        this.set(i, ItemStack.f_41583_);
                        continue;
                    }
                    TileEntitySteamTurbineRod.this.list.add((ISteamBlade)stack.m_41720_());
                }
            }
        };
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer packetBuffer) {
        super.readUpdatePacket(packetBuffer);
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer customPacketBuffer = super.writeUpdatePacket();
        return customPacketBuffer;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockSteamTurbine.steam_turbine_rod;
    }

    public ContainerSteamTurbineRod getGuiContainer(Player entityPlayer) {
        return new ContainerSteamTurbineRod(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiSteamTurbineRod((ContainerSteamTurbineRod)menu);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.steam_turbine.getBlock(this.getTeBlock());
    }

    @Override
    public InvSlot getSlot() {
        return this.slot;
    }

    @Override
    public int getBlockLevel() {
        return -1;
    }

    @Override
    public boolean hasOwnInventory() {
        return this.getMain() != null;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.slot.writeToNbt(new CompoundTag()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            CompoundTag tagCompound = (CompoundTag)DecoderHandler.decode(customPacketBuffer);
            this.slot.readFromNbt(tagCompound);
            this.slot.update();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.slot.update();
    }

    @Override
    public List<ISteamBlade> getRods() {
        return this.list;
    }

    @Override
    public void updateBlades() {
        this.slot.update();
    }
}

