/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.water;

import com.denfop.Localization;
import com.denfop.api.gui.IType;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.water.upgrade.EnumInfoRotorUpgradeModules;
import com.denfop.api.water.upgrade.IRotorUpgradeItem;
import com.denfop.api.water.upgrade.RotorUpgradeItemInform;
import com.denfop.api.water.upgrade.RotorUpgradeSystem;
import com.denfop.api.water.upgrade.event.EventRotorItemLoad;
import com.denfop.api.windsystem.EnumLevelGenerators;
import com.denfop.api.windsystem.EnumRotorSide;
import com.denfop.api.windsystem.EnumTypeWind;
import com.denfop.api.windsystem.EnumWindSide;
import com.denfop.api.windsystem.IWindMechanism;
import com.denfop.api.windsystem.IWindRotor;
import com.denfop.api.windsystem.WindSystem;
import com.denfop.api.windsystem.event.WindGeneratorEvent;
import com.denfop.blocks.ISubEnum;
import com.denfop.componets.Energy;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.componets.client.ComponentClientEffectRender;
import com.denfop.componets.client.EffectType;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerBaseWaterGenerator;
import com.denfop.gui.GuiBaseWaterGenerator;
import com.denfop.gui.GuiCore;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotWaterRotor;
import com.denfop.invslot.InvSlotWaterRotorBlades;
import com.denfop.items.ItemWindRod;
import com.denfop.items.reactors.ItemDamage;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.DamageHandler;
import com.mojang.math.Vector3f;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TileBaseWaterGenerator
extends TileEntityInventory
implements IWindMechanism,
IType,
IUpdatableTileEvent {
    public final Energy energy;
    public final InvSlotWaterRotorBlades slot_blades;
    private final EnumLevelGenerators levelGenerators;
    public InvSlotWaterRotor slot;
    public double generation = 0.0;
    public boolean need_repair;
    public int mind_wind;
    public boolean can_repair;
    public int mind_speed;
    public int timers;
    public double wind_speed;
    public EnumWindSide wind_side;
    public EnumTypeWind enumTypeWind;
    public int coefficient_power = 100;
    boolean space = false;
    private int tick;
    private boolean change_facing;
    private boolean min_level;
    private double addition_power;
    private double addition_efficient;
    private double addition_strength;
    private double coefficient;
    private EnumRotorSide rotorSide;
    private float speed;
    private float angle;
    private long lastcheck;
    private boolean work = true;
    private int time;
    private boolean can_work;
    private double biome;

    public TileBaseWaterGenerator(EnumLevelGenerators levelGenerators, IMultiTileBlock block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.levelGenerators = levelGenerators;
        this.slot = new InvSlotWaterRotor(this);
        this.slot_blades = new InvSlotWaterRotorBlades(this);
        this.energy = this.addComponent(Energy.asBasicSource(this, 500000 * (levelGenerators.ordinal() + 1), 1));
        this.change_facing = false;
        this.min_level = false;
        this.addition_power = 0.0;
        this.addition_efficient = 0.0;
        this.addition_strength = 0.0;
        this.tick = 0;
        this.biome = 1.0;
        this.componentClientEffectRender = new ComponentClientEffectRender(this, EffectType.WATER_GENERATOR);
    }

    private int getDamageTimeFromWind() {
        switch (this.enumTypeWind) {
            case ONE: {
                return 60;
            }
            case TWO: {
                return 55;
            }
            case THREE: {
                return 50;
            }
            case FOUR: {
                return 45;
            }
            case FIVE: {
                return 40;
            }
            case SIX: {
                return 35;
            }
            case SEVEN: {
                return 30;
            }
            case EIGHT: {
                return 25;
            }
            case NINE: {
                return 20;
            }
            case TEN: {
                return 10;
            }
        }
        return 20;
    }

    private int getDamageRotor() {
        if (this.coefficient_power == 100) {
            return 1;
        }
        return (int)((double)((int)((double)(this.getRotor().getLevel() * this.coefficient_power) / 100.0)) * Math.pow((double)this.coefficient_power / 100.0, this.getRotor().getLevel() - 1));
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer packet = super.writeUpdatePacket();
        try {
            EncoderHandler.encode(packet, this.slot);
            EncoderHandler.encode(packet, this.facing);
            EncoderHandler.encode(packet, this.generation);
            EncoderHandler.encode(packet, this.mind_speed);
            EncoderHandler.encode(packet, this.coefficient);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer customPacketBuffer) {
        super.readUpdatePacket(customPacketBuffer);
        try {
            this.slot.readFromNbt(this.getNBTFromSlot(customPacketBuffer));
            this.facing = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.generation = (Double)DecoderHandler.decode(customPacketBuffer);
            this.mind_speed = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.coefficient = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("wind.need_level") + this.levelGenerators.getMin() + " " + Localization.translate("wind.need_level1") + this.levelGenerators.getMax() + " " + Localization.translate("wind.need_level2"));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.coefficient = (Double)DecoderHandler.decode(customPacketBuffer);
            this.speed = ((Float)DecoderHandler.decode(customPacketBuffer)).floatValue();
            this.slot.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new CompoundTag()));
            this.rotorSide = EnumRotorSide.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.generation = (Double)DecoderHandler.decode(customPacketBuffer);
            this.timers = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.wind_speed = (Double)DecoderHandler.decode(customPacketBuffer);
            this.wind_side = EnumWindSide.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.mind_wind = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.mind_speed = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.enumTypeWind = EnumTypeWind.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.coefficient_power = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.coefficient);
            EncoderHandler.encode(packet, Float.valueOf(this.speed));
            EncoderHandler.encode(packet, this.slot);
            EncoderHandler.encode(packet, (Object)this.rotorSide);
            EncoderHandler.encode(packet, this.generation);
            EncoderHandler.encode(packet, this.timers);
            EncoderHandler.encode(packet, this.wind_speed);
            EncoderHandler.encode(packet, (Object)this.wind_side);
            EncoderHandler.encode(packet, this.mind_wind);
            EncoderHandler.encode(packet, this.mind_speed);
            EncoderHandler.encode(packet, (Object)this.enumTypeWind);
            EncoderHandler.encode(packet, this.coefficient_power);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        ItemStack stack = player.m_21120_(hand);
        if (this.getRotor() != null && stack.m_41720_() instanceof ItemWindRod) {
            ItemStack rotor = this.slot.get(0);
            if (((ItemWindRod)stack.m_41720_()).getLevel(this.getRotor().getLevel(), ((ISubEnum)((ItemWindRod)stack.m_41720_()).getElement()).getId()) && (double)rotor.m_41773_() >= (double)rotor.m_41776_() * 0.25) {
                this.slot.damage((int)(-((double)rotor.m_41776_() * 0.25)), 0.0);
                stack.m_41774_(1);
                return true;
            }
        }
        return super.onActivated(player, hand, side, vec3);
    }

    public boolean checkSpace() {
        int box = this.getRotorDiameter() / 2;
        if (box == 0) {
            return false;
        }
        Vector3f vec = this.getFacing().m_122432_();
        BlockPos pos1 = this.pos.m_121955_((Vec3i)new BlockPos((double)vec.m_122239_(), (double)vec.m_122260_(), (double)vec.m_122269_()));
        switch (this.getFacing().m_122434_()) {
            case Y: {
                return false;
            }
            case X: {
                for (int z = pos1.m_123343_() - box; z <= pos1.m_123343_() + box; ++z) {
                    for (int y = pos1.m_123342_() - box; y <= pos1.m_123342_() + box; ++y) {
                        BlockState state = this.f_58857_.m_8055_(new BlockPos(pos1.m_123341_(), y, z));
                        if (state.m_60767_() == Material.f_76305_) continue;
                        return false;
                    }
                }
                return true;
            }
            case Z: {
                for (int x = pos1.m_123341_() - box; x <= pos1.m_123341_() + box; ++x) {
                    for (int y = pos1.m_123342_() - box; y <= pos1.m_123342_() + box; ++y) {
                        BlockState state = this.f_58857_.m_8055_(new BlockPos(x, y, pos1.m_123343_()));
                        if (state.m_60767_() == Material.f_76305_) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setFacingWrench(Direction facing, Player player) {
        boolean fac = super.setFacingWrench(facing, player);
        new PacketUpdateFieldTile(this, "facing", this.facing);
        return fac;
    }

    @Override
    public void setWork(boolean work) {
        this.work = work;
    }

    @Override
    public EnumRotorSide getRotorSide() {
        return this.rotorSide;
    }

    @Override
    public void setRotorSide(EnumRotorSide rotorSide) {
        this.rotorSide = rotorSide;
        new PacketUpdateFieldTile(this, "rotorSide", (Object)this.rotorSide);
    }

    @Override
    public double getCoefficient() {
        return this.coefficient;
    }

    @Override
    public void setCoefficient(double coefficient) {
        this.coefficient = coefficient;
        new PacketUpdateFieldTile(this, "coefficient", this.coefficient);
    }

    @Override
    public IWindRotor getRotor() {
        return this.slot.isEmpty() ? null : (IWindRotor)this.slot.get(0).m_41720_();
    }

    @Override
    public ItemStack getItemStack() {
        return this.slot.get(0);
    }

    @Override
    public EnumLevelGenerators getLevelGenerator() {
        return this.levelGenerators;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.need_repair && this.getRotor() != null) {
            this.slot_blades.work();
        }
        this.timers = WindSystem.windSystem.getTime();
        this.wind_side = WindSystem.windSystem.getWindSide();
        this.enumTypeWind = WindSystem.windSystem.getEnumTypeWind();
        if (!this.work || !this.can_work) {
            if (this.generation != 0.0) {
                this.generation = 0.0;
            }
            return;
        }
        if (this.can_repair && this.time != 0 && this.f_58857_.m_46467_() % ((long)this.time * 20L) == 0L) {
            this.slot.damage(-1, 0.0);
        }
        if (this.f_58857_.m_46467_() % 30L == 0L) {
            if (this.getRotor() != null) {
                this.space = this.checkSpace();
                new PacketUpdateFieldTile(this, "space", this.space);
            } else if (this.space) {
                this.space = false;
                new PacketUpdateFieldTile(this, "space", this.space);
            } else {
                this.generation = 0.0;
            }
        }
        ++this.tick;
        if (this.tick >= 40) {
            this.tick = 40;
        }
        if (this.space && this.getRotor() != null && ((ItemDamage)this.slot.get(0).m_41720_()).getCustomDamage(this.slot.get(0)) < this.slot.get(0).m_41776_()) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.getRotor() == null) {
                if (this.getActive()) {
                    this.setActive(false);
                }
                if (this.space) {
                    this.space = false;
                    new PacketUpdateFieldTile(this, "space", this.space);
                }
                return;
            }
            this.wind_speed = WindSystem.windSystem.getWind_Strength();
            this.generation = WindSystem.windSystem.getPowerFromWaterRotor(this.f_58857_, this, this.getItemStack()) * this.biome * (double)this.coefficient_power / 100.0;
            this.energy.addEnergy(this.generation);
            if (this.f_58857_.m_46467_() % (long)this.getDamageTimeFromWind() == 0L) {
                this.slot.damage(this.getDamageRotor(), this.addition_strength);
            }
        } else {
            this.generation = 0.0;
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("speed")) {
            try {
                this.speed = ((Float)DecoderHandler.decode(is)).floatValue();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot")) {
            this.slot.readFromNbt(this.getNBTFromSlot(is));
        }
        if (name.equals("space")) {
            try {
                this.space = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("coefficient")) {
            try {
                this.coefficient = (Double)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("work")) {
            try {
                this.work = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("rotorSide")) {
            try {
                this.rotorSide = EnumRotorSide.values()[(Integer)DecoderHandler.decode(is)];
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("change_facing")) {
            try {
                this.change_facing = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("min_level")) {
            try {
                this.min_level = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("mind_wind")) {
            try {
                this.mind_wind = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("wind_side")) {
            try {
                this.wind_side = EnumWindSide.values()[(Integer)DecoderHandler.decode(is)];
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("angle")) {
            try {
                this.angle = ((Float)DecoderHandler.decode(is)).floatValue();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("generation")) {
            try {
                this.generation = (Double)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("mind_speed")) {
            try {
                this.mind_speed = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.timers = WindSystem.windSystem.getTime();
        this.wind_side = WindSystem.windSystem.getWindSide();
        this.enumTypeWind = WindSystem.windSystem.getEnumTypeWind();
        if (!this.slot.isEmpty()) {
            MinecraftForge.EVENT_BUS.post((Event)new EventRotorItemLoad(this.getWorld(), (IRotorUpgradeItem)this.slot.get(0).m_41720_(), this.slot.get(0)));
        }
        this.biome = this.getWorld().m_204166_(this.pos).m_203656_(BiomeTags.f_207603_) || this.getWorld().m_204166_(this.pos).m_203656_(BiomeTags.f_207605_) ? 1.0 : 0.5;
        this.change();
        this.setRotorSide(WindSystem.windSystem.getRotorSide(this.getFacing()));
        MinecraftForge.EVENT_BUS.post((Event)new WindGeneratorEvent(this, this.getWorld(), true));
        new PacketUpdateFieldTile(this, "speed", Float.valueOf(this.speed));
        new PacketUpdateFieldTile(this, "slot", this.slot);
        new PacketUpdateFieldTile(this, "space", this.space);
        new PacketUpdateFieldTile(this, "coefficient", this.coefficient);
        new PacketUpdateFieldTile(this, "wind_side", (Object)this.wind_side);
        new PacketUpdateFieldTile(this, "angle", Float.valueOf(this.angle));
        new PacketUpdateFieldTile(this, "mind_speed", this.mind_speed);
        new PacketUpdateFieldTile(this, "generation", this.generation);
        if (this.getRotor() != null) {
            this.energy.setSourceTier(this.getRotor().getSourceTier());
        }
        this.can_work = this.getWorld().m_6042_().f_223549_() && this.getWorld().m_46472_() != Level.f_46429_;
        this.work = true;
        this.timers = WindSystem.windSystem.getTime();
        this.wind_side = WindSystem.windSystem.getWindSide();
        this.enumTypeWind = WindSystem.windSystem.getEnumTypeWind();
        if (!this.slot.get(0).m_41619_() && (double)DamageHandler.getDamage(this.slot.get(0)) >= (double)DamageHandler.getMaxDamage(this.slot.get(0)) * 0.25) {
            this.need_repair = true;
        }
    }

    @Override
    public void onUnloaded() {
        MinecraftForge.EVENT_BUS.post((Event)new WindGeneratorEvent(this, this.getWorld(), false));
        super.onUnloaded();
    }

    @Override
    public boolean canPlace(TileEntityBlock te, BlockPos pos, Level world) {
        for (int i = pos.m_123341_() - 4; i <= pos.m_123341_() + 4; ++i) {
            for (int j = pos.m_123342_() - 4; j <= pos.m_123342_() + 4; ++j) {
                for (int k = pos.m_123343_() - 4; k <= pos.m_123343_() + 4; ++k) {
                    BlockEntity tile = world.m_7702_(new BlockPos(i, j, k));
                    if (!(tile instanceof IWindMechanism)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void onBlockBreak(boolean w) {
        super.onBlockBreak(w);
    }

    @Override
    public void setActive(boolean active) {
        if (active != this.getActive()) {
            new PacketUpdateFieldTile(this, "slot", this.slot);
        }
        super.setActive(active);
    }

    public double getGeneration() {
        return this.generation;
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.m_128405_("coef", this.coefficient_power);
        return nbtTagCompound;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.coefficient_power = nbtTagCompound.m_128451_("coef");
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, Float.valueOf(this.speed));
            EncoderHandler.encode(packet, this.slot);
            EncoderHandler.encode(packet, this.space);
            EncoderHandler.encode(packet, this.coefficient);
            EncoderHandler.encode(packet, (Object)this.wind_side);
            EncoderHandler.encode(packet, Float.valueOf(this.angle));
            EncoderHandler.encode(packet, this.mind_speed);
            EncoderHandler.encode(packet, this.generation);
            EncoderHandler.encode(packet, this.coefficient_power);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.speed = ((Float)DecoderHandler.decode(customPacketBuffer)).floatValue();
            this.slot.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new CompoundTag()));
            this.space = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.coefficient = (Double)DecoderHandler.decode(customPacketBuffer);
            this.wind_side = EnumWindSide.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.angle = ((Float)DecoderHandler.decode(customPacketBuffer)).floatValue();
            this.mind_speed = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.generation = (Double)DecoderHandler.decode(customPacketBuffer);
            this.coefficient_power = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public float getAngle() {
        if (this.getWorld().m_46472_() != Level.f_46428_) {
            return 0.0f;
        }
        if (this.speed != 0.0f && this.work && this.getRotor() != null && ((ItemDamage)this.slot.get(0).m_41720_()).getCustomDamage(this.slot.get(0)) > 0) {
            long k = System.currentTimeMillis() - this.lastcheck;
            this.angle = this.mind_wind != 0 ? (this.angle += (float)((double)k * WindSystem.windSystem.getSpeed(Math.min(24.7 + (double)this.mind_speed, WindSystem.windSystem.getSpeedFromPower(this.m_58899_(), this, this.generation)) * this.getCoefficient()))) : (this.angle += (float)((double)((float)k * this.speed) * this.getCoefficient()));
            this.angle %= 360.0f;
        }
        this.lastcheck = System.currentTimeMillis();
        return this.angle;
    }

    @Override
    public void setRotationSpeed(float speed) {
        if (this.speed != speed) {
            this.speed = speed;
            new PacketUpdateFieldTile(this, "speed", Float.valueOf(speed));
        }
    }

    @Override
    public int getRotorDiameter() {
        return this.getRotor() != null ? this.getRotor().getDiameter(this.slot.get(0)) : 0;
    }

    @Override
    public ResourceLocation getRotorRenderTexture() {
        return this.getRotor() != null ? this.getRotor().getRotorRenderTexture(this.slot.get(0)) : null;
    }

    @Override
    public void change() {
        this.change_facing = false;
        this.min_level = false;
        this.addition_power = 0.0;
        this.addition_efficient = 0.0;
        this.addition_strength = 0.0;
        this.time = 0;
        this.mind_speed = 0;
        this.mind_wind = 0;
        if (this.getRotor() != null) {
            RotorUpgradeItemInform modules;
            int i;
            List<RotorUpgradeItemInform> list = RotorUpgradeSystem.instance.getInformation(this.getItemStack());
            this.change_facing = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.AUTO, list) != null;
            for (i = 0; i < 3; ++i) {
                modules = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.getFromID(i), list);
                this.addition_strength += modules == null ? 0.0 : (double)modules.number * modules.upgrade.getCoef();
            }
            for (i = 3; i < 6; ++i) {
                modules = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.getFromID(i), list);
                this.addition_efficient += modules == null ? 0.0 : (double)modules.number * modules.upgrade.getCoef();
            }
            for (i = 6; i < 9; ++i) {
                modules = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.getFromID(i), list);
                this.addition_power += modules == null ? 0.0 : (double)modules.number * modules.upgrade.getCoef();
            }
            for (i = 13; i < 16; ++i) {
                modules = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.getFromID(i), list);
                this.time = modules == null ? 0 : (int)modules.upgrade.getCoef();
            }
            for (i = 10; i < 13; ++i) {
                modules = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.getFromID(i), list);
                this.mind_wind = modules == null ? 0 : (int)modules.upgrade.getCoef();
            }
            RotorUpgradeItemInform modules2 = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.getFromID(16), list);
            double d = this.biome = this.getWorld().m_204166_(this.pos).m_203656_(BiomeTags.f_207603_) || this.getWorld().m_204166_(this.pos).m_203656_(BiomeTags.f_207605_) ? 1.0 : 0.5;
            if (modules2 != null) {
                this.biome = 1.0;
            }
        }
        new PacketUpdateFieldTile(this, "change_facing", this.change_facing);
        new PacketUpdateFieldTile(this, "min_level", this.min_level);
        new PacketUpdateFieldTile(this, "mind_wind", this.mind_wind);
        if (this.change_facing) {
            WindSystem.windSystem.getNewPositionOfMechanism(this);
        }
    }

    @Override
    public double getAdditionalCoefficient() {
        return this.addition_efficient;
    }

    @Override
    public double getAdditionalPower() {
        return this.addition_power;
    }

    @Override
    public boolean getAuto() {
        return this.change_facing;
    }

    @Override
    public boolean getMin() {
        return this.min_level;
    }

    @Override
    public boolean getSpace() {
        return this.space;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public boolean need_repair() {
        return this.need_repair;
    }

    @Override
    public boolean can_repair() {
        return this.can_repair;
    }

    @Override
    public int getMinWind() {
        return this.mind_wind;
    }

    @Override
    public int getMinWindSpeed() {
        return this.mind_speed;
    }

    public ContainerBaseWaterGenerator getGuiContainer(Player entityPlayer) {
        return new ContainerBaseWaterGenerator(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiBaseWaterGenerator((ContainerBaseWaterGenerator)menu);
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        if (i == 0.0) {
            if (this.tick >= 20) {
                WindSystem.windSystem.getNewFacing(this.getFacing(), this);
                this.tick = 0;
                if (this.getAuto()) {
                    WindSystem.windSystem.getNewPositionOfMechanism(this);
                }
            }
        } else {
            this.coefficient_power = (int)i;
            if (this.coefficient_power < 100) {
                this.coefficient_power = 100;
            }
            if (this.coefficient_power > 150) {
                this.coefficient_power = 150;
            }
        }
    }

    @Override
    public EnumTypeStyle getStyle() {
        return EnumTypeStyle.DEFAULT;
    }
}

