/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.quarry_earth;

import com.denfop.IUItem;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockEarthQuarry;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerEarthAnalyzer;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiEarthAnalyzer;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.quarry_earth.DataPos;
import com.denfop.tiles.quarry_earth.IAnalyzer;
import com.denfop.tiles.quarry_earth.TileEntityEarthQuarryController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityEarthQuarryAnalyzer
extends TileEntityMultiBlockElement
implements IAnalyzer,
IUpdatableTileEvent {
    public int blockCol;
    public int blockOres;
    Map<ChunkPos, List<DataPos>> chunkPosListHashMap = new HashMap<ChunkPos, List<DataPos>>();
    int x = -1;
    int z = -1;
    private boolean analyzer;
    private boolean fullAnalyzer;
    private ChunkPos chunkPos;

    public TileEntityEarthQuarryAnalyzer(BlockPos pos, BlockState state) {
        super(BlockEarthQuarry.earth_analyzer, pos, state);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.earthQuarry.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockEarthQuarry.earth_analyzer;
    }

    public ContainerEarthAnalyzer getGuiContainer(Player var1) {
        return new ContainerEarthAnalyzer(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiEarthAnalyzer((ContainerEarthAnalyzer)menu);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.analyzer);
        customPacketBuffer.writeBoolean(this.fullAnalyzer);
        customPacketBuffer.writeInt(this.blockCol);
        customPacketBuffer.writeInt(this.blockOres);
        return customPacketBuffer;
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.analyzer = customPacketBuffer.readBoolean();
        this.fullAnalyzer = customPacketBuffer.readBoolean();
        this.blockCol = customPacketBuffer.readInt();
        this.blockOres = customPacketBuffer.readInt();
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128379_("analyzer", this.analyzer);
        nbt.m_128379_("fullAnalyzer", this.fullAnalyzer);
        nbt.m_128405_("blockCol", this.blockCol);
        nbt.m_128405_("blockOres", this.blockOres);
        return super.writeToNBT(nbt);
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.analyzer = nbtTagCompound.m_128471_("analyzer");
        this.fullAnalyzer = nbtTagCompound.m_128471_("fullAnalyzer");
        this.blockCol = nbtTagCompound.m_128451_("blockCol");
        this.blockOres = nbtTagCompound.m_128451_("blockOres");
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.chunkPos = this.f_58857_.m_46745_(this.pos).m_7697_();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().m_46467_() % 10L == 0L) {
            if (this.analyzer && !this.fullAnalyzer && this.getMain() != null) {
                TileEntityEarthQuarryController controller;
                if (this.z == 2) {
                    if (!this.chunkPosListHashMap.isEmpty()) {
                        this.fullAnalyzer = true;
                        controller = (TileEntityEarthQuarryController)this.getMain();
                        controller.map = this.chunkPosListHashMap;
                        controller.chunkPosList = new ArrayList<ChunkPos>(this.chunkPosListHashMap.keySet());
                    }
                    this.analyzer = false;
                }
                controller = (TileEntityEarthQuarryController)this.getMain();
                LevelChunk chunk1 = this.f_58857_.m_6325_(this.chunkPos.f_45578_ + this.x, this.chunkPos.f_45579_ + this.z);
                if (!TileEntityEarthQuarryController.chunkPos.contains(chunk1.m_7697_())) {
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            int height = chunk1.m_5885_(Heightmap.Types.WORLD_SURFACE, chunk1.m_7697_().f_45578_ * 16 + x & 0xF, chunk1.m_7697_().f_45579_ * 16 + z & 0xF);
                            for (int y = 0; y < 10; ++y) {
                                if (!(controller.getEnergy().getEnergy() > 20.0)) continue;
                                controller.getEnergy().useEnergy(20.0);
                                BlockPos pos = new BlockPos(chunk1.m_7697_().f_45578_ * 16 + x, height - y, chunk1.m_7697_().f_45579_ * 16 + z);
                                ++this.blockCol;
                                BlockState state = this.f_58857_.m_8055_(pos);
                                if (state.m_60734_() != Blocks.f_50493_ && state.m_60734_() != Blocks.f_49994_ && state.m_60734_() != Blocks.f_49992_) continue;
                                List dataPos = this.chunkPosListHashMap.getOrDefault(chunk1.m_7697_(), new ArrayList());
                                if (dataPos.isEmpty()) {
                                    dataPos.add(new DataPos(pos, state));
                                    this.chunkPosListHashMap.put(chunk1.m_7697_(), dataPos);
                                } else {
                                    dataPos.add(new DataPos(pos, state));
                                }
                                this.blockOres = 0;
                                for (List<DataPos> dataPos1 : this.chunkPosListHashMap.values()) {
                                    this.blockOres += dataPos1.size();
                                }
                            }
                        }
                    }
                    if (this.x < 1) {
                        ++this.x;
                    } else {
                        ++this.z;
                        this.x = -1;
                    }
                } else if (this.x < 1) {
                    ++this.x;
                } else {
                    ++this.z;
                    this.x = -1;
                }
            } else {
                this.analyzer = false;
            }
        }
    }

    @Override
    public boolean isAnalyzed() {
        return this.analyzer;
    }

    @Override
    public boolean fullAnalyzed() {
        return this.fullAnalyzer;
    }

    @Override
    public Map<ChunkPos, List<DataPos>> getChunkPoses() {
        return this.chunkPosListHashMap;
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (var2 == 0.0 && this.getMain() != null && !this.analyzer) {
            this.analyzer = true;
            this.x = -1;
            this.z = -1;
            this.chunkPosListHashMap.clear();
            this.blockCol = 0;
            this.blockOres = 0;
        }
    }
}

