/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.quarry_earth;

import com.denfop.IUItem;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockEarthQuarry;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerEarthController;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiEarthController;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.tiles.quarry_earth.DataPos;
import com.denfop.tiles.quarry_earth.IAnalyzer;
import com.denfop.tiles.quarry_earth.IEarthChest;
import com.denfop.tiles.quarry_earth.IEarthQuarry;
import com.denfop.tiles.quarry_earth.IRigDrill;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityEarthQuarryController
extends TileMultiBlockBase
implements IEarthQuarry,
IUpdatableTileEvent {
    public static List<ChunkPos> chunkPos = new LinkedList<ChunkPos>();
    public static Random random = new Random();
    public final Energy energy;
    public List<IEarthChest> earthChestList = new ArrayList<IEarthChest>();
    public IAnalyzer analyzer;
    public boolean work;
    public int indexChunk = 0;
    public Map<ChunkPos, List<DataPos>> map;
    public List<ChunkPos> chunkPosList;
    public int max = 0;
    public int block_Col;
    private List<DataPos> dataPos = new LinkedList<DataPos>();
    private IRigDrill quarry;

    public TileEntityEarthQuarryController(BlockPos pos, BlockState state) {
        super(InitMultiBlockSystem.EarthQuarryMultiBlock, BlockEarthQuarry.earth_controller, pos, state);
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 100000.0, 14));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.work = nbttagcompound.m_128471_("work");
        this.indexChunk = nbttagcompound.m_128451_("indexChunk");
        this.max = nbttagcompound.m_128451_("max");
        this.block_Col = nbttagcompound.m_128451_("block_Col");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        nbttagcompound.m_128379_("work", this.work);
        nbttagcompound.m_128405_("indexChunk", this.indexChunk);
        nbttagcompound.m_128405_("max", this.max);
        nbttagcompound.m_128405_("block_Col", this.block_Col);
        return super.writeToNBT(nbttagcompound);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.earthQuarry.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockEarthQuarry.earth_controller;
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeInt(this.max);
        customPacketBuffer.writeInt(this.indexChunk);
        customPacketBuffer.writeInt(this.block_Col);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
        this.max = customPacketBuffer.readInt();
        this.indexChunk = customPacketBuffer.readInt();
        this.block_Col = customPacketBuffer.readInt();
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (var2 == 0.0 && !this.analyzer.getChunkPoses().isEmpty()) {
            this.work = !this.work;
            this.indexChunk = 0;
            this.dataPos.clear();
            this.block_Col = 0;
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work && this.full && this.getWorld().m_46467_() % 10L == 0L) {
            if (this.analyzer.fullAnalyzed() && !this.chunkPosList.isEmpty()) {
                List dataPos = this.map.getOrDefault(this.chunkPosList.get(this.indexChunk), Collections.emptyList());
                this.max = this.chunkPosList.size();
                for (DataPos dataPos1 : dataPos) {
                    if (this.energy.getEnergy() < 50.0) continue;
                    this.energy.useEnergy(50.0);
                    if (dataPos1.state.m_60734_() == Blocks.f_50493_) {
                        if (random.nextInt(100) < 90) continue;
                        this.f_58857_.m_7731_(dataPos1.getPos(), IUItem.ore2.getStateFromMeta(1), 3);
                        this.dataPos.add(dataPos1);
                        continue;
                    }
                    if (dataPos1.state.m_60734_() == Blocks.f_49994_) {
                        if (random.nextInt(100) < 94) continue;
                        this.f_58857_.m_7731_(dataPos1.getPos(), IUItem.ore2.getStateFromMeta(2), 3);
                        this.dataPos.add(dataPos1);
                        continue;
                    }
                    if (dataPos1.state.m_60734_() != Blocks.f_49992_ || random.nextInt(100) < 80) continue;
                    this.f_58857_.m_7731_(dataPos1.getPos(), IUItem.ore2.getStateFromMeta(0), 3);
                    this.dataPos.add(dataPos1);
                }
                this.block_Col = this.dataPos.size();
                chunkPos.add(this.chunkPosList.get(this.indexChunk));
                ++this.indexChunk;
                if (this.indexChunk == this.chunkPosList.size()) {
                    this.quarry.startOperation(this.dataPos);
                    this.chunkPosList.clear();
                    this.work = false;
                }
            } else {
                this.work = false;
                this.indexChunk = this.max;
            }
        }
    }

    public ContainerEarthController getGuiContainer(Player entityPlayer) {
        return new ContainerEarthController(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiEarthController((ContainerEarthController)menu);
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.earthChestList.clear();
        }
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), IAnalyzer.class);
        this.analyzer = (IAnalyzer)this.getWorld().m_7702_(pos1.get(0));
        List<BlockPos> pos2 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), IEarthChest.class);
        for (BlockPos pos3 : pos2) {
            this.earthChestList.add((IEarthChest)this.getWorld().m_7702_(pos3));
        }
        this.map = this.analyzer.getChunkPoses();
        this.chunkPosList = new ArrayList<ChunkPos>(this.map.keySet());
        List<BlockPos> pos3 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), IRigDrill.class);
        this.quarry = (IRigDrill)this.getWorld().m_7702_(pos3.get(0));
    }

    @Override
    public void usingBeforeGUI() {
    }

    public Energy getEnergy() {
        return this.energy;
    }
}

