/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.transport.tiles;

import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.IEnergyAcceptor;
import com.denfop.api.energy.IEnergyConductor;
import com.denfop.api.energy.IEnergyEmitter;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.energy.InfoCable;
import com.denfop.api.energy.NodeStats;
import com.denfop.api.energy.event.EnergyTileLoadEvent;
import com.denfop.api.energy.event.EnergyTileUnLoadEvent;
import com.denfop.api.item.IHazmatLike;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.damagesource.IUDamageSource;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.transport.tiles.TileEntityMultiCable;
import com.denfop.tiles.transport.types.CableType;
import com.denfop.tiles.transport.types.ICableItem;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TileEntityCable
extends TileEntityMultiCable
implements IEnergyConductor {
    public boolean addedToEnergyNet = false;
    public int f_58855_;
    protected CableType cableType;
    boolean updateConnect = false;
    Map<Direction, IEnergyTile> energyConductorMap = new HashMap<Direction, IEnergyTile>();
    List<InfoTile<IEnergyTile>> validReceivers = new LinkedList<InfoTile<IEnergyTile>>();
    int hashCodeSource;
    private boolean needUpdate;
    private ChunkPos chunkPos;
    private InfoCable cable;
    private long id;

    public TileEntityCable(CableType cableType, IMultiTileBlock block, BlockPos pos, BlockState state) {
        super(cableType, block, pos, state);
        this.cableType = cableType;
        this.f_58855_ = cableType.ordinal();
    }

    @Override
    public void addInformation(ItemStack stack, List<String> info) {
        CableType type = this.cableType;
        double capacity = type.capacity;
        double loss = type.loss;
        info.add(ModUtils.getString(capacity) + " " + Localization.translate("iu.generic.text.EUt"));
        info.add(Localization.translate("cable.tooltip.loss", lossFormat.format(loss)));
    }

    @Override
    public void onEntityCollision(Entity entity) {
        super.onEntityCollision(entity);
        if (!this.getWorld().f_46443_ && entity instanceof LivingEntity && (this.cableType == CableType.tin || this.cableType == CableType.copper || this.cableType == CableType.gold || this.cableType == CableType.iron)) {
            NodeStats stats = EnergyNetGlobal.instance.getNodeStats(this);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!IHazmatLike.hasCompleteHazmat((LivingEntity)player) && stats.getEnergyIn() > 0.0) {
                    entity.m_6469_(IUDamageSource.current, 0.25f);
                }
            } else if (stats.getEnergyIn() > 0.0) {
                entity.m_6469_(IUDamageSource.current, 0.25f);
            }
        }
    }

    @Override
    public ICableItem getCableItem() {
        return this.cableType;
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.cableType = CableType.values[nbt.m_128445_("cableType") & 0xFF];
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.m_128344_("cableType", (byte)this.cableType.ordinal());
        return nbt;
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        super.updateTileServer(var1, var2);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.getWorld(), this));
        this.needUpdate = true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.needUpdate) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.getWorld(), this, this));
            this.needUpdate = false;
            this.updateConnectivity();
        }
        if (this.updateConnect) {
            this.updateConnect = false;
            this.updateConnectivity();
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_ && !this.addedToEnergyNet) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.getWorld(), this, this));
            this.addedToEnergyNet = true;
            this.updateConnectivity();
        }
    }

    @Override
    public void onUnloaded() {
        if (!this.getWorld().f_46443_ && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.getWorld(), this));
            this.addedToEnergyNet = false;
            this.updateConnectivity();
        }
        super.onUnloaded();
    }

    @Override
    public SoundType getBlockSound(Entity entity) {
        return SoundType.f_56745_;
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
    }

    @Override
    public InfoCable getCable() {
        return this.cable;
    }

    @Override
    public void setCable(InfoCable cable) {
        this.cable = cable;
    }

    @Override
    public void updateConnectivity() {
        Direction[] var4;
        byte newConnectivity = 0;
        for (Direction dir : var4 = Direction.values()) {
            newConnectivity = (byte)(newConnectivity << 1);
            IEnergyTile tile = this.energyConductorMap.get(dir);
            if (this.getBlackList().contains(dir) || (!(tile instanceof IEnergyAcceptor) || !((IEnergyAcceptor)tile).acceptsEnergyFrom(this, dir.m_122424_())) && (!(tile instanceof IEnergyEmitter) || !((IEnergyEmitter)tile).emitsEnergyTo(this, dir.m_122424_()))) continue;
            newConnectivity = (byte)(newConnectivity + 1);
        }
        this.setConnectivity(newConnectivity);
        this.cableItem = this.cableType;
    }

    @Override
    public boolean wrenchCanRemove(Player player) {
        return false;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, Direction direction) {
        return !this.getBlackList().contains(direction);
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, Direction direction) {
        return !this.getBlackList().contains(direction);
    }

    @Override
    public double getConductionLoss() {
        return this.cableType.loss;
    }

    @Override
    public double getConductorBreakdownEnergy() {
        return this.cableType.capacity + 1.0;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cableType);
            EncoderHandler.encode(packet, this.connectivity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cableType = CableType.values[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.connectivity = (Byte)DecoderHandler.decode(customPacketBuffer);
            Direction[] var5 = Direction.values();
            HashMap<Direction, Boolean> booleanMap = new HashMap<Direction, Boolean>();
            for (Direction facing : var5) {
                boolean hasConnection = (this.connectivity & 1 << facing.ordinal()) != 0;
                booleanMap.put(facing, hasConnection);
            }
            this.f_58856_ = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.block.m_49966_().m_61124_((Property)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, this.active))).m_61124_(this.block.facingProperty, (Comparable)this.getFacing())).m_61124_((Property)BlockTileEntity.NORTH, (Comparable)((Boolean)booleanMap.get(Direction.SOUTH)))).m_61124_((Property)BlockTileEntity.SOUTH, (Comparable)((Boolean)booleanMap.get(Direction.NORTH)))).m_61124_((Property)BlockTileEntity.WEST, (Comparable)((Boolean)booleanMap.get(Direction.UP)))).m_61124_((Property)BlockTileEntity.EAST, (Comparable)((Boolean)booleanMap.get(Direction.DOWN)))).m_61124_((Property)BlockTileEntity.UP, (Comparable)((Boolean)booleanMap.get(Direction.WEST)))).m_61124_((Property)BlockTileEntity.DOWN, (Comparable)((Boolean)booleanMap.get(Direction.EAST)));
            this.getWorld().m_7731_(this.f_58858_, this.f_58856_, 3);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<Direction, IEnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public List<InfoTile<IEnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void RemoveTile(IEnergyTile tile, Direction facing1) {
        if (!this.getWorld().m_5776_()) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<IEnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IEnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
            this.updateConnect = true;
        }
    }

    @Override
    public void AddTile(IEnergyTile tile, Direction facing1) {
        if (!this.getWorld().f_46443_) {
            if (!this.energyConductorMap.containsKey(facing1)) {
                this.energyConductorMap.put(facing1, tile);
                this.validReceivers.add(new InfoTile<IEnergyTile>(tile, facing1.m_122424_()));
            }
            this.updateConnect = true;
        }
    }

    @Override
    public BlockEntity getTileEntity() {
        return this;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }
}

