/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import com.denfop.utils.DataEntities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;

public final class CapturedMobUtils {
    @Nonnull
    private static final ResourceLocation PIG = new ResourceLocation("pig");
    public static DataEntities data = new DataEntities();
    @Nullable
    private final CompoundTag entityNbt;
    @Nonnull
    private final ResourceLocation entityId;
    @Nullable
    private final String customName;
    private final String resource;
    private final double coefficient;
    private int color;

    private CapturedMobUtils(@Nonnull LivingEntity entity) {
        LivingEntity entLiv;
        this.entityId = EntityType.m_20613_((EntityType)entity.m_6095_());
        this.entityNbt = entity.serializeNBT();
        String name = null;
        if (entity instanceof LivingEntity && (entLiv = entity).m_8077_()) {
            name = entLiv.m_6302_();
        }
        this.color = -1;
        StringBuilder builder = new StringBuilder(this.entityId.toString());
        if (entity instanceof Sheep) {
            this.color = ((Sheep)entity).m_29874_().m_41060_();
            builder.append("_").append(((Sheep)entity).m_29874_().m_41065_());
        }
        this.customName = name != null && name.length() > 0 ? name : null;
        this.resource = builder.toString();
        this.coefficient = entity.m_21233_() / 40.0f;
    }

    private CapturedMobUtils(@Nonnull CompoundTag nbt) {
        this.entityNbt = nbt.m_128441_("entity") ? nbt.m_128469_("entity").m_6426_() : (nbt.m_128441_("EntityTag") ? nbt.m_128469_("EntityTag").m_6426_() : null);
        String id = nbt.m_128461_("entityId");
        this.coefficient = nbt.m_128459_("coefficient");
        this.entityId = !id.isEmpty() ? new ResourceLocation(id) : PIG;
        StringBuilder builder = new StringBuilder(this.entityId.toString());
        this.customName = nbt.m_128461_("customName");
        this.color = nbt.m_128451_("color");
        if (this.color >= 0) {
            builder.append("_").append(DyeColor.m_41053_((int)this.color));
        }
        this.resource = builder.toString();
    }

    private CapturedMobUtils(@Nonnull ResourceLocation entityId) {
        this.entityNbt = null;
        this.entityId = entityId;
        this.customName = null;
        this.resource = this.entityId.toString();
        this.coefficient = 1.0;
    }

    @Nullable
    public static CapturedMobUtils create(@Nullable Entity entity) {
        return entity instanceof LivingEntity && entity.m_6084_() && !entity.m_9236_().m_5776_() && !(entity instanceof Player) && !CapturedMobUtils.isBlacklisted(entity) ? new CapturedMobUtils((LivingEntity)entity) : null;
    }

    @Nullable
    public static CapturedMobUtils create(@Nullable ResourceLocation entityId) {
        return entityId != null && data.contains(entityId) && CapturedMobUtils.isRegisteredMob(entityId) ? new CapturedMobUtils(entityId) : null;
    }

    public static boolean isRegisteredMob(ResourceLocation entityName) {
        if (entityName == null) {
            return false;
        }
        Class clazz = data.getTypeFromResourceLocation(entityName).m_142225_();
        return LivingEntity.class.isAssignableFrom(clazz);
    }

    public static boolean containsSoul(@Nullable CompoundTag nbt) {
        return nbt != null && (nbt.m_128441_("entity") || nbt.m_128441_("entityId") || nbt.m_128441_("EntityTag"));
    }

    public static boolean containsSoul(@Nonnull ItemStack stack) {
        return CapturedMobUtils.isValid(stack) && stack.m_41782_() && CapturedMobUtils.containsSoul(stack.m_41783_());
    }

    public static boolean isValid(@Nonnull ItemStack stack) {
        return !stack.m_41619_();
    }

    @Nullable
    public static CapturedMobUtils create(@Nonnull ItemStack stack) {
        if (CapturedMobUtils.containsSoul(stack)) {
            assert (stack.m_41783_() != null);
            return new CapturedMobUtils(stack.m_41783_());
        }
        return null;
    }

    @Nullable
    public static CapturedMobUtils create(@Nullable CompoundTag nbt) {
        return CapturedMobUtils.containsSoul(nbt) ? new CapturedMobUtils(nbt) : null;
    }

    public static boolean isBlacklisted(@Nonnull Entity entity) {
        ResourceLocation entityId = EntityType.m_20613_((EntityType)entity.m_6095_());
        return entityId == null;
    }

    public double getCoefficient() {
        return this.coefficient;
    }

    public String getResource() {
        return this.resource;
    }

    @Nonnull
    public ItemStack toStack(@Nonnull Item item, int amount) {
        ItemStack stack = new ItemStack((ItemLike)item, amount);
        stack.m_41751_(this.toNbt(null));
        return stack;
    }

    @Nonnull
    public CompoundTag toNbt(@Nullable CompoundTag nbt) {
        CompoundTag data = nbt != null ? nbt : new CompoundTag();
        data.m_128359_("entityId", this.entityId.toString());
        if (this.entityNbt != null) {
            data.m_128365_("entity", (Tag)this.entityNbt.m_6426_());
        }
        if (this.customName != null) {
            data.m_128359_("customName", this.customName);
        }
        data.m_128405_("color", this.color);
        data.m_128347_("coefficient", this.coefficient);
        return data;
    }

    @Nullable
    public Entity getEntity(@Nullable Level world, boolean clone) {
        return this.getEntity(world, null, null, clone);
    }

    @Nullable
    public Entity getEntity(@Nullable Level world, @Nullable BlockPos pos, @Nullable DifficultyInstance difficulty, boolean clone) {
        if (world == null) {
            return null;
        }
        CompoundTag entityNbt_nullchecked = this.entityNbt;
        if (entityNbt_nullchecked == null || !clone) {
            Entity entity = data.createEntityByIDFromName(this.entityId, world);
            if (entity == null) {
                return null;
            }
            if (pos != null) {
                entity.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            }
            if (entity instanceof Mob) {
                if (pos != null && difficulty == null) {
                    difficulty = world.m_6436_(pos);
                }
                if (!(difficulty == null || pos != null && ForgeEventFactory.doSpecialSpawn((Mob)((Mob)entity), (LevelAccessor)world, (float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_(), null, (MobSpawnType)MobSpawnType.NATURAL))) {
                    ((Mob)entity).m_6518_((ServerLevelAccessor)world, difficulty, MobSpawnType.NATURAL, null, null);
                }
            }
            if (entity instanceof Sheep) {
                ((Sheep)entity).m_29855_(DyeColor.m_41053_((int)this.color));
            }
            return entity;
        }
        Entity entity = data.createEntityFromNBT(entityNbt_nullchecked, world);
        if (entity instanceof Sheep) {
            ((Sheep)entity).m_29855_(DyeColor.m_41053_((int)this.color));
        }
        return entity;
    }
}

