/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import com.denfop.ElectricItem;
import com.denfop.api.item.IElectricItemManager;
import com.denfop.api.item.IEnergyItem;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ElectricItemManager
implements IElectricItemManager {
    public static ItemStack getCharged(Item item, double charge) {
        if (!(item instanceof IEnergyItem)) {
            throw new IllegalArgumentException("no electric item");
        }
        ItemStack ret = new ItemStack((ItemLike)item);
        ElectricItem.manager.charge(ret, charge, Integer.MAX_VALUE, true, false);
        return ret;
    }

    public static void addChargeVariants(Item item, List<ItemStack> list) {
        list.add(ElectricItemManager.getCharged(item, 0.0));
        list.add(ElectricItemManager.getCharged(item, Double.MAX_VALUE));
    }

    @Override
    public double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        IEnergyItem item = (IEnergyItem)stack.m_41720_();
        assert (item.getMaxEnergy(stack) > 0.0);
        if (this.getCharge(stack) == item.getMaxEnergy(stack)) {
            return 0.0;
        }
        if (!(amount < 0.0) && ModUtils.getSize(stack) <= 1 && item.getTierItem(stack) <= tier) {
            if (!ignoreTransferLimit && amount > item.getTransferEnergy(stack)) {
                amount = item.getTransferEnergy(stack);
            }
            CompoundTag tNBT = ModUtils.nbt(stack);
            double newCharge = tNBT.m_128459_("charge");
            amount = Math.min(amount, item.getMaxEnergy(stack) - newCharge);
            if (!simulate) {
                if ((newCharge += amount) > 0.0) {
                    tNBT.m_128347_("charge", newCharge);
                } else {
                    tNBT.m_128347_("charge", 0.0);
                }
            }
            return amount;
        }
        return 0.0;
    }

    @Override
    public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        IEnergyItem item = (IEnergyItem)stack.m_41720_();
        assert (item.getMaxEnergy(stack) > 0.0);
        if (!(amount < 0.0) && ModUtils.getSize(stack) <= 1 && item.getTierItem(stack) <= tier) {
            if (externally && !item.canProvideEnergy(stack)) {
                return 0.0;
            }
            if (!ignoreTransferLimit && amount > item.getTransferEnergy(stack)) {
                amount = item.getTransferEnergy(stack);
            }
            CompoundTag tNBT = ModUtils.nbt(stack);
            double newCharge = tNBT.m_128459_("charge");
            amount = Math.min(amount, newCharge);
            if (!simulate) {
                if ((newCharge -= amount) > 0.0) {
                    tNBT.m_128347_("charge", newCharge);
                } else {
                    tNBT.m_128347_("charge", 0.0);
                }
            }
            return amount;
        }
        return 0.0;
    }

    @Override
    public double getCharge(ItemStack stack) {
        return ModUtils.nbt(stack).m_128459_("charge");
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return ((IEnergyItem)stack.m_41720_()).getMaxEnergy(stack);
    }

    @Override
    public boolean canUse(ItemStack stack, double amount) {
        return ElectricItem.manager.getCharge(stack) >= amount;
    }

    @Override
    public boolean use(ItemStack stack, double amount, LivingEntity entity) {
        double transfer = this.getCharge(stack);
        if (transfer >= amount) {
            ElectricItem.manager.discharge(stack, amount, Integer.MAX_VALUE, true, false, false);
            return true;
        }
        return false;
    }

    @Override
    public String getToolTip(ItemStack stack) {
        if (stack.m_41720_() instanceof IEnergyItem) {
            double charge = ElectricItem.manager.getCharge(stack);
            return ModUtils.getString(charge) + "/" + ModUtils.getString(((IEnergyItem)stack.m_41720_()).getMaxEnergy(stack)) + " EF";
        }
        return "";
    }

    @Override
    public int getTier(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() instanceof IEnergyItem ? (int)((IEnergyItem)stack.m_41720_()).getTierItem(stack) : 0;
    }
}

