/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.radiationsystem.EnumCoefficient;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.invslot.InvSlot;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.quarry.QuarryItem;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.world.WorldBaseGen;
import com.denfop.world.vein.ChanceOre;
import com.denfop.world.vein.VeinType;
import com.google.common.base.Preconditions;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModUtils {
    public static final Set<String> ignoredNbtKeys = new HashSet<String>(Arrays.asList("damage", "charge", "energy", "advDmg"));
    private static final Direction[] BY_2D_DATA = (Direction[])Arrays.stream(Direction.values()).filter(p_235685_ -> p_235685_.m_122434_().m_122479_()).sorted(Comparator.comparingInt(Direction::m_122416_)).toArray(Direction[]::new);
    public static Logger log;
    public static Direction[] facings;
    public static ItemStack emptyStack;
    public static Set<Direction> noFacings;
    public static Set<Direction> onlyNorth;
    public static Set<Direction> horizontalFacings;
    public static Direction[] HORIZONTALS;
    public static Set<Direction> verticalFacings;
    public static Set<Direction> downSideFacings;
    public static Set<Direction> allFacings;

    public static double getEnergyValue(ItemStack stack) {
        if (ModUtils.isEmpty(stack)) {
            return 0.0;
        }
        if (ModUtils.checkItemEquality(stack, Items.f_42451_)) {
            return 800.0;
        }
        return 0.0;
    }

    public static int getFuelValue(ItemStack stack, boolean allowLava) {
        boolean isLava;
        if (ModUtils.isEmpty(stack)) {
            return 0;
        }
        FluidStack liquid = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
        boolean bl = isLava = !liquid.isEmpty() && liquid.getAmount() > 0 && liquid.getFluid() == Fluids.f_76195_;
        if (isLava && !allowLava) {
            return 0;
        }
        int ret = (Integer)AbstractFurnaceBlockEntity.m_58423_().get(stack.m_41720_());
        return isLava ? ret / 10 : ret;
    }

    public static ItemStack get(Player player, InteractionHand hand) {
        return player.m_21120_(hand);
    }

    public static ItemStack decSize(ItemStack stack) {
        return ModUtils.decSize(stack, 1);
    }

    public static ItemStack decSize(ItemStack stack, int amount) {
        return ModUtils.incSize(stack, -amount);
    }

    public static ItemStack incSize(ItemStack stack, int amount) {
        return ModUtils.setSize(stack, ModUtils.getSize(stack) + amount);
    }

    public static boolean storeInventoryItem(ItemStack stack, Player player, boolean simulate) {
        if (!simulate) {
            return player.m_150109_().m_36054_(stack);
        }
        int sizeLeft = ModUtils.getSize(stack);
        int maxStackSize = Math.min(player.m_150109_().m_6893_(), stack.m_41741_());
        for (int i = 0; i < player.m_150109_().f_35974_.size() && sizeLeft > 0; ++i) {
            ItemStack invStack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (ModUtils.isEmpty(invStack)) {
                sizeLeft -= maxStackSize;
                continue;
            }
            if (!ModUtils.checkItemEqualityStrict(stack, invStack) || ModUtils.getSize(invStack) >= maxStackSize) continue;
            sizeLeft -= maxStackSize - ModUtils.getSize(invStack);
        }
        return sizeLeft <= 0;
    }

    public static void dropAsEntity(Level world, BlockPos pos, ItemStack stack, int count) {
        stack = stack.m_41777_();
        stack.m_41764_(count);
        ModUtils.dropAsEntity(world, pos, stack);
    }

    public static void dropAsEntity(Level world, BlockPos pos, ItemStack stack) {
        if (!ModUtils.isEmpty(stack)) {
            double f = 0.7;
            double dx = (double)world.f_46441_.m_188501_() * f + (1.0 - f) * 0.5;
            double dy = (double)world.f_46441_.m_188501_() * f + (1.0 - f) * 0.5;
            double dz = (double)world.f_46441_.m_188501_() * f + (1.0 - f) * 0.5;
            ItemEntity entityItem = new ItemEntity(world, (double)pos.m_123341_() + dx, (double)pos.m_123342_() + dy, (double)pos.m_123343_() + dz, stack.m_41777_());
            entityItem.m_32060_();
            world.m_7967_((Entity)entityItem);
        }
    }

    public static boolean checkItemEquality(ItemStack a, ItemStack b) {
        return ModUtils.isEmpty(a) && ModUtils.isEmpty(b) || !ModUtils.isEmpty(a) && !ModUtils.isEmpty(b) && a.m_41720_() == b.m_41720_() && ModUtils.checkNbtEquality(a, b);
    }

    public static boolean checkItemEquality(ItemStack a, Item b) {
        return ModUtils.isEmpty(a) && b == null || !ModUtils.isEmpty(a) && b != null && a.m_41720_() == b;
    }

    public static boolean checkItemEqualityStrict(ItemStack a, ItemStack b) {
        return ModUtils.isEmpty(a) && ModUtils.isEmpty(b) || !ModUtils.isEmpty(a) && !ModUtils.isEmpty(b) && a.m_150930_(b.m_41720_()) && ModUtils.checkNbtEqualityStrict(a, b);
    }

    private static boolean checkNbtEquality(ItemStack a, ItemStack b) {
        return NbtUtils.m_129235_((Tag)a.m_41783_(), (Tag)b.m_41783_(), (boolean)true);
    }

    public static boolean checkNbtEquality(CompoundTag a, CompoundTag b) {
        String key2;
        Set keysB;
        if (a == b) {
            return true;
        }
        Set keysA = a != null ? a.m_128431_() : Collections.emptySet();
        Set set = keysB = b != null ? b.m_128431_() : Collections.emptySet();
        if (keysA.isEmpty() && keysB.isEmpty()) {
            return true;
        }
        HashSet<String> toCheck = new HashSet<String>(Math.max(keysA.size(), keysB.size()));
        for (String key2 : keysA) {
            if (ignoredNbtKeys.contains(key2)) continue;
            if (!keysB.contains(key2)) {
                return false;
            }
            toCheck.add(key2);
        }
        for (String key2 : keysB) {
            if (ignoredNbtKeys.contains(key2)) continue;
            if (!keysA.contains(key2)) {
                return false;
            }
            toCheck.add(key2);
        }
        Iterator var5 = toCheck.iterator();
        do {
            if (var5.hasNext()) continue;
            return true;
        } while (a.m_128423_(key2 = (String)var5.next()).equals(b.m_128423_(key2)));
        return false;
    }

    public static boolean checkNbtEqualityStrict(ItemStack a, ItemStack b) {
        CompoundTag nbtA = a.m_41783_();
        CompoundTag nbtB = b.m_41783_();
        if (nbtA == null && nbtB == null) {
            return true;
        }
        if (nbtA == nbtB) {
            return true;
        }
        if (nbtA == null) {
            return false;
        }
        return nbtA.equals((Object)nbtB);
    }

    public static boolean isEmpty(ItemStack stack) {
        if (stack == emptyStack || stack == null) {
            return true;
        }
        stack.m_41720_();
        return stack.m_41613_() <= 0;
    }

    public static boolean isEmpty(Player player, InteractionHand hand) {
        return ModUtils.isEmpty(player.m_21120_(hand));
    }

    public static int getSize(ItemStack stack) {
        return ModUtils.isEmpty(stack) ? 0 : stack.m_41613_();
    }

    public static List<ItemStack> get_blacklist_block() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)Blocks.f_50069_));
        list.add(new ItemStack((ItemLike)Blocks.f_50493_));
        list.add(new ItemStack((ItemLike)Blocks.f_50134_));
        list.add(new ItemStack((ItemLike)Blocks.f_50259_));
        list.add(new ItemStack((ItemLike)Blocks.f_50334_));
        list.add(new ItemStack((ItemLike)Blocks.f_50122_));
        list.add(new ItemStack((ItemLike)Blocks.f_50652_));
        list.add(new ItemStack((ItemLike)Blocks.f_50175_));
        list.add(new ItemStack((ItemLike)Blocks.f_50281_));
        list.add(new ItemStack((ItemLike)Blocks.f_50387_));
        list.add(new ItemStack((ItemLike)Blocks.f_50546_));
        list.add(new ItemStack((ItemLike)Blocks.f_50599_));
        return list;
    }

    public static void info(String message) {
        log.info(message);
    }

    public static List<ItemStack> getListFromModule(ItemStack stack) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (!stack.m_41619_()) {
            CompoundTag nbt = ModUtils.nbt(stack);
            int size = nbt.m_128451_("size");
            for (int j = 0; j < size; ++j) {
                String l = "number_" + j;
                String temp = ModUtils.NBTGetString(stack, l);
                TagKey tag = new TagKey(Registry.f_122904_, new ResourceLocation(temp));
                List list = new Ingredient.TagValue(tag).m_6223_().stream().toList();
                stacks.addAll(list);
            }
        }
        return stacks;
    }

    public static List<QuarryItem> getQuarryListFromModule(ItemStack stack) {
        ArrayList<QuarryItem> stacks = new ArrayList<QuarryItem>();
        if (!stack.m_41619_()) {
            CompoundTag nbt = ModUtils.nbt(stack);
            int size = nbt.m_128451_("size");
            for (int j = 0; j < size; ++j) {
                String l = "number_" + j;
                String temp = ModUtils.NBTGetString(stack, l);
                stacks.add(new QuarryItem(temp));
            }
        }
        return stacks;
    }

    public static boolean getOre(Block localBlock) {
        ItemStack stack = new ItemStack((ItemLike)localBlock, 1);
        for (ItemStack itemstack : ModUtils.get_blacklist_block()) {
            if (!stack.m_150930_(itemstack.m_41720_())) continue;
            return false;
        }
        return true;
    }

    public static boolean getore(Item localBlock) {
        for (ItemStack itemstack : ModUtils.get_blacklist_block()) {
            if (localBlock != itemstack.m_41720_()) continue;
            return false;
        }
        return true;
    }

    public static boolean getore(ItemStack localBlock) {
        for (ItemStack itemstack : ModUtils.get_blacklist_block()) {
            if (!localBlock.m_150930_(itemstack.m_41720_())) continue;
            return false;
        }
        return true;
    }

    public static boolean getore(Block stack, Block localBlock) {
        ItemStack stack1 = new ItemStack((ItemLike)localBlock);
        for (ItemStack itemstack : ModUtils.get_blacklist_block()) {
            if (!stack1.m_150930_(itemstack.m_41720_())) continue;
            return false;
        }
        if (stack != localBlock) {
            return false;
        }
        for (ItemStack itemstack : IUCore.get_ore) {
            BlockItem blockItem = (BlockItem)itemstack.m_41720_();
            if (stack != blockItem.m_40614_()) continue;
            return true;
        }
        return localBlock == Blocks.f_50173_;
    }

    public static List<Double> Time(double time) {
        ArrayList<Double> list = new ArrayList<Double>();
        double temp = 0.0;
        if (time / 3600.0 >= 1.0) {
            temp = time / 3600.0;
        }
        temp = Math.floor(temp);
        list.add(Math.floor(temp));
        double temp1 = 0.0;
        if ((time - temp * 3600.0) / 60.0 >= 1.0) {
            temp1 = (time - temp * 3600.0) / 60.0;
        }
        temp1 = Math.floor(temp1);
        list.add(Math.floor(temp1));
        double temp2 = time - (temp * 3600.0 + temp1 * 60.0);
        list.add(Math.floor(temp2));
        return list;
    }

    public static void NBTSetString(ItemStack stack, String name, String string) {
        if (string == null) {
            return;
        }
        CompoundTag NBTTagCompound = stack.m_41783_();
        if (NBTTagCompound == null) {
            NBTTagCompound = new CompoundTag();
        }
        NBTTagCompound.m_128359_(name, string);
        stack.m_41751_(NBTTagCompound);
    }

    public static int getsum1(List<Integer> sum) {
        int sum_sum = 0;
        for (Integer aDouble : sum) {
            sum_sum += aDouble.intValue();
        }
        return sum_sum;
    }

    public static void SetDoubleWithoutItem(CompoundTag NBTTagCompound, String name, double amount) {
        if (NBTTagCompound == null) {
            NBTTagCompound = new CompoundTag();
        }
        NBTTagCompound.m_128347_(name, amount);
    }

    public static String Boolean(boolean boolean1) {
        if (boolean1) {
            return Localization.translate("iu.yes");
        }
        return Localization.translate("iu.no");
    }

    public static void mode(ItemStack stack, List<Component> list) {
        CompoundTag nbt = ModUtils.nbt(stack);
        list.add((Component)Component.m_237113_((String)ModUtils.mode(nbt)));
    }

    public static String mode(CompoundTag nbt) {
        String mode = nbt.m_128461_("mode");
        if (mode.isEmpty()) {
            return Localization.translate("defaultskin");
        }
        return switch (mode) {
            case "Zelen" -> Localization.translate("camouflageskin");
            case "Demon" -> Localization.translate("demonskin");
            case "Dark" -> Localization.translate("Darkskin");
            case "Cold" -> Localization.translate("Coldskin");
            case "Ender" -> Localization.translate("Enderskin");
            case "Ukraine" -> Localization.translate("Ukraineskin");
            case "Fire" -> Localization.translate("Fireskin");
            case "Emerald" -> Localization.translate("Emeraldskin");
            case "Taiga" -> Localization.translate("Taigaskin");
            case "Desert" -> Localization.translate("Desertskin");
            case "Snow" -> Localization.translate("Snowskin");
            default -> Localization.translate("defaultskin");
        };
    }

    public static ItemStack mode(CompoundTag nbt, ItemStack stack) {
        String mode = nbt.m_128461_("mode");
        ItemStack stack1 = stack.m_41777_();
        if (mode.isEmpty()) {
            return stack1;
        }
        nbt = ModUtils.nbt(stack1);
        nbt.m_128359_("mode", mode);
        return stack1;
    }

    public static String mode(int meta) {
        if (meta == 0) {
            return Localization.translate("defaultskin");
        }
        switch (meta) {
            case 3: {
                return Localization.translate("camouflageskin");
            }
            case 4: {
                return Localization.translate("demonskin");
            }
            case 6: {
                return Localization.translate("Darkskin");
            }
            case 1: {
                return Localization.translate("Coldskin");
            }
            case 7: {
                return Localization.translate("Enderskin");
            }
            case 2: {
                return Localization.translate("Ukraineskin");
            }
            case 5: {
                return Localization.translate("Fireskin");
            }
            case 11: {
                return Localization.translate("Emeraldskin");
            }
            case 8: {
                return Localization.translate("Taigaskin");
            }
            case 10: {
                return Localization.translate("Desertskin");
            }
            case 9: {
                return Localization.translate("Snowskin");
            }
        }
        return Localization.translate("defaultskin");
    }

    public static String getString(float number) {
        int i = (int)Math.log10(number);
        String maxstorage_2 = "0";
        if (i > -3 && i < 0) {
            float gg = number * 1000.0f;
            maxstorage_2 = String.format("%.0fm", Float.valueOf(gg));
        } else if (i <= -3 && i > -6) {
            float gg = number * 1000000.0f;
            maxstorage_2 = String.format("%.2f\u00b5", Float.valueOf(gg));
        } else if (i <= -6 && i > -9) {
            float gg = number * 1.0E9f;
            maxstorage_2 = String.format("%.2fn", Float.valueOf(gg));
        } else if (i <= -9 && i > -12) {
            float gg = number * 1.0E12f;
            maxstorage_2 = String.format("%.2fp", Float.valueOf(gg));
        } else if (i >= 0 && i < 3 && number <= 1000.0f) {
            float gg = number;
            maxstorage_2 = String.format("%.0f", Float.valueOf(gg));
        } else if (i >= 3 && i < 6) {
            float gg = number / 1000.0f;
            maxstorage_2 = String.format("%.2fK", Float.valueOf(gg));
        } else if (i >= 6 && i < 9) {
            float gg = number / 1000000.0f;
            maxstorage_2 = String.format("%.2fM", Float.valueOf(gg));
        } else if (i >= 9 && i < 12) {
            float gg = number / 1.0E9f;
            maxstorage_2 = String.format("%.2fG", Float.valueOf(gg));
        }
        return maxstorage_2;
    }

    public static String getUnit(EnumCoefficient coefficient) {
        switch (coefficient) {
            case MICRO: {
                return "\u00b5";
            }
            case MILI: {
                return "m";
            }
            case KILO: {
                return "k";
            }
            case DEFAULT: {
                return "";
            }
        }
        return "n";
    }

    public static String getString1(double number) {
        int i = (int)Math.log10(number);
        String maxstorage_2 = "0";
        if (i > -3 && i < 0) {
            double gg = number * 1000.0;
            maxstorage_2 = String.format("%.0fm", gg);
        } else if (i <= -3 && i > -6) {
            double gg = number * 1000000.0;
            maxstorage_2 = String.format("%.0f\u00b5", gg);
        } else if (i <= -6 && i > -9) {
            double gg = number * 1.0E9;
            maxstorage_2 = String.format("%.0fn", gg);
        } else if (i <= -9 && i > -12) {
            double gg = number * 1.0E12;
            maxstorage_2 = String.format("%.0fp", gg);
        } else if (i >= 0 && i < 3 && number <= 1000.0) {
            double gg = number;
            maxstorage_2 = String.format("%.0f", gg);
        } else if (i >= 3 && i < 6 && number >= 1000.0 && number < 1000000.0) {
            double gg = number / 1000.0;
            maxstorage_2 = String.format("%.2fK", gg);
        } else if (i >= 6 && i < 9 && number >= 1000000.0 && number < 1.0E9) {
            double gg = number / 1000000.0;
            maxstorage_2 = String.format("%.2fM", gg);
        } else if (i >= 9 && i < 12 && number >= 1.0E9 && number < 2.1E9) {
            double gg = number / 1.0E9;
            maxstorage_2 = String.format("%.2fG", gg);
        }
        return maxstorage_2;
    }

    public static String getString(double number) {
        String maxstorage_2 = "0";
        double i = Math.log10(number);
        if (i > -3.0 && i < 0.0) {
            maxstorage_2 = String.format("%.0fm", number * 1000.0);
        } else if (i <= -3.0 && i > -6.0) {
            maxstorage_2 = String.format("%.0f\u00b5", number * 1000000.0);
        } else if (i <= -6.0 && i > -9.0) {
            maxstorage_2 = String.format("%.0fn", number * 1.0E9);
        } else if (i <= -9.0 && i > -12.0) {
            maxstorage_2 = String.format("%.0fp", number * 1.0E12);
        } else if (i < 3.0) {
            maxstorage_2 = String.format("%.0f", number);
        } else if (i < 6.0) {
            maxstorage_2 = String.format("%.2fK", number / 1000.0);
        } else if (i < 9.0) {
            maxstorage_2 = String.format("%.2fM", number / 1000000.0);
        } else if (i < 12.0) {
            maxstorage_2 = String.format("%.2fG", number / 1.0E9);
        } else if (i < 15.0) {
            maxstorage_2 = String.format("%.2fT", number / 1.0E12);
        } else if (i < 18.0) {
            maxstorage_2 = String.format("%.2fP", number / 1.0E15);
        } else if (i < 21.0) {
            maxstorage_2 = String.format("%.2fE", number / 1.0E18);
        } else if (i < 24.0) {
            maxstorage_2 = String.format("%.2fZ", number / 1.0E21);
        } else if (i < 27.0) {
            maxstorage_2 = String.format("%.2fY", number / 1.0E24);
        }
        return maxstorage_2;
    }

    public static String getStringBukket(double number) {
        String maxstorage_2 = "0";
        double i = Math.log10(number);
        if (i > -3.0 && i < 0.0) {
            maxstorage_2 = String.format("%.0fm", number * 1000.0);
        } else if (i <= -3.0 && i > -6.0) {
            maxstorage_2 = String.format("%.0f\u00b5", number * 1000000.0);
        } else if (i <= -6.0 && i > -9.0) {
            maxstorage_2 = String.format("%.0fn", number * 1.0E9);
        } else if (i <= -9.0 && i > -12.0) {
            maxstorage_2 = String.format("%.0fp", number * 1.0E12);
        } else if (i < 3.0) {
            maxstorage_2 = String.format("%.0fm", number * 1000.0);
        } else if (i < 6.0) {
            maxstorage_2 = String.format("%.2fK", number / 1000.0);
        } else if (i < 9.0) {
            maxstorage_2 = String.format("%.2fM", number / 1000000.0);
        } else if (i < 12.0) {
            maxstorage_2 = String.format("%.2fG", number / 1.0E9);
        } else if (i < 15.0) {
            maxstorage_2 = String.format("%.2fT", number / 1.0E12);
        } else if (i < 18.0) {
            maxstorage_2 = String.format("%.2fP", number / 1.0E15);
        } else if (i < 21.0) {
            maxstorage_2 = String.format("%.2fE", number / 1.0E18);
        } else if (i < 24.0) {
            maxstorage_2 = String.format("%.2fZ", number / 1.0E21);
        } else if (i < 27.0) {
            maxstorage_2 = String.format("%.2fY", number / 1.0E24);
        }
        return maxstorage_2;
    }

    public static CompoundTag nbt() {
        return new CompoundTag();
    }

    public static CompoundTag nbt(ItemStack stack) {
        if (stack.m_41619_()) {
            return new CompoundTag();
        }
        CompoundTag NBTTagCompound = stack.m_41783_();
        if (NBTTagCompound == null) {
            NBTTagCompound = new CompoundTag();
        }
        stack.m_41751_(NBTTagCompound);
        return NBTTagCompound;
    }

    public static CompoundTag nbtOrNull(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        return stack.m_41783_();
    }

    public static int slot(List<Integer> list) {
        int meta = 0;
        for (Integer integer : list) {
            if (integer == 0) continue;
            meta = integer;
        }
        return meta;
    }

    public static String NBTGetString(ItemStack stack, String name) {
        if (name == null) {
            return "";
        }
        if (stack == null) {
            return "";
        }
        CompoundTag NBTTagCompound = ModUtils.nbt(stack);
        return NBTTagCompound.m_128461_(name);
    }

    public static int NBTGetInteger(ItemStack stack, String name) {
        if (name == null) {
            return 0;
        }
        CompoundTag NBTTagCompound = stack.m_41783_();
        if (NBTTagCompound == null) {
            return 0;
        }
        return NBTTagCompound.m_128451_(name);
    }

    public static void NBTSetInteger(ItemStack stack, String name, int string) {
        if (name == null) {
            return;
        }
        CompoundTag NBTTagCompound = stack.m_41783_();
        if (NBTTagCompound == null) {
            NBTTagCompound = new CompoundTag();
        }
        NBTTagCompound.m_128405_(name, string);
        stack.m_41751_(NBTTagCompound);
    }

    public static int convertRGBcolorToInt(int r, int g, int b) {
        float divColor = 255.0f;
        Color tmpColor = new Color((float)r / divColor, (float)g / divColor, (float)b / divColor);
        return tmpColor.getRGB();
    }

    public static int convertRGBAcolorToInt(int r, int g, int b) {
        return 0xFA000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static IItemHandler getItemHandler(@javax.annotation.Nullable BlockEntity tile, Direction side) {
        if (tile == null) {
            return null;
        }
        @NotNull LazyOptional capability = tile.getCapability(ForgeCapabilities.ITEM_HANDLER, side);
        IItemHandler handler = (IItemHandler)capability.orElseGet(() -> null);
        if (handler == null) {
            if (side != null && tile instanceof WorldlyContainer) {
                handler = new SidedInvWrapper((WorldlyContainer)tile, side);
            } else if (tile instanceof Container) {
                handler = new InvWrapper((Container)tile);
            }
        }
        return handler;
    }

    public static ItemStack setSize(ItemStack stack, int col) {
        stack = stack.m_41777_();
        stack.m_41764_(col);
        return stack;
    }

    public static ItemStack setSize(Item item, int col) {
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.m_41764_(col);
        return stack;
    }

    public static int limit(int value, int min, int max) {
        if (value <= min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static float limit(float value, float min, float max) {
        if (!Float.isNaN(value) && !(value <= min)) {
            return Math.min(value, max);
        }
        return min;
    }

    public static double limit(double value, double min, double max) {
        if (!Double.isNaN(value) && !(value <= min)) {
            return Math.min(value, max);
        }
        return min;
    }

    public static ItemStack getRecipeFromType(Level world, ItemStack stack1, RecipeType<SmeltingRecipe> type) {
        List recipes = world.m_7465_().m_44013_(type);
        for (SmeltingRecipe recipe : recipes) {
            if (recipe.m_7527_().size() > 1) {
                return ItemStack.f_41583_;
            }
            if (!((Ingredient)recipe.m_7527_().get(0)).test(stack1)) continue;
            return recipe.m_8043_();
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public static ItemStack insertItem(IItemHandler dest, @Nonnull ItemStack stack, boolean simulate, int slots) {
        if (dest == null || stack.m_41619_()) {
            return stack;
        }
        slots = Math.min(slots, dest.getSlots());
        for (int i = 0; i < slots; ++i) {
            ItemStack stack1 = dest.insertItem(i, stack, simulate);
            if (stack1.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (stack1 == stack) continue;
            return stack1;
        }
        return stack;
    }

    public static void showFlames(Level level, BlockPos pos, Direction facing) {
        if (level.f_46441_.m_188503_(8) == 0) {
            double x = (double)pos.m_123341_() + ((double)facing.m_122429_() * 1.04 + 1.0) / 2.0;
            double y = (double)pos.m_123342_() + (double)level.f_46441_.m_188501_() * 0.375;
            double z = (double)pos.m_123343_() + ((double)facing.m_122431_() * 1.04 + 1.0) / 2.0;
            if (facing.m_122434_() == Direction.Axis.X) {
                z += (double)level.f_46441_.m_188501_() * 0.625 - 0.3125;
            } else {
                x += (double)level.f_46441_.m_188501_() * 0.625 - 0.3125;
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static ItemStack getCellFromFluid(Fluid fluid) {
        return IUItem.fluidCell.getItem().getItemStack(fluid);
    }

    public static void tick(InvSlotOutput slot, TileEntityBlock tile) {
        for (Direction facing1 : facings) {
            BlockPos pos = tile.m_58899_().m_121955_(facing1.m_122436_());
            BlockEntity tile1 = tile.getWorld().m_7702_(pos);
            if (tile1 instanceof TileEntityInventory) {
                TileEntityInventory inventory = (TileEntityInventory)tile1;
                for (InvSlot invSlot : inventory.getInputSlots()) {
                    int maxCount;
                    ItemStack input;
                    if (invSlot.acceptAllOrIndex()) {
                        for (int j = 0; j < slot.size(); ++j) {
                            ItemStack output = slot.get(j);
                            if (output.m_41619_() || !invSlot.accepts(output, 0)) continue;
                            for (int jj = 0; jj < invSlot.size() && !output.m_41619_(); ++jj) {
                                input = invSlot.get(jj);
                                if (input.m_41619_()) {
                                    if (!invSlot.add(output)) continue;
                                    slot.set(j, ItemStack.f_41583_);
                                    output = ItemStack.f_41583_;
                                    continue;
                                }
                                if (!ModUtils.checkItemEquality(input, output) || (maxCount = Math.min(input.m_41741_() - input.m_41613_(), output.m_41613_())) <= 0) continue;
                                input.m_41769_(maxCount);
                                output.m_41774_(maxCount);
                            }
                        }
                        continue;
                    }
                    for (int jj = 0; jj < slot.size(); ++jj) {
                        ItemStack output;
                        for (int j = 0; j < invSlot.size() && !(output = slot.get(jj)).m_41619_(); ++j) {
                            input = invSlot.get(j);
                            if (input.m_41619_()) {
                                if (!invSlot.accepts(output, j) || !invSlot.add(output)) continue;
                                slot.set(jj, ItemStack.f_41583_);
                                output = ItemStack.f_41583_;
                                continue;
                            }
                            if (!ModUtils.checkItemEquality(input, output) || (maxCount = Math.min(input.m_41741_() - input.m_41613_(), output.m_41613_())) <= 0) continue;
                            input.m_41769_(maxCount);
                            output.m_41774_(maxCount);
                        }
                    }
                }
                continue;
            }
            IItemHandler handler = ModUtils.getItemHandler(tile1, facing1.m_122424_());
            if (handler == null) continue;
            int slots = handler.getSlots();
            for (int j = 0; j < slot.size(); ++j) {
                int count;
                ItemStack stack1;
                ItemStack took = slot.get(j);
                if (took.m_41619_()) continue;
                if (!(handler instanceof Container)) {
                    stack1 = ModUtils.insertItem(handler, took = took.m_41777_(), true, slots);
                    if (stack1.m_41619_()) {
                        slot.set(j, ItemStack.f_41583_);
                        ModUtils.insertItem(handler, took, false, slots);
                        continue;
                    }
                    if (stack1 == took) continue;
                    count = slot.get(j).m_41613_() - stack1.m_41613_();
                    slot.get(j).m_41774_(count);
                    stack1.m_41764_(count);
                    ModUtils.insertItem(handler, stack1, false, slots);
                    continue;
                }
                stack1 = ModUtils.insertItem1(handler, took, true, slots);
                if (stack1.m_41619_()) {
                    slot.set(j, ItemStack.f_41583_);
                    ModUtils.insertItem1(handler, took, false, slots);
                    continue;
                }
                if (stack1 == took) continue;
                count = slot.get(j).m_41613_() - stack1.m_41613_();
                slot.get(j).m_41774_(count);
                stack1.m_41764_(count);
                ModUtils.insertItem1(handler, stack1, false, slots);
            }
        }
    }

    @Nonnull
    public static ItemStack insertItem1(IItemHandler dest, @Nonnull ItemStack stack, boolean simulate, int slot) {
        if (dest == null || stack.m_41619_()) {
            return stack;
        }
        slot = Math.min(slot, dest.getSlots());
        for (int i = 0; i < slot; ++i) {
            ItemStack stack2 = ModUtils.insertItem2(dest, i, stack, simulate);
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (stack2 == stack) continue;
            return stack2;
        }
        return stack;
    }

    public static boolean canItemStacksStack(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        if (a.m_41619_() || !a.m_150930_(b.m_41720_()) || a.m_41782_() != b.m_41782_()) {
            return false;
        }
        return !a.m_41782_() || a.m_41783_().equals((Object)b.m_41783_());
    }

    @Nonnull
    public static ItemStack insertItem2(IItemHandler dest, int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = dest.getStackInSlot(slot);
        if (!stackInSlot.m_41619_()) {
            int max = stackInSlot.m_41741_();
            int limit = dest.getSlotLimit(slot);
            if (stackInSlot.m_41613_() >= Math.min(max, limit)) {
                return stack;
            }
            if (!ModUtils.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            int m = Math.min(max, limit) - stackInSlot.m_41613_();
            if (stack.m_41613_() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.m_41777_();
                    copy.m_41769_(stackInSlot.m_41613_());
                    ((SidedInvWrapper)dest).setStackInSlot(slot, copy);
                    return ItemStack.f_41583_;
                }
            } else {
                stack = stack.m_41777_();
                if (!simulate) {
                    ItemStack copy = stack.m_41620_(m);
                    copy.m_41769_(stackInSlot.m_41613_());
                    ((SidedInvWrapper)dest).setStackInSlot(slot, copy);
                    return ItemStack.f_41583_;
                }
            }
            return stack;
        }
        int m = Math.min(stack.m_41741_(), dest.getSlotLimit(slot));
        if (m < stack.m_41613_()) {
            stack = stack.m_41777_();
            if (!simulate) {
                ((SidedInvWrapper)dest).setStackInSlot(slot, stack.m_41620_(m));
            }
            return stack;
        }
        if (!simulate) {
            ((SidedInvWrapper)dest).setStackInSlot(slot, stack);
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public static FluidActionResult tryFillContainer(@NotNull ItemStack container, IFluidHandler fluidSource, int maxAmount, @Nullable Player player, boolean doFill) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        IFluidHandlerItem containerFluidHandler = (IFluidHandlerItem)containerCopy.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse((Object)((IFluidHandlerItem)containerCopy.m_41720_().initCapabilities(containerCopy, containerCopy.m_41783_())));
        for (int i = 0; i < fluidSource.getTanks(); ++i) {
            FluidStack simulatedTransfer = ModUtils.tryFluidTransfer((IFluidHandler)containerFluidHandler, fluidSource, maxAmount, false, i);
            if (simulatedTransfer.isEmpty()) continue;
            if (doFill) {
                ModUtils.tryFluidTransfer((IFluidHandler)containerFluidHandler, fluidSource, maxAmount, true, i);
                if (player != null) {
                    SoundEvent soundevent = simulatedTransfer.getFluid().getFluidType().getSound(simulatedTransfer, SoundActions.BUCKET_FILL);
                    player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            } else {
                containerFluidHandler.fill(simulatedTransfer, IFluidHandler.FluidAction.EXECUTE);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }
        return FluidActionResult.FAILURE;
    }

    @NotNull
    public static FluidActionResult tryFillContainerAndStow(@NotNull ItemStack container, IFluidHandler fluidSource, IItemHandler inventory, int maxAmount, @Nullable Player player, boolean doFill) {
        if (container.m_41619_()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.m_150110_().f_35937_) {
            FluidActionResult filledReal = ModUtils.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
            if (filledReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.m_41613_() == 1) {
            FluidActionResult filledReal = ModUtils.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
            if (filledReal.isSuccess()) {
                return filledReal;
            }
        } else {
            ItemStack remainder;
            FluidActionResult filledSimulated = ModUtils.tryFillContainer(container, fluidSource, maxAmount, player, false);
            if (filledSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)filledSimulated.getResult(), (boolean)true)).m_41619_() || player != null)) {
                FluidActionResult filledReal = ModUtils.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
                remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)filledReal.getResult(), (!doFill ? 1 : 0) != 0);
                if (!remainder.m_41619_() && player != null && doFill) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)remainder);
                }
                ItemStack containerCopy = container.m_41777_();
                containerCopy.m_41774_(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    public static boolean interactWithFluidHandler(@Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull IFluidHandler handler) {
        IItemHandler playerInventory;
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)hand);
        Preconditions.checkNotNull((Object)handler);
        ItemStack heldItem = player.m_21120_(hand);
        if (!heldItem.m_41619_() && (playerInventory = (IItemHandler)player.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse((Object)new InvWrapper((Container)player.m_150109_()))) != null) {
            FluidActionResult fluidActionResult = ModUtils.tryFillContainerAndStow(heldItem, handler, playerInventory, Integer.MAX_VALUE, player, true);
            if (!fluidActionResult.isSuccess()) {
                Object stack = null;
                int sizeTanks = handler.getTanks();
                int capacity = -1;
                @NotNull ItemStack stack1 = ItemHandlerHelper.copyStackWithSize((ItemStack)heldItem, (int)1);
                IFluidHandlerItem containerFluidHandler = FluidHandlerFix.getFluidHandler(stack1);
                for (int i = 0; i < sizeTanks; ++i) {
                    if ((!handler.getFluidInTank(i).isEmpty() || handler.fill(containerFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) <= 0) && (handler.getFluidInTank(i).isEmpty() || !handler.getFluidInTank(i).isFluidEqual(containerFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)) || handler.fill(containerFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) <= 0)) continue;
                    capacity = handler.getTankCapacity(i) - (handler.getFluidInTank(i).isEmpty() ? 0 : handler.getFluidInTank(i).getAmount());
                }
                fluidActionResult = capacity <= 0 ? FluidActionResult.FAILURE : ModUtils.tryEmptyContainerAndStow(heldItem, handler, playerInventory, capacity, player, true);
            }
            if (fluidActionResult.isSuccess()) {
                player.m_21008_(hand, fluidActionResult.getResult());
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static FluidActionResult tryEmptyContainerAndStow(@NotNull ItemStack container, IFluidHandler fluidDestination, IItemHandler inventory, int maxAmount, @Nullable Player player, boolean doDrain) {
        if (container.m_41619_()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.m_150110_().f_35937_) {
            FluidActionResult emptiedReal = ModUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.m_41613_() == 1) {
            FluidActionResult emptiedReal = ModUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return emptiedReal;
            }
        } else {
            ItemStack remainder;
            FluidActionResult emptiedSimulated = ModUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, false);
            if (emptiedSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)emptiedSimulated.getResult(), (boolean)true)).m_41619_() || player != null)) {
                FluidActionResult emptiedReal = ModUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
                remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)emptiedReal.getResult(), (!doDrain ? 1 : 0) != 0);
                if (!remainder.m_41619_() && player != null && doDrain) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)remainder);
                }
                ItemStack containerCopy = container.m_41777_();
                containerCopy.m_41774_(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @NotNull
    public static FluidActionResult tryEmptyContainer(@NotNull ItemStack container, IFluidHandler fluidDestination, int maxAmount, @Nullable Player player, boolean doDrain) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        IFluidHandlerItem containerFluidHandler = FluidHandlerFix.getFluidHandler(containerCopy);
        if (containerFluidHandler != null) {
            FluidStack transfer = ModUtils.tryFluidTransfer(fluidDestination, (IFluidHandler)containerFluidHandler, maxAmount, doDrain);
            if (transfer.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            if (!doDrain) {
                containerFluidHandler.drain(transfer, IFluidHandler.FluidAction.EXECUTE);
            }
            if (doDrain && player != null) {
                SoundEvent soundevent = transfer.getFluid().getFluidType().getSound(transfer, SoundActions.BUCKET_EMPTY);
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }
        return FluidActionResult.FAILURE;
    }

    @NotNull
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer, int index) {
        FluidStack stack = fluidSource.getFluidInTank(index).copy();
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        stack.setAmount(Math.min(stack.getAmount(), maxAmount));
        FluidStack drainable = fluidSource.drain(stack, IFluidHandler.FluidAction.SIMULATE);
        if (!drainable.isEmpty()) {
            return ModUtils.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer) {
        FluidStack drainable = fluidSource.drain(maxAmount, IFluidHandler.FluidAction.SIMULATE);
        if (!drainable.isEmpty()) {
            return ModUtils.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, FluidStack resource, boolean doTransfer) {
        FluidStack drainable = fluidSource.drain(resource, IFluidHandler.FluidAction.SIMULATE);
        if (!drainable.isEmpty() && resource.isFluidEqual(drainable)) {
            return ModUtils.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return FluidStack.EMPTY;
    }

    private static FluidStack tryFluidTransfer_Internal(IFluidHandler fluidDestination, IFluidHandler fluidSource, FluidStack drainable, boolean doTransfer) {
        int fillableAmount = fluidDestination.fill(drainable, IFluidHandler.FluidAction.SIMULATE);
        if (fillableAmount > 0) {
            drainable.setAmount(fillableAmount);
            if (doTransfer) {
                FluidStack drained = fluidSource.drain(drainable, IFluidHandler.FluidAction.EXECUTE);
                if (!drained.isEmpty()) {
                    drained.setAmount(fluidDestination.fill(drained, IFluidHandler.FluidAction.EXECUTE));
                    return drained;
                }
            } else {
                return drainable;
            }
        }
        return FluidStack.EMPTY;
    }

    public static Direction getFacingFromTwoPositions(BlockPos fromPos, BlockPos toPos) {
        int dx = toPos.m_123341_() - fromPos.m_123341_();
        int dy = toPos.m_123342_() - fromPos.m_123342_();
        int dz = toPos.m_123343_() - fromPos.m_123343_();
        if (dx > 0) {
            return Direction.EAST;
        }
        if (dx < 0) {
            return Direction.WEST;
        }
        if (dy > 0) {
            return Direction.DOWN;
        }
        if (dy < 0) {
            return Direction.UP;
        }
        if (dz > 0) {
            return Direction.SOUTH;
        }
        if (dz < 0) {
            return Direction.NORTH;
        }
        return Direction.DOWN;
    }

    public static boolean inChanceOre(VeinType veinType, BlockState state) {
        for (ChanceOre chanceOre : veinType.getOres()) {
            if (chanceOre.getBlock() != state) continue;
            return true;
        }
        return false;
    }

    public static List<Component> getInformationFromOre(BlockState state) {
        ArrayList<Component> stringList = new ArrayList<Component>();
        for (VeinType vein : WorldBaseGen.veinTypes) {
            if ((vein.getHeavyOre() == null || vein.getHeavyOre().getStateMeta(vein.getMeta()) != state) && !ModUtils.inChanceOre(vein, state)) continue;
            Component s = vein.getHeavyOre() != null ? new ItemStack((ItemLike)vein.getHeavyOre().getBlock(), 1).m_41611_() : new ItemStack((ItemLike)vein.getOres().get(0).getBlock().m_60734_(), 1).m_41611_();
            stringList.add(s);
        }
        return stringList;
    }

    static {
        facings = Direction.values();
        emptyStack = ItemStack.f_41583_;
        noFacings = Collections.emptySet();
        onlyNorth = Collections.unmodifiableSet(EnumSet.of(Direction.NORTH));
        horizontalFacings = Collections.unmodifiableSet(EnumSet.copyOf(Arrays.asList(BY_2D_DATA)));
        HORIZONTALS = BY_2D_DATA;
        verticalFacings = Collections.unmodifiableSet(EnumSet.of(Direction.DOWN, Direction.UP));
        downSideFacings = Collections.unmodifiableSet(EnumSet.complementOf(EnumSet.of(Direction.UP)));
        allFacings = Collections.unmodifiableSet(EnumSet.allOf(Direction.class));
    }
}

