/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RetraceDiggingUtils {
    public static BlockHitResult retrace(Player player) {
        return RetraceDiggingUtils.retrace(player, RetraceDiggingUtils.getBlockReachDistance(player));
    }

    public static double getBlockReachDistance(Player player) {
        return player.m_9236_().f_46443_ ? RetraceDiggingUtils.getBlockReachDistance_client() : (player instanceof ServerPlayer ? RetraceDiggingUtils.getBlockReachDistance_server((ServerPlayer)player) : 5.0);
    }

    public static BlockHitResult retrace(Player player, double reach) {
        return RetraceDiggingUtils.retrace(player, reach, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static double getBlockReachDistance_client() {
        return Minecraft.m_91087_().f_91074_.getReachDistance();
    }

    private static double getBlockReachDistance_server(ServerPlayer player) {
        return player.getReachDistance();
    }

    public static BlockHitResult retrace(Player player, double reach, boolean stopOnFluids) {
        Vec3 startVec = RetraceDiggingUtils.getStartVec(player);
        Vec3 endVec = RetraceDiggingUtils.getEndVec(player, reach);
        return player.m_9236_().m_45547_(new ClipContext(startVec, endVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.WATER, (Entity)player));
    }

    public static Vec3 getStartVec(Player player) {
        return RetraceDiggingUtils.getCorrectedHeadVec(player);
    }

    public static Vec3 getCorrectedHeadVec(Player player) {
        Vector3f v = new Vector3f(player.m_20182_());
        v.m_122272_(0.0f, player.m_20192_(), 0.0f);
        return new Vec3(v);
    }

    public static Vec3 getEndVec(Player player, double reach) {
        Vector3f headVec = new Vector3f(RetraceDiggingUtils.getCorrectedHeadVec(player));
        Vec3 lookVec = player.m_20154_();
        headVec.m_122272_((float)(lookVec.f_82479_ * reach), (float)(lookVec.f_82480_ * reach), (float)(lookVec.f_82481_ * reach));
        return new Vec3(headVec);
    }
}

