/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import com.denfop.Localization;
import com.denfop.network.packet.CustomPacketBuffer;
import java.io.IOException;
import net.minecraft.nbt.CompoundTag;

public class Timer {
    boolean canWork = true;
    private int max;
    private int hour;
    private int minute;
    private int seconds;

    public Timer(int hour, int minute, int seconds) {
        this.hour = hour;
        this.minute = minute;
        this.seconds = seconds;
        this.max = hour * 3600 + minute * 60 + seconds;
    }

    public Timer(int time) {
        int hour = time / 3600;
        int minute = (time -= hour * 3600) / 60;
        int seconds = time - minute * 60;
        this.hour = hour;
        this.minute = minute;
        this.seconds = seconds;
        this.max = hour * 3600 + minute * 60 + seconds;
    }

    public Timer(CompoundTag tagCompound) {
        this.hour = tagCompound.m_128451_("hour");
        this.minute = tagCompound.m_128445_("minute");
        this.seconds = tagCompound.m_128445_("seconds");
        this.canWork = tagCompound.m_128471_("canWork");
        this.max = tagCompound.m_128451_("max");
    }

    public Timer(CustomPacketBuffer is) {
        this.hour = is.readInt();
        this.minute = is.readByte();
        this.seconds = is.readByte();
        this.canWork = is.readBoolean();
        this.max = is.readInt();
    }

    public void readBuffer(CustomPacketBuffer is) throws IOException {
        this.hour = is.readInt();
        this.minute = is.readByte();
        this.seconds = is.readByte();
        this.canWork = is.readBoolean();
        this.max = is.readInt();
    }

    public void writeBuffer(CustomPacketBuffer buffer) {
        buffer.writeInt(this.hour);
        buffer.writeByte(this.minute);
        buffer.writeByte(this.seconds);
        buffer.writeBoolean(this.canWork);
        buffer.writeInt(this.max);
    }

    public CompoundTag writeNBT(CompoundTag tagCompound) {
        tagCompound.m_128405_("hour", this.hour);
        tagCompound.m_128344_("minute", (byte)this.minute);
        tagCompound.m_128344_("seconds", (byte)this.seconds);
        tagCompound.m_128379_("canWork", this.canWork);
        tagCompound.m_128405_("max", this.max);
        return tagCompound;
    }

    public String getDisplay() {
        Object time = "";
        if (this.hour > 0) {
            time = (String)time + this.hour + Localization.translate("iu.hour");
        }
        if (this.minute > 0) {
            time = (String)time + this.minute + Localization.translate("iu.minutes");
        }
        if (this.seconds > 0) {
            time = (String)time + this.seconds + Localization.translate("iu.seconds");
        }
        return time;
    }

    public int getMax() {
        return this.max;
    }

    public double getProgressBar() {
        return Math.min(1.0, (double)(this.max - this.getBar()) / ((double)this.max * 1.0));
    }

    public int getBar() {
        return this.hour * 3600 + this.minute * 60 + this.seconds;
    }

    public int getTime() {
        return this.seconds + this.minute * 60 + this.hour * 3600;
    }

    public void work(double percent) {
        int i = 0;
        while ((double)i < percent) {
            if (this.seconds != 0) {
                --this.seconds;
            } else if (this.minute != 0) {
                this.seconds = 59;
                --this.minute;
            } else if (this.hour != 0) {
                --this.hour;
                this.minute = 59;
                this.seconds = 59;
            } else {
                this.canWork = false;
            }
            ++i;
        }
    }

    public void work() {
        for (int i = 0; i < 1; ++i) {
            if (this.seconds != 0) {
                --this.seconds;
                continue;
            }
            if (this.minute != 0) {
                this.seconds = 59;
                --this.minute;
                continue;
            }
            if (this.hour != 0) {
                --this.hour;
                this.minute = 59;
                this.seconds = 59;
                continue;
            }
            this.canWork = false;
        }
    }

    public void rework() {
        ++this.seconds;
        if (this.seconds == 60) {
            this.seconds = 0;
            ++this.minute;
            if (this.minute == 60) {
                this.minute = 0;
                ++this.hour;
            }
        }
    }

    public boolean canWork() {
        return this.canWork;
    }

    public void setCanWork(boolean canWork) {
        this.canWork = canWork;
    }

    public void readNBT(CompoundTag tagCompound) {
        this.hour = tagCompound.m_128451_("hour");
        this.minute = tagCompound.m_128445_("minute");
        this.seconds = tagCompound.m_128445_("seconds");
        this.canWork = tagCompound.m_128471_("canWork");
    }

    public void readTimer(Timer timer) {
        this.hour = timer.hour;
        this.seconds = timer.seconds;
        this.minute = timer.minute;
        this.canWork = timer.canWork;
    }

    public Timer cloning() {
        Timer timer = new Timer(this.hour, this.minute, this.seconds);
        timer.canWork = this.canWork;
        return timer;
    }

    public boolean getMinute(int minute) {
        return this.minute == minute;
    }

    public void getTimeFromTimerRemove(Timer timerTo) {
        this.hour -= timerTo.hour;
        this.minute -= timerTo.minute;
        this.seconds -= timerTo.seconds;
        if (this.seconds < 0) {
            this.seconds = Math.abs(this.seconds);
        }
        this.max = this.hour * 3600 + this.minute * 60 + this.seconds;
    }
}

