/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world;

import com.denfop.IUItem;
import com.denfop.blocks.BlockRubWood;
import com.denfop.blocks.BlockSwampRubWood;
import com.denfop.blocks.BlockTropicalRubWood;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;

public class RubTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public RubTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    protected boolean canGrowInto(Block blockType) {
        Material material = blockType.m_49966_().m_60767_();
        return material == Material.f_76296_ || material == Material.f_76274_ || blockType == Blocks.f_50440_ || blockType == Blocks.f_50493_ || blockType.m_49966_().m_204336_(BlockTags.f_13106_) || blockType.m_49966_().m_204336_(BlockTags.f_13035_) || blockType.m_49966_().m_204336_(BlockTags.f_13104_) || blockType == Blocks.f_50191_ || blockType == IUItem.rubWood.getBlock().get() || blockType == IUItem.leaves.getBlock().get();
    }

    public boolean placeInstantly(ServerLevel pLevel, ChunkGenerator generator, BlockState pState, RandomSource pRandom, BlockPos pPos) {
        int i = pRandom.m_188503_(5) + pRandom.m_188503_(4) + pRandom.m_188503_(2);
        ServerLevel worldIn = pLevel;
        BlockPos position = pPos;
        RandomSource rand = pRandom;
        if (i <= 3) {
            i = 4;
        }
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                BlockState state = worldIn.m_8055_(position.m_7918_(x, 0, z));
                if (state.m_60767_() != Material.f_76320_ && state.m_60734_() != IUItem.rubWood.getBlock().get()) continue;
                return false;
            }
        }
        boolean flag = true;
        Block woodBlock = (Block)IUItem.rubWood.getBlock().get();
        BlockState leaves = IUItem.leaves.getDefaultState();
        if (position.m_123342_() >= 1 && position.m_123342_() + i + 1 <= 256) {
            for (int j = position.m_123342_(); j <= position.m_123342_() + 1 + i; ++j) {
                int k = 1;
                if (j == position.m_123342_()) {
                    k = 0;
                }
                if (j >= position.m_123342_() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.m_123341_() - k; l <= position.m_123341_() + k && flag; ++l) {
                    for (int i1 = position.m_123343_() - k; i1 <= position.m_123343_() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.m_141928_()) {
                            if (this.isReplaceable((WorldGenLevel)worldIn, (BlockPos)blockpos$mutableblockpos.m_122178_(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = position.m_7495_();
            BlockState state = worldIn.m_8055_(down);
            boolean isSoil = state.m_60734_().canSustainPlant(state, (BlockGetter)worldIn, down, Direction.UP, (IPlantable)IUItem.rubberSapling.getBlock().get());
            if (isSoil && position.m_123342_() < worldIn.m_141928_() - i - 1) {
                this.onPlantGrow(state, (WorldGenLevel)worldIn, down, position);
                Holder biome = worldIn.m_204166_(position);
                if (!biome.m_203656_(Tags.Biomes.IS_SWAMP) && !biome.m_203656_(BiomeTags.f_207610_)) {
                    for (int i2 = position.m_123342_() - i / 2 + i; i2 <= position.m_123342_() + i + 1 + rand.m_188503_(3); ++i2) {
                        int i3;
                        BlockPos blockpos;
                        BlockState state2;
                        int l1;
                        int k1;
                        BlockState state22;
                        BlockPos blockpos2;
                        int[][] offsets;
                        int k2 = i2 - (position.m_123342_() + i + 1);
                        int l2 = 3;
                        if (i2 >= position.m_123342_() + i) {
                            l2 = 1;
                        }
                        if (i2 == position.m_123342_() + i) {
                            for (int[] offset : offsets = new int[][]{{-1, 0}, {0, -1}, {1, 0}, {0, 1}}) {
                                blockpos2 = new BlockPos(position.m_123341_() + offset[0], i2, position.m_123343_() + offset[1]);
                                state22 = worldIn.m_8055_(blockpos2);
                                if (!state22.m_60795_()) continue;
                                worldIn.m_7731_(blockpos2, leaves, 3);
                            }
                        }
                        if (i2 == position.m_123342_() - i / 2 + i + 1) {
                            l2 = 3;
                            for (int[] offset : offsets = new int[][]{{-2, 0}, {0, -2}, {2, 0}, {0, 2}}) {
                                blockpos2 = new BlockPos(position.m_123341_() + offset[0], i2, position.m_123343_() + offset[1]);
                                state22 = worldIn.m_8055_(blockpos2);
                                if (!state22.m_60795_()) continue;
                                worldIn.m_7731_(blockpos2, leaves, 3);
                            }
                        }
                        if (i2 == position.m_123342_() - i / 2 + i) {
                            l2 = 4;
                            if (i > 6) {
                                int i32;
                                for (i32 = position.m_123341_() - l2 / 2; i32 <= position.m_123341_() + l2 / 2; ++i32) {
                                    int j1 = i32 - position.m_123341_();
                                    for (k1 = position.m_123343_() - l2 / 2; k1 <= position.m_123343_() + l2 / 2; ++k1) {
                                        l1 = k1 - position.m_123343_();
                                        if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.m_188503_(2) == 0 || k2 == 0) || !(state2 = worldIn.m_8055_(blockpos = new BlockPos(i32, i2 - 1, k1))).m_60795_()) continue;
                                        worldIn.m_7731_(blockpos, leaves, 3);
                                    }
                                }
                                for (i32 = position.m_123341_() - 2; i32 <= position.m_123341_() + 2; i32 += 4) {
                                    int j1 = i32 - position.m_123341_();
                                    for (k1 = position.m_123343_() - 2; k1 <= position.m_123343_() + 2; k1 += 4) {
                                        l1 = k1 - position.m_123343_();
                                        if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.m_188503_(2) == 0 || k2 == 0) || !(state2 = worldIn.m_8055_(blockpos = new BlockPos(i32, i2 - 1, k1))).m_60795_()) continue;
                                        this.m_5974_((LevelWriter)worldIn, blockpos, Blocks.f_50016_.m_49966_());
                                    }
                                }
                            }
                            l2 = 4;
                        }
                        for (i3 = position.m_123341_() - l2 / 2; i3 <= position.m_123341_() + l2 / 2; ++i3) {
                            int j1 = i3 - position.m_123341_();
                            for (k1 = position.m_123343_() - l2 / 2; k1 <= position.m_123343_() + l2 / 2; ++k1) {
                                l1 = k1 - position.m_123343_();
                                if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.m_188503_(2) == 0 || k2 == 0) || !(state2 = worldIn.m_8055_(blockpos = new BlockPos(i3, i2, k1))).m_60795_()) continue;
                                this.m_5974_((LevelWriter)worldIn, blockpos, leaves);
                            }
                        }
                        if (i2 != position.m_123342_() - i / 2 + i) continue;
                        for (i3 = position.m_123341_() - 2; i3 <= position.m_123341_() + 2; i3 += 4) {
                            int j1 = i3 - position.m_123341_();
                            for (k1 = position.m_123343_() - 2; k1 <= position.m_123343_() + 2; k1 += 4) {
                                l1 = k1 - position.m_123343_();
                                if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.m_188503_(2) == 0 || k2 == 0) || !(state2 = worldIn.m_8055_(blockpos = new BlockPos(i3, i2, k1))).m_60795_()) continue;
                                this.m_5974_((LevelWriter)worldIn, blockpos, Blocks.f_50016_.m_49966_());
                            }
                        }
                    }
                    int treeholechance = 40;
                    for (int j2 = 0; j2 < i; ++j2) {
                        BlockPos upN = position.m_6630_(j2);
                        BlockState state2 = worldIn.m_8055_(upN);
                        if (!state2.m_60795_() && !state2.m_204336_(BlockTags.f_13035_) && state2.m_60734_() != IUItem.rubberSapling.getBlock().get()) continue;
                        if (rand.m_188503_(100) <= treeholechance) {
                            treeholechance -= 10;
                            this.m_5974_((LevelWriter)worldIn, position.m_6630_(j2), (BlockState)woodBlock.m_49966_().m_61124_(BlockRubWood.stateProperty, (Comparable)((Object)BlockRubWood.RubberWoodState.getWet(ModUtils.HORIZONTALS[rand.m_188503_(4)]))));
                            continue;
                        }
                        this.m_5974_((LevelWriter)worldIn, position.m_6630_(j2), (BlockState)woodBlock.m_49966_().m_61124_(BlockRubWood.stateProperty, (Comparable)((Object)BlockRubWood.RubberWoodState.plain_y)));
                    }
                } else {
                    if (biome.m_203656_(Tags.Biomes.IS_SWAMP)) {
                        HashMap<BlockPos, BlockState> map = new HashMap<BlockPos, BlockState>();
                        boolean create = this.createSwampTree(WorldBaseGen.random, position, (WorldGenLevel)worldIn, map);
                        if (create) {
                            for (Map.Entry entry : map.entrySet()) {
                                this.m_5974_((LevelWriter)worldIn, (BlockPos)entry.getKey(), (BlockState)entry.getValue());
                            }
                        }
                        return create;
                    }
                    HashMap<BlockPos, BlockState> map = new HashMap<BlockPos, BlockState>();
                    boolean create = this.createRubTree(WorldBaseGen.random, position, (WorldGenLevel)worldIn, map);
                    if (create) {
                        for (Map.Entry entry : map.entrySet()) {
                            this.m_5974_((LevelWriter)worldIn, (BlockPos)entry.getKey(), (BlockState)entry.getValue());
                        }
                    }
                    return create;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> p_159749_) {
        int rubberTrees;
        LinkedList<Holder> biomes = new LinkedList<Holder>();
        ChunkPos chunkPos = new ChunkPos(p_159749_.m_159777_());
        for (rubberTrees = 0; rubberTrees < 5; ++rubberTrees) {
            int x = chunkPos.m_45604_() + 8 + (rubberTrees & 2) * 15;
            int i = chunkPos.m_45605_() + 8 + ((rubberTrees & 2) >>> 1) * 15;
            BlockPos pos = new BlockPos(x, 0, i);
            biomes.add(p_159749_.m_159774_().m_204166_(pos));
        }
        rubberTrees = 0;
        for (Holder biome : biomes) {
            if (biome == null) continue;
            if (biome.m_203656_(Tags.Biomes.IS_SWAMP)) {
                rubberTrees += WorldBaseGen.random.nextInt(10) + 2;
            }
            if (biome.m_203656_(BiomeTags.f_207610_)) {
                rubberTrees += WorldBaseGen.random.nextInt(15) + 5;
            }
            if (!biome.m_203656_(BiomeTags.f_207611_)) continue;
            rubberTrees += WorldBaseGen.random.nextInt(5) + 1;
        }
        rubberTrees = Math.round((float)rubberTrees * 2.0f);
        if (WorldBaseGen.random.nextInt(100) >= (rubberTrees /= 2)) {
            return false;
        }
        int i = p_159749_.m_225041_().m_188503_(5) + p_159749_.m_225041_().m_188503_(4) + p_159749_.m_225041_().m_188503_(2);
        WorldGenLevel worldIn = p_159749_.m_159774_();
        BlockPos position = p_159749_.m_159777_();
        RandomSource rand = p_159749_.m_225041_();
        if (i <= 3) {
            i = 4;
        }
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                BlockState state = worldIn.m_8055_(position.m_7918_(x, 0, z));
                if (state.m_60767_() != Material.f_76320_ && state.m_60734_() != IUItem.rubWood.getBlock().get()) continue;
                return false;
            }
        }
        boolean flag = true;
        Block woodBlock = (Block)IUItem.rubWood.getBlock().get();
        BlockState leaves = IUItem.leaves.getDefaultState();
        if (position.m_123342_() >= 1 && position.m_123342_() + i + 1 <= 256) {
            for (int j = position.m_123342_(); j <= position.m_123342_() + 1 + i; ++j) {
                int k = 1;
                if (j == position.m_123342_()) {
                    k = 0;
                }
                if (j >= position.m_123342_() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.m_123341_() - k; l <= position.m_123341_() + k && flag; ++l) {
                    for (int i1 = position.m_123343_() - k; i1 <= position.m_123343_() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.m_141928_()) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.m_122178_(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = position.m_7495_();
            BlockState state = worldIn.m_8055_(down);
            boolean isSoil = state.m_60734_().canSustainPlant(state, (BlockGetter)worldIn, down, Direction.UP, (IPlantable)IUItem.rubberSapling.getBlock().get());
            if (isSoil && position.m_123342_() < worldIn.m_141928_() - i - 1) {
                this.onPlantGrow(state, worldIn, down, position);
                Holder biome = worldIn.m_204166_(position);
                if (!biome.m_203656_(Tags.Biomes.IS_SWAMP) && !biome.m_203656_(BiomeTags.f_207610_)) {
                    for (int i2 = position.m_123342_() - i / 2 + i; i2 <= position.m_123342_() + i + 1 + rand.m_188503_(3); ++i2) {
                        int i3;
                        BlockPos blockpos;
                        BlockState state2;
                        int l1;
                        int k1;
                        BlockState state22;
                        BlockPos blockpos2;
                        int[][] offsets;
                        int k2 = i2 - (position.m_123342_() + i + 1);
                        int l2 = 3;
                        if (i2 >= position.m_123342_() + i) {
                            l2 = 1;
                        }
                        if (i2 == position.m_123342_() + i) {
                            for (int[] offset : offsets = new int[][]{{-1, 0}, {0, -1}, {1, 0}, {0, 1}}) {
                                blockpos2 = new BlockPos(position.m_123341_() + offset[0], i2, position.m_123343_() + offset[1]);
                                state22 = worldIn.m_8055_(blockpos2);
                                if (!state22.m_60795_()) continue;
                                worldIn.m_7731_(blockpos2, leaves, 3);
                            }
                        }
                        if (i2 == position.m_123342_() - i / 2 + i + 1) {
                            l2 = 3;
                            for (int[] offset : offsets = new int[][]{{-2, 0}, {0, -2}, {2, 0}, {0, 2}}) {
                                blockpos2 = new BlockPos(position.m_123341_() + offset[0], i2, position.m_123343_() + offset[1]);
                                state22 = worldIn.m_8055_(blockpos2);
                                if (!state22.m_60795_()) continue;
                                worldIn.m_7731_(blockpos2, leaves, 3);
                            }
                        }
                        if (i2 == position.m_123342_() - i / 2 + i) {
                            l2 = 4;
                            if (i > 6) {
                                int i32;
                                for (i32 = position.m_123341_() - l2 / 2; i32 <= position.m_123341_() + l2 / 2; ++i32) {
                                    int j1 = i32 - position.m_123341_();
                                    for (k1 = position.m_123343_() - l2 / 2; k1 <= position.m_123343_() + l2 / 2; ++k1) {
                                        l1 = k1 - position.m_123343_();
                                        if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.m_188503_(2) == 0 || k2 == 0) || !(state2 = worldIn.m_8055_(blockpos = new BlockPos(i32, i2 - 1, k1))).m_60795_()) continue;
                                        worldIn.m_7731_(blockpos, leaves, 3);
                                    }
                                }
                                for (i32 = position.m_123341_() - 2; i32 <= position.m_123341_() + 2; i32 += 4) {
                                    int j1 = i32 - position.m_123341_();
                                    for (k1 = position.m_123343_() - 2; k1 <= position.m_123343_() + 2; k1 += 4) {
                                        l1 = k1 - position.m_123343_();
                                        if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.m_188503_(2) == 0 || k2 == 0) || !(state2 = worldIn.m_8055_(blockpos = new BlockPos(i32, i2 - 1, k1))).m_60795_()) continue;
                                        this.m_5974_((LevelWriter)worldIn, blockpos, Blocks.f_50016_.m_49966_());
                                    }
                                }
                            }
                            l2 = 4;
                        }
                        for (i3 = position.m_123341_() - l2 / 2; i3 <= position.m_123341_() + l2 / 2; ++i3) {
                            int j1 = i3 - position.m_123341_();
                            for (k1 = position.m_123343_() - l2 / 2; k1 <= position.m_123343_() + l2 / 2; ++k1) {
                                l1 = k1 - position.m_123343_();
                                if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.m_188503_(2) == 0 || k2 == 0) || !(state2 = worldIn.m_8055_(blockpos = new BlockPos(i3, i2, k1))).m_60795_()) continue;
                                this.m_5974_((LevelWriter)worldIn, blockpos, leaves);
                            }
                        }
                        if (i2 != position.m_123342_() - i / 2 + i) continue;
                        for (i3 = position.m_123341_() - 2; i3 <= position.m_123341_() + 2; i3 += 4) {
                            int j1 = i3 - position.m_123341_();
                            for (k1 = position.m_123343_() - 2; k1 <= position.m_123343_() + 2; k1 += 4) {
                                l1 = k1 - position.m_123343_();
                                if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.m_188503_(2) == 0 || k2 == 0) || !(state2 = worldIn.m_8055_(blockpos = new BlockPos(i3, i2, k1))).m_60795_()) continue;
                                this.m_5974_((LevelWriter)worldIn, blockpos, Blocks.f_50016_.m_49966_());
                            }
                        }
                    }
                    int treeholechance = 40;
                    for (int j2 = 0; j2 < i; ++j2) {
                        BlockPos upN = position.m_6630_(j2);
                        BlockState state2 = worldIn.m_8055_(upN);
                        if (!state2.m_60795_() && !state2.m_204336_(BlockTags.f_13035_) && state2.m_60734_() != IUItem.rubberSapling.getBlock().get()) continue;
                        if (rand.m_188503_(100) <= treeholechance) {
                            treeholechance -= 10;
                            this.m_5974_((LevelWriter)worldIn, position.m_6630_(j2), (BlockState)woodBlock.m_49966_().m_61124_(BlockRubWood.stateProperty, (Comparable)((Object)BlockRubWood.RubberWoodState.getWet(ModUtils.HORIZONTALS[rand.m_188503_(4)]))));
                            continue;
                        }
                        this.m_5974_((LevelWriter)worldIn, position.m_6630_(j2), (BlockState)woodBlock.m_49966_().m_61124_(BlockRubWood.stateProperty, (Comparable)((Object)BlockRubWood.RubberWoodState.plain_y)));
                    }
                } else {
                    if (biome.m_203656_(Tags.Biomes.IS_SWAMP)) {
                        HashMap<BlockPos, BlockState> map = new HashMap<BlockPos, BlockState>();
                        boolean create = this.createSwampTree(WorldBaseGen.random, position, worldIn, map);
                        if (create) {
                            for (Map.Entry entry : map.entrySet()) {
                                this.m_5974_((LevelWriter)worldIn, (BlockPos)entry.getKey(), (BlockState)entry.getValue());
                            }
                        }
                        return create;
                    }
                    HashMap<BlockPos, BlockState> map = new HashMap<BlockPos, BlockState>();
                    boolean create = this.createRubTree(WorldBaseGen.random, position, worldIn, map);
                    if (create) {
                        for (Map.Entry entry : map.entrySet()) {
                            this.m_5974_((LevelWriter)worldIn, (BlockPos)entry.getKey(), (BlockState)entry.getValue());
                        }
                    }
                    return create;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean createRubTree(Random rand, BlockPos position, WorldGenLevel worldIn, Map<BlockPos, BlockState> map) {
        BlockPos pos2;
        int max = 6 + WorldBaseGen.random.nextInt(3);
        int treeholechance = 90;
        BlockTropicalRubWood woodBlock = (BlockTropicalRubWood)IUItem.tropicalRubWood.getBlock().get();
        BlockState leaves = IUItem.leaves.getDefaultState();
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                BlockPos upN = position.m_7495_().m_7918_(x, 0, z);
                BlockTropicalRubWood.RubberWoodState rubberWoodState = x == 1 || x == -1 ? BlockTropicalRubWood.RubberWoodState.plain_x : BlockTropicalRubWood.RubberWoodState.plain_z;
                pos2 = upN;
                map.put(pos2, (BlockState)woodBlock.m_49966_().m_61124_(BlockTropicalRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
            }
        }
        for (int j2 = 0; j2 < max; ++j2) {
            BlockPos upN = position.m_6630_(j2);
            BlockState state2 = worldIn.m_8055_(upN);
            if (j2 == max - 1) {
                BlockPos upN1;
                for (int x = -2; x < 3; ++x) {
                    for (int z = -2; z < 3; ++z) {
                        int j;
                        int yy;
                        int zz;
                        BlockPos upN2;
                        int xx;
                        if (x == 0 && z == 0 || z != 0 && x != 0) continue;
                        upN1 = upN.m_7918_(x, 0, z);
                        BlockTropicalRubWood.RubberWoodState rubberWoodState = x != 0 ? BlockTropicalRubWood.RubberWoodState.plain_x : BlockTropicalRubWood.RubberWoodState.plain_z;
                        BlockPos pos22 = upN1;
                        map.put(pos22, (BlockState)woodBlock.m_49966_().m_61124_(BlockTropicalRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        upN1 = upN1.m_7494_();
                        if (x <= -1) {
                            upN1 = upN1.m_7918_(-1, 0, 0);
                        } else if (z <= -1) {
                            upN1 = upN1.m_7918_(0, 0, -1);
                        } else if (x >= 1) {
                            upN1 = upN1.m_7918_(1, 0, 0);
                        } else if (z >= 1) {
                            upN1 = upN1.m_7918_(0, 0, 1);
                        }
                        pos22 = upN1;
                        map.put(pos22, (BlockState)woodBlock.m_49966_().m_61124_(BlockTropicalRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        for (xx = -1; xx < 2; ++xx) {
                            for (int zz2 = -1; zz2 < 2; ++zz2) {
                                if (xx == 0 && zz2 == 0 || xx == -1 && zz2 == -1 || xx == 1 && zz2 == 1 || xx == 1 && zz2 == -1 || xx == -1 && zz2 == 1) continue;
                                upN2 = upN1.m_7918_(xx, 0, zz2);
                                map.put(upN2, leaves);
                            }
                        }
                        pos22 = upN1 = upN1.m_7494_();
                        map.put(pos22, leaves);
                        upN1 = upN1.m_7495_();
                        if (x == -2) {
                            for (zz = -1; zz < 2; ++zz) {
                                for (yy = -1; yy < 2; ++yy) {
                                    pos22 = upN2 = upN1.m_7918_(0, yy, zz);
                                    map.put(pos22, leaves);
                                }
                            }
                            upN1 = upN1.m_7918_(-1, 0, 0);
                            for (j = 1; j > -4; --j) {
                                BlockPos upN22;
                                pos22 = upN22 = upN1.m_7918_(0, j, 0);
                                map.put(pos22, leaves);
                                if (j != 0) continue;
                                for (int zz3 = -1; zz3 < 2; ++zz3) {
                                    for (int yy2 = -1; yy2 < 2; ++yy2) {
                                        BlockPos upN3;
                                        if (zz3 == 0 && yy2 == 0 || zz3 == -1 && yy2 == -1 || zz3 == 1 && yy2 == 1 || zz3 == 1 && yy2 == -1 || zz3 == -1 && yy2 == 1) continue;
                                        pos22 = upN3 = upN1.m_7918_(0, yy2, zz3);
                                        map.put(pos22, leaves);
                                    }
                                }
                            }
                            continue;
                        }
                        if (z == -2) {
                            for (xx = -1; xx < 2; ++xx) {
                                for (yy = -1; yy < 2; ++yy) {
                                    pos22 = upN2 = upN1.m_7918_(xx, yy, 0);
                                    map.put(pos22, leaves);
                                }
                            }
                            upN1 = upN1.m_7918_(0, 0, -1);
                            for (j = 1; j > -4; --j) {
                                BlockPos upN23;
                                pos22 = upN23 = upN1.m_7918_(0, j, 0);
                                map.put(pos22, leaves);
                            }
                            continue;
                        }
                        if (x == 2) {
                            for (zz = -1; zz < 2; ++zz) {
                                for (yy = -1; yy < 2; ++yy) {
                                    pos22 = upN2 = upN1.m_7918_(0, yy, zz);
                                    map.put(pos22, leaves);
                                }
                            }
                            upN1 = upN1.m_7918_(1, 0, 0);
                            for (j = 1; j > -4; --j) {
                                BlockPos upN24;
                                pos22 = upN24 = upN1.m_7918_(0, j, 0);
                                map.put(pos22, leaves);
                            }
                            continue;
                        }
                        if (z != 2) continue;
                        for (xx = -1; xx < 2; ++xx) {
                            for (yy = -1; yy < 2; ++yy) {
                                pos22 = upN2 = upN1.m_7918_(xx, yy, 0);
                                map.put(pos22, leaves);
                            }
                        }
                        upN1 = upN1.m_7918_(0, 0, 1);
                        for (j = 1; j > -4; --j) {
                            BlockPos upN25;
                            pos22 = upN25 = upN1.m_7918_(0, j, 0);
                            map.put(pos22, leaves);
                        }
                    }
                }
                upN1 = upN.m_7494_();
                for (int xx = -1; xx < 2; ++xx) {
                    for (int zz = -1; zz < 2; ++zz) {
                        if (!(xx == -1 && zz == -1 || xx == 1 && zz == 1 || xx == 1 && zz == -1 || xx == -1 && zz == 1)) continue;
                        BlockPos upN2 = upN1.m_7918_(xx, 0, zz);
                        map.put(upN2, leaves);
                    }
                }
                pos2 = upN1;
                map.put(pos2, leaves);
                upN1 = upN.m_7494_().m_7494_();
                for (int xx = -1; xx < 2; ++xx) {
                    for (int zz = -1; zz < 2; ++zz) {
                        if (xx == -1 && zz == -1 || xx == 1 && zz == 1 || xx == 1 && zz == -1 || xx == -1 && zz == 1) continue;
                        BlockPos upN2 = upN1.m_7918_(xx, 0, zz);
                        map.put(upN2, leaves);
                    }
                }
            }
            if (!state2.m_60795_() && !state2.m_204336_(BlockTags.f_13035_) && state2.m_60734_() != IUItem.rubberSapling.getBlock().get()) continue;
            if (rand.nextInt(100) <= treeholechance && j2 < max - 1) {
                treeholechance -= 10;
                map.put(position.m_6630_(j2), (BlockState)woodBlock.m_49966_().m_61124_(BlockTropicalRubWood.stateProperty, (Comparable)((Object)BlockTropicalRubWood.RubberWoodState.getWet(ModUtils.HORIZONTALS[rand.nextInt(4)]))));
                continue;
            }
            map.put(position.m_6630_(j2), (BlockState)woodBlock.m_49966_().m_61124_(BlockTropicalRubWood.stateProperty, (Comparable)((Object)BlockTropicalRubWood.RubberWoodState.plain_y)));
        }
        return true;
    }

    private boolean createSwampTree(Random rand, BlockPos position, WorldGenLevel worldIn, Map<BlockPos, BlockState> map) {
        int treeholechance = 60;
        BlockState leaves = IUItem.leaves.getDefaultState();
        BlockSwampRubWood woodBlock = (BlockSwampRubWood)IUItem.swampRubWood.getBlock().get();
        if (rand.nextInt(2) == 0) {
            int max = 7 + rand.nextInt(4);
            Direction facing = null;
            for (int j2 = 0; j2 < max; ++j2) {
                BlockPos upN = position.m_6630_(j2);
                BlockState state2 = worldIn.m_8055_(upN);
                int type = WorldBaseGen.random.nextInt(3);
                if (WorldBaseGen.random.nextInt(100) <= 50 && j2 > 1 && j2 != max - 1) {
                    if (type == 0) {
                        prevFacing = facing;
                        facing = Direction.values()[2 + WorldBaseGen.random.nextInt(4)];
                        while (facing == prevFacing) {
                            facing = Direction.values()[2 + WorldBaseGen.random.nextInt(4)];
                        }
                        BlockPos pos1 = upN.m_121955_(facing.m_122436_());
                        BlockState state1 = worldIn.m_8055_(pos1);
                        if (!state1.m_60795_() && !state1.m_204336_(BlockTags.f_13035_) && state1.m_60734_() != IUItem.rubberSapling.getBlock().get()) {
                            return false;
                        }
                        BlockSwampRubWood.RubberWoodState rubberWoodState = facing.m_122434_() == Direction.Axis.X ? BlockSwampRubWood.RubberWoodState.plain_x : BlockSwampRubWood.RubberWoodState.plain_z;
                        map.put(pos1, (BlockState)woodBlock.m_49966_().m_61124_(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        for (int x = -1; x < 2; ++x) {
                            for (int z = -1; z < 2; ++z) {
                                if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                                BlockPos pos2 = pos1.m_7918_(x, 0, z);
                                BlockState state3 = worldIn.m_8055_(pos2);
                                if (state3.m_60767_() == Material.f_76296_) {
                                    map.put(pos2, leaves);
                                    continue;
                                }
                                return false;
                            }
                        }
                    } else if (type == 1) {
                        int ii;
                        prevFacing = facing;
                        facing = Direction.values()[2 + WorldBaseGen.random.nextInt(4)];
                        while (facing == prevFacing) {
                            facing = Direction.values()[2 + WorldBaseGen.random.nextInt(4)];
                        }
                        BlockPos pos1 = upN;
                        int max1 = 2;
                        for (ii = 0; ii < max1; ++ii) {
                            BlockState state1 = worldIn.m_8055_(pos1 = pos1.m_121955_(facing.m_122436_()));
                            if (!state1.m_60795_() && !state1.m_204336_(BlockTags.f_13035_) && state1.m_60734_() != IUItem.rubberSapling.getBlock().get()) {
                                return false;
                            }
                            BlockSwampRubWood.RubberWoodState rubberWoodState = facing.m_122434_() == Direction.Axis.X ? BlockSwampRubWood.RubberWoodState.plain_x : BlockSwampRubWood.RubberWoodState.plain_z;
                            map.put(pos1, (BlockState)woodBlock.m_49966_().m_61124_(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                            for (int x = -1; x < 2; ++x) {
                                for (int z = -1; z < 2; ++z) {
                                    if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                                    BlockPos pos2 = pos1.m_7918_(x, 0, z);
                                    BlockState state3 = worldIn.m_8055_(pos2);
                                    if (state3.m_60767_() == Material.f_76296_) {
                                        map.put(pos2, leaves);
                                        continue;
                                    }
                                    return false;
                                }
                            }
                        }
                        max1 = 1;
                        for (ii = 0; ii < max1; ++ii) {
                            pos1 = pos1.m_7494_();
                            if (rand.nextInt(100) <= treeholechance) {
                                treeholechance -= 10;
                                this.m_5974_((LevelWriter)worldIn, pos1, (BlockState)woodBlock.m_49966_().m_61124_(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(ModUtils.HORIZONTALS[rand.nextInt(4)]))));
                            } else {
                                this.m_5974_((LevelWriter)worldIn, pos1, (BlockState)woodBlock.m_49966_().m_61124_(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
                            }
                            for (int x = -1; x < 2; ++x) {
                                for (int z = -1; z < 2; ++z) {
                                    if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                                    BlockPos pos2 = pos1.m_7918_(x, 0, z);
                                    BlockState state3 = worldIn.m_8055_(pos2);
                                    if (state3.m_60767_() == Material.f_76296_) {
                                        map.put(pos2, leaves);
                                        continue;
                                    }
                                    return false;
                                }
                            }
                            BlockPos pos2 = pos1.m_7494_();
                            BlockState state3 = worldIn.m_8055_(pos2);
                            if (state3.m_60767_() != Material.f_76296_) {
                                return false;
                            }
                            map.put(pos2, leaves);
                        }
                    }
                }
                if (!state2.m_60795_() && !state2.m_204336_(BlockTags.f_13035_) && state2.m_60734_() != IUItem.rubberSapling.getBlock().get()) continue;
                if (rand.nextInt(100) <= treeholechance) {
                    treeholechance -= 10;
                    map.put(position.m_6630_(j2), (BlockState)woodBlock.m_49966_().m_61124_(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(ModUtils.HORIZONTALS[rand.nextInt(4)]))));
                } else {
                    map.put(position.m_6630_(j2), (BlockState)woodBlock.m_49966_().m_61124_(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
                }
                BlockPos pos = position.m_6630_(j2);
                if (j2 >= 3) {
                    for (int x = -1; x < 2; ++x) {
                        for (int z = -1; z < 2; ++z) {
                            if (x == 0 && z == 0 || j2 >= max - 3 && (x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1)) continue;
                            BlockPos pos1 = pos.m_7918_(x, 0, z);
                            BlockState state1 = worldIn.m_8055_(pos1);
                            if (state1.m_60767_() == Material.f_76296_) {
                                map.put(pos1, leaves);
                                continue;
                            }
                            return false;
                        }
                    }
                }
                if (j2 != max - 1) continue;
                BlockPos pos2 = pos.m_7494_();
                BlockState state3 = worldIn.m_8055_(pos2);
                if (state3.m_60767_() == Material.f_76296_) {
                    map.put(pos2, leaves);
                    continue;
                }
                return false;
            }
        } else {
            treeholechance = 60;
            woodBlock = (BlockSwampRubWood)IUItem.swampRubWood.getBlock().get();
            int max = 5 + rand.nextInt(4);
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                    BlockPos upN = position.m_7495_().m_7918_(x, 0, z);
                    BlockSwampRubWood.RubberWoodState rubberWoodState = x == 1 || x == -1 ? BlockSwampRubWood.RubberWoodState.plain_x : BlockSwampRubWood.RubberWoodState.plain_z;
                    BlockPos pos2 = upN;
                    BlockState state3 = worldIn.m_8055_(pos2);
                    if (state3.m_60767_() != Material.f_76296_) {
                        return false;
                    }
                    map.put(pos2, (BlockState)woodBlock.m_49966_().m_61124_(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                }
            }
            for (int j2 = 0; j2 < max; ++j2) {
                BlockState state3;
                int y;
                BlockPos upN = position.m_6630_(j2);
                BlockState state2 = worldIn.m_8055_(upN);
                if (j2 < max - 1) {
                    if (!state2.m_60795_() && !state2.m_204336_(BlockTags.f_13035_) && state2.m_60734_() != IUItem.rubberSapling.getBlock().get()) continue;
                    if (rand.nextInt(100) <= treeholechance) {
                        treeholechance -= 10;
                        map.put(position.m_6630_(j2), (BlockState)woodBlock.m_49966_().m_61124_(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(ModUtils.HORIZONTALS[rand.nextInt(4)]))));
                        continue;
                    }
                    map.put(position.m_6630_(j2), (BlockState)woodBlock.m_49966_().m_61124_(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
                    continue;
                }
                if (j2 != max - 1) continue;
                if (state2.m_60795_() || state2.m_204336_(BlockTags.f_13035_) || state2.m_60734_() == IUItem.rubberSapling.getBlock().get()) {
                    if (rand.nextInt(100) <= treeholechance) {
                        treeholechance -= 10;
                        map.put(position.m_6630_(j2), (BlockState)woodBlock.m_49966_().m_61124_(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(ModUtils.HORIZONTALS[rand.nextInt(4)]))));
                    } else {
                        map.put(position.m_6630_(j2), (BlockState)woodBlock.m_49966_().m_61124_(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
                    }
                }
                BlockPos upN1 = position.m_6630_(j2);
                for (y = 0; y < 5; ++y) {
                    int radius = 0;
                    if (y < 3) {
                        radius = 3;
                    }
                    if (y == 3) {
                        radius = 1;
                    }
                    if (y == 4) {
                        radius = 0;
                    }
                    for (int x = -radius; x <= radius; ++x) {
                        for (int z = -radius; z <= radius; ++z) {
                            if (x * x + z * z > radius * radius || Math.abs(x) == Math.abs(z) && Math.abs(x) == 2 || y == 2 && (Math.abs(z) == 0 && Math.abs(x) == 3 || Math.abs(z) == 3 && Math.abs(x) == 0)) continue;
                            BlockPos pos = upN1.m_7918_(x, y, z);
                            state2 = worldIn.m_8055_(pos);
                            if (state2.m_60767_() == Material.f_76296_) {
                                map.put(pos, leaves);
                                continue;
                            }
                            return false;
                        }
                    }
                }
                upN1 = position.m_6630_(j2).m_7495_().m_7495_();
                for (y = 0; y < 2; ++y) {
                    for (int x = -1; x < 2; ++x) {
                        for (int z = -1; z < 2; ++z) {
                            if (x == 0 && z == 0 || (y != 0 ? Math.abs(x) != Math.abs(z) : Math.abs(x) == Math.abs(z))) continue;
                            BlockPos upN2 = upN1.m_7918_(x, y, z);
                            state3 = worldIn.m_8055_(upN2);
                            if (state3.m_60767_() == Material.f_76296_) {
                                map.put(upN2, leaves);
                                continue;
                            }
                            return false;
                        }
                    }
                }
                for (int x = -2; x < 3; ++x) {
                    for (int z = -2; z < 3; ++z) {
                        if (x == 0 && z == 0 || z != 0 && x != 0) continue;
                        upN1 = upN.m_7918_(x, 0, z);
                        BlockSwampRubWood.RubberWoodState rubberWoodState = x != 0 ? BlockSwampRubWood.RubberWoodState.plain_x : BlockSwampRubWood.RubberWoodState.plain_z;
                        BlockPos pos2 = upN1;
                        state3 = worldIn.m_8055_(pos2);
                        if (state3.m_60767_() != Material.f_76296_) {
                            return false;
                        }
                        map.put(pos2, (BlockState)woodBlock.m_49966_().m_61124_(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        upN1 = upN1.m_7495_();
                        state3 = worldIn.m_8055_(upN1);
                        if (state3.m_60767_() != Material.f_76296_) {
                            return false;
                        }
                        map.put(upN1, leaves);
                        upN1 = upN1.m_7494_().m_7494_();
                        if (x == -1) {
                            upN1 = upN1.m_7918_(-1, 0, 0);
                        } else if (z == -1) {
                            upN1 = upN1.m_7918_(0, 0, -1);
                        } else if (x == 1) {
                            upN1 = upN1.m_7918_(1, 0, 0);
                        } else {
                            if (z != 1) continue;
                            upN1 = upN1.m_7918_(0, 0, 1);
                        }
                        rubberWoodState = BlockSwampRubWood.RubberWoodState.plain_y;
                        pos2 = upN1;
                        state3 = worldIn.m_8055_(pos2);
                        if (state3.m_60767_() != Material.f_76296_) {
                            return false;
                        }
                        map.put(pos2, (BlockState)woodBlock.m_49966_().m_61124_(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                    }
                }
            }
        }
        return true;
    }

    public void onPlantGrow(BlockState state, WorldGenLevel world, BlockPos pos, BlockPos source) {
        if (state.m_60734_() == Blocks.f_50440_ || state.m_60734_() == Blocks.f_50093_) {
            world.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        }
    }

    public boolean isReplaceable(WorldGenLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60767_() == Material.f_76296_ || state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13106_) || this.canGrowInto(state.m_60734_());
    }
}

