/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world;

import com.denfop.blocks.FluidName;
import com.denfop.blocks.IUFluid;
import com.denfop.world.GenData;
import com.denfop.world.TypeGas;
import com.denfop.world.WorldBaseGen;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Material;

public class WorldGenGas
extends Feature<NoneFeatureConfiguration> {
    public static Map<ChunkPos, GenData> gasMap = new HashMap<ChunkPos, GenData>();
    public static Map<TypeGas, FluidName> gasFluidMap = new HashMap<TypeGas, FluidName>();
    private BlockState block;
    private TypeGas typeGas;

    public WorldGenGas(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public static void registerFluid() {
        gasFluidMap.put(TypeGas.GAS, FluidName.fluidgas);
        gasFluidMap.put(TypeGas.BROMIDE, FluidName.fluidbromine);
        gasFluidMap.put(TypeGas.CHLORINE, FluidName.fluidchlorum);
        gasFluidMap.put(TypeGas.FLUORINE, FluidName.fluidfluor);
        gasFluidMap.put(TypeGas.IODINE, FluidName.fluidiodine);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        if (WorldBaseGen.random.nextInt(900) + 1 > 500) {
            WorldGenLevel level = context.m_159774_();
            ChunkPos chunkPos = new ChunkPos(context.m_159777_());
            int var3 = chunkPos.m_45604_() + WorldBaseGen.random.nextInt(16) + 8;
            int var4 = WorldBaseGen.random.nextInt(WorldBaseGen.random.nextInt(WorldBaseGen.random.nextInt(30) + 20) + 8);
            int var5 = chunkPos.m_45605_() + WorldBaseGen.random.nextInt(16) + 8;
            Holder biome = level.m_204166_(new BlockPos(var3, 0, var5));
            if (biome.m_203656_(BiomeTags.f_207603_) || biome.m_203656_(BiomeTags.f_207605_)) {
                int rand = WorldBaseGen.random.nextInt(100);
                this.typeGas = rand < 50 ? TypeGas.GAS : TypeGas.IODINE;
                this.block = ((IUFluid)((Object)gasFluidMap.get((Object)this.typeGas).getInstance().get())).m_76145_().m_76188_();
                return this.generate(level, WorldBaseGen.random, new BlockPos(var3, var4, var5));
            }
            int rand = WorldBaseGen.random.nextInt(100);
            this.typeGas = rand < 50 ? TypeGas.GAS : (rand < 75 ? TypeGas.BROMIDE : TypeGas.CHLORINE);
            this.block = ((IUFluid)((Object)gasFluidMap.get((Object)this.typeGas).getInstance().get())).m_76145_().m_76188_();
            return this.generate(level, WorldBaseGen.random, new BlockPos(var3, var4, var5));
        }
        return false;
    }

    private boolean generate(WorldGenLevel world, Random rand, BlockPos pos) {
        int k;
        int j;
        int x = pos.m_123341_() - 8;
        int z = pos.m_123343_() - 8;
        int y = pos.m_123342_();
        int xmin = Integer.MAX_VALUE;
        int xmax = Integer.MIN_VALUE;
        int zmin = Integer.MAX_VALUE;
        int zmax = Integer.MIN_VALUE;
        int ymin = 255;
        int ymax = 0;
        if (rand.nextInt(500) <= 450) {
            return false;
        }
        if (y > 40) {
            return false;
        }
        if (y <= 4) {
            return false;
        }
        boolean can = false;
        boolean[] arrayOfBoolean = new boolean[2048];
        int i = rand.nextInt(4) + 4;
        for (int j2 = 0; j2 < i; ++j2) {
            double d1 = rand.nextDouble() * 6.0 + 3.0;
            double d2 = rand.nextDouble() * 4.0 + 2.0;
            double d3 = rand.nextDouble() * 6.0 + 3.0;
            double d4 = rand.nextDouble() * (16.0 - d1 - 2.0) + 1.0 + d1 / 2.0;
            double d5 = rand.nextDouble() * (8.0 - d2 - 4.0) + 2.0 + d2 / 2.0;
            double d6 = rand.nextDouble() * (16.0 - d3 - 2.0) + 1.0 + d3 / 2.0;
            for (int i2 = 1; i2 < 15; ++i2) {
                for (int i3 = 1; i3 < 15; ++i3) {
                    for (int i4 = 1; i4 < 7; ++i4) {
                        double d7 = ((double)i2 - d4) / (d1 / 2.0);
                        double d8 = ((double)i4 - d5) / (d2 / 2.0);
                        double d9 = ((double)i3 - d6) / (d3 / 2.0);
                        double d10 = d7 * d7 + d8 * d8 + d9 * d9;
                        if (!(d10 < 1.0)) continue;
                        arrayOfBoolean[(i2 * 16 + i3) * 8 + i4] = true;
                    }
                }
            }
        }
        for (j = 0; j < 16; ++j) {
            for (k = 0; k < 16; ++k) {
                for (int m = 0; m < 8; ++m) {
                    boolean n;
                    int i1 = (j * 16 + k) * 8 + m;
                    boolean bl = n = arrayOfBoolean[i1] && (j < 15 && arrayOfBoolean[((j + 1) * 16 + k) * 8 + m] || j > 0 && arrayOfBoolean[((j - 1) * 16 + k) * 8 + m] || k < 15 && arrayOfBoolean[(j * 16 + k + 1) * 8 + m] || k > 0 && arrayOfBoolean[(j * 16 + k - 1) * 8 + m] || m < 7 && arrayOfBoolean[(j * 16 + k) * 8 + m + 1] || m > 0 && arrayOfBoolean[i1 - 1]);
                    if (!n) continue;
                    BlockState blockState1 = world.m_8055_(new BlockPos(x + j, y + m, z + k));
                    Material material = blockState1.m_60767_();
                    if (m >= 4 && material.m_76332_()) {
                        return false;
                    }
                    if (m >= 4 || material.m_76333_() || blockState1 == this.block) continue;
                    return false;
                }
            }
        }
        for (j = 0; j < 16; ++j) {
            for (k = 0; k < 16; ++k) {
                for (int m = 0; m < 8; ++m) {
                    if (!arrayOfBoolean[(j * 16 + k) * 8 + m]) continue;
                    BlockPos pos1 = new BlockPos(x + j, y + m, z + k);
                    world.m_7731_(pos1, m >= 4 ? Blocks.f_50016_.m_49966_() : this.block, 2);
                    can = true;
                    if (xmin > x + j) {
                        xmin = x + j;
                    }
                    if (xmax < x + j) {
                        xmax = x + j;
                    }
                    if (zmin > z + k) {
                        zmin = z + k;
                    }
                    if (zmax < z + k) {
                        zmax = z + k;
                    }
                    if (ymin > y + m) {
                        ymin = y + m;
                    }
                    if (ymax >= y + m) continue;
                    ymax = y + m;
                }
            }
        }
        for (j = 0; j < 16; ++j) {
            for (k = 0; k < 16; ++k) {
                for (int m = 4; m < 8; ++m) {
                    BlockState blockState = null;
                    boolean need = arrayOfBoolean[(j * 16 + k) * 8 + m];
                    if (need) {
                        blockState = world.m_8055_(new BlockPos(x + j, y + m - 1, z + k));
                    }
                    if (!need || blockState.m_60734_() != Blocks.f_50493_ && blockState.m_60734_() != Blocks.f_49990_ || world.m_45517_(LightLayer.SKY, new BlockPos(x + j, y + m - 1, z + k)) <= 0) continue;
                    world.m_7731_(new BlockPos(x + j, y + m - 1, z + k), Blocks.f_50440_.m_49966_(), 3);
                }
            }
        }
        if (this.block.m_60767_() == Material.f_76305_) {
            for (j = 0; j < 16; ++j) {
                for (k = 0; k < 16; ++k) {
                    for (int m = 0; m < 8; ++m) {
                        boolean i1;
                        int i2 = (j * 16 + k) * 8 + m;
                        boolean bl = i1 = arrayOfBoolean[i2] && (j < 15 && arrayOfBoolean[((j + 1) * 16 + k) * 8 + m] || j > 0 && arrayOfBoolean[((j - 1) * 16 + k) * 8 + m] || k < 15 && arrayOfBoolean[(j * 16 + k + 1) * 8 + m] || k > 0 && arrayOfBoolean[(j * 16 + k - 1) * 8 + m] || m < 7 && arrayOfBoolean[(j * 16 + k) * 8 + m + 1] || m > 0 && arrayOfBoolean[i2 - 1]);
                        if (!i1 || m >= 4 && rand.nextInt(2) == 0 || !world.m_8055_(new BlockPos(x + j, y + m, z + k)).m_60767_().m_76333_()) continue;
                        world.m_7731_(new BlockPos(x + j, y + m, z + k), this.block, 3);
                        if (xmin > x + j) {
                            xmin = x + j;
                        }
                        if (xmax < x + j) {
                            xmax = x + j;
                        }
                        if (zmin > z + k) {
                            zmin = z + k;
                        }
                        if (zmax < z + k) {
                            zmax = z + k;
                        }
                        if (ymin > y + m) {
                            ymin = y + m;
                        }
                        if (ymax >= y + m) continue;
                        ymax = y + m;
                    }
                }
            }
        }
        int xCenter = (xmin + xmax) / 2;
        int zCenter = (zmin + zmax) / 2;
        int yCenter = (ymin + ymax) / 2;
        if (can) {
            can = false;
            block16: for (int x1 = -1; x1 < 2; ++x1) {
                for (int z1 = -1; z1 < 2; ++z1) {
                    for (int y1 = -1; y1 < 2; ++y1) {
                        if (!world.m_8055_(new BlockPos(xCenter + x1, yCenter + y1, zCenter + z1)).m_60767_().m_76332_()) continue;
                        can = true;
                        break block16;
                    }
                }
            }
            if (can) {
                gasMap.put(new ChunkPos(xCenter >> 4, zCenter >> 4), new GenData(yCenter, xCenter, zCenter, this.typeGas));
            }
        }
        return can;
    }
}

