/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world.vein;

import com.denfop.IUItem;
import com.denfop.blocks.BlockDeposits;
import com.denfop.blocks.BlockDeposits1;
import com.denfop.blocks.BlockDeposits2;
import com.denfop.world.WorldBaseGen;
import com.denfop.world.vein.ChanceOre;
import com.denfop.world.vein.TypeVein;
import com.denfop.world.vein.VeinStructure;
import com.denfop.world.vein.VeinType;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;

public class AlgorithmVein
extends Feature<NoneFeatureConfiguration> {
    public static List<VeinStructure> veinStructureList = new LinkedList<VeinStructure>();
    static Random random = new Random();
    private static Map<ChunkPos, ChunkAccess> chunkPosChunkMap = new HashMap<ChunkPos, ChunkAccess>();

    public AlgorithmVein(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    private static boolean generate(WorldGenLevel level, VeinType veinType, BlockPos blockPos, ChunkAccess chunk, int meta1) {
        block128: {
            block129: {
                BlockPos pos1;
                int chance_type;
                block127: {
                    int k;
                    if (random.nextInt(3) > 0) {
                        return false;
                    }
                    Holder biome = level.m_204166_(blockPos);
                    int value = random.nextInt(101 + (biome.m_203656_(BiomeTags.f_207608_) ? 20 : 0));
                    if (value <= 55) {
                        veinType.setVein(TypeVein.SMALL);
                    } else if (value < 86) {
                        veinType.setVein(TypeVein.MEDIUM);
                    } else if (value < 100) {
                        veinType.setVein(TypeVein.BIG);
                    }
                    chance_type = random.nextInt(101);
                    if (chance_type > 15 || !biome.m_203656_(BiomeTags.f_207608_)) break block127;
                    ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
                    int height = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, blockPos.m_123341_(), blockPos.m_123343_());
                    int radius = 10;
                    if (veinType.getVein() == TypeVein.SMALL) {
                        radius = level.m_213780_().m_188503_(4) + 2;
                    } else if (veinType.getVein() == TypeVein.MEDIUM) {
                        radius = level.m_213780_().m_188503_(6) + 3;
                    } else if (veinType.getVein() == TypeVein.BIG) {
                        radius = level.m_213780_().m_188503_(7) + 5;
                    }
                    BlockPos pos = new BlockPos((double)blockPos.m_123341_(), (double)height - (double)radius * 0.9 - (double)random.nextInt(15), (double)blockPos.m_123343_());
                    ChunkPos chunkPos = null;
                    ChunkAccess chunk1 = null;
                    for (int x = -radius; x <= radius; ++x) {
                        for (int y = -radius; y <= radius; ++y) {
                            for (int z = -radius; z <= radius; ++z) {
                                double distance = Math.sqrt(x * x + y * y + z * z);
                                if (distance <= (double)radius && distance > (double)radius * 0.45) {
                                    int meta = random.nextInt(veinType.getOres().size());
                                    ChanceOre ore = veinType.getOres().get(meta);
                                    BlockPos pos12 = pos.m_7918_(x, y, z);
                                    if (!ore.needGenerate(level) || random.nextInt(100) <= 50) continue;
                                    if (chunk1 == null || chunkPos == null) {
                                        chunk1 = level.m_6522_(pos12.m_123341_() >> 4, pos12.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                        if (chunk1 == null) continue;
                                        chunkPos = chunk1.m_7697_();
                                    } else if (pos12.m_123341_() >> 4 != chunkPos.f_45578_ && pos12.m_123343_() >> 4 != chunk.m_7697_().f_45579_) {
                                        chunk1 = level.m_6522_(pos12.m_123341_() >> 4, pos12.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                        if (chunk1 == null) continue;
                                        chunkPos = chunk1.m_7697_();
                                    }
                                    if (!AlgorithmVein.canGenerateSphere(level, pos12, chunk1)) continue;
                                    blockPosList.add(pos12);
                                    AlgorithmVein.setBlockState1(level, pos12, ore.getBlock(), 2);
                                    continue;
                                }
                                if (distance <= (double)radius && distance >= (double)radius * 0.35) {
                                    BlockPos pos13 = pos.m_7918_(x, y, z);
                                    if (veinType.getHeavyOre() != null) {
                                        if (random.nextInt(100) <= 40 || !AlgorithmVein.canGenerateSphere(level, pos13, chunk1)) continue;
                                        blockPosList.add(pos13);
                                        AlgorithmVein.setBlockState1(level, pos13, veinType.getHeavyOre().getStateMeta(veinType.getMeta()), 2);
                                        continue;
                                    }
                                    int meta = random.nextInt(veinType.getOres().size());
                                    ChanceOre ore = veinType.getOres().get(meta);
                                    if (!ore.needGenerate(level) || random.nextInt(100) <= 50) continue;
                                    if (chunk1 == null || chunkPos == null) {
                                        chunk1 = level.m_6522_(pos13.m_123341_() >> 4, pos13.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                        if (chunk1 == null) continue;
                                        chunkPos = chunk1.m_7697_();
                                    } else if (pos13.m_123341_() >> 4 != chunkPos.f_45578_ && pos13.m_123343_() >> 4 != chunk.m_7697_().f_45579_) {
                                        chunk1 = level.m_6522_(pos13.m_123341_() >> 4, pos13.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                        if (chunk1 == null) continue;
                                        chunkPos = chunk1.m_7697_();
                                    }
                                    if (!AlgorithmVein.canGenerateSphere(level, pos13, chunk1)) continue;
                                    blockPosList.add(pos13);
                                    AlgorithmVein.setBlockState1(level, pos13, ore.getBlock(), 2);
                                    continue;
                                }
                                if (!(distance <= (double)radius) || !(distance < (double)radius * 0.35)) continue;
                                BlockPos pos14 = pos.m_7918_(x, y, z);
                                AlgorithmVein.setBlockState1(level, pos14, Blocks.f_50016_.m_49966_(), 2);
                            }
                        }
                    }
                    int ii = 0;
                    switch (veinType.getVein()) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case SMALL: {
                            int n = 5;
                            break;
                        }
                        case MEDIUM: {
                            int n = 10;
                            break;
                        }
                        case BIG: {
                            int n = k = 15;
                        }
                    }
                    while (ii < k && !blockPosList.isEmpty()) {
                        int y;
                        BlockPos pos15 = (BlockPos)blockPosList.get(random.nextInt(blockPosList.size()));
                        if (chunk1 == null) {
                            chunk1 = level.m_6522_(pos15.m_123341_() >> 4, pos15.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                            chunkPos = chunk1.m_7697_();
                        } else if (pos15.m_123341_() >> 4 != chunkPos.f_45578_ && pos15.m_123343_() >> 4 != chunk.m_7697_().f_45579_) {
                            chunk1 = level.m_6522_(pos15.m_123341_() >> 4, pos15.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                            chunkPos = chunk1.m_7697_();
                        }
                        int height1 = y = chunk1.m_5885_(Heightmap.Types.WORLD_SURFACE, pos15.m_123341_(), pos15.m_123343_());
                        BlockPos pos2 = null;
                        boolean need = false;
                        while (height1 - 3 < y) {
                            pos2 = new BlockPos(pos15.m_123341_(), y - 1, pos15.m_123343_());
                            BlockState oldState = level.m_8055_(pos2);
                            pos2 = new BlockPos(pos15.m_123341_(), y + 1, pos15.m_123343_());
                            BlockState upState = level.m_8055_(pos2);
                            pos2 = new BlockPos(pos15.m_123341_(), y, pos15.m_123343_());
                            BlockState oldState1 = level.m_8055_(pos2);
                            boolean canSpawn = AlgorithmVein.canSpawn(oldState, oldState1, upState);
                            if (canSpawn) {
                                need = true;
                                break;
                            }
                            --y;
                        }
                        if (!need) {
                            blockPosList.remove(pos15);
                            continue;
                        }
                        FluidState fluidState = level.m_6425_(pos2);
                        if (meta1 < 16) {
                            AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits)IUItem.blockdeposits.getBlock(BlockDeposits.Type.getFromID(meta1)).get()).m_49966_().m_61124_((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.f_76191_.m_76145_() && fluidState.m_76152_() == Fluids.f_76193_)), 3);
                        } else if (meta1 < 32) {
                            AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits1)IUItem.blockdeposits1.getBlock(BlockDeposits1.Type.getFromID(meta1 - 16)).get()).m_49966_().m_61124_((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.f_76191_.m_76145_() && fluidState.m_76152_() == Fluids.f_76193_)), 3);
                        } else {
                            AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits2)IUItem.blockdeposits2.getBlock(BlockDeposits2.Type.getFromID(meta1 - 32)).get()).m_49966_().m_61124_((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.f_76191_.m_76145_() && fluidState.m_76152_() == Fluids.f_76193_)), 3);
                        }
                        ++ii;
                        blockPosList.remove(pos15);
                    }
                    break block128;
                }
                if (chance_type > 80) break block129;
                ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
                int height = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, blockPos.m_123341_(), blockPos.m_123343_());
                BlockPos pos = new BlockPos(blockPos.m_123341_(), height / 2 + height / 4, blockPos.m_123343_());
                int x1 = random.nextInt(veinType.getVein().getMax()) + 3;
                int y1 = random.nextInt(veinType.getVein().getMax()) + 3;
                int z1 = random.nextInt(veinType.getVein().getMax()) + 3;
                int minX = 10;
                int minY = 10;
                int minZ = 10;
                int maxX = -10;
                int maxY = -10;
                int maxZ = -10;
                ChunkPos chunkPos = null;
                ChunkAccess chunk1 = null;
                for (int x = -x1; x < x1 + 1; ++x) {
                    for (int y = -y1; y < y1; ++y) {
                        for (int z = -z1; z < z1 + 1; ++z) {
                            int meta = random.nextInt(veinType.getOres().size());
                            ChanceOre ore = veinType.getOres().get(meta);
                            int need = Math.max(Math.max(x, y), z);
                            if (need < veinType.getVein().getMinNeed()) {
                                need = 0;
                            }
                            BlockPos pos16 = pos.m_7918_(x, y, z);
                            if (chunk1 == null || chunkPos == null) {
                                chunk1 = level.m_6522_(pos16.m_123341_() >> 4, pos16.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                if (chunk1 == null) continue;
                                chunkPos = chunk1.m_7697_();
                            } else if (pos16.m_123341_() >> 4 != chunkPos.f_45578_ && pos16.m_123343_() >> 4 != chunk.m_7697_().f_45579_) {
                                chunk1 = level.m_6522_(pos16.m_123341_() >> 4, pos16.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                if (chunk1 == null) continue;
                                chunkPos = chunk1.m_7697_();
                            }
                            if (random.nextInt(50) > 10 && ore.needGenerate(level) && (need == 0 || random.nextInt(100 - Math.min(need * veinType.getVein().getNeed(), 90)) > 50) && AlgorithmVein.canGenerate(level, pos16, chunk1)) {
                                if (x < minX) {
                                    minX = x;
                                }
                                if (x > maxX) {
                                    maxX = x;
                                }
                                if (y < minY) {
                                    minY = y;
                                }
                                if (y > maxY) {
                                    maxY = y;
                                }
                                if (z < minZ) {
                                    minZ = z;
                                }
                                if (z > maxZ) {
                                    maxZ = z;
                                }
                                blockPosList.add(pos16);
                                AlgorithmVein.setBlockState1(level, pos16, ore.getBlock(), 2);
                                continue;
                            }
                            if (veinType.getHeavyOre() == null || random.nextInt(50) <= 40 || random.nextInt(100 - Math.min(need * veinType.getVein().getNeed(), 90)) <= 50 || !AlgorithmVein.canGenerate(level, pos16, chunk1)) continue;
                            blockPosList.add(pos16);
                            AlgorithmVein.setBlockState1(level, pos16, veinType.getHeavyOre().getStateMeta(veinType.getMeta()), 2);
                            if (x < minX) {
                                minX = x;
                            }
                            if (x > maxX) {
                                maxX = x;
                            }
                            if (y < minY) {
                                minY = y;
                            }
                            if (y > maxY) {
                                maxY = y;
                            }
                            if (z < minZ) {
                                minZ = z;
                            }
                            if (z <= maxZ) continue;
                            maxZ = z;
                        }
                    }
                }
                int[] numbers = new int[]{maxY, minY, maxX, minX, maxZ, minZ};
                int[] number2 = new int[]{1, 0, 3, 2, 5, 4};
                int[] yxz = new int[]{0, 0, 0};
                int[][] yxz1 = new int[][]{{1, 2}, {0, 2}, {0, 1}};
                int[][] numbers1 = new int[][]{{3, 2, 5, 4}, {1, 0, 5, 4}, {1, 0, 3, 2}};
                chunk1 = null;
                chunkPos = null;
                int level1 = 1;
                int i = random.nextInt(6);
                while (level1 < veinType.getVein().getLevel() + 1) {
                    block134: {
                        ChanceOre ore;
                        int meta;
                        block130: {
                            if (i % 2 != 0) break block130;
                            yxz[i / 2] = numbers[i];
                            while (yxz[i / 2] < random.nextInt(veinType.getVein().getMax_length()) + 3 + numbers[i] + 1) {
                                yxz[yxz1[i / 2][0]] = numbers[numbers1[i / 2][0]] + level1 * 2;
                                while (yxz[yxz1[i / 2][0]] < numbers[numbers1[i / 2][1]] - level1 * 2 + 1) {
                                    yxz[yxz1[i / 2][1]] = numbers[numbers1[i / 2][2]] + level1 * 2;
                                    while (yxz[yxz1[i / 2][1]] < numbers[numbers1[i / 2][3]] - level1 * 2 + 1) {
                                        block131: {
                                            block133: {
                                                block132: {
                                                    meta = random.nextInt(veinType.getOres().size());
                                                    ore = veinType.getOres().get(meta);
                                                    if (!ore.needGenerate(level) || random.nextInt(100) <= 50) break block131;
                                                    pos1 = pos.m_7918_(yxz[1], yxz[0], yxz[2]);
                                                    if (chunk1 != null && chunkPos != null) break block132;
                                                    chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                                    if (chunk1 == null) break block131;
                                                    chunkPos = chunk1.m_7697_();
                                                    break block133;
                                                }
                                                if (pos1.m_123341_() >> 4 == chunkPos.f_45578_ || pos1.m_123343_() >> 4 == chunk.m_7697_().f_45579_) break block133;
                                                chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                                if (chunk1 == null) break block131;
                                                chunkPos = chunk1.m_7697_();
                                            }
                                            if (AlgorithmVein.canGenerate(level, pos1, chunk1)) {
                                                blockPosList.add(pos1);
                                                AlgorithmVein.setBlockState1(level, pos1, ore.getBlock(), 2);
                                            }
                                        }
                                        int n = yxz1[i / 2][1];
                                        yxz[n] = yxz[n] + 1;
                                    }
                                    int n = yxz1[i / 2][0];
                                    yxz[n] = yxz[n] + 1;
                                }
                                int n = i / 2;
                                yxz[n] = yxz[n] + 1;
                            }
                            break block134;
                        }
                        yxz[i / 2] = numbers[i];
                        while (yxz[i / 2] > numbers[i] - random.nextInt(veinType.getVein().getMax_length()) - 4) {
                            yxz[yxz1[i / 2][0]] = numbers[numbers1[i / 2][0]] + level1 * 2;
                            while (yxz[yxz1[i / 2][0]] < numbers[numbers1[i / 2][1]] - level1 * 2 + 1) {
                                yxz[yxz1[i / 2][1]] = numbers[numbers1[i / 2][2]] + level1 * 2;
                                while (yxz[yxz1[i / 2][1]] < numbers[numbers1[i / 2][3]] - level1 * 2 + 1) {
                                    block135: {
                                        block137: {
                                            block136: {
                                                meta = random.nextInt(veinType.getOres().size());
                                                ore = veinType.getOres().get(meta);
                                                if (!ore.needGenerate(level) || random.nextInt(100) <= 50) break block135;
                                                pos1 = pos.m_7918_(yxz[1], yxz[0], yxz[2]);
                                                if (chunk1 != null && chunkPos != null) break block136;
                                                chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                                if (chunk1 == null) break block135;
                                                chunkPos = chunk1.m_7697_();
                                                break block137;
                                            }
                                            if (pos1.m_123341_() >> 4 == chunkPos.f_45578_ || pos1.m_123343_() >> 4 == chunk.m_7697_().f_45579_) break block137;
                                            chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                            if (chunk1 == null) break block135;
                                            chunkPos = chunk1.m_7697_();
                                        }
                                        if (AlgorithmVein.canGenerate(level, pos1, chunk1)) {
                                            blockPosList.add(pos1);
                                            AlgorithmVein.setBlockState1(level, pos1, ore.getBlock(), 2);
                                        }
                                    }
                                    int n = yxz1[i / 2][1];
                                    yxz[n] = yxz[n] + 1;
                                }
                                int n = yxz1[i / 2][0];
                                yxz[n] = yxz[n] + 1;
                            }
                            int n = i / 2;
                            yxz[n] = yxz[n] - 1;
                        }
                    }
                    int n = number2[i];
                    numbers[n] = numbers[n] + (yxz[i / 2] - numbers[i]);
                    numbers[i] = yxz[i / 2];
                    ++level1;
                    int prev = i;
                    random.nextInt();
                    i = random.nextInt(6);
                    while (i != prev) {
                        i = random.nextInt(6);
                    }
                }
                int k = 0;
                switch (veinType.getVein()) {
                    case SMALL: {
                        k = 5;
                        break;
                    }
                    case MEDIUM: {
                        k = 10;
                        break;
                    }
                    case BIG: {
                        k = 15;
                    }
                }
                chunk1 = null;
                int ii = 0;
                while (ii < k && !blockPosList.isEmpty()) {
                    int y;
                    pos1 = (BlockPos)blockPosList.get(random.nextInt(blockPosList.size()));
                    if (chunk1 == null) {
                        chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                        if (chunk1 == null) {
                            ++i;
                            continue;
                        }
                        chunkPos = chunk1.m_7697_();
                    } else if (pos1.m_123341_() >> 4 != chunkPos.f_45578_ && pos1.m_123343_() >> 4 != chunk.m_7697_().f_45579_) {
                        chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                        if (chunk1 == null) {
                            ++i;
                            continue;
                        }
                        chunkPos = chunk1.m_7697_();
                    }
                    int height1 = y = chunk1.m_5885_(Heightmap.Types.WORLD_SURFACE, pos1.m_123341_(), pos1.m_123343_());
                    BlockPos pos2 = null;
                    boolean need = false;
                    while (height1 - 3 < y) {
                        pos2 = new BlockPos(pos1.m_123341_(), y - 1, pos1.m_123343_());
                        BlockState oldState = level.m_8055_(pos2);
                        pos2 = new BlockPos(pos1.m_123341_(), y + 1, pos1.m_123343_());
                        BlockState upState = level.m_8055_(pos2);
                        pos2 = new BlockPos(pos1.m_123341_(), y, pos1.m_123343_());
                        BlockState oldState1 = level.m_8055_(pos2);
                        boolean canSpawn = AlgorithmVein.canSpawn(oldState, oldState1, upState);
                        if (canSpawn) {
                            need = true;
                            break;
                        }
                        --y;
                    }
                    if (!need) {
                        blockPosList.remove(pos1);
                        continue;
                    }
                    FluidState fluidState = level.m_6425_(pos2);
                    if (meta1 < 16) {
                        AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits)IUItem.blockdeposits.getBlock(BlockDeposits.Type.getFromID(meta1)).get()).m_49966_().m_61124_((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.f_76191_.m_76145_() && fluidState.m_76152_() == Fluids.f_76193_)), 3);
                    } else if (meta1 < 32) {
                        AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits1)IUItem.blockdeposits1.getBlock(BlockDeposits1.Type.getFromID(meta1 - 16)).get()).m_49966_().m_61124_((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.f_76191_.m_76145_() && fluidState.m_76152_() == Fluids.f_76193_)), 3);
                    } else {
                        AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits2)IUItem.blockdeposits2.getBlock(BlockDeposits2.Type.getFromID(meta1 - 32)).get()).m_49966_().m_61124_((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.f_76191_.m_76145_() && fluidState.m_76152_() == Fluids.f_76193_)), 3);
                    }
                    ++ii;
                    blockPosList.remove(pos1);
                }
                break block128;
            }
            int height = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, blockPos.m_123341_(), blockPos.m_123343_());
            BlockPos pos = new BlockPos(blockPos.m_123341_(), height / 2 + height / 4, blockPos.m_123343_());
            int centerX = pos.m_123341_();
            int centerY = pos.m_123342_();
            int centerZ = pos.m_123343_();
            int R = 0;
            int r = 0;
            int y1 = 0;
            if (veinType.getVein() == TypeVein.SMALL) {
                R = level.m_213780_().m_188503_(4) + 3;
                r = level.m_213780_().m_188503_(3) + 2;
                y1 = level.m_213780_().m_188503_(3) + 1;
            } else if (veinType.getVein() == TypeVein.MEDIUM) {
                R = level.m_213780_().m_188503_(6) + 3;
                r = level.m_213780_().m_188503_(4) + 3;
                y1 = level.m_213780_().m_188503_(3) + 2;
            } else if (veinType.getVein() == TypeVein.BIG) {
                R = level.m_213780_().m_188503_(7) + 5;
                r = level.m_213780_().m_188503_(4) + 4;
                y1 = level.m_213780_().m_188503_(5) + 3;
            }
            ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
            ChunkPos chunkPos = null;
            ChunkAccess chunk1 = null;
            for (int y2 = centerY - y1; y2 < centerY + y1; ++y2) {
                for (int x = -(R + r); x <= R + r; ++x) {
                    for (int z = -(R + r); z <= R + r; ++z) {
                        ChanceOre ore;
                        int meta;
                        BlockPos pos1;
                        if (x * x + z * z <= (R + r) * (R + r) && x * x + z * z > r * r) {
                            pos1 = new BlockPos(centerX + x, y2, centerZ + z);
                            meta = random.nextInt(veinType.getOres().size());
                            ore = veinType.getOres().get(meta);
                            if (!ore.needGenerate(level) || random.nextInt(100) <= 50) continue;
                            if (chunk1 == null || chunkPos == null) {
                                chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                if (chunk1 == null) continue;
                                chunkPos = chunk1.m_7697_();
                            } else if (pos1.m_123341_() >> 4 != chunkPos.f_45578_ && pos1.m_123343_() >> 4 != chunk.m_7697_().f_45579_) {
                                chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                if (chunk1 == null) continue;
                                chunkPos = chunk1.m_7697_();
                            }
                            if (!AlgorithmVein.canGenerate(level, pos1, chunk1)) continue;
                            blockPosList.add(pos1);
                            AlgorithmVein.setBlockState1(level, pos1, ore.getBlock(), 2);
                            continue;
                        }
                        if (x * x + z * z > (R + r) * (R + r) || x * x + z * z < r * r) continue;
                        pos1 = new BlockPos(centerX + x, y2, centerZ + z);
                        if (chunk1 == null || chunkPos == null) {
                            chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                            if (chunk1 == null) continue;
                            chunkPos = chunk1.m_7697_();
                        } else if (pos1.m_123341_() >> 4 != chunkPos.f_45578_ && pos1.m_123343_() >> 4 != chunk.m_7697_().f_45579_) {
                            chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                            if (chunk1 == null) continue;
                            chunkPos = chunk1.m_7697_();
                        }
                        if (veinType.getHeavyOre() != null) {
                            if (random.nextInt(100) <= 40 || !AlgorithmVein.canGenerate(level, pos1, chunk1)) continue;
                            blockPosList.add(pos1);
                            AlgorithmVein.setBlockState1(level, pos1, veinType.getHeavyOre().getStateMeta(veinType.getMeta()), 2);
                            continue;
                        }
                        meta = random.nextInt(veinType.getOres().size());
                        ore = veinType.getOres().get(meta);
                        if (!ore.needGenerate(level) || random.nextInt(100) <= 50) continue;
                        if (chunk1 == null || chunkPos == null) {
                            chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                            if (chunk1 == null) continue;
                            chunkPos = chunk1.m_7697_();
                        } else if (pos1.m_123341_() >> 4 != chunkPos.f_45578_ && pos1.m_123343_() >> 4 != chunk.m_7697_().f_45579_) {
                            chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                            if (chunk1 == null) continue;
                            chunkPos = chunk1.m_7697_();
                        }
                        if (!AlgorithmVein.canGenerate(level, pos1, chunk1)) continue;
                        blockPosList.add(pos1);
                        AlgorithmVein.setBlockState1(level, pos1, ore.getBlock(), 2);
                    }
                }
            }
            chunk1 = null;
            int ii = 0;
            int k = 0;
            switch (veinType.getVein()) {
                case SMALL: {
                    k = 5;
                    break;
                }
                case MEDIUM: {
                    k = 10;
                    break;
                }
                case BIG: {
                    k = 15;
                }
            }
            while (ii < k && !blockPosList.isEmpty()) {
                int y;
                BlockPos pos1 = (BlockPos)blockPosList.get(random.nextInt(blockPosList.size()));
                if (chunk1 == null) {
                    chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                    chunkPos = chunk1.m_7697_();
                } else if (pos1.m_123341_() >> 4 != chunkPos.f_45578_ && pos1.m_123343_() >> 4 != chunk.m_7697_().f_45579_) {
                    chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                    chunkPos = chunk1.m_7697_();
                }
                int height1 = y = chunk1.m_5885_(Heightmap.Types.WORLD_SURFACE, pos1.m_123341_(), pos1.m_123343_());
                BlockPos pos2 = null;
                boolean need = false;
                while (height1 - 3 < y) {
                    pos2 = new BlockPos(pos1.m_123341_(), y - 1, pos1.m_123343_());
                    BlockState oldState = level.m_8055_(pos2);
                    pos2 = new BlockPos(pos1.m_123341_(), y + 1, pos1.m_123343_());
                    BlockState upState = level.m_8055_(pos2);
                    pos2 = new BlockPos(pos1.m_123341_(), y, pos1.m_123343_());
                    BlockState oldState1 = level.m_8055_(pos2);
                    boolean canSpawn = AlgorithmVein.canSpawn(oldState, oldState1, upState);
                    if (canSpawn) {
                        need = true;
                        break;
                    }
                    --y;
                }
                if (!need) {
                    blockPosList.remove(pos1);
                    continue;
                }
                FluidState fluidState = level.m_6425_(pos2);
                if (meta1 < 16) {
                    AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits)IUItem.blockdeposits.getBlock(BlockDeposits.Type.getFromID(meta1)).get()).m_49966_().m_61124_((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.f_76191_.m_76145_() && fluidState.m_76152_() == Fluids.f_76193_)), 3);
                } else if (meta1 < 32) {
                    AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits1)IUItem.blockdeposits1.getBlock(BlockDeposits1.Type.getFromID(meta1 - 16)).get()).m_49966_().m_61124_((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.f_76191_.m_76145_() && fluidState.m_76152_() == Fluids.f_76193_)), 3);
                } else {
                    AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits2)IUItem.blockdeposits2.getBlock(BlockDeposits2.Type.getFromID(meta1 - 32)).get()).m_49966_().m_61124_((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.f_76191_.m_76145_() && fluidState.m_76152_() == Fluids.f_76193_)), 3);
                }
                ++ii;
                blockPosList.remove(pos1);
            }
        }
        chunkPosChunkMap.clear();
        return true;
    }

    public static void setBlockState1(WorldGenLevel level, BlockPos p_46605_, BlockState p_46606_, int p_46607_) {
        level.m_7731_(p_46605_, p_46606_, p_46607_);
    }

    private static boolean canGenerateSphere(WorldGenLevel world, BlockPos pos, ChunkAccess chunk) {
        BlockState state = world.m_8055_(pos);
        if (pos.m_123342_() >= 60) {
            if (state.m_60767_() == Material.f_76296_ || pos.m_123342_() >= chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()) - 4) {
                return false;
            }
            return state.m_60767_() != Material.f_76317_ && state.m_60767_() != Material.f_76313_ && state.m_60767_() != Material.f_76320_ && !state.m_60767_().m_76332_();
        }
        if (state.m_60767_() == Material.f_76296_ || pos.m_123342_() >= chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()) - 4) {
            return false;
        }
        if (state.m_60767_() == Material.f_76315_ || state.m_60767_() == Material.f_76317_ || state.m_60767_() == Material.f_76313_ || state.m_60767_() == Material.f_76320_ || state.m_60767_().m_76332_()) {
            return false;
        }
        return state.m_60800_((BlockGetter)chunk, pos) != -1.0f;
    }

    private static boolean canSpawn(BlockState underState, BlockState state, BlockState upState) {
        boolean can;
        Block block = underState.m_60734_();
        boolean bl = can = block == Blocks.f_50440_ || block == Blocks.f_49994_ || block == Blocks.f_50493_ || block == Blocks.f_49992_ || block == Blocks.f_50652_ || block == Blocks.f_50069_;
        if (can) {
            if (state.m_60767_() == Material.f_76296_ || state.m_60767_() == Material.f_76302_ || state.m_60734_() == Blocks.f_50359_ || state.m_60734_() == Blocks.f_50360_ || state.m_60734_() == Blocks.f_50357_) {
                return true;
            }
            return state.m_60767_().m_76332_() && upState.m_60767_().m_76332_();
        }
        return false;
    }

    private static boolean canGenerate(WorldGenLevel world, BlockPos pos, ChunkAccess chunk) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60767_() == Material.f_76296_ || pos.m_123342_() >= chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()) - 4) {
            return false;
        }
        if (pos.m_123342_() >= 60) {
            return false;
        }
        if (state.m_60767_() == Material.f_76315_ || state.m_60767_() == Material.f_76317_ || state.m_60767_() == Material.f_76313_ || state.m_60767_() == Material.f_76320_ || state.m_60767_().m_76332_()) {
            return false;
        }
        return state.m_60767_() == Material.f_76296_ || state.m_60800_((BlockGetter)chunk, pos) != -1.0f;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> p_159749_) {
        if (WorldBaseGen.random.nextInt(4) <= 2) {
            if (WorldBaseGen.veinTypes1.isEmpty()) {
                WorldBaseGen.veinTypes1 = new ArrayList<VeinType>(WorldBaseGen.veinTypes);
            }
            int meta = WorldBaseGen.random.nextInt(WorldBaseGen.veinTypes1.size());
            VeinType veinType = WorldBaseGen.veinTypes1.remove(meta);
            BlockPos origin = p_159749_.m_159777_();
            ChunkPos chunkPos = new ChunkPos(origin);
            ChunkAccess chunk = p_159749_.m_159774_().m_6522_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62314_, false);
            VeinStructure veinStructure = new VeinStructure(p_159749_.m_159774_(), veinType, new BlockPos(chunkPos.f_45578_ * 16 + random.nextInt(16), 2, chunkPos.f_45579_ * 16 + random.nextInt(16)), chunk, veinType.getDeposits_meta());
            return AlgorithmVein.generate(p_159749_.m_159774_(), veinStructure.getVeinType(), veinStructure.getBlockPos(), veinStructure.getChunk(), veinStructure.getDepositsMeta());
        }
        return false;
    }
}

