/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies.building;

import com.denfop.api.space.colonies.Building;
import com.denfop.api.space.colonies.Colony;
import com.denfop.api.space.colonies.api.IColony;
import com.denfop.api.space.colonies.api.building.IColonyStorage;
import com.denfop.api.space.colonies.api.building.IStorage;
import com.denfop.api.space.colonies.building.Storage;
import com.denfop.api.space.colonies.enums.EnumProblems;
import com.denfop.api.space.colonies.enums.EnumTypeBuilding;
import com.denfop.network.packet.CustomPacketBuffer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class StorageBuilding
extends Building
implements IColonyStorage {
    boolean work;
    IStorage storage;
    byte energy;
    byte peoples;

    public StorageBuilding(IColony colonie, boolean simulate) {
        super(colonie);
        this.storage = new Storage(this);
        this.energy = (byte)10;
        this.peoples = 0;
        this.work = true;
        if (!simulate) {
            this.getColony().addStorage(this.storage);
            this.getColony().addBuilding(this);
        }
    }

    public StorageBuilding(CustomPacketBuffer packetBuffer, Colony colony) {
        super(colony);
        this.peoples = packetBuffer.readByte();
        this.energy = (byte)10;
        this.work = packetBuffer.readBoolean();
        this.storage = new Storage(packetBuffer, this);
        this.getColony().addStorage(this.storage);
        this.getColony().addBuilding(this);
    }

    public StorageBuilding(CompoundTag tag, HolderLookup.Provider p_323640_, IColony colonie) {
        super(colonie);
        this.peoples = tag.getByte("people");
        this.energy = (byte)10;
        this.work = tag.getBoolean("work");
        this.storage = new Storage(tag.getCompound("storage"), p_323640_, this);
        this.getColony().addStorage(this.storage);
        this.getColony().addBuilding(this);
    }

    @Override
    public CustomPacketBuffer writePacket(CustomPacketBuffer customPacketBuffer) {
        super.writePacket(customPacketBuffer);
        customPacketBuffer.writeByte(this.peoples);
        customPacketBuffer.writeBoolean(this.work);
        this.storage.writePacket(customPacketBuffer);
        return customPacketBuffer;
    }

    @Override
    public byte getId() {
        return 7;
    }

    @Override
    public CompoundTag writeTag(CompoundTag tag, HolderLookup.Provider p_323640_) {
        super.writeTag(tag, p_323640_);
        tag.putByte("people", this.peoples);
        tag.putBoolean("work", this.work);
        tag.put("storage", (Tag)this.getStorage().writeNBT(new CompoundTag(), p_323640_));
        return tag;
    }

    @Override
    public int getMinLevelColony() {
        return 10;
    }

    @Override
    public IStorage getStorage() {
        return this.storage;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public int getPeoples() {
        return this.peoples;
    }

    @Override
    public boolean getWork() {
        return this.work;
    }

    @Override
    public void setWork(boolean setWork) {
        this.work = setWork;
    }

    @Override
    public int getWorkers() {
        return this.peoples;
    }

    @Override
    public int needWorkers() {
        return 5 - this.peoples;
    }

    @Override
    public void addWorkers(int workers) {
        this.peoples = (byte)(this.peoples + workers);
    }

    @Override
    public void removeWorkers(int remove) {
        this.peoples = (byte)(this.peoples - remove);
    }

    @Override
    public void work() {
        if (this.getColony().getEnergy() >= this.getEnergy()) {
            this.getColony().useEnergy(this.getEnergy());
            if (!this.getWork()) {
                this.setWork(true);
            }
        } else {
            if (!this.getColony().getProblems().contains((Object)EnumProblems.ENERGY)) {
                this.getColony().getProblems().add(EnumProblems.ENERGY);
            }
            if (this.getWork()) {
                this.setWork(false);
            }
        }
    }

    @Override
    public EnumTypeBuilding getTypeBuilding() {
        return EnumTypeBuilding.STORAGE;
    }

    @Override
    public int getPeople() {
        return this.peoples;
    }
}

