/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.research;

import com.denfop.ElectricItem;
import com.denfop.api.space.IAsteroid;
import com.denfop.api.space.IBody;
import com.denfop.api.space.IPlanet;
import com.denfop.api.space.ISatellite;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.fakebody.Data;
import com.denfop.api.space.fakebody.EnumOperation;
import com.denfop.api.space.fakebody.FakeAsteroid;
import com.denfop.api.space.fakebody.FakePlanet;
import com.denfop.api.space.fakebody.FakeSatellite;
import com.denfop.api.space.fakebody.IFakeAsteroid;
import com.denfop.api.space.fakebody.IFakeBody;
import com.denfop.api.space.fakebody.IFakePlanet;
import com.denfop.api.space.fakebody.IFakeSatellite;
import com.denfop.api.space.fakebody.SpaceOperation;
import com.denfop.api.space.research.api.IResearchSystem;
import com.denfop.api.space.research.api.IResearchTable;
import com.denfop.api.space.research.api.IRocketLaunchPad;
import com.denfop.api.space.rovers.api.IRovers;
import com.denfop.utils.FluidHandlerFix;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class BaseSpaceResearchSystem
implements IResearchSystem {
    @Override
    public Data getDataFromPlayer(IResearchTable table, IBody body) {
        return SpaceNet.instance.getFakeSpaceSystem().getDataFromUUID(table.getPlayer()).computeIfAbsent(body, k -> new Data(table.getPlayer(), body));
    }

    @Override
    public void sendingAutoOperation(IRovers rovers, IBody body, IResearchTable table) {
        if (this.canSendingOperation(rovers, body, table)) {
            IFakeBody fakeSatellite;
            IRocketLaunchPad rocketLaunchPad;
            FluidStack fluidStack;
            UUID uuid;
            if (body instanceof IPlanet) {
                uuid = table.getPlayer();
                FakePlanet fakeplanet = new FakePlanet(uuid, (IPlanet)body, rovers, SpaceNet.instance.getFakeSpaceSystem().getDataFromUUID(uuid).computeIfAbsent(body, k -> new Data(uuid, body)), new SpaceOperation(body, EnumOperation.WAIT, true));
                fluidStack = FluidHandlerFix.getFluidHandler(rovers.getItemStack()).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                if (!fluidStack.isEmpty() && fluidStack.getAmount() >= fakeplanet.getTimerFrom().getTime() + fakeplanet.getTimerTo().getTime()) {
                    SpaceNet.instance.getFakeSpaceSystem().addFakePlanet(fakeplanet);
                    SpaceNet.instance.getFakeSpaceSystem().getBodyMap().computeIfAbsent(uuid, l -> new LinkedList()).add(fakeplanet);
                    SpaceNet.instance.getFakeSpaceSystem().getSpaceTable(uuid).put(body, fakeplanet.getSpaceOperation());
                } else {
                    rocketLaunchPad = SpaceNet.instance.getFakeSpaceSystem().getRocketPadMap().get(table.getPlayer());
                    rocketLaunchPad.getSlotOutput().add(rovers.getItemStack());
                }
            }
            if (body instanceof ISatellite) {
                uuid = table.getPlayer();
                fakeSatellite = new FakeSatellite(uuid, (ISatellite)body, rovers, SpaceNet.instance.getFakeSpaceSystem().getDataFromUUID(uuid).computeIfAbsent(body, k -> new Data(uuid, body)), new SpaceOperation(body, EnumOperation.WAIT, true));
                fluidStack = FluidHandlerFix.getFluidHandler(rovers.getItemStack()).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                if (!fluidStack.isEmpty() && fluidStack.getAmount() >= ((FakeSatellite)fakeSatellite).getTimerFrom().getTime() + ((FakeSatellite)fakeSatellite).getTimerTo().getTime()) {
                    SpaceNet.instance.getFakeSpaceSystem().addFakeSatellite((FakeSatellite)fakeSatellite);
                    SpaceNet.instance.getFakeSpaceSystem().getBodyMap().computeIfAbsent(uuid, l -> new LinkedList()).add(fakeSatellite);
                    SpaceNet.instance.getFakeSpaceSystem().getSpaceTable(uuid).put(body, ((FakeSatellite)fakeSatellite).getSpaceOperation());
                } else {
                    rocketLaunchPad = SpaceNet.instance.getFakeSpaceSystem().getRocketPadMap().get(table.getPlayer());
                    rocketLaunchPad.getSlotOutput().add(rovers.getItemStack());
                }
            }
            if (body instanceof IAsteroid) {
                uuid = table.getPlayer();
                fakeSatellite = new FakeAsteroid(uuid, (IAsteroid)body, rovers, SpaceNet.instance.getFakeSpaceSystem().getDataFromUUID(uuid).computeIfAbsent(body, k -> new Data(uuid, body)), new SpaceOperation(body, EnumOperation.WAIT, true));
                fluidStack = FluidHandlerFix.getFluidHandler(rovers.getItemStack()).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                if (!fluidStack.isEmpty() && fluidStack.getAmount() >= ((FakeAsteroid)fakeSatellite).getTimerFrom().getTime() + ((FakeAsteroid)fakeSatellite).getTimerTo().getTime()) {
                    SpaceNet.instance.getFakeSpaceSystem().addFakeAsteroid((FakeAsteroid)fakeSatellite);
                    SpaceNet.instance.getFakeSpaceSystem().getBodyMap().computeIfAbsent(uuid, l -> new LinkedList()).add(fakeSatellite);
                    SpaceNet.instance.getFakeSpaceSystem().getSpaceTable(uuid).put(body, ((FakeAsteroid)fakeSatellite).getSpaceOperation());
                } else {
                    rocketLaunchPad = SpaceNet.instance.getFakeSpaceSystem().getRocketPadMap().get(table.getPlayer());
                    rocketLaunchPad.getSlotOutput().add(rovers.getItemStack());
                }
            }
            IRocketLaunchPad rocketLaunchPad2 = SpaceNet.instance.getFakeSpaceSystem().getRocketPadMap().get(table.getPlayer());
            rocketLaunchPad2.consumeRover();
        }
    }

    @Override
    public void sendingOperation(IRovers rovers, IBody body, IResearchTable table) {
        if (this.canSendingOperation(rovers, body, table)) {
            IFakeBody fakeSatellite;
            IRocketLaunchPad rocketLaunchPad;
            UUID uuid;
            if (body instanceof IPlanet) {
                uuid = table.getPlayer();
                FakePlanet fakeplanet = new FakePlanet(uuid, (IPlanet)body, rovers, SpaceNet.instance.getFakeSpaceSystem().getDataFromUUID(uuid).computeIfAbsent(body, k -> new Data(uuid, body)), new SpaceOperation(body, EnumOperation.WAIT));
                SpaceNet.instance.getFakeSpaceSystem().addFakePlanet(fakeplanet);
                rocketLaunchPad = SpaceNet.instance.getFakeSpaceSystem().getRocketPadMap().get(uuid);
                rocketLaunchPad.addDataRocket(fakeplanet.getRover().getItemStack());
                SpaceNet.instance.getFakeSpaceSystem().getBodyMap().computeIfAbsent(uuid, l -> new LinkedList()).add(fakeplanet);
                SpaceNet.instance.getFakeSpaceSystem().getSpaceTable(uuid).put(body, fakeplanet.getSpaceOperation());
            }
            if (body instanceof ISatellite) {
                uuid = table.getPlayer();
                fakeSatellite = new FakeSatellite(uuid, (ISatellite)body, rovers, SpaceNet.instance.getFakeSpaceSystem().getDataFromUUID(uuid).computeIfAbsent(body, k -> new Data(uuid, body)), new SpaceOperation(body, EnumOperation.WAIT));
                SpaceNet.instance.getFakeSpaceSystem().addFakeSatellite((FakeSatellite)fakeSatellite);
                rocketLaunchPad = SpaceNet.instance.getFakeSpaceSystem().getRocketPadMap().get(uuid);
                rocketLaunchPad.addDataRocket(((FakeSatellite)fakeSatellite).getRover().getItemStack());
                SpaceNet.instance.getFakeSpaceSystem().getBodyMap().computeIfAbsent(uuid, l -> new LinkedList()).add(fakeSatellite);
                SpaceNet.instance.getFakeSpaceSystem().getSpaceTable(uuid).put(body, ((FakeSatellite)fakeSatellite).getSpaceOperation());
            }
            if (body instanceof IAsteroid) {
                uuid = table.getPlayer();
                fakeSatellite = new FakeAsteroid(uuid, (IAsteroid)body, rovers, SpaceNet.instance.getFakeSpaceSystem().getDataFromUUID(uuid).computeIfAbsent(body, k -> new Data(uuid, body)), new SpaceOperation(body, EnumOperation.WAIT));
                SpaceNet.instance.getFakeSpaceSystem().addFakeAsteroid((FakeAsteroid)fakeSatellite);
                rocketLaunchPad = SpaceNet.instance.getFakeSpaceSystem().getRocketPadMap().get(uuid);
                rocketLaunchPad.addDataRocket(((FakeAsteroid)fakeSatellite).getRover().getItemStack());
                SpaceNet.instance.getFakeSpaceSystem().getBodyMap().computeIfAbsent(uuid, l -> new LinkedList()).add(fakeSatellite);
                SpaceNet.instance.getFakeSpaceSystem().getSpaceTable(uuid).put(body, ((FakeAsteroid)fakeSatellite).getSpaceOperation());
            }
            IRocketLaunchPad rocketLaunchPad2 = SpaceNet.instance.getFakeSpaceSystem().getRocketPadMap().get(table.getPlayer());
            rocketLaunchPad2.consumeRover();
        }
    }

    @Override
    public boolean canSendingOperation(IRovers rovers, IBody body, IResearchTable table) {
        List list = SpaceNet.instance.getFakeSpaceSystem().getBodyMap().computeIfAbsent(table.getPlayer(), k -> new LinkedList());
        for (IFakeBody fakeBody : list) {
            if (!fakeBody.matched(body)) continue;
            return false;
        }
        IRocketLaunchPad rocketLaunchPad = SpaceNet.instance.getFakeSpaceSystem().getRocketPadMap().get(table.getPlayer());
        if (rocketLaunchPad == null) {
            return false;
        }
        if (rovers == null) {
            return false;
        }
        if (FluidHandlerFix.getFluidHandler(rovers.getItemStack()).drain(10, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
            return false;
        }
        Data data = SpaceNet.instance.getFakeSpaceSystem().getDataFromUUID(table.getPlayer()).computeIfAbsent(body, k -> new Data(table.getPlayer(), body));
        switch (rovers.getItem().getType()) {
            case ROVERS: {
                if (data.getPercent() >= 0.0) break;
            }
            case PROBE: {
                if (data.getPercent() >= 20.0) break;
                return false;
            }
            case SATELLITE: {
                if (data.getPercent() >= 50.0) break;
                return false;
            }
            case ROCKET: {
                if (data.getPercent() >= 80.0) break;
                return false;
            }
        }
        if (!ElectricItem.manager.canUse(rovers.getItemStack(), 10.0)) {
            return false;
        }
        if (body instanceof IPlanet) {
            return table.getLevelTable().ordinal() >= ((IPlanet)body).getLevels().ordinal() && rovers.getItem().getLevel().getLevelsList().contains((Object)((IPlanet)body).getLevels());
        }
        if (body instanceof ISatellite) {
            return table.getLevelTable().ordinal() >= ((ISatellite)body).getLevels().ordinal() && rovers.getItem().getLevel().getLevelsList().contains((Object)((ISatellite)body).getLevels());
        }
        if (body instanceof IAsteroid) {
            return table.getLevelTable().ordinal() >= ((IAsteroid)body).getLevels().ordinal() && rovers.getItem().getLevel().getLevelsList().contains((Object)((IAsteroid)body).getLevels());
        }
        return false;
    }

    @Override
    public void returnOperation(IBody body, IResearchTable table) {
        if (body instanceof IPlanet) {
            List<IFakeBody> list = SpaceNet.instance.getFakeSpaceSystem().getBodyMap().get(table.getPlayer());
            IFakeBody fakePlanet = null;
            for (IFakeBody fakeBody : list) {
                if (!fakeBody.matched(body)) continue;
                fakePlanet = (IFakePlanet)fakeBody;
                break;
            }
            if (fakePlanet != null && fakePlanet.getTimerTo().canWork()) {
                fakePlanet.getTimerTo().setCanWork(false);
                fakePlanet.getTimerFrom().setCanWork(true);
                fakePlanet.getTimerFrom().getTimeFromTimerRemove(fakePlanet.getTimerTo());
            }
        } else if (body instanceof ISatellite) {
            List<IFakeBody> list = SpaceNet.instance.getFakeSpaceSystem().getBodyMap().get(table.getPlayer());
            IFakeBody fakeSatellite = null;
            for (IFakeBody fakeBody : list) {
                if (!fakeBody.matched(body)) continue;
                fakeSatellite = (IFakeSatellite)fakeBody;
                break;
            }
            if (fakeSatellite != null && fakeSatellite.getTimerTo().canWork()) {
                fakeSatellite.getTimerTo().setCanWork(false);
                fakeSatellite.getTimerFrom().setCanWork(true);
                fakeSatellite.getTimerFrom().getTimeFromTimerRemove(fakeSatellite.getTimerTo());
            }
        } else if (body instanceof IAsteroid) {
            List<IFakeBody> list = SpaceNet.instance.getFakeSpaceSystem().getBodyMap().get(table.getPlayer());
            IFakeBody fakeSatellite = null;
            for (IFakeBody fakeBody : list) {
                if (!fakeBody.matched(body)) continue;
                fakeSatellite = (IFakeAsteroid)fakeBody;
                break;
            }
            if (fakeSatellite != null && fakeSatellite.getTimerTo().canWork()) {
                fakeSatellite.getTimerTo().setCanWork(false);
                fakeSatellite.getTimerFrom().setCanWork(true);
                fakeSatellite.getTimerFrom().getTimeFromTimerRemove(fakeSatellite.getTimerTo());
            }
        }
    }
}

