/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.upgrade;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.upgrade.ILevelInstruments;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.IUpgradeSystem;
import com.denfop.api.upgrade.IUpgradeWithBlackList;
import com.denfop.api.upgrade.UpgradeItemInform;
import com.denfop.api.upgrade.UpgradeModificator;
import com.denfop.api.upgrade.event.EventItemBlackListLoad;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.datacomponent.UpgradeItem;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.modules.ItemUpgradeModule;
import com.denfop.recipe.IInputHandler;
import com.denfop.utils.ModUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;

public class BaseUpgradeSystem
implements IUpgradeSystem {
    List<UpgradeModificator> list_modificators = new ArrayList<UpgradeModificator>();
    int max = 0;

    public BaseUpgradeSystem() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public static void addupgrade(Item container, ItemStack fill) {
        CompoundTag nbt = ModUtils.nbt();
        nbt.putString("mode_module", fill.getItem() instanceof ItemUpgradeModule ? ItemUpgradeModule.getType((int)IUItem.upgrademodule.getMeta((ItemUpgradeModule)((ItemUpgradeModule)fill.getItem()))).name : "blacklist");
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("upgradeblock", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)container, 1)), input.getInput(fill)), new RecipeOutput(nbt, new ItemStack((ItemLike)container, 1))));
        Recipes.recipes.addRecipe("antiupgradeblock", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)container, 1))), new RecipeOutput(nbt, fill)));
    }

    public static void addupgrade(Item container, ItemStack fill, String type) {
        CompoundTag nbt = ModUtils.nbt();
        nbt.putString("type", type);
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("upgradeblock", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)container, 1)), input.getInput(fill)), new RecipeOutput(nbt, new ItemStack((ItemLike)container, 1))));
    }

    @Override
    public void addModification() {
        if (this.list_modificators.isEmpty()) {
            this.list_modificators.add(new UpgradeModificator(IUItem.core.getStack(7), "0"));
            this.list_modificators.add(new UpgradeModificator(IUItem.neutroniumingot.getItem(), "1"));
        }
    }

    public List<Integer> getPositiveUpgradeFromLevel(ItemStack stack) {
        if (stack.getItem() instanceof ILevelInstruments) {
            ILevelInstruments levelInstruments = (ILevelInstruments)stack.getItem();
            int level = levelInstruments.getLevel(stack);
            int speed = level / 2;
            int less_draw_energy = level / 5;
            int lucky = level / 10;
            int area = level / 15;
            int depth = level / 20;
            ArrayList<Integer> integers = new ArrayList<Integer>();
            integers.add(speed);
            integers.add(less_draw_energy);
            integers.add(lucky);
            integers.add(area);
            integers.add(depth);
            return integers;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void addModificate(ItemStack container, String name) {
        UpgradeItem upgradeItem = (UpgradeItem)container.get(DataComponentsInit.UPGRADE_ITEM);
        for (UpgradeModificator modification : this.list_modificators) {
            if (!modification.matches(name) || upgradeItem.upgradeModificators().contains(modification)) continue;
            List<UpgradeModificator> upgradeModificatorList = upgradeItem.upgradeModificators();
            upgradeModificatorList.add(modification);
            upgradeItem.updateModificator(container, upgradeModificatorList);
            break;
        }
    }

    @Override
    public boolean needModificate(ItemStack container, ItemStack fill) {
        List<UpgradeModificator> list = this.getListModifications(container);
        for (UpgradeModificator modificator : list) {
            if (!modificator.matches(fill)) continue;
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void loadItem(EventItemLoad event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        RegistryAccess.Frozen registryAccess = ((ServerLevel)event.getLevel()).getServer().registryAccess();
        this.updateListFromNBT(event.item, event.stack, (RegistryAccess)registryAccess);
    }

    @SubscribeEvent
    public void loadItem(EventItemBlackListLoad event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        RegistryAccess.Frozen registryAccess = ((ServerLevel)event.getLevel()).getServer().registryAccess();
        this.updateBlackListFromNBT(event.item, event.stack, event.nbt, (RegistryAccess)registryAccess);
    }

    @Override
    public boolean getModifications(ItemStack item) {
        return !((UpgradeItem)item.getOrDefault(DataComponentsInit.UPGRADE_ITEM, (Object)UpgradeItem.EMPTY)).upgradeModificators().isEmpty();
    }

    @Override
    public List<UpgradeModificator> getListModifications(ItemStack item) {
        ArrayList list = ((UpgradeItem)item.getOrDefault(DataComponentsInit.UPGRADE_ITEM, (Object)UpgradeItem.EMPTY)).upgradeModificators();
        return list != null ? list : new ArrayList();
    }

    @Override
    public int getRemaining(ItemStack item) {
        int k = this.getListModifications(item).size();
        return 4 + k - ((UpgradeItem)item.get(DataComponentsInit.UPGRADE_ITEM)).amount();
    }

    @Override
    public boolean hasBlackList(ItemStack item) {
        return !((UpgradeItem)item.getOrDefault(DataComponentsInit.UPGRADE_ITEM, (Object)UpgradeItem.EMPTY)).blackList().isEmpty();
    }

    @Override
    public boolean hasInMap(ItemStack stack) {
        return stack.has(DataComponentsInit.UPGRADE_ITEM) && !((UpgradeItem)stack.get(DataComponentsInit.UPGRADE_ITEM)).equals(UpgradeItem.EMPTY);
    }

    @Override
    public List<String> getBlackList(ItemStack item) {
        List<String> list = ((UpgradeItem)item.getOrDefault(DataComponentsInit.UPGRADE_ITEM, (Object)UpgradeItem.EMPTY)).blackList();
        return list != null ? list : Collections.emptyList();
    }

    @Override
    public List<UpgradeItemInform> getInformation(ItemStack item) {
        return ((UpgradeItem)item.getOrDefault(DataComponentsInit.UPGRADE_ITEM, (Object)UpgradeItem.EMPTY)).upgradeItemInforms();
    }

    @Override
    public List<String> getAvailableUpgrade(IUpgradeItem iUpgradeItem, ItemStack item) {
        UpgradeItem upgradeItem = (UpgradeItem)item.getOrDefault(DataComponentsInit.UPGRADE_ITEM, (Object)UpgradeItem.EMPTY);
        List<UpgradeItemInform> list = upgradeItem.upgradeItemInforms();
        List<EnumInfoUpgradeModules> list1 = iUpgradeItem.getUpgradeModules();
        LinkedList<CallSite> stringList = new LinkedList<CallSite>();
        block0: for (EnumInfoUpgradeModules enumInfoUpgradeModules : list1) {
            for (UpgradeItemInform upgradeItemInform : list) {
                if (!upgradeItemInform.upgrade.equals((Object)enumInfoUpgradeModules)) continue;
                if (upgradeItemInform.number >= upgradeItemInform.upgrade.max) continue block0;
                stringList.add((CallSite)((Object)(String.valueOf(ChatFormatting.GREEN) + (upgradeItemInform.upgrade.max - upgradeItemInform.number) + "x " + new ItemStack((ItemLike)IUItem.upgrademodule.getItemFromMeta(enumInfoUpgradeModules.ordinal()), 1).getDisplayName().getString())));
                continue block0;
            }
            stringList.add((CallSite)((Object)(String.valueOf(ChatFormatting.GREEN) + enumInfoUpgradeModules.max + "x " + new ItemStack((ItemLike)IUItem.upgrademodule.getItemFromMeta(enumInfoUpgradeModules.ordinal()), 1).getDisplayName().getString())));
        }
        return list != null ? stringList : Collections.emptyList();
    }

    @Override
    public UpgradeItemInform getModules(EnumInfoUpgradeModules module, ItemStack item) {
        List<UpgradeItemInform> list = this.getInformation(item);
        for (UpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return upgrade;
        }
        return null;
    }

    @Override
    public UpgradeItemInform getModules(EnumInfoUpgradeModules module, ItemStack item, List<UpgradeItemInform> list) {
        for (UpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return upgrade;
        }
        return null;
    }

    @Override
    public boolean hasModules(EnumInfoUpgradeModules module, ItemStack item) {
        if (!(item.getItem() instanceof IUpgradeItem)) {
            return false;
        }
        List<UpgradeItemInform> list = this.getInformation(item);
        for (UpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasModules(EnumInfoUpgradeModules module, ItemStack item, List<UpgradeItemInform> list) {
        if (!(item.getItem() instanceof IUpgradeItem)) {
            return false;
        }
        for (UpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateListFromNBT(IUpgradeItem item, ItemStack stack, RegistryAccess registryAccess) {
        boolean hasID;
        UpgradeItem upgradeItem = (UpgradeItem)stack.getOrDefault(DataComponentsInit.UPGRADE_ITEM, (Object)UpgradeItem.EMPTY);
        boolean bl = hasID = upgradeItem == UpgradeItem.EMPTY;
        if (!hasID) {
            ++this.max;
            upgradeItem = (UpgradeItem)stack.set(DataComponentsInit.UPGRADE_ITEM, (Object)UpgradeItem.EMPTY.copy());
        }
        this.addModification();
        int modesTagList = upgradeItem.amount();
        int ost = upgradeItem.upgradeModificators().size() + 4 - modesTagList;
        upgradeItem = upgradeItem.updateCanUpgrade(stack, ost > 0);
        upgradeItem = upgradeItem.updateListUpgrades(stack, this.getPositiveUpgradeFromLevel(stack));
        ItemEnchantments.Mutable itemenchantments$mutable = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack));
        itemenchantments$mutable.removeIf(enchantmentHolder -> true);
        stack.set(DataComponents.ENCHANTMENTS, (Object)itemenchantments$mutable.toImmutable());
        this.updateEnchantment((Holder<Enchantment>)registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SILK_TOUCH), EnumInfoUpgradeModules.SILK_TOUCH, 1, stack);
        this.updateEnchantment((Holder<Enchantment>)registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FORTUNE), EnumInfoUpgradeModules.LUCKY, this.getModulesValue(EnumInfoUpgradeModules.LUCKY, stack), stack);
        this.updateEnchantment((Holder<Enchantment>)registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.EFFICIENCY), EnumInfoUpgradeModules.EFFICIENT, this.calculateEfficiencyLevel(stack), stack);
        this.updateEnchantment((Holder<Enchantment>)registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FIRE_ASPECT), EnumInfoUpgradeModules.FIRE, this.getModulesValue(EnumInfoUpgradeModules.FIRE, stack), stack);
        this.updateEnchantment((Holder<Enchantment>)registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.LOOTING), EnumInfoUpgradeModules.LOOT, this.getModulesValue(EnumInfoUpgradeModules.LOOT, stack), stack);
        this.updateEnchantment((Holder<Enchantment>)registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.PROJECTILE_PROTECTION), EnumInfoUpgradeModules.PROTECTION_ARROW, this.calculateProjectileProtectionLevel(stack), stack);
    }

    @Override
    public List<Integer> getUpgradeFromList(ItemStack stack) {
        return ((UpgradeItem)stack.getOrDefault(DataComponentsInit.UPGRADE_ITEM, (Object)UpgradeItem.EMPTY)).listUpgrades();
    }

    private UpgradeModificator getModification(int i) {
        if (i == 0) {
            return this.list_modificators.get(0);
        }
        if (i == 1) {
            return this.list_modificators.get(1);
        }
        return null;
    }

    @Override
    public void setInformation(IUpgradeItem item, List<EnumInfoUpgradeModules> lst, ItemStack stack, RegistryAccess registryAccess) {
        this.write(item, lst, stack, registryAccess);
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        this.max = 0;
        this.list_modificators.clear();
    }

    @Override
    public void write(IUpgradeItem item, List<EnumInfoUpgradeModules> lst, ItemStack stack, RegistryAccess registryAccess) {
        ItemEnchantments.Mutable itemenchantments$mutable = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack));
        itemenchantments$mutable.removeIf(enchantmentHolder -> true);
        stack.set(DataComponents.ENCHANTMENTS, (Object)itemenchantments$mutable.toImmutable());
        this.updateEnchantment((Holder<Enchantment>)registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SILK_TOUCH), EnumInfoUpgradeModules.SILK_TOUCH, 1, stack);
        this.updateEnchantment((Holder<Enchantment>)registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FORTUNE), EnumInfoUpgradeModules.LUCKY, this.getModulesValue(EnumInfoUpgradeModules.LUCKY, stack), stack);
        this.updateEnchantment((Holder<Enchantment>)registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.EFFICIENCY), EnumInfoUpgradeModules.EFFICIENT, this.calculateEfficiencyLevel(stack), stack);
        this.updateEnchantment((Holder<Enchantment>)registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FIRE_ASPECT), EnumInfoUpgradeModules.FIRE, this.getModulesValue(EnumInfoUpgradeModules.FIRE, stack), stack);
        this.updateEnchantment((Holder<Enchantment>)registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.LOOTING), EnumInfoUpgradeModules.LOOT, this.getModulesValue(EnumInfoUpgradeModules.LOOT, stack), stack);
        this.updateEnchantment((Holder<Enchantment>)registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.PROJECTILE_PROTECTION), EnumInfoUpgradeModules.PROTECTION_ARROW, this.calculateProjectileProtectionLevel(stack), stack);
    }

    private void updateEnchantment(Holder<Enchantment> enchantment, EnumInfoUpgradeModules module, int level, ItemStack stack) {
        if (this.hasModules(module, stack)) {
            stack.enchant(enchantment, level);
        }
    }

    private int getModulesValue(EnumInfoUpgradeModules module, ItemStack stack) {
        UpgradeItemInform modules = this.getModules(module, stack);
        if (modules == null) {
            return 0;
        }
        return modules.number;
    }

    private int calculateEfficiencyLevel(ItemStack stack) {
        int baseLevel = 1;
        int moduleLevel = this.getModulesValue(EnumInfoUpgradeModules.EFFICIENT, stack);
        if (moduleLevel == 0) {
            return 0;
        }
        return baseLevel + (moduleLevel - 1) * 2;
    }

    private int calculateProjectileProtectionLevel(ItemStack stack) {
        int baseLevel = 1;
        int moduleLevel = this.getModulesValue(EnumInfoUpgradeModules.PROTECTION_ARROW, stack);
        if (moduleLevel == 0) {
            return 0;
        }
        return baseLevel + (moduleLevel - 1) * 2;
    }

    @Override
    public void updateBlackListFromNBT(IUpgradeWithBlackList item, ItemStack stack, CompoundTag nbt, RegistryAccess registryAccess) {
        this.updateListFromNBT(item, stack, registryAccess);
    }

    @Override
    public void updateLevel(ItemStack stack) {
        ((UpgradeItem)stack.get(DataComponentsInit.UPGRADE_ITEM)).updateListUpgrades(stack, this.getPositiveUpgradeFromLevel(stack));
    }

    @Override
    public void updateBlackListFromStack(ItemStack stack) {
    }

    @Override
    public void removeUpdate(ItemStack stack, Level world, int index) {
        UpgradeItem upgradeItem = (UpgradeItem)stack.get(DataComponentsInit.UPGRADE_ITEM);
        if (upgradeItem != null) {
            List<UpgradeItemInform> listInform = upgradeItem.upgradeItemInforms();
            UpgradeItemInform needRemove = null;
            for (UpgradeItemInform inform : upgradeItem.upgradeItemInforms()) {
                if (index != inform.upgrade.ordinal()) continue;
                if (inform.number > 1) {
                    --inform.number;
                    break;
                }
                needRemove = inform;
            }
            RegistryAccess.Frozen registryAccess = ((ServerLevel)world).getServer().registryAccess();
            ItemEnchantments.Mutable itemenchantments$mutable = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack));
            itemenchantments$mutable.removeIf(enchantmentHolder -> true);
            stack.set(DataComponents.ENCHANTMENTS, (Object)itemenchantments$mutable.toImmutable());
            this.updateEnchantment((Holder<Enchantment>)registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SILK_TOUCH), EnumInfoUpgradeModules.SILK_TOUCH, 1, stack);
            this.updateEnchantment((Holder<Enchantment>)registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FORTUNE), EnumInfoUpgradeModules.LUCKY, this.getModulesValue(EnumInfoUpgradeModules.LUCKY, stack), stack);
            this.updateEnchantment((Holder<Enchantment>)registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.EFFICIENCY), EnumInfoUpgradeModules.EFFICIENT, this.calculateEfficiencyLevel(stack), stack);
            this.updateEnchantment((Holder<Enchantment>)registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FIRE_ASPECT), EnumInfoUpgradeModules.FIRE, this.getModulesValue(EnumInfoUpgradeModules.FIRE, stack), stack);
            this.updateEnchantment((Holder<Enchantment>)registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.LOOTING), EnumInfoUpgradeModules.LOOT, this.getModulesValue(EnumInfoUpgradeModules.LOOT, stack), stack);
            this.updateEnchantment((Holder<Enchantment>)registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.PROJECTILE_PROTECTION), EnumInfoUpgradeModules.PROTECTION_ARROW, this.calculateProjectileProtectionLevel(stack), stack);
            if (needRemove != null) {
                listInform.remove(needRemove);
                upgradeItem = upgradeItem.updateAmount(stack, upgradeItem.amount() - 1);
                int modesTagList = upgradeItem.amount();
                int ost = upgradeItem.upgradeModificators().size() + 4 - modesTagList;
                upgradeItem = upgradeItem.updateCanUpgrade(stack, ost > 0);
            }
            upgradeItem = upgradeItem.updateUpgrades(stack, listInform);
        }
    }

    @Override
    public List<ItemStack> getListStack(ItemStack stack) {
        UpgradeItem upgradeItem = (UpgradeItem)stack.get(DataComponentsInit.UPGRADE_ITEM);
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        if (upgradeItem != null) {
            for (UpgradeItemInform inform : upgradeItem.upgradeItemInforms()) {
                for (int i = 0; i < inform.number; ++i) {
                    list.add(new ItemStack((ItemLike)IUItem.upgrademodule.getItemFromMeta(inform.upgrade.ordinal()), 1));
                }
            }
        }
        return list;
    }

    @Override
    public void addRecipe(Item stack, List<EnumInfoUpgradeModules> lst) {
        for (EnumInfoUpgradeModules upgrades : lst) {
            BaseUpgradeSystem.addupgrade(stack, new ItemStack((ItemLike)IUItem.upgrademodule.getStack(upgrades.ordinal()), 1));
        }
        if (lst.contains((Object)EnumInfoUpgradeModules.DIG_DEPTH)) {
            BaseUpgradeSystem.addupgrade(stack, new ItemStack((ItemLike)IUItem.module9.getStack(12), 1));
        }
        for (UpgradeModificator modificator : this.list_modificators) {
            BaseUpgradeSystem.addupgrade(stack, new ItemStack((ItemLike)modificator.itemstack), modificator.type);
        }
    }

    @Override
    public boolean shouldUpdate(EnumInfoUpgradeModules type, ItemStack stack1) {
        List<UpgradeItemInform> list = this.getInformation(stack1);
        for (UpgradeItemInform inform : list) {
            if (inform.upgrade != type || inform.number < type.max) continue;
            return false;
        }
        return true;
    }
}

