/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks.mechanism;

import com.denfop.IUCore;
import com.denfop.api.item.IMultiBlockItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.state.DefaultDrop;
import com.denfop.blocks.state.HarvestTool;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.transformer.TileHEEVTransformer;
import com.denfop.tiles.transformer.TileTransformerEV;
import com.denfop.tiles.transformer.TileTransformerHV;
import com.denfop.tiles.transformer.TileTransformerLV;
import com.denfop.tiles.transformer.TileTransformerMV;
import com.denfop.tiles.transformer.TileUEVTransformer;
import com.denfop.tiles.transformer.TileUHEVTransformer;
import com.denfop.tiles.transformer.TileUHVTransformer;
import com.denfop.tiles.transformer.TileUMEVTransformer;
import com.denfop.tiles.transformer.TileUMHVTransformer;
import com.denfop.tiles.transformer.TileUMVTransformer;
import com.denfop.utils.ModUtils;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforge.registries.DeferredHolder;

public enum BlockTransformer implements IMultiTileBlock,
IMultiBlockItem
{
    umv(TileUMVTransformer.class, 0),
    uhv(TileUHVTransformer.class, 1),
    uev(TileUEVTransformer.class, 2),
    umhv(TileUMHVTransformer.class, 3),
    umev(TileUMEVTransformer.class, 4),
    uhev(TileUHEVTransformer.class, 5),
    heev(TileHEEVTransformer.class, 6),
    lv(TileTransformerLV.class, 7),
    mv(TileTransformerMV.class, 8),
    hv(TileTransformerHV.class, 9),
    ev(TileTransformerEV.class, 10);

    private final Class<? extends TileEntityBlock> teClass;
    private final int itemMeta;
    int idBlock;
    private TileEntityBlock dummyTe;
    private BlockState defaultState;
    private DeferredHolder<BlockEntityType<?>, BlockEntityType<? extends TileEntityBlock>> blockType;

    private BlockTransformer(Class<? extends TileEntityBlock> teClass, int itemMeta) {
        this.teClass = teClass;
        this.itemMeta = itemMeta;
    }

    @Override
    public int getIDBlock() {
        return this.idBlock;
    }

    @Override
    public void setIdBlock(int id) {
        this.idBlock = id;
    }

    @Override
    public void buildDummies() {
        ModContainer mc = IUCore.instance.modContainer;
        if (mc == null || !"industrialupgrade".equals(mc.getModId())) {
            throw new IllegalAccessError("Don't mess with this please.");
        }
        if (this.teClass != null) {
            try {
                this.dummyTe = (TileEntityBlock)((Object)this.teClass.getConstructors()[0].newInstance(BlockPos.ZERO, this.defaultState));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public BlockEntityType<? extends TileEntityBlock> getBlockType() {
        return (BlockEntityType)this.blockType.get();
    }

    @Override
    public void setDefaultState(BlockState blockState) {
        this.defaultState = blockState;
    }

    @Override
    public void setType(DeferredHolder<BlockEntityType<?>, BlockEntityType<? extends TileEntityBlock>> blockEntityType) {
        this.blockType = blockEntityType;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getMainPath() {
        return "transformer_iu";
    }

    @Override
    public int getId() {
        return this.itemMeta;
    }

    @Override
    public boolean hasItem() {
        return true;
    }

    @Override
    public Class<? extends TileEntityBlock> getTeClass() {
        return this.teClass;
    }

    @Override
    public boolean hasActive() {
        return false;
    }

    @Override
    @Nonnull
    public Set<Direction> getSupportedFacings() {
        return ModUtils.allFacings;
    }

    @Override
    public float getHardness() {
        return 3.0f;
    }

    @Override
    @Nonnull
    public HarvestTool getHarvestTool() {
        return HarvestTool.Wrench;
    }

    @Override
    @Nonnull
    public DefaultDrop getDefaultDrop() {
        return DefaultDrop.Self;
    }

    @Override
    public boolean allowWrenchRotating() {
        return true;
    }

    @Override
    public TileEntityBlock getDummyTe() {
        return this.dummyTe;
    }

    @Override
    public boolean hasUniqueRender(ItemStack itemStack) {
        return false;
    }
}

