/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.TypePurifierJob;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.proxy.CommonProxy;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.base.TileEntityTesseract;
import com.denfop.tiles.mechanism.TileEntitySafe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ComponentPrivate
extends AbstractComponent {
    private final List<String> players = new ArrayList<String>();
    private final List<UUID> playersUUID = new ArrayList<UUID>();
    boolean activate = false;

    public ComponentPrivate(TileEntityInventory parent) {
        super(parent);
    }

    public Player getPlayerByUUID(Level level, String name) {
        for (int i = 0; i < level.players().size(); ++i) {
            Player player = (Player)level.players().get(i);
            if (!name.equals(player.getName().getString())) continue;
            return player;
        }
        return null;
    }

    @Override
    public boolean onBlockActivated(Player player, InteractionHand hand) {
        super.onBlockActivated(player, hand);
        ItemStack stack = player.getItemInHand(hand);
        if (!this.activate && !stack.isEmpty() && this.players.contains(player.getName().getString()) && stack.getItem() == IUItem.module7.getItemFromMeta(0)) {
            this.activate = true;
            List stringList = (List)stack.getOrDefault(DataComponentsInit.LIST_STRING, Collections.emptyList());
            for (String s : stringList) {
                this.players.add(s);
                this.playersUUID.add(this.getPlayerByUUID(player.level(), s).getUUID());
            }
            stack.shrink(1);
            return true;
        }
        if (this.activate && !this.getParent().getLevel().isClientSide && !this.players.contains(player.getName().getString()) && !player.isCreative()) {
            CommonProxy.sendPlayerMessage(player, Localization.translate("iu.error"));
            return true;
        }
        return false;
    }

    public void setActivate(boolean activate) {
        this.activate = activate;
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        if (placer instanceof Player) {
            this.players.add(placer.getName().getString());
            this.playersUUID.add(placer.getUUID());
        }
    }

    @Override
    public boolean canEntityDestroy(Entity entity) {
        return !this.activate || entity instanceof Player && (this.players.contains(entity.getName().getString()) || ((Player)entity).isCreative());
    }

    @Override
    public boolean wrenchCanRemove(Player player) {
        return !this.activate || player != null && (this.players.contains(player.getName().getString()) || player.isCreative());
    }

    @Override
    public TypePurifierJob getPurifierJob() {
        return TypePurifierJob.ItemStack;
    }

    @Override
    public boolean canUsePurifier(Player player) {
        return !(this.parent instanceof TileEntityTesseract) && !(this.parent instanceof TileEntitySafe) && this.activate && (this.players.contains(player.getName().getString()) || player.isCreative());
    }

    @Override
    public ItemStack getItemStackUpgrade() {
        this.activate = false;
        String player = this.players.get(0);
        UUID playerUUID = this.playersUUID.get(0);
        this.players.clear();
        this.playersUUID.clear();
        this.players.add(player);
        this.playersUUID.add(playerUUID);
        return new ItemStack((ItemLike)IUItem.module7.getItemFromMeta(0));
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> ret = super.getDrops();
        if (this.activate && !(this.parent instanceof TileEntityTesseract) && !(this.parent instanceof TileEntitySafe)) {
            ret.add(new ItemStack((ItemLike)IUItem.module7.getItemFromMeta(0)));
        }
        return ret;
    }

    @Override
    public CompoundTag writeToNbt() {
        int i;
        CompoundTag nbt = super.writeToNbt();
        nbt.putInt("size", this.players.size());
        for (i = 0; i < this.players.size(); ++i) {
            nbt.putString("player_" + i, this.players.get(i));
        }
        nbt.putInt("size1", this.playersUUID.size());
        for (i = 0; i < this.playersUUID.size(); ++i) {
            nbt.putUUID("player_uuid_" + i, this.playersUUID.get(i));
        }
        nbt.putBoolean("activate", this.activate);
        return nbt;
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        super.readFromNbt(nbt);
        int size = nbt.getInt("size");
        for (int i = 0; i < size; ++i) {
            this.players.add(nbt.getString("player_" + i));
        }
        int size1 = nbt.getInt("size1");
        for (int i = 0; i < size1; ++i) {
            this.playersUUID.add(nbt.getUUID("player_uuid_" + i));
        }
        this.activate = nbt.getBoolean("activate");
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(player.registryAccess());
        buffer.writeInt(this.players.size());
        buffer.writeBoolean(this.activate);
        this.players.forEach(buffer::writeString);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = new CustomPacketBuffer(this.parent.registryAccess());
        buffer.writeInt(this.players.size());
        buffer.writeBoolean(this.activate);
        this.players.forEach(buffer::writeString);
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.players.clear();
        try {
            int size = is.readInt();
            this.activate = is.readBoolean();
            for (int i = 0; i < size; ++i) {
                this.players.add(is.readString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.playersUUID.isEmpty()) {
            this.playersUUID.add(UUID.randomUUID());
        }
    }

    @Override
    public boolean isServer() {
        return true;
    }

    public List<UUID> getPlayersUUID() {
        return this.playersUUID;
    }

    public List<String> getPlayers() {
        return this.players;
    }
}

