/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.pollution.IPollutionMechanism;
import com.denfop.api.pollution.PollutionSoilLoadEvent;
import com.denfop.api.pollution.PollutionSoilUnLoadEvent;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.TypePurifierJob;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Vector3f;

public class SoilPollutionComponent
extends AbstractComponent
implements IPollutionMechanism {
    private double pollution;
    private double default_pollution;
    private ChunkPos chunkPos;
    private double percent = 1.0;

    public SoilPollutionComponent(TileEntityInventory parent, double pollution) {
        super(parent);
        this.pollution = pollution;
        this.default_pollution = pollution;
    }

    public static void spawnSoilPollution(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.1;
        double z = (double)pos.getZ() + 0.5;
        if (random.nextFloat() < 0.3f) {
            Vector3f dirtyColor = new Vector3f(0.2f, 0.4f, 0.1f);
            server.sendParticles((ParticleOptions)new DustParticleOptions(dirtyColor, 0.8f), x, y, z, 2, 0.02, 0.005, 0.02, 0.001);
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        if (this.parent != null && this.parent.getWorld() == null) {
            tooltip.add(Localization.translate("iu.pollution.soil.info") + " " + String.format("%.2f", this.default_pollution) + Localization.translate("iu.pollution.soil.info1"));
        }
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag tagCompound = super.writeToNbt();
        tagCompound.putDouble("percent", this.percent);
        return tagCompound;
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        super.readFromNbt(nbt);
        this.percent = nbt.getDouble("percent");
    }

    @Override
    public TypePurifierJob getPurifierJob() {
        return TypePurifierJob.ItemStack;
    }

    @Override
    public boolean canUsePurifier(Player player) {
        return this.percent != 1.0;
    }

    @Override
    public ItemStack getItemStackUpgrade() {
        if (this.percent == 0.0) {
            this.percent = 0.5;
            return new ItemStack((ItemLike)IUItem.antisoilpollution1.getItem());
        }
        this.percent = 1.0;
        return new ItemStack((ItemLike)IUItem.antisoilpollution.getItem());
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> ret = super.getDrops();
        if (this.percent == 0.0) {
            ret.add(new ItemStack((ItemLike)IUItem.antisoilpollution1.getItem()));
            ret.add(new ItemStack((ItemLike)IUItem.antisoilpollution.getItem()));
        } else if (this.percent == 0.5) {
            ret.add(new ItemStack((ItemLike)IUItem.antisoilpollution.getItem()));
        }
        return ret;
    }

    @Override
    public boolean onBlockActivated(Player player, InteractionHand hand) {
        if (!this.parent.getLevel().isClientSide) {
            ItemStack stack = player.getItemInHand(hand);
            Item item = stack.getItem();
            if (this.percent == 1.0 && item == IUItem.antisoilpollution.getItem()) {
                stack.shrink(1);
                this.percent = 0.5;
                if (this.parent.getActive()) {
                    this.setPollution(this.default_pollution * this.percent);
                } else {
                    this.setPollution(0.0);
                }
            } else if (this.percent == 0.5 && item == IUItem.antisoilpollution1.getItem()) {
                stack.shrink(1);
                this.percent = 0.0;
                if (this.parent.getActive()) {
                    this.setPollution(this.default_pollution * this.percent);
                } else {
                    this.setPollution(0.0);
                }
            }
        }
        return super.onBlockActivated(player, hand);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.parent.getWorld().getGameTime() % 20L == 0L && this.parent.getActive()) {
            SoilPollutionComponent.spawnSoilPollution(this.parent.getWorld(), this.parent.getPos(), this.parent.getWorld().random);
        }
        if (this.parent.getActive()) {
            this.setPollution(this.default_pollution * this.percent);
        } else {
            this.setPollution(0.0);
        }
    }

    @Override
    public void onLoaded() {
        if (!this.parent.getLevel().isClientSide && this.parent.getLevel().dimension() == Level.OVERWORLD) {
            NeoForge.EVENT_BUS.post((Event)new PollutionSoilLoadEvent(this.parent.getLevel(), this));
        }
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16, player.registryAccess());
        buffer.writeDouble(this.pollution);
        buffer.writeDouble(this.default_pollution);
        buffer.writeDouble(this.percent);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = super.updateComponent();
        buffer.writeDouble(this.pollution);
        buffer.writeDouble(this.default_pollution);
        buffer.writeDouble(this.percent);
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.pollution = is.readDouble();
        this.default_pollution = is.readDouble();
        this.percent = is.readDouble();
    }

    public double getDefault_pollution() {
        return this.default_pollution;
    }

    @Override
    public void onUnloaded() {
        if (!this.parent.getLevel().isClientSide && this.parent.getLevel().dimension() == Level.OVERWORLD) {
            NeoForge.EVENT_BUS.post((Event)new PollutionSoilUnLoadEvent(this.parent.getLevel(), this));
        }
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public ChunkPos getChunkPos() {
        if (this.chunkPos == null) {
            this.chunkPos = new ChunkPos(this.getParent().getBlockPos());
        }
        return this.chunkPos;
    }

    @Override
    public double getPollution() {
        return this.pollution;
    }

    public void setPollution(double pollution) {
        if (this.pollution != pollution && !this.parent.getLevel().isClientSide && this.parent.getLevel().dimension() == Level.OVERWORLD) {
            NeoForge.EVENT_BUS.post((Event)new PollutionSoilUnLoadEvent(this.parent.getLevel(), this));
            this.pollution = pollution * this.percent;
            NeoForge.EVENT_BUS.post((Event)new PollutionSoilLoadEvent(this.parent.getLevel(), this));
        }
    }
}

