/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.datacomponent;

import com.denfop.api.agriculture.genetics.EnumGenetic;
import com.denfop.api.agriculture.genetics.GeneticTraits;
import com.denfop.datacomponent.DataComponentsInit;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.codec.StreamCodec;

public record GenomeCrop(Map<EnumGenetic, GeneticTraits> geneticTraitsMap) {
    public static final Codec<GenomeCrop> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)Codec.INT).fieldOf("traits_ordinals").forGetter(genome -> genome.geneticTraitsMap.values().stream().map(Enum::ordinal).collect(Collectors.toList()))).apply((Applicative)instance, GenomeCrop::newFromOrdinals));
    public static final StreamCodec<ByteBuf, GenomeCrop> STREAM_CODEC = StreamCodec.composite(DataComponentsInit.INT_ARRAY, GenomeCrop::toIntList, GenomeCrop::newFromOrdinals);

    private static List<Integer> toIntList(GenomeCrop genome) {
        return genome.geneticTraitsMap().values().stream().map(Enum::ordinal).collect(Collectors.toList());
    }

    private static GenomeCrop newFromOrdinals(List<Integer> ordinals) {
        HashMap<EnumGenetic, GeneticTraits> map = new HashMap<EnumGenetic, GeneticTraits>();
        for (int ord : ordinals) {
            GeneticTraits gt = GeneticTraits.values()[ord];
            map.put(gt.getGenetic(), gt);
        }
        return new GenomeCrop(map);
    }
}

